/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.dbcp.dbcp2;

import java.lang.management.ManagementFactory;
import java.util.Objects;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

class ObjectNameWrapper {
    private static final Log log = LogFactory.getLog(ObjectNameWrapper.class);
    private static MBeanServer MBEAN_SERVER = ObjectNameWrapper.getPlatformMBeanServer();
    private final ObjectName objectName;

    private static MBeanServer getPlatformMBeanServer() {
        try {
            return ManagementFactory.getPlatformMBeanServer();
        }
        catch (Exception | LinkageError throwable) {
            log.debug((Object)"Failed to get platform MBeanServer", throwable);
            return null;
        }
    }

    public static ObjectName unwrap(ObjectNameWrapper objectNameWrapper) {
        return objectNameWrapper == null ? null : objectNameWrapper.unwrap();
    }

    public static ObjectNameWrapper wrap(ObjectName objectName) {
        return new ObjectNameWrapper(objectName);
    }

    public static ObjectNameWrapper wrap(String string) throws MalformedObjectNameException {
        return ObjectNameWrapper.wrap(new ObjectName(string));
    }

    public ObjectNameWrapper(ObjectName objectName) {
        this.objectName = objectName;
    }

    public void registerMBean(Object object) {
        if (MBEAN_SERVER == null || this.objectName == null) {
            return;
        }
        try {
            MBEAN_SERVER.registerMBean(object, this.objectName);
        }
        catch (Exception | LinkageError throwable) {
            log.warn((Object)("Failed to complete JMX registration for " + this.objectName), throwable);
        }
    }

    public String toString() {
        return Objects.toString(this.objectName);
    }

    public void unregisterMBean() {
        if (MBEAN_SERVER == null || this.objectName == null) {
            return;
        }
        if (MBEAN_SERVER.isRegistered(this.objectName)) {
            try {
                MBEAN_SERVER.unregisterMBean(this.objectName);
            }
            catch (Exception | LinkageError throwable) {
                log.warn((Object)("Failed to complete JMX unregistration for " + this.objectName), throwable);
            }
        }
    }

    public ObjectName unwrap() {
        return this.objectName;
    }
}

