/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javahelp;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.help.SearchHit;
import javax.help.SearchTOCItem;
import javax.help.search.SearchEngine;
import javax.help.search.SearchEvent;
import javax.help.search.SearchItem;
import javax.help.search.SearchListener;
import javax.help.search.SearchQuery;
import org.netbeans.api.javahelp.Help;
import org.netbeans.modules.javahelp.JavaHelp;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

class JavaHelpQuery
implements Comparator<SearchTOCItem> {
    private static JavaHelpQuery theInstance;
    private SearchEngine engine;
    private static final Logger LOG;

    private JavaHelpQuery() {
    }

    public static JavaHelpQuery getDefault() {
        if (null == theInstance) {
            theInstance = new JavaHelpQuery();
        }
        return theInstance;
    }

    @Override
    public int compare(SearchTOCItem searchTOCItem, SearchTOCItem searchTOCItem2) {
        int n = searchTOCItem2.hitCount() - searchTOCItem.hitCount();
        if (0 == n) {
            double d;
            double d2 = searchTOCItem.getConfidence();
            if (d2 < (d = searchTOCItem2.getConfidence())) {
                n = -11;
            } else if (d2 > d) {
                n = 1;
            }
        }
        return n;
    }

    public synchronized List<SearchTOCItem> search(String string) {
        if (null == this.engine) {
            this.engine = this.createSearchEngine();
        }
        ArrayList<SearchTOCItem> arrayList = new ArrayList<SearchTOCItem>();
        Thread thread = new Thread(this.createSearch(string, arrayList), "JavaHelpQuery.search[" + string + "]");
        thread.start();
        try {
            thread.join(60000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return arrayList;
    }

    private Runnable createSearch(final String string, final List<SearchTOCItem> list) {
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (null == JavaHelpQuery.this.engine) {
                    return;
                }
                SynchronizedSearchListener synchronizedSearchListener = new SynchronizedSearchListener(list);
                SearchQuery searchQuery = JavaHelpQuery.this.engine.createQuery();
                searchQuery.addSearchListener(synchronizedSearchListener);
                searchQuery.start(string, Locale.getDefault());
                SynchronizedSearchListener synchronizedSearchListener2 = synchronizedSearchListener;
                synchronized (synchronizedSearchListener2) {
                    while (!synchronizedSearchListener.isSearchDone()) {
                        try {
                            synchronizedSearchListener.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
                Collections.sort(list, JavaHelpQuery.this);
            }
        };
        return runnable;
    }

    private SearchEngine createSearchEngine() {
        JavaHelp javaHelp;
        SearchEngine searchEngine = null;
        Help help = (Help)Lookup.getDefault().lookup(Help.class);
        if (help != null && help instanceof JavaHelp && null == (searchEngine = (javaHelp = (JavaHelp)help).createSearchEngine())) {
            LOG.log(Level.INFO, NbBundle.getMessage(JavaHelpQuery.class, (String)"Err_CreateJavaHelpSearchEngine"));
            searchEngine = new DummySearchEngine();
        }
        return searchEngine;
    }

    static {
        LOG = Logger.getLogger(JavaHelpQuery.class.getName());
    }

    private class SynchronizedSearchListener
    implements SearchListener {
        private final List<SearchTOCItem> items;
        private boolean searchDone = false;

        public SynchronizedSearchListener(List<SearchTOCItem> list) {
            this.items = list;
        }

        @Override
        public void itemsFound(SearchEvent searchEvent) {
            this.addItemsToList(searchEvent.getSearchItems(), this.items);
        }

        @Override
        public void searchStarted(SearchEvent searchEvent) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void searchFinished(SearchEvent searchEvent) {
            SynchronizedSearchListener synchronizedSearchListener = this;
            synchronized (synchronizedSearchListener) {
                this.searchDone = true;
                this.notifyAll();
            }
        }

        public boolean isSearchDone() {
            return this.searchDone;
        }

        private void addItemsToList(Enumeration enumeration, List<SearchTOCItem> list) {
            if (null == enumeration) {
                return;
            }
            while (enumeration.hasMoreElements()) {
                URL uRL;
                SearchItem searchItem = (SearchItem)enumeration.nextElement();
                try {
                    uRL = new URL(searchItem.getBase(), searchItem.getFilename());
                }
                catch (MalformedURLException malformedURLException) {
                    LOG.log(Level.FINE, "Invalid URL in SearchItem: " + searchItem.getTitle(), malformedURLException);
                    continue;
                }
                boolean bl = false;
                for (SearchTOCItem searchTOCItem : list) {
                    URL uRL2 = searchTOCItem.getURL();
                    if (uRL2 == null || uRL == null || !uRL.sameFile(uRL2)) continue;
                    searchTOCItem.addSearchHit(new SearchHit(searchItem.getConfidence(), searchItem.getBegin(), searchItem.getEnd()));
                    bl = true;
                    break;
                }
                if (bl) continue;
                SearchTOCItem searchTOCItem = new SearchTOCItem(searchItem);
                list.add(searchTOCItem);
            }
        }
    }

    private static class DummySearchQuery
    extends SearchQuery {
        private List<SearchListener> listeners = new ArrayList<SearchListener>(1);

        public DummySearchQuery(DummySearchEngine dummySearchEngine) {
            super(dummySearchEngine);
        }

        @Override
        public void addSearchListener(SearchListener searchListener) {
            this.listeners.add(searchListener);
        }

        @Override
        public void removeSearchListener(SearchListener searchListener) {
            this.listeners.remove(searchListener);
        }

        @Override
        public void start(String string, Locale locale) throws IllegalArgumentException, IllegalStateException {
            SearchEvent searchEvent = new SearchEvent(this, "", false);
            for (SearchListener searchListener : this.listeners) {
                searchListener.searchStarted(searchEvent);
                searchListener.searchFinished(searchEvent);
            }
        }

        @Override
        public void stop() throws IllegalStateException {
        }

        @Override
        public boolean isActive() {
            return false;
        }
    }

    private static class DummySearchEngine
    extends SearchEngine {
        private DummySearchEngine() {
        }

        @Override
        public SearchQuery createQuery() throws IllegalStateException {
            return new DummySearchQuery(this);
        }
    }
}

