/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.snaptracer.impl.details;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.modules.profiler.snaptracer.impl.details.DetailsPanel;
import org.netbeans.modules.profiler.snaptracer.impl.details.DetailsTableModel;
import org.netbeans.modules.profiler.snaptracer.impl.details.ItemValueRenderer;
import org.netbeans.modules.profiler.snaptracer.impl.details.MarkRenderer;
import org.netbeans.modules.profiler.snaptracer.impl.details.TimestampRenderer;
import org.netbeans.modules.profiler.snaptracer.impl.swing.HeaderLabel;

final class DetailsTable
extends JTable {
    private static final int DEFAULT_ROW_HEIGHT = DetailsTable.defaultRowHeight();
    static final Color DEFAULT_GRID_COLOR = new Color(240, 240, 240);
    private TableCellRenderer markRenderer;
    private TimestampRenderer timestampRenderer;

    DetailsTable() {
        this.setOpaque(true);
        this.setBackground(UIUtils.getProfilerResultsBackground());
        this.setRowHeight(DEFAULT_ROW_HEIGHT);
        this.setRowMargin(0);
        this.setAutoCreateRowSorter(true);
        this.setShowHorizontalLines(false);
        this.setShowVerticalLines(true);
        this.setGridColor(DEFAULT_GRID_COLOR);
        this.getTableHeader().setPreferredSize(new Dimension(1, HeaderLabel.DEFAULT_HEIGHT));
        this.getColumnModel().setColumnMargin(1);
        this.initRenderers();
    }

    @Override
    public void addColumn(TableColumn tableColumn) {
        super.addColumn(tableColumn);
        if (tableColumn.getModelIndex() == 0 || tableColumn.getModelIndex() == 1) {
            this.updateColumns(true);
        }
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        super.tableChanged(tableModelEvent);
        if (tableModelEvent.getType() == 1) {
            this.updateColumns(false);
        }
    }

    @Override
    protected JTableHeader createDefaultTableHeader() {
        return new JTableHeader(this.columnModel){

            @Override
            public String getToolTipText(MouseEvent mouseEvent) {
                int n = this.columnModel.getColumnIndexAtX(mouseEvent.getPoint().x);
                int n2 = this.columnModel.getColumn(n).getModelIndex();
                return ((DetailsTableModel)DetailsTable.this.dataModel).getColumnTooltip(n2);
            }
        };
    }

    private void initRenderers() {
        this.markRenderer = this.getDefaultRenderer(Boolean.class);
        TableCellRenderer tableCellRenderer = this.getDefaultRenderer(String.class);
        this.timestampRenderer = new TimestampRenderer(tableCellRenderer);
        TableCellRenderer tableCellRenderer2 = this.getDefaultRenderer(Long.class);
        this.setDefaultRenderer(Boolean.class, new MarkRenderer(this.markRenderer));
        this.setDefaultRenderer(DetailsPanel.class, this.timestampRenderer);
        this.setDefaultRenderer(Long.class, new ItemValueRenderer(tableCellRenderer2));
    }

    private void updateColumns(boolean bl) {
        Component component;
        if (this.timestampRenderer == null) {
            return;
        }
        if (bl) {
            component = this.markRenderer.getTableCellRendererComponent(this, Boolean.FALSE, false, false, 0, 0);
            int n = component.getPreferredSize().width;
            TableColumn tableColumn = this.columnModel.getColumn(0);
            TableCellRenderer tableCellRenderer = this.getTableHeader().getDefaultRenderer();
            Component component2 = tableCellRenderer.getTableCellRendererComponent(this, tableColumn.getHeaderValue(), false, false, 0, 0);
            n = Math.max(n, component2.getPreferredSize().width);
            tableColumn.setPreferredWidth(n += 16);
            tableColumn.setMaxWidth(n);
        }
        if (this.columnModel.getColumnCount() > 1) {
            if (!this.timestampRenderer.updateFormat(this.dataModel) && !bl) {
                return;
            }
            component = this.timestampRenderer.getTableCellRendererComponent(this, 1268996399999L, false, false, 0, 1);
            TableColumn tableColumn = this.columnModel.getColumn(1);
            int n = component.getPreferredSize().width + 5;
            if (bl || tableColumn.getMaxWidth() < n) {
                tableColumn.setPreferredWidth(n);
                tableColumn.setMaxWidth(n);
                if (!bl) {
                    this.repaint();
                }
            }
        }
    }

    private static int defaultRowHeight() {
        return new JLabel((String)"X").getPreferredSize().height + 4;
    }
}

