/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.propertysheet;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.beans.PropertyEditor;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.plaf.ComboBoxUI;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.text.JTextComponent;
import org.openide.explorer.propertysheet.ComboBoxAutoCompleteSupport;
import org.openide.explorer.propertysheet.IncrementPropertyValueSupport;
import org.openide.explorer.propertysheet.InplaceEditor;
import org.openide.explorer.propertysheet.PropUtils;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.explorer.propertysheet.PropertyModel;
import org.openide.explorer.propertysheet.SheetTable;
import org.openide.explorer.propertysheet.editors.EnhancedPropertyEditor;

class ComboInplaceEditor
extends JComboBox
implements InplaceEditor,
FocusListener,
AncestorListener,
IncrementPropertyValueSupport {
    static final KeyStroke[] cbKeyStrokes = new KeyStroke[]{KeyStroke.getKeyStroke(40, 0, false), KeyStroke.getKeyStroke(38, 0, false), KeyStroke.getKeyStroke(40, 0, true), KeyStroke.getKeyStroke(38, 0, true), KeyStroke.getKeyStroke(34, 0, false), KeyStroke.getKeyStroke(33, 0, false), KeyStroke.getKeyStroke(34, 0, true), KeyStroke.getKeyStroke(33, 0, true)};
    private static PopupChecker checker = null;
    protected PropertyEditor editor;
    protected PropertyEnv env;
    private ListCellRenderer originalRenderer;
    protected PropertyModel mdl;
    boolean inSetUI = false;
    private boolean tableUI;
    private boolean connecting = false;
    private boolean hasBeenEditable = false;
    private boolean needLayout = false;
    private boolean suppressFireActionEvent = false;
    private final boolean isAutoComplete;
    private boolean strictAutoCompleteMatching;
    private boolean in_setSelectedItem = false;
    private static Boolean syscheck = null;

    public ComboInplaceEditor(boolean bl) {
        if (bl) {
            this.putClientProperty("JComboBox.isTableCellEditor", Boolean.TRUE);
        }
        if (Boolean.getBoolean("netbeans.ps.combohack")) {
            this.setLightWeightPopupEnabled(false);
        }
        if (this.getClass() == ComboInplaceEditor.class) {
            this.enableEvents(4L);
        }
        this.tableUI = bl;
        if (bl) {
            this.updateUI();
        }
        this.originalRenderer = this.getRenderer();
        this.isAutoComplete = ComboBoxAutoCompleteSupport.install(this);
        String string = UIManager.getLookAndFeel().getID();
        if ("Aqua".equals(string) || "Metal".equals(string)) {
            UIManager.put("PopupMenu.consumeEventOnClose", Boolean.TRUE);
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this.isEditable() && this.getClass() == ComboInplaceEditor.class) {
            this.getEditor().getEditorComponent().addFocusListener(this);
        }
        this.getLayout().layoutContainer(this);
    }

    @Override
    public void setEditable(boolean bl) {
        boolean bl2 = this.hasBeenEditable;
        this.hasBeenEditable |= bl;
        super.setEditable(bl);
        if (bl2 != this.hasBeenEditable) {
            this.log("Combo editor for " + this.editor + " setEditable (" + bl + ")");
            this.needLayout = true;
        }
    }

    @Override
    public void removeNotify() {
        this.log("Combo editor for " + this.editor + " removeNotify forcing popup close");
        this.setPopupVisible(false);
        super.removeNotify();
        this.getEditor().getEditorComponent().removeFocusListener(this);
    }

    @Override
    public Insets getInsets() {
        if ("Aqua".equals(UIManager.getLookAndFeel().getID())) {
            return new Insets(0, 0, 0, 0);
        }
        return super.getInsets();
    }

    @Override
    public void clear() {
        this.editor = null;
        this.env = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connect(PropertyEditor propertyEditor, PropertyEnv propertyEnv) {
        this.connecting = true;
        try {
            this.log("Combo editor connect to " + propertyEditor + " env=" + propertyEnv);
            this.env = propertyEnv;
            this.editor = propertyEditor;
            this.setModel(new DefaultComboBoxModel<String>(propertyEditor.getTags()));
            boolean bl = this.editor instanceof EnhancedPropertyEditor ? ((EnhancedPropertyEditor)this.editor).supportsEditingTaggedValues() : propertyEnv != null && Boolean.TRUE.equals(propertyEnv.getFeatureDescriptor().getValue("canEditAsText"));
            boolean bl2 = null != propertyEnv && Boolean.FALSE.equals(propertyEnv.getFeatureDescriptor().getValue("canAutoComplete"));
            this.strictAutoCompleteMatching = !bl;
            this.setEditable(bl || this.isAutoComplete && !bl2);
            this.setActionCommand("success");
            Object object = propertyEnv.getFeatureDescriptor().getValue("customListCellRendererSupport");
            if (object != null) {
                AtomicReference atomicReference = (AtomicReference)object;
                atomicReference.set(this.originalRenderer);
                this.setRenderer((ListCellRenderer)object);
            }
            if (PropUtils.supportsValueIncrement(propertyEnv)) {
                PropUtils.wrapUpDownArrowActions(this, this);
                PropUtils.wrapUpDownArrowActions((JComponent)this.getEditor().getEditorComponent(), this);
            }
            this.reset();
        }
        finally {
            this.connecting = false;
        }
    }

    private void log(String string) {
        if (PropUtils.isLoggable(ComboInplaceEditor.class) && this.getClass() == ComboInplaceEditor.class) {
            PropUtils.log(ComboInplaceEditor.class, string);
        }
    }

    @Override
    public void setSelectedItem(Object object) {
        try {
            if (this.in_setSelectedItem) {
                this.in_setSelectedItem = false;
                if (PropUtils.supportsValueIncrement(this.env)) {
                    return;
                }
            }
            this.in_setSelectedItem = true;
            if (object == null && this.editor != null && this.editor.getTags() != null && this.editor.getTags().length > 0) {
                object = this.editor.getTags()[0];
            }
            if (object != null) {
                super.setSelectedItem(object);
            }
        }
        finally {
            this.in_setSelectedItem = false;
        }
    }

    @Override
    public void fireActionEvent() {
        if (this.connecting || this.editor == null) {
            return;
        }
        if (this.editor == null) {
            return;
        }
        if (this.suppressFireActionEvent) {
            return;
        }
        if ("comboBoxEdited".equals(this.getActionCommand())) {
            this.log("Translating comboBoxEdited action command to COMMAND_SUCCESS");
            this.setActionCommand("success");
        }
        this.log("Combo editor firing ActionPerformed command=" + this.getActionCommand());
        super.fireActionEvent();
    }

    @Override
    public void reset() {
        String string;
        String string2 = null;
        if (this.editor != null) {
            this.log("Combo editor reset setting selected item to " + this.editor.getAsText());
            string2 = this.editor.getAsText();
        }
        if (this.getClass() == ComboInplaceEditor.class && this.env != null && this.env.getFeatureDescriptor() != null && (string = (String)this.env.getFeatureDescriptor().getValue("initialEditValue")) != null) {
            string2 = string;
        }
        this.setSelectedItem(string2);
    }

    @Override
    public Object getValue() {
        if (this.isEditable()) {
            Object object;
            if (this.isAutoComplete && null != (object = this.getEditor().getItem())) {
                int n = ComboBoxAutoCompleteSupport.findMatch(this, object.toString());
                if (n >= 0 && n < this.getItemCount()) {
                    return this.getItemAt(n);
                }
                if (this.strictAutoCompleteMatching) {
                    int n2 = this.getSelectedIndex();
                    if (n2 < 0) {
                        if (null != this.editor) {
                            return this.editor.getAsText();
                        }
                        return null;
                    }
                    return this.getSelectedItem();
                }
            }
            return this.getEditor().getItem();
        }
        return this.getSelectedItem();
    }

    @Override
    public PropertyEditor getPropertyEditor() {
        return this.editor;
    }

    @Override
    public PropertyModel getPropertyModel() {
        return this.mdl;
    }

    @Override
    public void setPropertyModel(PropertyModel propertyModel) {
        this.log("Combo editor set property model to " + propertyModel);
        this.mdl = propertyModel;
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public KeyStroke[] getKeyStrokes() {
        return cbKeyStrokes;
    }

    @Override
    public void updateUI() {
        boolean bl;
        LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
        String string = lookAndFeel.getID();
        boolean bl2 = bl = this.tableUI && (lookAndFeel instanceof MetalLookAndFeel || "GTK".equals(string) || "Nimbus".equals(string) || "Aqua".equals(string) && ComboInplaceEditor.checkMacSystemVersion() || PropUtils.isWindowsVistaLaF() || "Kunststoff".equals(string));
        if (bl) {
            super.setUI(PropUtils.createComboUI(this, this.tableUI));
        } else {
            super.updateUI();
        }
        if (this.tableUI & this.getEditor().getEditorComponent() instanceof JComponent) {
            ((JComponent)this.getEditor().getEditorComponent()).setBorder(null);
        }
    }

    static boolean checkMacSystemVersion() {
        int n = 10;
        int n2 = 5;
        if (syscheck == null) {
            String string = System.getProperty("os.version");
            int n3 = string.indexOf(46);
            if (n3 > 0) {
                int n4 = string.indexOf(46, n3 + 1);
                if (n4 < 0) {
                    n4 = string.length();
                }
                try {
                    int n5 = Integer.parseInt(string.substring(0, n3));
                    int n6 = Integer.parseInt(string.substring(n3 + 1, n4));
                    syscheck = n5 > n || n5 == n && n6 >= n2;
                }
                catch (NumberFormatException numberFormatException) {
                    syscheck = false;
                }
            } else {
                syscheck = false;
            }
        }
        return syscheck;
    }

    @Override
    public void setUI(ComboBoxUI comboBoxUI) {
        this.inSetUI = true;
        try {
            super.setUI(comboBoxUI);
        }
        finally {
            this.inSetUI = false;
        }
    }

    @Override
    public void showPopup() {
        try {
            this.log(" Combo editor show popup");
            super.showPopup();
        }
        catch (NullPointerException nullPointerException) {
            this.log(" Combo editor show popup later due to npe");
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ComboInplaceEditor.super.showPopup();
                }
            });
        }
    }

    private void prepareEditor() {
        Component component = this.getEditor().getEditorComponent();
        if (component instanceof JTextComponent) {
            JTextComponent jTextComponent = (JTextComponent)component;
            String string = jTextComponent.getText();
            if (string != null && string.length() > 0) {
                jTextComponent.setSelectionStart(0);
                jTextComponent.setSelectionEnd(string.length());
            }
            if (this.tableUI) {
                jTextComponent.setBackground(this.getBackground());
            } else {
                jTextComponent.setBackground(PropUtils.getTextFieldBackground());
            }
            if (this.tableUI) {
                jTextComponent.requestFocus();
            }
        }
        if (this.getLayout() != null) {
            this.getLayout().layoutContainer(this);
        }
        this.repaint();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void processFocusEvent(FocusEvent var1_1) {
        if (var1_1.getID() == 1005 && var1_1.getOppositeComponent() == this.getEditor().getEditorComponent() && this.isPopupVisible()) {
            return;
        }
        super.processFocusEvent(var1_1);
        if (PropUtils.isLoggable(ComboInplaceEditor.class)) {
            PropUtils.log(ComboInplaceEditor.class, "Focus event on combo editor");
            PropUtils.log(ComboInplaceEditor.class, var1_1);
        }
        var2_2 = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (!this.isDisplayable()) ** GOTO lbl-1000
        if (var1_1.getID() == 1004 && var2_2 == this && !this.isPopupVisible()) {
            if (this.isEditable()) {
                this.prepareEditor();
                if (this.tableUI) {
                    SwingUtilities.invokeLater(new PopupChecker());
                }
            } else if (this.tableUI && (null == this.env || !PropUtils.supportsValueIncrement(this.env))) {
                this.showPopup();
                SwingUtilities.invokeLater(new PopupChecker());
            }
            this.repaint();
        } else if (var1_1.getID() == 1005 && this.isPopupVisible() && !this.isDisplayable()) {
            if (!PropUtils.psCommitOnFocusLoss) {
                this.setActionCommand("failure");
                this.fireActionEvent();
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (!ComboInplaceEditor.this.isDisplayable()) {
                        ComboInplaceEditor.this.hidePopup();
                    }
                }
            });
        }
        this.repaint();
    }

    @Override
    public boolean isKnownComponent(Component component) {
        return component == this.getEditor().getEditorComponent();
    }

    @Override
    public void setValue(Object object) {
        ComboBoxAutoCompleteSupport.setIgnoreSelectionEvents(this, true);
        this.setSelectedItem(object);
        ComboBoxAutoCompleteSupport.setIgnoreSelectionEvents(this, false);
    }

    @Override
    public boolean supportsTextEntry() {
        return this.isEditable();
    }

    @Override
    protected void installAncestorListener() {
        if (this.tableUI) {
            this.addAncestorListener(this);
        } else {
            super.installAncestorListener();
        }
    }

    @Override
    public void addFocusListener(FocusListener focusListener) {
        if (!this.inSetUI || !this.tableUI) {
            super.addFocusListener(focusListener);
        }
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        this.prepareEditor();
        if (null == this.env || !PropUtils.supportsValueIncrement(this.env)) {
            this.showPopup();
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        Component component = focusEvent.getOppositeComponent();
        if (!this.isAncestorOf(component) && component != this.getEditor().getEditorComponent()) {
            if (component == this || component instanceof SheetTable && ((SheetTable)component).isAncestorOf(this)) {
                return;
            }
            this.setActionCommand("failure");
            this.log(" Combo editor lost focus - setting action command to failure");
            this.getEditor().getEditorComponent().removeFocusListener(this);
            if (checker == null) {
                this.log("No active popup checker, firing action event");
                this.fireActionEvent();
            }
        }
    }

    @Override
    public void firePopupMenuCanceled() {
        super.firePopupMenuCanceled();
        if (this.isEditable()) {
            Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            if (this.isDisplayable() && component == this) {
                this.log("combo editor popup menu canceled.  Requesting focus on editor component");
                this.getEditor().getEditorComponent().requestFocus();
            }
        }
    }

    @Override
    public void processKeyEvent(KeyEvent keyEvent) {
        super.processKeyEvent(keyEvent);
        if (keyEvent.getID() == 401) {
            if (keyEvent.getKeyCode() == 27) {
                this.setActionCommand("failure");
                this.fireActionEvent();
            }
        }
    }

    @Override
    public void ancestorAdded(AncestorEvent ancestorEvent) {
        checker = new PopupChecker();
        SwingUtilities.invokeLater(checker);
    }

    @Override
    public void ancestorMoved(AncestorEvent ancestorEvent) {
        if (this.needLayout && this.getLayout() != null) {
            this.getLayout().layoutContainer(this);
        }
    }

    @Override
    public void ancestorRemoved(AncestorEvent ancestorEvent) {
    }

    @Override
    public void paintChildren(Graphics graphics) {
        if (this.editor != null && !this.hasFocus() && this.editor.isPaintable()) {
            return;
        }
        super.paintChildren(graphics);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintComponent(Graphics graphics) {
        if (this.editor != null && !this.hasFocus() && this.editor.isPaintable()) {
            Insets insets = this.getInsets();
            Color color = graphics.getColor();
            try {
                graphics.setColor(this.getBackground());
                graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
            finally {
                graphics.setColor(color);
            }
            insets.left += PropUtils.getTextMargin();
            this.editor.paintValue(graphics, new Rectangle(insets.left, insets.top, this.getWidth() - (insets.right + insets.left), this.getHeight() - (insets.top + insets.bottom)));
        } else {
            super.paintComponent(graphics);
        }
    }

    @Override
    public boolean incrementValue() {
        return this.setNextValue(true);
    }

    @Override
    public boolean decrementValue() {
        return this.setNextValue(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setNextValue(boolean bl) {
        try {
            this.suppressFireActionEvent = true;
            if (this.isPopupVisible()) {
                boolean bl2 = false;
                return bl2;
            }
            if (!PropUtils.supportsValueIncrement(this.env)) {
                boolean bl3 = false;
                return bl3;
            }
            Object object = PropUtils.getNextValue(this.env, bl);
            if (null == object) {
                boolean bl4 = true;
                return bl4;
            }
            this.setValue(object);
            boolean bl5 = PropUtils.updateProp(this);
            return bl5;
        }
        finally {
            this.suppressFireActionEvent = false;
        }
    }

    @Override
    public boolean isIncrementEnabled() {
        return !this.isPopupVisible();
    }

    private class PopupChecker
    implements Runnable {
        private PopupChecker() {
        }

        @Override
        public void run() {
            Window window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
            if (null != window && window.isAncestorOf(ComboInplaceEditor.this)) {
                if (ComboInplaceEditor.this.isShowing() && !ComboInplaceEditor.this.isPopupVisible()) {
                    ComboInplaceEditor.this.log("Popup checker ensuring editor prepared or popup visible");
                    if (ComboInplaceEditor.this.isEditable()) {
                        ComboInplaceEditor.this.prepareEditor();
                    }
                    ComboInplaceEditor.this.showPopup();
                }
                checker = null;
            }
        }
    }
}

