/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search.matcher;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.CharBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.api.search.SearchPattern;
import org.netbeans.api.search.provider.SearchListener;
import org.netbeans.modules.search.MatchingObject;
import org.netbeans.modules.search.TextDetail;
import org.netbeans.modules.search.TextRegexpUtil;
import org.netbeans.modules.search.matcher.AbstractMatcher;
import org.netbeans.modules.search.matcher.MatcherUtils;
import org.netbeans.modules.search.matcher.MultiLineMappedMatcherSmall;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;

public class MultiLineMappedMatcherBig
extends AbstractMatcher {
    private static int SIZE_LIMIT = 0xA00000;
    private static int LINE_LIMIT = 4096;
    private SearchPattern searchPattern;
    private Pattern pattern;
    private int fileMatches = 0;
    private int itemMatches = 0;
    private volatile boolean terminated = false;

    public MultiLineMappedMatcherBig(SearchPattern searchPattern) {
        this.searchPattern = searchPattern;
        this.pattern = TextRegexpUtil.makeTextPattern(searchPattern);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected MatchingObject.Def checkMeasuredInternal(FileObject fileObject, SearchListener searchListener) {
        List<TextDetail> list;
        Charset charset = FileEncodingQuery.getEncoding((FileObject)fileObject);
        try (LongCharSequence longCharSequence = null;){
            MatchingObject.Def def;
            File file = FileUtil.toFile((FileObject)fileObject);
            longCharSequence = new LongCharSequence(file, charset);
            list = this.matchWholeFile(longCharSequence, fileObject);
            if (list == null) {
                MatchingObject.Def def2 = null;
                return def2;
            }
            MatchingObject.Def def3 = def = new MatchingObject.Def(fileObject, charset, list);
            return def3;
        }
    }

    private List<TextDetail> matchWholeFile(CharSequence charSequence, FileObject fileObject) throws DataObjectNotFoundException {
        Matcher matcher = this.pattern.matcher(charSequence);
        DataObject dataObject = null;
        MultiLineMappedMatcherSmall.LineInfoHelper lineInfoHelper = new MultiLineMappedMatcherSmall.LineInfoHelper(charSequence);
        LinkedList<TextDetail> linkedList = null;
        while (matcher.find()) {
            if (linkedList == null) {
                linkedList = new LinkedList<TextDetail>();
                dataObject = DataObject.find((FileObject)fileObject);
                ++this.fileMatches;
            }
            ++this.itemMatches;
            TextDetail textDetail = new TextDetail(dataObject, this.searchPattern);
            lineInfoHelper.findAndSetPositionInfo(textDetail, matcher.start(), matcher.end(), matcher.group());
            linkedList.add(textDetail);
            if (this.fileMatches < 500 && this.itemMatches < 5000) continue;
            break;
        }
        return linkedList;
    }

    @Override
    public void terminate() {
        this.terminated = true;
    }

    class TerminatedException
    extends RuntimeException {
        TerminatedException() {
        }
    }

    private static enum State {
        STANDARD,
        ENDING,
        FLUSHING,
        FLUSHED;

    }

    private class LongCharSequence
    implements CharSequence {
        private long fileSize;
        private FileInputStream fileInputStream;
        private FileChannel fileChannel;
        private int charBufferStartsAt = -1;
        private int charBufferEndsAt = -1;
        private CharBuffer charBuffer = null;
        private MappedByteBuffer byteBuffer;
        private CharsetDecoder decoder = null;
        private int length = -1;
        private long decodedBytes = 0L;
        private boolean overflow = false;
        private int shifts = 0;
        private int maps = 0;
        private State state = State.STANDARD;

        public LongCharSequence(File file, Charset charset) throws FileNotFoundException {
            this.decoder = MultiLineMappedMatcherBig.this.prepareDecoder(charset);
            this.fileInputStream = new FileInputStream(file);
            this.fileChannel = this.fileInputStream.getChannel();
            this.fileSize = file.length();
            this.charBuffer = CharBuffer.allocate((int)Math.min(this.fileSize, (long)SIZE_LIMIT));
        }

        public void reset() {
            this.decoder.reset();
            this.decoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
            this.decodedBytes = 0L;
            this.charBuffer.clear();
            this.charBufferStartsAt = -1;
            this.charBufferEndsAt = -1;
            this.overflow = false;
            this.state = State.STANDARD;
            if (this.byteBuffer != null) {
                MatcherUtils.unmap(this.byteBuffer);
                this.byteBuffer = null;
            }
        }

        @Override
        public synchronized int length() {
            if (this.length == -1) {
                try {
                    if (this.charBufferStartsAt == -1) {
                        this.reset();
                    }
                    while (this.shiftBuffer()) {
                        if (!MultiLineMappedMatcherBig.this.terminated) continue;
                        throw new TerminatedException();
                    }
                    this.length = this.charBufferStartsAt + this.charBuffer.limit();
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
            return this.length;
        }

        @Override
        public synchronized char charAt(int n) {
            if (MultiLineMappedMatcherBig.this.terminated) {
                throw new TerminatedException();
            }
            if (this.isInBuffer(n)) {
                return this.getFromBuffer(n);
            }
            if (n > this.length()) {
                throw new IndexOutOfBoundsException();
            }
            if (n < this.charBufferStartsAt || this.charBufferStartsAt == -1) {
                this.reset();
            }
            try {
                while (this.shiftBuffer()) {
                    if (!this.isInBuffer(n)) continue;
                    return this.getFromBuffer(n);
                }
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
            throw new IllegalStateException("Cannot get character.");
        }

        private boolean shiftBuffer() throws IOException {
            boolean bl;
            ++this.shifts;
            if (this.state == State.FLUSHED) {
                assert (!this.overflow);
                bl = false;
            } else if (this.state == State.STANDARD) {
                assert (!this.overflow);
                bl = this.shiftBufferStandard();
            } else if (this.state == State.ENDING) {
                assert (this.overflow);
                bl = this.shiftBufferEnding();
            } else if (this.state == State.FLUSHING) {
                assert (this.overflow);
                bl = this.shiftBufferFlushing();
            } else {
                throw new IllegalStateException();
            }
            this.updateBufferBounds();
            return bl;
        }

        private boolean shiftBufferStandard() throws IllegalStateException, IOException {
            long l;
            if (this.byteBuffer == null || this.byteBuffer.remaining() == 0) {
                if (this.byteBuffer != null) {
                    MatcherUtils.unmap(this.byteBuffer);
                }
                l = Math.min((long)SIZE_LIMIT, this.fileSize - this.decodedBytes);
                this.byteBuffer = this.fileChannel.map(FileChannel.MapMode.READ_ONLY, this.decodedBytes, l);
                ++this.maps;
            }
            l = this.byteBuffer.position();
            int n = this.charBufferStartsAt == -1 ? 0 : this.charBuffer.limit();
            this.charBuffer.clear();
            CoderResult coderResult = this.decoder.decode(this.byteBuffer, this.charBuffer, false);
            this.charBufferStartsAt = this.charBufferStartsAt == -1 ? 0 : this.charBufferStartsAt + n;
            this.decodedBytes += (long)this.byteBuffer.position() - l;
            if (coderResult.isOverflow()) {
                if (l == (long)this.byteBuffer.position()) {
                    throw new IllegalStateException("Neverending loop?");
                }
                this.charBuffer.flip();
                return true;
            }
            if (this.decodedBytes < this.fileSize) {
                this.charBuffer.flip();
                MatcherUtils.unmap(this.byteBuffer);
                this.byteBuffer = null;
                return true;
            }
            this.state = State.ENDING;
            return this.shiftBufferEnding();
        }

        private boolean shiftBufferEnding() {
            CoderResult coderResult;
            assert (this.state == State.ENDING);
            if (this.overflow) {
                this.charBufferStartsAt += this.charBuffer.limit();
                this.charBuffer.clear();
            }
            if ((coderResult = this.decoder.decode(this.byteBuffer, this.charBuffer, true)).isOverflow()) {
                this.charBuffer.flip();
                this.overflow = true;
                return true;
            }
            this.overflow = false;
            this.state = State.FLUSHING;
            return this.shiftBufferFlushing();
        }

        private boolean shiftBufferFlushing() {
            assert (this.state == State.FLUSHING);
            if (this.overflow) {
                this.charBufferStartsAt += this.charBuffer.limit();
                this.charBuffer.clear();
            }
            CoderResult coderResult = this.decoder.flush(this.charBuffer);
            this.charBuffer.flip();
            if (coderResult.isOverflow()) {
                this.overflow = true;
            } else {
                this.overflow = false;
                this.state = State.FLUSHED;
            }
            return true;
        }

        @Override
        public synchronized CharSequence subSequence(int n, int n2) {
            if (n2 - n < LINE_LIMIT) {
                StringBuilder stringBuilder = new StringBuilder();
                for (int i = n; i < n2; ++i) {
                    stringBuilder.append(this.charAt(i));
                }
                return stringBuilder.toString();
            }
            throw new IllegalArgumentException("Long subSequences are not supported.");
        }

        @Override
        public synchronized String toString() {
            return this.subSequence(0, this.length()).toString();
        }

        public void close() {
            if (this.fileChannel != null) {
                try {
                    this.fileChannel.close();
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
            if (this.fileInputStream != null) {
                try {
                    this.fileInputStream.close();
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
            if (this.byteBuffer != null) {
                MatcherUtils.unmap(this.byteBuffer);
            }
        }

        private boolean isInBuffer(int n) {
            return n >= this.charBufferStartsAt && n < this.charBufferEndsAt;
        }

        private char getFromBuffer(int n) {
            return this.charBuffer.charAt(n - this.charBufferStartsAt);
        }

        private void updateBufferBounds() {
            this.charBufferEndsAt = this.charBufferStartsAt == -1 ? -1 : this.charBufferStartsAt + this.charBuffer.limit();
        }
    }
}

