/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.heapviewer.java.impl;

import com.sun.tools.visualvm.heapviewer.HeapContext;
import com.sun.tools.visualvm.heapviewer.HeapFragment;
import com.sun.tools.visualvm.heapviewer.java.InstanceReferenceNode;
import com.sun.tools.visualvm.heapviewer.java.JavaHeapFragment;
import com.sun.tools.visualvm.heapviewer.java.impl.Bundle;
import com.sun.tools.visualvm.heapviewer.model.DataType;
import com.sun.tools.visualvm.heapviewer.model.HeapViewerNode;
import com.sun.tools.visualvm.heapviewer.model.HeapViewerNodeFilter;
import com.sun.tools.visualvm.heapviewer.model.Progress;
import com.sun.tools.visualvm.heapviewer.model.RootNode;
import com.sun.tools.visualvm.heapviewer.model.TextNode;
import com.sun.tools.visualvm.heapviewer.ui.HeapViewPlugin;
import com.sun.tools.visualvm.heapviewer.ui.HeapViewerActions;
import com.sun.tools.visualvm.heapviewer.ui.TreeTableView;
import com.sun.tools.visualvm.heapviewer.ui.TreeTableViewColumn;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.lib.profiler.heap.ArrayItemValue;
import org.netbeans.lib.profiler.heap.Heap;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.heap.ObjectFieldValue;
import org.netbeans.lib.profiler.heap.Value;
import org.netbeans.modules.profiler.api.icons.Icons;

public class PathToGCRootPlugin
extends HeapViewPlugin {
    private final Heap heap;
    private Instance selected;
    private final TreeTableView objectsView;

    public PathToGCRootPlugin(HeapContext context, HeapViewerActions actions) {
        super(Bundle.PathToGCRootPlugin_Name(), Bundle.PathToGCRootPlugin_Description(), Icons.getIcon((String)"ProfilerIcons.RunGC"));
        this.heap = context.getFragment().getHeap();
        this.objectsView = new TreeTableView("java_objects_gcroots", context, actions, TreeTableViewColumn.instancesPlain(this.heap)){

            @Override
            protected HeapViewerNode[] computeData(RootNode root, Heap heap, String viewID, HeapViewerNodeFilter viewFilter, List<DataType> dataTypes, List<SortOrder> sortOrders, Progress progress) {
                if (PathToGCRootPlugin.this.selected != null) {
                    Instance instance = PathToGCRootPlugin.this.selected;
                    Instance nextInstance = PathToGCRootPlugin.getNearestGCRootPointer(instance);
                    if (nextInstance == null) {
                        return new HeapViewerNode[]{new TextNode(Bundle.PathToGCRootPlugin_NoRoot())};
                    }
                    if (nextInstance == instance) {
                        return new HeapViewerNode[]{new TextNode(Bundle.PathToGCRootPlugin_IsRoot())};
                    }
                    ToRoot node = null;
                    HeapViewerNode firstNode = null;
                    ToRoot previousNode = null;
                    while (instance != nextInstance) {
                        List references = instance.getReferences();
                        for (Value reference : references) {
                            if (!nextInstance.equals(reference.getDefiningInstance())) continue;
                            if (reference instanceof ObjectFieldValue) {
                                node = new FieldToRoot((ObjectFieldValue)reference);
                            } else if (reference instanceof ArrayItemValue) {
                                node = new ArrayItemToRoot((ArrayItemValue)reference);
                            }
                            if (firstNode == null) {
                                firstNode = (HeapViewerNode)((Object)node);
                                break;
                            }
                            previousNode.setChildren(new HeapViewerNode[]{(HeapViewerNode)((Object)node)});
                            break;
                        }
                        instance = nextInstance;
                        nextInstance = instance.getNearestGCRootPointer();
                        previousNode = node;
                    }
                    node.setChildren(HeapViewerNode.NO_NODES);
                    return new HeapViewerNode[]{firstNode};
                }
                return new HeapViewerNode[]{new TextNode(Bundle.PathToGCRootPlugin_NoSelection())};
            }

            @Override
            protected void childrenChanged() {
                RootNode root = this.getRoot();
                while (root != null) {
                    this.expandNode(root);
                    root = root.getNChildren() > 0 ? root.getChild(0) : null;
                }
            }
        };
    }

    @Override
    protected JComponent createComponent() {
        return this.objectsView.getComponent();
    }

    @Override
    protected void nodeSelected(HeapViewerNode node, boolean adjusting) {
        this.selected = node == null ? null : HeapViewerNode.getValue(node, DataType.INSTANCE, this.heap);
        this.objectsView.reloadView();
    }

    private static Instance getNearestGCRootPointer(Instance instance) {
        assert (!SwingUtilities.isEventDispatchThread());
        ProgressHandle pHandle = null;
        try {
            pHandle = ProgressHandle.createHandle((String)Bundle.PathToGCRootPlugin_ProgressMsg());
            pHandle.setInitialDelay(1000);
            pHandle.start(1000);
            HeapFragment.setProgress(pHandle, 0);
            Instance instance2 = instance.getNearestGCRootPointer();
            return instance2;
        }
        finally {
            if (pHandle != null) {
                pHandle.finish();
            }
        }
    }

    public static class Provider
    extends HeapViewPlugin.Provider {
        @Override
        public HeapViewPlugin createPlugin(HeapContext context, HeapViewerActions actions, String viewID) {
            if (!viewID.startsWith("diff") && JavaHeapFragment.isJavaHeap(context)) {
                return new PathToGCRootPlugin(context, actions);
            }
            return null;
        }
    }

    private static class ArrayItemToRoot
    extends InstanceReferenceNode.ArrayItem
    implements ToRoot {
        public ArrayItemToRoot(ArrayItemValue value) {
            super(value, true);
        }

        @Override
        public void setChildren(HeapViewerNode[] ch) {
            super.setChildren(ch);
        }
    }

    private static class FieldToRoot
    extends InstanceReferenceNode.Field
    implements ToRoot {
        public FieldToRoot(ObjectFieldValue value) {
            super(value, true);
        }

        @Override
        public void setChildren(HeapViewerNode[] ch) {
            super.setChildren(ch);
        }
    }

    private static interface ToRoot {
        public void setChildren(HeapViewerNode[] var1);
    }
}

