/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.v2;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.lib.profiler.common.ProfilingSettings;
import org.netbeans.lib.profiler.common.event.ProfilingStateEvent;
import org.netbeans.lib.profiler.common.event.ProfilingStateListener;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.components.ProfilerToolbar;
import org.netbeans.modules.profiler.v2.ProfilerSession;
import org.openide.util.Lookup;

public abstract class ProfilerFeature {
    public abstract Icon getIcon();

    public abstract String getName();

    public abstract String getDescription();

    public abstract int getPosition();

    public abstract JPanel getResultsUI();

    public abstract JPanel getSettingsUI();

    public abstract ProfilerToolbar getToolbar();

    public abstract boolean supportsSettings(ProfilingSettings var1);

    public abstract void configureSettings(ProfilingSettings var1);

    public abstract boolean currentSettingsValid();

    public abstract boolean supportsConfiguration(Lookup var1);

    public abstract void configure(Lookup var1);

    protected void activatedInSession() {
    }

    protected void deactivatedInSession() {
    }

    public abstract void addChangeListener(ChangeListener var1);

    public abstract void removeChangeListener(ChangeListener var1);

    public static final class Registry {
        private static boolean HAS_PROVIDERS;

        private Registry() {
        }

        public static boolean hasProviders() {
            return HAS_PROVIDERS;
        }

        static Collection<? extends Provider> getProviders() {
            Collection collection = Lookup.getDefault().lookupAll(Provider.class);
            HAS_PROVIDERS = !collection.isEmpty();
            return collection;
        }
    }

    public static abstract class Provider {
        public abstract ProfilerFeature getFeature(ProfilerSession var1);
    }

    public static abstract class Basic
    extends ProfilerFeature {
        private Set<ChangeListener> listeners;
        private final Icon icon;
        private final String name;
        private final String description;
        private final int position;
        private final ProfilerSession session;
        private volatile boolean isActive;
        private ProfilingStateListener listener;

        public Basic(Icon icon, String string, String string2, int n, ProfilerSession profilerSession) {
            this.icon = icon;
            this.name = string;
            this.description = string2;
            this.position = n;
            this.session = profilerSession;
        }

        @Override
        public final Icon getIcon() {
            return this.icon;
        }

        @Override
        public final String getName() {
            return this.name;
        }

        @Override
        public final String getDescription() {
            return this.description;
        }

        @Override
        public final int getPosition() {
            return this.position;
        }

        protected final ProfilerSession getSession() {
            return this.session;
        }

        @Override
        public JPanel getSettingsUI() {
            return null;
        }

        @Override
        public boolean supportsSettings(ProfilingSettings profilingSettings) {
            return true;
        }

        @Override
        public boolean currentSettingsValid() {
            return true;
        }

        @Override
        public ProfilerToolbar getToolbar() {
            return null;
        }

        @Override
        public boolean supportsConfiguration(Lookup lookup) {
            return false;
        }

        @Override
        public void configure(Lookup lookup) {
        }

        protected void notifyActivated() {
        }

        protected void notifyDeactivated() {
        }

        protected final boolean isActivated() {
            return this.isActive;
        }

        @Override
        protected final void activatedInSession() {
            this.isActive = true;
            this.notifyActivated();
            this.session.addListener(this.getListener());
            final int n = this.session.getState();
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    Basic.this.profilingStateChanged(-1, n);
                }
            };
            UIUtils.runInEventDispatchThread((Runnable)runnable);
        }

        @Override
        protected final void deactivatedInSession() {
            this.isActive = false;
            this.notifyDeactivated();
            this.session.removeListener(this.getListener());
            this.listener = null;
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    Basic.this.profilingStateChanged(-1, 1);
                }
            };
            UIUtils.runInEventDispatchThread((Runnable)runnable);
        }

        protected final int getSessionState() {
            return this.isActive ? this.session.getState() : 1;
        }

        protected final String readFlag(String string, String string2) {
            String string3 = this.getClass().getName();
            return this.session.getStorage().readFlag(string3 + "_" + string, string2);
        }

        protected final void storeFlag(String string, String string2) {
            String string3 = this.getClass().getName();
            this.session.getStorage().storeFlag(string3 + "_" + string, string2);
        }

        private ProfilingStateListener getListener() {
            if (this.listener == null) {
                this.listener = new ProfilingStateListener(){

                    public void serverStateChanged(int n, int n2) {
                        if (!Basic.this.isActive) {
                            return;
                        }
                        Basic.this.serverStateChanged(n, n2);
                    }

                    public void instrumentationChanged(int n, int n2) {
                        if (!Basic.this.isActive) {
                            return;
                        }
                        Basic.this.instrumentationChanged(n, n2);
                    }

                    public void profilingStateChanged(ProfilingStateEvent profilingStateEvent) {
                        if (!Basic.this.isActive) {
                            return;
                        }
                        Basic.this.profilingStateChanged(profilingStateEvent.getOldState(), profilingStateEvent.getNewState());
                    }

                    public void threadsMonitoringChanged() {
                        if (!Basic.this.isActive) {
                            return;
                        }
                        Basic.this.threadsMonitoringChanged();
                    }

                    public void lockContentionMonitoringChanged() {
                        if (!Basic.this.isActive) {
                            return;
                        }
                        Basic.this.lockContentionMonitoringChanged();
                    }
                };
            }
            return this.listener;
        }

        protected void serverStateChanged(int n, int n2) {
        }

        protected void instrumentationChanged(int n, int n2) {
        }

        protected void profilingStateChanged(int n, int n2) {
        }

        protected void threadsMonitoringChanged() {
        }

        protected void lockContentionMonitoringChanged() {
        }

        @Override
        public final synchronized void addChangeListener(ChangeListener changeListener) {
            if (this.listeners == null) {
                this.listeners = new HashSet<ChangeListener>();
            }
            this.listeners.add(changeListener);
        }

        @Override
        public final synchronized void removeChangeListener(ChangeListener changeListener) {
            if (this.listeners != null) {
                this.listeners.remove(changeListener);
            }
        }

        protected final synchronized void fireChange() {
            if (this.listeners == null) {
                return;
            }
            ChangeEvent changeEvent = new ChangeEvent(this);
            for (ChangeListener changeListener : this.listeners) {
                changeListener.stateChanged(changeEvent);
            }
        }
    }
}

