/*
 * Decompiled with CFR 0.152.
 */
package org.openide.awt;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.LabelUI;
import org.openide.awt.HtmlRenderer;
import org.openide.awt.HtmlRendererImpl;
import org.openide.util.Exceptions;

class HtmlLabelUI
extends LabelUI {
    static final boolean antialias = Boolean.getBoolean("nb.cellrenderer.antialiasing") || Boolean.getBoolean("swing.aatext") || HtmlLabelUI.isGTK() && HtmlLabelUI.gtkShouldAntialias() || HtmlLabelUI.isAqua();
    private static HtmlLabelUI uiInstance;
    private static int FIXED_HEIGHT;
    private static Map<Object, Object> hintsMap;
    private static Color unfocusedSelBg;
    private static Color unfocusedSelFg;
    private static Boolean gtkAA;

    HtmlLabelUI() {
    }

    public static ComponentUI createUI(JComponent jComponent) {
        assert (jComponent instanceof HtmlRendererImpl);
        if (uiInstance == null) {
            uiInstance = new HtmlLabelUI();
        }
        return uiInstance;
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        if (GraphicsEnvironment.isHeadless()) {
            return super.getPreferredSize(jComponent);
        }
        return this.calcPreferredSize((HtmlRendererImpl)jComponent);
    }

    private static int textWidth(String string, Graphics graphics, Font font, boolean bl) {
        if (string != null) {
            if (bl) {
                return Math.round(Math.round(Math.ceil(HtmlRenderer.renderHTML(string, graphics, 0, 0, Integer.MAX_VALUE, Integer.MAX_VALUE, font, Color.BLACK, 0, false))));
            }
            return Math.round(Math.round(Math.ceil(HtmlRenderer.renderPlainString(string, graphics, 0, 0, Integer.MAX_VALUE, Integer.MAX_VALUE, font, Color.BLACK, 0, false))));
        }
        return 0;
    }

    private Dimension calcPreferredSize(HtmlRendererImpl htmlRendererImpl) {
        Insets insets = htmlRendererImpl.getInsets();
        Dimension dimension = new Dimension(insets.left + insets.right, insets.top + insets.bottom);
        String string = htmlRendererImpl.getText();
        Graphics graphics = htmlRendererImpl.getGraphics();
        Icon icon = htmlRendererImpl.getIcon();
        if (string != null) {
            FontMetrics fontMetrics = graphics.getFontMetrics(htmlRendererImpl.getFont());
            dimension.height += fontMetrics.getMaxAscent() + fontMetrics.getMaxDescent();
        }
        if (icon != null) {
            if (htmlRendererImpl.isCentered()) {
                dimension.height += icon.getIconHeight() + htmlRendererImpl.getIconTextGap();
                dimension.width += icon.getIconWidth();
            } else {
                dimension.height = Math.max(icon.getIconHeight() + insets.top + insets.bottom, dimension.height);
                dimension.width += icon.getIconWidth() + htmlRendererImpl.getIconTextGap();
            }
        }
        ((Graphics2D)graphics).addRenderingHints(HtmlLabelUI.getHints());
        int n = HtmlLabelUI.textWidth(string, graphics, htmlRendererImpl.getFont(), htmlRendererImpl.isHtml()) + 4;
        dimension.width = htmlRendererImpl.isCentered() ? Math.max(dimension.width, n + insets.right + insets.left) : (dimension.width += n + htmlRendererImpl.getIndent());
        if (FIXED_HEIGHT > 0) {
            dimension.height = FIXED_HEIGHT;
        }
        return dimension;
    }

    static final Map<?, ?> getHints() {
        if (hintsMap == null && (hintsMap = (Map)Toolkit.getDefaultToolkit().getDesktopProperty("awt.font.desktophints")) == null) {
            hintsMap = new HashMap<Object, Object>();
            if (antialias) {
                hintsMap.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            }
        }
        Map<Object, Object> map = hintsMap;
        assert (map != null);
        return map;
    }

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        Color color = HtmlLabelUI.getBackgroundFor((HtmlRendererImpl)jComponent);
        HtmlRendererImpl htmlRendererImpl = (HtmlRendererImpl)jComponent;
        if (!(color == null || HtmlLabelUI.isNimbus() && htmlRendererImpl.getType() == HtmlRendererImpl.Type.TREE)) {
            int n;
            if (htmlRendererImpl.getType() == HtmlRendererImpl.Type.TABLE) {
                n = 0;
            } else {
                n = htmlRendererImpl.isSelected() ? (htmlRendererImpl.getIcon() == null ? 0 : htmlRendererImpl.getIcon().getIconWidth() + htmlRendererImpl.getIconTextGap()) : 0;
                n += htmlRendererImpl.getIndent();
            }
            graphics.setColor(color);
            graphics.fillRect(n, 0, jComponent.getWidth() - n, jComponent.getHeight());
        }
        if (htmlRendererImpl.isLeadSelection()) {
            Color color2 = UIManager.getColor("Tree.selectionBorderColor");
            if (color2 == null || color2.equals(color)) {
                color2 = Color.BLUE;
            }
            if (!(HtmlLabelUI.isGTK() || HtmlLabelUI.isAqua() || HtmlLabelUI.isNimbus())) {
                int n = htmlRendererImpl.getType() == HtmlRendererImpl.Type.TABLE ? 0 : (htmlRendererImpl.getIcon() == null ? 0 : htmlRendererImpl.getIcon().getIconWidth() + htmlRendererImpl.getIconTextGap());
                graphics.setColor(color2);
                graphics.drawRect(n, 0, jComponent.getWidth() - (n + 1), jComponent.getHeight() - 1);
            }
        }
        this.paint(graphics, jComponent);
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        ((Graphics2D)graphics).addRenderingHints(HtmlLabelUI.getHints());
        HtmlRendererImpl htmlRendererImpl = (HtmlRendererImpl)jComponent;
        if (htmlRendererImpl.isCentered()) {
            this.paintIconAndTextCentered(graphics, htmlRendererImpl);
        } else {
            this.paintIconAndText(graphics, htmlRendererImpl);
        }
    }

    private void paintIconAndText(Graphics graphics, HtmlRendererImpl htmlRendererImpl) {
        int n;
        Font font = htmlRendererImpl.getFont();
        graphics.setFont(font);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n2 = fontMetrics.getMaxAscent() + fontMetrics.getMaxDescent();
        Insets insets = htmlRendererImpl.getInsets();
        int n3 = htmlRendererImpl.getHeight();
        int n4 = n3 - (insets.top + insets.bottom);
        int n5 = n4 >= n2 ? n2 + insets.top + (n4 / 2 - n2 / 2) - fontMetrics.getMaxDescent() : (htmlRendererImpl.getHeight() > n2 ? n2 + (n3 - n2) / 2 - fontMetrics.getMaxDescent() : fontMetrics.getMaxAscent());
        int n6 = htmlRendererImpl.getIndent();
        Icon icon = htmlRendererImpl.getIcon();
        if (icon != null && icon.getIconWidth() > 0 && icon.getIconHeight() > 0) {
            int n7 = n4 > icon.getIconHeight() ? insets.top + (n4 / 2 - icon.getIconHeight() / 2) : (n4 == icon.getIconHeight() ? insets.top : insets.top);
            n = insets.left + htmlRendererImpl.getIndent() + 1;
            try {
                icon.paintIcon(htmlRendererImpl, graphics, n, n7);
            }
            catch (NullPointerException nullPointerException) {
                Exceptions.attachMessage((Throwable)nullPointerException, (String)("Probably an ImageIcon with a null source image: " + icon + " - " + htmlRendererImpl.getText()));
                Exceptions.printStackTrace((Throwable)nullPointerException);
            }
            n6 = n + icon.getIconWidth() + htmlRendererImpl.getIconTextGap();
        } else {
            n6 += insets.left;
        }
        String string = htmlRendererImpl.getText();
        if (string == null) {
            return;
        }
        n = icon != null ? htmlRendererImpl.getWidth() - (insets.left + insets.right + icon.getIconWidth() + htmlRendererImpl.getIconTextGap() + htmlRendererImpl.getIndent()) : htmlRendererImpl.getWidth() - (insets.left + insets.right + htmlRendererImpl.getIndent());
        Color color = HtmlLabelUI.getBackgroundFor(htmlRendererImpl);
        Color color2 = HtmlLabelUI.ensureContrastingColor(HtmlLabelUI.getForegroundFor(htmlRendererImpl), color);
        if (htmlRendererImpl.isHtml()) {
            HtmlRenderer._renderHTML(string, 0, graphics, n6, n5, n, n2, font, color2, htmlRendererImpl.getRenderStyle(), true, color, htmlRendererImpl.isSelected());
        } else {
            HtmlRenderer.renderPlainString(string, graphics, n6, n5, n, n2, font, color2, htmlRendererImpl.getRenderStyle(), true);
        }
    }

    private void paintIconAndTextCentered(Graphics graphics, HtmlRendererImpl htmlRendererImpl) {
        int n;
        int n2;
        Insets insets = htmlRendererImpl.getInsets();
        Icon icon = htmlRendererImpl.getIcon();
        int n3 = htmlRendererImpl.getWidth() - (insets.left + insets.right);
        int n4 = insets.left;
        int n5 = 0;
        if (icon != null && icon.getIconWidth() > 0 && icon.getIconHeight() > 0) {
            n2 = n3 > icon.getIconWidth() ? n3 / 2 - icon.getIconWidth() / 2 : n4;
            n = 0;
            icon.paintIcon(htmlRendererImpl, graphics, n2, n);
            n5 += icon.getIconHeight() + htmlRendererImpl.getIconTextGap();
        }
        n4 = (n2 = htmlRendererImpl.getPreferredSize().width) < htmlRendererImpl.getWidth() ? htmlRendererImpl.getWidth() / 2 - n2 / 2 : 0;
        n = htmlRendererImpl.getHeight() - n5;
        Font font = htmlRendererImpl.getFont();
        graphics.setFont(font);
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        n5 += fontMetrics.getMaxAscent();
        Color color = HtmlLabelUI.getBackgroundFor(htmlRendererImpl);
        Color color2 = HtmlLabelUI.ensureContrastingColor(HtmlLabelUI.getForegroundFor(htmlRendererImpl), color);
        if (htmlRendererImpl.isHtml()) {
            HtmlRenderer._renderHTML(htmlRendererImpl.getText(), 0, graphics, n4, n5, n2, n, font, color2, htmlRendererImpl.getRenderStyle(), true, color, htmlRendererImpl.isSelected());
        } else {
            HtmlRenderer.renderString(htmlRendererImpl.getText(), graphics, n4, n5, n2, n, htmlRendererImpl.getFont(), color2, htmlRendererImpl.getRenderStyle(), true);
        }
    }

    static Color ensureContrastingColor(Color color, Color color2) {
        if (color2 == null) {
            if (HtmlLabelUI.isNimbus()) {
                color2 = UIManager.getColor("Tree.background");
                if (null == color2) {
                    color2 = Color.WHITE;
                }
            } else {
                color2 = UIManager.getColor("text");
                if (color2 == null) {
                    color2 = Color.WHITE;
                }
            }
        }
        if (color == null) {
            if (HtmlLabelUI.isNimbus()) {
                color = UIManager.getColor("Tree.foreground");
                if (null == color) {
                    color = Color.BLACK;
                }
            } else {
                color = UIManager.getColor("textText");
                if (color == null) {
                    color = Color.BLACK;
                }
            }
        }
        if (Color.BLACK.equals(color) && Color.WHITE.equals(color)) {
            return color;
        }
        boolean bl = color.equals(color2);
        int n = 0;
        if (!bl) {
            n = HtmlLabelUI.difference(color, color2);
            boolean bl2 = bl = n < 80;
        }
        if (bl) {
            int n2 = HtmlLabelUI.luminance(color2);
            boolean bl3 = n2 >= 128;
            color = bl3 ? Color.BLACK : Color.WHITE;
        }
        return color;
    }

    private static int difference(Color color, Color color2) {
        return Math.abs(HtmlLabelUI.luminance(color) - HtmlLabelUI.luminance(color2));
    }

    private static int luminance(Color color) {
        return (299 * color.getRed() + 587 * color.getGreen() + 114 * color.getBlue()) / 1000;
    }

    static Color getBackgroundFor(HtmlRendererImpl htmlRendererImpl) {
        if (htmlRendererImpl.isOpaque()) {
            return htmlRendererImpl.getBackground();
        }
        if (htmlRendererImpl.isSelected() && !htmlRendererImpl.isParentFocused() && !HtmlLabelUI.isGTK() && !HtmlLabelUI.isNimbus()) {
            return HtmlLabelUI.getUnfocusedSelectionBackground();
        }
        Color color = null;
        if (htmlRendererImpl.isSelected()) {
            switch (htmlRendererImpl.getType()) {
                case LIST: {
                    color = UIManager.getColor("List.selectionBackground");
                    if (color != null) break;
                    color = UIManager.getColor("Tree.selectionBackground");
                    break;
                }
                case TABLE: {
                    color = UIManager.getColor("Table.selectionBackground");
                    break;
                }
                case TREE: {
                    return UIManager.getColor("Tree.selectionBackground");
                }
            }
            return color == null ? htmlRendererImpl.getBackground() : color;
        }
        return null;
    }

    static Color getForegroundFor(HtmlRendererImpl htmlRendererImpl) {
        if (htmlRendererImpl.isSelected() && !htmlRendererImpl.isParentFocused() && !HtmlLabelUI.isGTK() && !HtmlLabelUI.isNimbus()) {
            return HtmlLabelUI.getUnfocusedSelectionForeground();
        }
        if (!htmlRendererImpl.isEnabled()) {
            return UIManager.getColor("textInactiveText");
        }
        Color color = null;
        if (htmlRendererImpl.isSelected()) {
            switch (htmlRendererImpl.getType()) {
                case LIST: {
                    color = UIManager.getColor("List.selectionForeground");
                    break;
                }
                case TABLE: {
                    color = UIManager.getColor("Table.selectionForeground");
                    break;
                }
                case TREE: {
                    color = UIManager.getColor("Tree.selectionForeground");
                }
            }
        }
        return color == null ? htmlRendererImpl.getForeground() : color;
    }

    static boolean isAqua() {
        return "Aqua".equals(UIManager.getLookAndFeel().getID());
    }

    static boolean isGTK() {
        return "GTK".equals(UIManager.getLookAndFeel().getID());
    }

    static boolean isNimbus() {
        return "Nimbus".equals(UIManager.getLookAndFeel().getID());
    }

    private static Color getUnfocusedSelectionBackground() {
        if (unfocusedSelBg == null && (unfocusedSelBg = UIManager.getColor("nb.explorer.unfocusedSelBg")) == null) {
            unfocusedSelBg = UIManager.getColor("controlShadow");
            if (unfocusedSelBg == null) {
                unfocusedSelBg = Color.lightGray;
            }
            if (!Color.WHITE.equals(unfocusedSelBg.brighter())) {
                unfocusedSelBg = unfocusedSelBg.brighter();
            }
        }
        return unfocusedSelBg;
    }

    private static Color getUnfocusedSelectionForeground() {
        if (unfocusedSelFg == null && (unfocusedSelFg = UIManager.getColor("nb.explorer.unfocusedSelFg")) == null && (unfocusedSelFg = UIManager.getColor("textText")) == null) {
            unfocusedSelFg = Color.BLACK;
        }
        return unfocusedSelFg;
    }

    public static final boolean gtkShouldAntialias() {
        if (gtkAA == null) {
            Object object = Toolkit.getDefaultToolkit().getDesktopProperty("gnome.Xft/Antialias");
            gtkAA = new Integer(1).equals(object) ? Boolean.TRUE : Boolean.FALSE;
        }
        return gtkAA;
    }

    static {
        String string = System.getProperty("nb.cellrenderer.fixedheight");
        if (string != null) {
            try {
                FIXED_HEIGHT = Integer.parseInt(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

