/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.swing.renderer;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JComponent;
import org.netbeans.lib.profiler.ui.swing.renderer.BaseRenderer;
import org.netbeans.lib.profiler.ui.swing.renderer.ProfilerRenderer;
import org.netbeans.lib.profiler.ui.swing.renderer.RelativeRenderer;

public abstract class MultiRenderer
extends BaseRenderer
implements RelativeRenderer {
    private Dimension preferredSize;

    protected int renderersGap() {
        return 0;
    }

    protected abstract ProfilerRenderer[] valueRenderers();

    @Override
    public void setDiffMode(boolean bl) {
        ProfilerRenderer[] profilerRendererArray = this.valueRenderers();
        if (profilerRendererArray == null) {
            return;
        }
        for (ProfilerRenderer profilerRenderer : profilerRendererArray) {
            if (!(profilerRenderer instanceof RelativeRenderer)) continue;
            ((RelativeRenderer)((Object)profilerRenderer)).setDiffMode(bl);
        }
    }

    @Override
    public boolean isDiffMode() {
        ProfilerRenderer[] profilerRendererArray = this.valueRenderers();
        if (profilerRendererArray == null) {
            return false;
        }
        for (ProfilerRenderer profilerRenderer : profilerRendererArray) {
            if (!(profilerRenderer instanceof RelativeRenderer)) continue;
            return ((RelativeRenderer)((Object)profilerRenderer)).isDiffMode();
        }
        return false;
    }

    @Override
    public void setOpaque(boolean bl) {
        super.setOpaque(bl);
        ProfilerRenderer[] profilerRendererArray = this.valueRenderers();
        if (profilerRendererArray == null) {
            return;
        }
        for (ProfilerRenderer profilerRenderer : profilerRendererArray) {
            profilerRenderer.getComponent().setOpaque(bl);
        }
    }

    @Override
    public void setForeground(Color color) {
        super.setForeground(color);
        ProfilerRenderer[] profilerRendererArray = this.valueRenderers();
        if (profilerRendererArray == null) {
            return;
        }
        for (ProfilerRenderer profilerRenderer : profilerRendererArray) {
            profilerRenderer.getComponent().setForeground(color);
        }
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        ProfilerRenderer[] profilerRendererArray = this.valueRenderers();
        if (profilerRendererArray == null) {
            return;
        }
        for (ProfilerRenderer profilerRenderer : profilerRendererArray) {
            profilerRenderer.getComponent().setBackground(color);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.preferredSize == null) {
            this.preferredSize = new Dimension();
        } else {
            this.preferredSize.setSize(0, 0);
        }
        ProfilerRenderer[] profilerRendererArray = this.valueRenderers();
        if (profilerRendererArray != null) {
            int n = 0;
            for (ProfilerRenderer profilerRenderer : profilerRendererArray) {
                JComponent jComponent = profilerRenderer.getComponent();
                if (!jComponent.isVisible()) continue;
                Dimension dimension = jComponent.getPreferredSize();
                this.preferredSize.width += dimension.width;
                this.preferredSize.height = Math.max(this.preferredSize.height, dimension.height);
                ++n;
            }
            this.preferredSize.width += this.renderersGap() * (n - 1);
        }
        return this.sharedDimension(this.preferredSize);
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        int n = this.getHorizontalAlignment();
        int n2 = this.renderersGap();
        if (n == 10 || n == 2) {
            int n3 = this.location.x;
            for (ProfilerRenderer profilerRenderer : this.valueRenderers()) {
                JComponent jComponent = profilerRenderer.getComponent();
                if (!jComponent.isVisible()) continue;
                int n4 = jComponent.getPreferredSize().width;
                jComponent.setSize(n4, this.size.height);
                profilerRenderer.move(n3, this.location.y);
                jComponent.paint(graphics);
                n3 += n4 + n2;
            }
        } else {
            int n5 = this.location.x + this.size.width;
            ProfilerRenderer[] profilerRendererArray = this.valueRenderers();
            for (int i = profilerRendererArray.length - 1; i >= 0; --i) {
                ProfilerRenderer profilerRenderer = profilerRendererArray[i];
                JComponent jComponent = profilerRenderer.getComponent();
                if (!jComponent.isVisible()) continue;
                int n6 = jComponent.getPreferredSize().width;
                jComponent.setSize(n6, this.size.height);
                profilerRenderer.move(n5 -= n6, this.location.y);
                jComponent.paint(graphics);
                n5 -= n2;
            }
        }
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        ProfilerRenderer[] profilerRendererArray = this.valueRenderers();
        if (profilerRendererArray != null) {
            for (ProfilerRenderer profilerRenderer : profilerRendererArray) {
                stringBuilder.append(profilerRenderer.toString());
            }
        }
        return stringBuilder.toString();
    }
}

