/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.swing;

import java.awt.Color;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.Objects;
import java.util.ResourceBundle;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

public class TextArea
extends JTextArea {
    private String hint;
    private Color hintFg;
    private boolean showsHint;
    private boolean changeListener;

    private static ResourceBundle BUNDLE() {
        return ResourceBundle.getBundle("org.netbeans.lib.profiler.ui.swing.Bundle");
    }

    public TextArea() {
    }

    public TextArea(String string) {
        super(string);
    }

    public TextArea(int n, int n2) {
        super(n, n2);
    }

    public TextArea(String string, int n, int n2) {
        super(string, n, n2);
    }

    public TextArea(Document document) {
        super(document);
    }

    public TextArea(Document document, String string, int n, int n2) {
        super(document, string, n, n2);
    }

    @Override
    public void setText(String string) {
        if (this.showsHint() && !Objects.equals(string, this.hint)) {
            this.hideHint();
        }
        if (!this.changeListener) {
            this.changeListener = true;
            this.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent documentEvent) {
                    this.updated();
                }

                @Override
                public void removeUpdate(DocumentEvent documentEvent) {
                    this.updated();
                }

                @Override
                public void changedUpdate(DocumentEvent documentEvent) {
                    this.updated();
                }

                private void updated() {
                    if (!TextArea.this.showsHint()) {
                        TextArea.this.changed();
                    }
                }
            });
        }
        super.setText(string);
    }

    protected void changed() {
    }

    public void setHint(String string) {
        this.hideHint();
        this.hint = string;
        if (!this.isFocusOwner()) {
            this.showHint();
        }
    }

    public String getHint() {
        return this.hint;
    }

    public boolean showsHint() {
        return this.showsHint;
    }

    @Override
    protected void processFocusEvent(FocusEvent focusEvent) {
        if (this.isFocusOwner()) {
            this.hideHint();
        } else {
            this.showHint();
        }
        super.processFocusEvent(focusEvent);
    }

    private void showHint() {
        if (this.hint != null && this.getText().isEmpty()) {
            this.showsHint = true;
            this.setText(this.hint);
            this.hintFg = this.getForeground();
            this.setForeground(this.getDisabledTextColor());
        }
    }

    private void hideHint() {
        if (this.showsHint) {
            this.showsHint = false;
            this.setForeground(this.hintFg);
            if (Objects.equals(this.getText(), this.hint)) {
                this.setText("");
            }
        }
    }

    @Override
    protected void processMouseEvent(MouseEvent mouseEvent) {
        super.processMouseEvent(mouseEvent);
        if (mouseEvent.isPopupTrigger() && this.isEnabled()) {
            this.showPopup(mouseEvent);
        }
    }

    private void showPopup(MouseEvent mouseEvent) {
        Object object;
        boolean bl = this.isEditable();
        boolean bl2 = this.getSelectedText() != null;
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem(TextArea.BUNDLE().getString("TextArea_Cut")){

            @Override
            protected void fireActionPerformed(ActionEvent actionEvent) {
                super.fireActionPerformed(actionEvent);
                TextArea.this.cut();
                this.requestFocusInWindow();
            }
        };
        jMenuItem.setEnabled(bl && bl2);
        jPopupMenu.add(jMenuItem);
        JMenuItem jMenuItem2 = new JMenuItem(TextArea.BUNDLE().getString("TextArea_Copy")){

            @Override
            protected void fireActionPerformed(ActionEvent actionEvent) {
                super.fireActionPerformed(actionEvent);
                TextArea.this.copy();
                this.requestFocusInWindow();
            }
        };
        jMenuItem2.setEnabled(bl2);
        jPopupMenu.add(jMenuItem2);
        JMenuItem jMenuItem3 = new JMenuItem(TextArea.BUNDLE().getString("TextArea_Paste")){

            @Override
            protected void fireActionPerformed(ActionEvent actionEvent) {
                super.fireActionPerformed(actionEvent);
                TextArea.this.hideHint();
                try {
                    TextArea.this.replaceSelection(Toolkit.getDefaultToolkit().getSystemClipboard().getContents(this).getTransferData(DataFlavor.stringFlavor).toString());
                    this.requestFocusInWindow();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                TextArea.this.showHint();
            }
        };
        try {
            object = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(this);
            jMenuItem3.setEnabled(bl && object != null && object.isDataFlavorSupported(DataFlavor.stringFlavor));
            this.requestFocusInWindow();
        }
        catch (Exception exception) {
            jMenuItem3.setEnabled(false);
        }
        jPopupMenu.add(jMenuItem3);
        if (bl) {
            object = new JMenuItem(TextArea.BUNDLE().getString("TextArea_Delete")){

                @Override
                protected void fireActionPerformed(ActionEvent actionEvent) {
                    super.fireActionPerformed(actionEvent);
                    try {
                        int n = TextArea.this.getSelectionStart();
                        TextArea.this.getDocument().remove(n, TextArea.this.getSelectionEnd() - n);
                        this.requestFocusInWindow();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            };
            ((JMenuItem)object).setEnabled(bl2);
            jPopupMenu.add((JMenuItem)object);
        }
        jPopupMenu.addSeparator();
        object = new JMenuItem(TextArea.BUNDLE().getString("TextArea_SelectAll")){

            @Override
            protected void fireActionPerformed(ActionEvent actionEvent) {
                super.fireActionPerformed(actionEvent);
                TextArea.this.selectAll();
                this.requestFocusInWindow();
            }
        };
        ((JMenuItem)object).setEnabled(!this.showsHint() && !this.getText().isEmpty());
        jPopupMenu.add((JMenuItem)object);
        this.customizePopup(jPopupMenu);
        jPopupMenu.show(this, mouseEvent.getX(), mouseEvent.getY());
    }

    protected void customizePopup(JPopupMenu jPopupMenu) {
    }

    @Override
    protected void processKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.isControlDown() && keyEvent.getID() == 402) {
            int n = keyEvent.getKeyCode();
            if (n == 61 || n == 521) {
                if (this.changeSize(keyEvent.isShiftDown(), true)) {
                    keyEvent.consume();
                }
            } else if (n == 45) {
                if (this.changeSize(keyEvent.isShiftDown(), false)) {
                    keyEvent.consume();
                }
            } else if (n == 48 && this.resetSize()) {
                keyEvent.consume();
            }
        }
        if (!keyEvent.isConsumed()) {
            super.processKeyEvent(keyEvent);
        }
    }

    protected boolean changeSize(boolean bl, boolean bl2) {
        return false;
    }

    protected boolean resetSize() {
        return false;
    }

    protected final JMenu createResizeMenu() {
        JMenu jMenu = new JMenu(TextArea.BUNDLE().getString("TextArea_Resize"));
        JMenuItem jMenuItem = new JMenuItem(TextArea.BUNDLE().getString("TextArea_HorizPlus")){

            @Override
            protected void fireActionPerformed(ActionEvent actionEvent) {
                TextArea.this.changeSize(false, true);
            }
        };
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(521, 2));
        jMenu.add(jMenuItem);
        JMenuItem jMenuItem2 = new JMenuItem(TextArea.BUNDLE().getString("TextArea_HorizMinus")){

            @Override
            protected void fireActionPerformed(ActionEvent actionEvent) {
                TextArea.this.changeSize(false, false);
            }
        };
        jMenuItem2.setAccelerator(KeyStroke.getKeyStroke(45, 2));
        jMenu.add(jMenuItem2);
        JMenuItem jMenuItem3 = new JMenuItem(TextArea.BUNDLE().getString("TextArea_VertPlus")){

            @Override
            protected void fireActionPerformed(ActionEvent actionEvent) {
                TextArea.this.changeSize(true, true);
            }
        };
        jMenuItem3.setAccelerator(KeyStroke.getKeyStroke(521, 3));
        jMenu.add(jMenuItem3);
        JMenuItem jMenuItem4 = new JMenuItem(TextArea.BUNDLE().getString("TextArea_VertMinus")){

            @Override
            protected void fireActionPerformed(ActionEvent actionEvent) {
                TextArea.this.changeSize(true, false);
            }
        };
        jMenuItem4.setAccelerator(KeyStroke.getKeyStroke(45, 3));
        jMenu.add(jMenuItem4);
        jMenu.addSeparator();
        JMenuItem jMenuItem5 = new JMenuItem(TextArea.BUNDLE().getString("TextArea_DefaultSize")){

            @Override
            protected void fireActionPerformed(ActionEvent actionEvent) {
                TextArea.this.resetSize();
            }
        };
        jMenuItem5.setAccelerator(KeyStroke.getKeyStroke(48, 2));
        jMenu.add(jMenuItem5);
        return jMenu;
    }
}

