/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.swing.renderer;

import java.text.Format;
import org.netbeans.lib.profiler.ui.Formatters;
import org.netbeans.lib.profiler.ui.swing.renderer.FormattedLabelRenderer;
import org.netbeans.lib.profiler.ui.swing.renderer.RelativeRenderer;

public class NumberRenderer
extends FormattedLabelRenderer
implements RelativeRenderer {
    private final Format outputFormat;
    protected boolean renderingDiff;

    public NumberRenderer() {
        this((Format)null);
    }

    public NumberRenderer(Format format) {
        super(Formatters.numberFormat());
        this.outputFormat = format;
        this.setHorizontalAlignment(11);
    }

    @Override
    public void setDiffMode(boolean bl) {
        this.renderingDiff = bl;
    }

    @Override
    public boolean isDiffMode() {
        return this.renderingDiff;
    }

    @Override
    protected String getValueString(Object object, int n, Format format) {
        if (object == null) {
            return "-";
        }
        String string = super.getValueString(object, n, format);
        String string2 = string = this.outputFormat == null ? string : NumberRenderer.formatImpl(this.outputFormat, string);
        if (this.renderingDiff && object instanceof Number && ((Number)object).doubleValue() >= 0.0) {
            string = '+' + string;
        }
        return string;
    }
}

