/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.heap;

import java.util.HashMap;
import java.util.Map;
import org.netbeans.lib.profiler.heap.GCRoot;
import org.netbeans.lib.profiler.heap.HprofByteBuffer;
import org.netbeans.lib.profiler.heap.HprofGCRoots;
import org.netbeans.lib.profiler.heap.HprofObject;
import org.netbeans.lib.profiler.heap.Instance;

class HprofGCRoot
extends HprofObject
implements GCRoot {
    static Map kindMap = new HashMap();
    HprofGCRoots roots;

    HprofGCRoot(HprofGCRoots hprofGCRoots, long l) {
        super(l);
        this.roots = hprofGCRoots;
    }

    @Override
    public Instance getInstance() {
        return this.roots.heap.getInstanceByID(this.getInstanceId());
    }

    @Override
    public String getKind() {
        byte by = this.getHprofBuffer().get(this.fileOffset);
        return (String)kindMap.get(by & 0xFF);
    }

    long getInstanceId() {
        return this.getHprofBuffer().getID(this.fileOffset + 1L);
    }

    HprofByteBuffer getHprofBuffer() {
        return this.roots.heap.dumpBuffer;
    }

    static {
        kindMap.put(255, "unknown");
        kindMap.put(1, "JNI global");
        kindMap.put(2, "JNI local");
        kindMap.put(3, "Java frame");
        kindMap.put(4, "native stack");
        kindMap.put(5, "sticky class");
        kindMap.put(6, "thread block");
        kindMap.put(7, "monitor used");
        kindMap.put(8, "thread object");
        kindMap.put(137, "interned string");
        kindMap.put(138, "finalizing");
        kindMap.put(139, "debugger");
        kindMap.put(140, "reference cleanup");
        kindMap.put(141, "VM internal");
        kindMap.put(142, "JNI monitor");
    }
}

