/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results.cpu;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.WeakHashMap;
import java.util.logging.Level;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.results.CCTNode;
import org.netbeans.lib.profiler.results.FilterSortSupport;
import org.netbeans.lib.profiler.results.ResultsSnapshot;
import org.netbeans.lib.profiler.results.cpu.AllThreadsMergedCPUCCTContainer;
import org.netbeans.lib.profiler.results.cpu.CPUCCTClassContainer;
import org.netbeans.lib.profiler.results.cpu.CPUCCTContainer;
import org.netbeans.lib.profiler.results.cpu.CPUCCTProvider;
import org.netbeans.lib.profiler.results.cpu.CPUResultsDiff;
import org.netbeans.lib.profiler.results.cpu.FlatProfileContainer;
import org.netbeans.lib.profiler.results.cpu.MethodIdMap;
import org.netbeans.lib.profiler.results.cpu.PrestimeCPUCCTNode;
import org.netbeans.lib.profiler.results.cpu.PrestimeCPUCCTNodeBacked;
import org.netbeans.lib.profiler.results.cpu.PrestimeCPUCCTNodeFree;

public class CPUResultsSnapshot
extends ResultsSnapshot {
    private static final String CPU_MSG = ResourceBundle.getBundle("org.netbeans.lib.profiler.results.cpu.Bundle").getString("CPUResultsSnapshot_CpuMsg");
    public static final int METHOD_LEVEL_VIEW = 0;
    public static final int CLASS_LEVEL_VIEW = 1;
    public static final int PACKAGE_LEVEL_VIEW = 2;
    protected Map threadIdMap;
    protected CPUCCTContainer[] allThreadsMergedCCTContainers;
    protected String[][] instrMethodClassesViews;
    protected String[] instrMethodNames;
    protected String[] instrMethodSignatures;
    protected PrestimeCPUCCTNode[] rootNode;
    protected CPUCCTContainer[][] threadCCTContainers;
    protected boolean collectingTwoTimeStamps;
    protected int nInstrMethods;
    private final Map<CCTNode, FilterSortSupport.Configuration> sortInfos = new WeakHashMap<CCTNode, FilterSortSupport.Configuration>();

    public CPUResultsSnapshot() {
        this.threadIdMap = new HashMap();
    }

    public CPUResultsSnapshot(long l, long l2, CPUCCTProvider cPUCCTProvider, boolean bl, String[] stringArray, String[] stringArray2, String[] stringArray3, int n) throws NoDataAvailableException {
        super(l, l2);
        this.collectingTwoTimeStamps = bl;
        this.instrMethodClassesViews = new String[3][];
        this.instrMethodClassesViews[0] = stringArray;
        this.instrMethodNames = stringArray2;
        this.instrMethodSignatures = stringArray3;
        this.nInstrMethods = n;
        CPUCCTContainer[] cPUCCTContainerArray = cPUCCTProvider.createPresentationCCTs(this);
        if (cPUCCTContainerArray == null || cPUCCTContainerArray.length == 0) {
            throw new NoDataAvailableException();
        }
        this.threadIdMap = new HashMap(cPUCCTContainerArray.length);
        for (int i = 0; i < cPUCCTContainerArray.length; ++i) {
            this.threadIdMap.put(cPUCCTContainerArray[i].threadId, i);
        }
        this.threadCCTContainers = new CPUCCTContainer[3][];
        this.threadCCTContainers[0] = cPUCCTContainerArray;
        this.allThreadsMergedCCTContainers = new CPUCCTContainer[3];
        this.rootNode = new PrestimeCPUCCTNode[3];
        this.rootNode[0] = this.createRootNodeForAllThreads(0);
        if (LOGGER.isLoggable(Level.FINEST)) {
            this.debugValues();
        }
    }

    public boolean isCollectingTwoTimeStamps() {
        return this.collectingTwoTimeStamps;
    }

    public CPUCCTContainer getContainerForThread(int n, int n2) {
        this.generateDataForView(n2);
        return this.threadCCTContainers[n2][this.getContainerIdForThreadId(n)];
    }

    public FlatProfileContainer getFlatProfile(int n, int n2) {
        this.generateDataForView(n2);
        if (n != -1) {
            return this.threadCCTContainers[n2][this.getContainerIdForThreadId(n)].getFlatProfile();
        }
        return this.allThreadsMergedCCTContainers[n2].getFlatProfile();
    }

    public FlatProfileContainer getFlatProfile(Collection<Integer> collection, int n) {
        if (collection == null) {
            return this.getFlatProfile(-1, n);
        }
        if (collection.size() == 1) {
            return this.getFlatProfile(collection.iterator().next(), n);
        }
        return this.createContainerForThreads(collection, n).getFlatProfile();
    }

    public String[] getInstrMethodClasses(int n) {
        return this.instrMethodClassesViews[n];
    }

    public String[] getInstrMethodNames() {
        return this.instrMethodNames;
    }

    public String[] getInstrMethodSignatures() {
        return this.instrMethodSignatures;
    }

    public String[] getMethodClassNameAndSig(int n, int n2) {
        if (n2 == 0) {
            return new String[]{this.instrMethodClassesViews[0][n], this.instrMethodNames[n], this.instrMethodSignatures[n]};
        }
        return new String[]{this.instrMethodClassesViews[n2][n], null, null};
    }

    public ClientUtils.SourceCodeSelection getSourceCodeSelection(int n, int n2) {
        String[] stringArray = this.getMethodClassNameAndSig(n, n2);
        return stringArray[1] != null ? new ClientUtils.SourceCodeSelection(stringArray[0], stringArray[1], stringArray[2]) : new ClientUtils.SourceCodeSelection(stringArray[0], "*", null);
    }

    public Map<Integer, ClientUtils.SourceCodeSelection> getMethodIDMap(int n) {
        HashMap<Integer, ClientUtils.SourceCodeSelection> hashMap = new HashMap<Integer, ClientUtils.SourceCodeSelection>();
        for (int i = 0; i < this.instrMethodClassesViews[n].length; ++i) {
            hashMap.put(i, this.getSourceCodeSelection(i, n));
        }
        return hashMap;
    }

    public int getNInstrMethods() {
        return this.nInstrMethods;
    }

    public int getNThreads() {
        return this.threadCCTContainers[0].length;
    }

    public PrestimeCPUCCTNode getReverseCCT(int n, int n2, int n3) {
        this.generateDataForView(n3);
        if (n >= 0) {
            return this.threadCCTContainers[n3][this.getContainerIdForThreadId(n)].getReverseCCT(n2);
        }
        if (n == -1) {
            return this.allThreadsMergedCCTContainers[n3].getReverseCCT(n2);
        }
        throw new IllegalArgumentException("!!! Cannot generate reverse CCT for threadId = " + n);
    }

    public PrestimeCPUCCTNode getRootNode(int n) {
        this.generateDataForView(n);
        return this.rootNode[n];
    }

    public PrestimeCPUCCTNode getRootNode(int n, Collection<Integer> collection, boolean bl) {
        Object[] objectArray;
        if (collection == null) {
            if (!bl) {
                return this.fixNCalls(this.getRootNode(n));
            }
            objectArray = this.getThreadIds();
            collection = new ArrayList<Integer>(objectArray.length);
            for (Object object : objectArray) {
                collection.add((int)object);
            }
        }
        objectArray = new PrestimeCPUCCTNode[collection.size()];
        Object[] objectArray2 = collection.iterator();
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = this.getContainerForThread((Integer)objectArray2.next(), n).getRootNode();
        }
        this.generateDataForView(n);
        return bl ? new PrestimeCPUCCTNodeBacked(this.threadCCTContainers[n][0], this.mergedChildren((PrestimeCPUCCTNode[])objectArray)) : this.fixNCalls(new PrestimeCPUCCTNodeBacked(this.threadCCTContainers[n][0], (PrestimeCPUCCTNode[])objectArray));
    }

    private PrestimeCPUCCTNode fixNCalls(PrestimeCPUCCTNode prestimeCPUCCTNode) {
        CCTNode[] cCTNodeArray;
        CCTNode[] cCTNodeArray2 = cCTNodeArray = prestimeCPUCCTNode == null ? null : prestimeCPUCCTNode.getChildren();
        if (cCTNodeArray != null) {
            for (CCTNode cCTNode : cCTNodeArray) {
                PrestimeCPUCCTNode prestimeCPUCCTNode2 = (PrestimeCPUCCTNode)cCTNode;
                prestimeCPUCCTNode2.nCalls = 0;
                CCTNode[] cCTNodeArray3 = prestimeCPUCCTNode2.getChildren();
                if (cCTNodeArray3 == null) continue;
                for (CCTNode cCTNode2 : cCTNodeArray3) {
                    prestimeCPUCCTNode2.addNCalls(((PrestimeCPUCCTNode)cCTNode2).getNCalls());
                }
            }
        }
        return prestimeCPUCCTNode;
    }

    private PrestimeCPUCCTNode[] mergedChildren(PrestimeCPUCCTNode[] prestimeCPUCCTNodeArray) {
        ArrayList<PrestimeCPUCCTNode> arrayList = new ArrayList<PrestimeCPUCCTNode>();
        for (PrestimeCPUCCTNode prestimeCPUCCTNode : prestimeCPUCCTNodeArray) {
            CCTNode[] cCTNodeArray = prestimeCPUCCTNode.getChildren();
            if (cCTNodeArray == null) continue;
            for (CCTNode cCTNode : cCTNodeArray) {
                int n = arrayList.indexOf(cCTNode);
                if (n == -1) {
                    arrayList.add(((PrestimeCPUCCTNode)cCTNode).createCopy());
                    continue;
                }
                ((PrestimeCPUCCTNode)arrayList.get(n)).merge(cCTNode);
            }
        }
        return arrayList.toArray(new PrestimeCPUCCTNode[0]);
    }

    public PrestimeCPUCCTNode getReverseRootNode(int n, Collection<Integer> collection, boolean bl) {
        int[] nArray = this.getThreadIds();
        class ThreadNodeBacked
        extends PrestimeCPUCCTNodeBacked {
            final /* synthetic */ CPUCCTContainer val$containerF;
            final /* synthetic */ FlatProfileContainer val$flatF;
            final /* synthetic */ int val$threadIdF;
            final /* synthetic */ int val$view;

            ThreadNodeBacked() {
                this.val$containerF = cPUCCTContainer;
                this.val$flatF = flatProfileContainer;
                this.val$threadIdF = n;
                this.val$view = n2;
                super(cPUCCTContainer, null);
                this.nCalls = (int)this.val$flatF.getNTotalInvocations();
                this.totalTime0 = this.val$containerF.getWholeGraphNetTime0();
                this.totalTime1 = this.val$containerF.isCollectingTwoTimeStamps() ? this.val$containerF.getWholeGraphNetTime1() : 0L;
                this.nChildren = this.val$flatF.getNRows();
            }

            @Override
            PrestimeCPUCCTNode createCopy() {
                ThreadNodeBacked threadNodeBacked = new ThreadNodeBacked();
                this.setupCopy(threadNodeBacked);
                return threadNodeBacked;
            }

            public PrestimeCPUCCTNode[] getChildren() {
                if (this.nChildren == 0) {
                    return null;
                }
                if (this.children == null) {
                    this.children = new PrestimeCPUCCTNode[this.val$flatF.getNRows()];
                    for (int i = 0; i < this.children.length; ++i) {
                        int n = i;
                        int n2 = this.val$flatF.getMethodIdAtRow(i);
                        class ReverseNodeBacked
                        extends PrestimeCPUCCTNodeBacked {
                            final /* synthetic */ int val$methodIdF;
                            final /* synthetic */ int val$mF;

                            ReverseNodeBacked() {
                                this.val$methodIdF = n;
                                this.val$mF = n2;
                                this.nChildren = 1;
                                this.container = container;
                                this.methodId = this.val$methodIdF;
                                this.nCalls = val$flatF.getNInvocationsAtRow(this.val$mF);
                                this.totalTime0 = val$flatF.getTotalTimeInMcs0AtRow(this.val$mF);
                                this.totalTime1 = val$flatF.isCollectingTwoTimeStamps() ? val$flatF.getTotalTimeInMcs1AtRow(this.val$mF) : 0L;
                                this.parent = this;
                            }

                            @Override
                            PrestimeCPUCCTNode createCopy() {
                                ReverseNodeBacked reverseNodeBacked = new ReverseNodeBacked();
                                this.setupCopy(reverseNodeBacked);
                                return reverseNodeBacked;
                            }

                            public PrestimeCPUCCTNode[] getChildren() {
                                if (this.nChildren == 0) {
                                    return null;
                                }
                                if (this.children == null) {
                                    PrestimeCPUCCTNode prestimeCPUCCTNode = CPUResultsSnapshot.this.getReverseCCT(val$threadIdF, this.val$methodIdF, val$view);
                                    this.children = prestimeCPUCCTNode.children;
                                    int n = this.nChildren = this.children == null ? 0 : this.children.length;
                                    if (this.nChildren > 0) {
                                        for (PrestimeCPUCCTNode prestimeCPUCCTNode2 : this.children) {
                                            prestimeCPUCCTNode2.parent = this;
                                        }
                                    }
                                }
                                return this.children;
                            }
                        }
                        this.children[i] = new ReverseNodeBacked();
                    }
                }
                return this.children;
            }
        }
        ArrayList<ThreadNodeBacked> arrayList = new ArrayList<ThreadNodeBacked>();
        for (int i = 0; i < nArray.length; ++i) {
            int n2 = nArray[i];
            if (collection != null && !collection.contains(n2)) continue;
            CPUCCTContainer cPUCCTContainer = this.getContainerForThread(n2, n);
            FlatProfileContainer flatProfileContainer = cPUCCTContainer.getFlatProfile();
            arrayList.add(new ThreadNodeBacked());
        }
        this.generateDataForView(n);
        PrestimeCPUCCTNode[] prestimeCPUCCTNodeArray = arrayList.toArray(new PrestimeCPUCCTNode[0]);
        PrestimeCPUCCTNodeBacked prestimeCPUCCTNodeBacked = new PrestimeCPUCCTNodeBacked(this.threadCCTContainers[n][0], bl ? this.mergedChildren(prestimeCPUCCTNodeArray) : prestimeCPUCCTNodeArray);
        return this.fixNCalls(prestimeCPUCCTNodeBacked);
    }

    public FilterSortSupport.Configuration getFilterSortInfo(CCTNode cCTNode) {
        return this.sortInfo(cCTNode);
    }

    private FilterSortSupport.Configuration sortInfo(CCTNode cCTNode) {
        while (cCTNode.getParent() != null) {
            cCTNode = cCTNode.getParent();
        }
        FilterSortSupport.Configuration configuration = this.sortInfos.get(cCTNode);
        if (configuration == null) {
            configuration = new FilterSortSupport.Configuration();
            this.sortInfos.put(cCTNode, configuration);
        }
        return configuration;
    }

    public void filterForward(String string, int n, PrestimeCPUCCTNodeBacked prestimeCPUCCTNodeBacked) {
    }

    public void filterReverse(String string, int n, PrestimeCPUCCTNodeFree prestimeCPUCCTNodeFree, int n2) {
    }

    public int[] getThreadIds() {
        int[] nArray = new int[this.threadCCTContainers[0].length];
        for (int i = 0; i < this.threadCCTContainers[0].length; ++i) {
            nArray[i] = this.threadCCTContainers[0][i].threadId;
        }
        return nArray;
    }

    public String getThreadNameForId(int n) {
        return this.getThreadNames()[this.getContainerIdForThreadId(n)];
    }

    public String[] getThreadNames() {
        String[] stringArray = new String[this.threadCCTContainers[0].length];
        for (int i = 0; i < this.threadCCTContainers[0].length; ++i) {
            stringArray[i] = this.threadCCTContainers[0][i].threadName;
        }
        return stringArray;
    }

    public CPUResultsSnapshot createDiff(CPUResultsSnapshot cPUResultsSnapshot) {
        if (!(cPUResultsSnapshot instanceof CPUResultsSnapshot)) {
            return null;
        }
        return new CPUResultsDiff(this, cPUResultsSnapshot);
    }

    void readFromSnapshot(CPUResultsSnapshot cPUResultsSnapshot) {
        this.beginTime = cPUResultsSnapshot.beginTime;
        this.timeTaken = cPUResultsSnapshot.timeTaken;
        this.collectingTwoTimeStamps = cPUResultsSnapshot.collectingTwoTimeStamps;
        this.nInstrMethods = cPUResultsSnapshot.nInstrMethods;
        this.instrMethodClassesViews = cPUResultsSnapshot.instrMethodClassesViews;
        this.instrMethodNames = cPUResultsSnapshot.instrMethodNames;
        this.instrMethodSignatures = cPUResultsSnapshot.instrMethodSignatures;
        this.threadCCTContainers = new CPUCCTContainer[3][];
        CPUCCTContainer[] cPUCCTContainerArray = cPUResultsSnapshot.threadCCTContainers[0];
        int n = cPUCCTContainerArray.length;
        CPUCCTContainer[] cPUCCTContainerArray2 = new CPUCCTContainer[n];
        this.threadCCTContainers[0] = cPUCCTContainerArray2;
        this.threadIdMap = cPUResultsSnapshot.threadIdMap;
        for (int i = 0; i < n; ++i) {
            cPUCCTContainerArray2[i] = new CPUCCTContainer(this);
            cPUCCTContainerArray2[i].threadId = cPUCCTContainerArray[i].threadId;
            cPUCCTContainerArray2[i].threadName = cPUCCTContainerArray[i].threadName;
            cPUCCTContainerArray2[i].collectingTwoTimeStamps = cPUCCTContainerArray[i].collectingTwoTimeStamps;
            cPUCCTContainerArray2[i].compactData = cPUCCTContainerArray[i].compactData;
            cPUCCTContainerArray2[i].childOfsSize = cPUCCTContainerArray[i].childOfsSize;
            cPUCCTContainerArray2[i].nodeSize = cPUCCTContainerArray[i].nodeSize;
            cPUCCTContainerArray2[i].wholeGraphGrossTimeAbs = cPUCCTContainerArray[i].wholeGraphGrossTimeAbs;
            cPUCCTContainerArray2[i].wholeGraphGrossTimeThreadCPU = cPUCCTContainerArray[i].wholeGraphGrossTimeThreadCPU;
            cPUCCTContainerArray2[i].timeInInjectedCodeInAbsCounts = cPUCCTContainerArray[i].timeInInjectedCodeInAbsCounts;
            cPUCCTContainerArray2[i].timeInInjectedCodeInThreadCPUCounts = cPUCCTContainerArray[i].timeInInjectedCodeInThreadCPUCounts;
            cPUCCTContainerArray2[i].wholeGraphPureTimeAbs = cPUCCTContainerArray[i].wholeGraphPureTimeAbs;
            cPUCCTContainerArray2[i].wholeGraphPureTimeThreadCPU = cPUCCTContainerArray[i].wholeGraphPureTimeThreadCPU;
            cPUCCTContainerArray2[i].wholeGraphNetTime0 = cPUCCTContainerArray[i].wholeGraphNetTime0;
            cPUCCTContainerArray2[i].wholeGraphNetTime1 = cPUCCTContainerArray[i].wholeGraphNetTime1;
            cPUCCTContainerArray2[i].totalInvNo = cPUCCTContainerArray[i].totalInvNo;
            cPUCCTContainerArray2[i].displayWholeThreadCPUTime = cPUCCTContainerArray[i].displayWholeThreadCPUTime;
            cPUCCTContainerArray2[i].rootNode = new PrestimeCPUCCTNodeBacked(cPUCCTContainerArray2[i], null, 0);
            if (cPUCCTContainerArray2[i].getMethodIdForNodeOfs(0) != 0) continue;
            cPUCCTContainerArray2[i].rootNode.setThreadNode();
        }
        this.allThreadsMergedCCTContainers = new CPUCCTContainer[3];
        this.rootNode = new PrestimeCPUCCTNode[3];
        this.rootNode[0] = this.createRootNodeForAllThreads(0);
    }

    @Override
    public void readFromStream(DataInputStream dataInputStream) throws IOException {
        int n;
        super.readFromStream(dataInputStream);
        this.collectingTwoTimeStamps = dataInputStream.readBoolean();
        this.nInstrMethods = dataInputStream.readInt();
        this.instrMethodClassesViews = new String[3][];
        String[] stringArray = new String[this.nInstrMethods];
        this.instrMethodClassesViews[0] = stringArray;
        this.instrMethodNames = new String[this.nInstrMethods];
        this.instrMethodSignatures = new String[this.nInstrMethods];
        for (n = 0; n < this.nInstrMethods; ++n) {
            stringArray[n] = dataInputStream.readUTF();
            this.instrMethodNames[n] = dataInputStream.readUTF();
            this.instrMethodSignatures[n] = dataInputStream.readUTF();
        }
        n = dataInputStream.readInt();
        this.threadCCTContainers = new CPUCCTContainer[3][];
        CPUCCTContainer[] cPUCCTContainerArray = new CPUCCTContainer[n];
        this.threadCCTContainers[0] = cPUCCTContainerArray;
        for (int i = 0; i < n; ++i) {
            cPUCCTContainerArray[i] = new CPUCCTContainer(this);
            cPUCCTContainerArray[i].readFromStream(dataInputStream);
            this.threadIdMap.put(cPUCCTContainerArray[i].threadId, i);
        }
        this.allThreadsMergedCCTContainers = new CPUCCTContainer[3];
        this.rootNode = new PrestimeCPUCCTNode[3];
        this.rootNode[0] = this.createRootNodeForAllThreads(0);
        if (LOGGER.isLoggable(Level.FINEST)) {
            this.debugValues();
        }
    }

    public void saveSortParams(int n, boolean bl, CCTNode cCTNode) {
        FilterSortSupport.Configuration configuration = this.sortInfo(cCTNode);
        configuration.setSortInfo(n, bl);
    }

    @Override
    public String toString() {
        return MessageFormat.format(CPU_MSG, super.toString());
    }

    @Override
    public void writeToStream(DataOutputStream dataOutputStream) throws IOException {
        super.writeToStream(dataOutputStream);
        dataOutputStream.writeBoolean(this.collectingTwoTimeStamps);
        dataOutputStream.writeInt(this.nInstrMethods);
        String[] stringArray = this.instrMethodClassesViews[0];
        for (int i = 0; i < this.nInstrMethods; ++i) {
            dataOutputStream.writeUTF(stringArray[i]);
            dataOutputStream.writeUTF(this.instrMethodNames[i]);
            dataOutputStream.writeUTF(this.instrMethodSignatures[i]);
        }
        CPUCCTContainer[] cPUCCTContainerArray = this.threadCCTContainers[0];
        int n = cPUCCTContainerArray.length;
        dataOutputStream.writeInt(n);
        for (int i = 0; i < n; ++i) {
            cPUCCTContainerArray[i].writeToStream(dataOutputStream);
        }
    }

    private int getContainerIdForThreadId(int n) {
        Integer n2 = n;
        Integer n3 = null;
        if (this.threadIdMap.containsKey(n2)) {
            n3 = (Integer)this.threadIdMap.get(n2);
        }
        return n3 != null ? n3 : 0;
    }

    protected PrestimeCPUCCTNode createRootNodeForAllThreads(int n) {
        this.generateDataForView(n);
        CPUCCTContainer[] cPUCCTContainerArray = this.threadCCTContainers[n];
        int n2 = cPUCCTContainerArray.length;
        PrestimeCPUCCTNode[] prestimeCPUCCTNodeArray = new PrestimeCPUCCTNode[n2];
        for (int i = 0; i < n2; ++i) {
            PrestimeCPUCCTNode prestimeCPUCCTNode = cPUCCTContainerArray[i].getRootNode();
            prestimeCPUCCTNodeArray[i] = !prestimeCPUCCTNode.isThreadNode() ? new PrestimeCPUCCTNodeBacked(cPUCCTContainerArray[i], new PrestimeCPUCCTNode[]{prestimeCPUCCTNode}) : prestimeCPUCCTNode;
        }
        this.allThreadsMergedCCTContainers[n] = new AllThreadsMergedCPUCCTContainer(this, prestimeCPUCCTNodeArray, n);
        return this.allThreadsMergedCCTContainers[n].getRootNode();
    }

    protected CPUCCTContainer createContainerForThreads(Collection<Integer> collection, int n) {
        this.generateDataForView(n);
        CPUCCTContainer[] cPUCCTContainerArray = this.threadCCTContainers[n];
        PrestimeCPUCCTNode[] prestimeCPUCCTNodeArray = new PrestimeCPUCCTNode[collection.size()];
        int n2 = 0;
        for (int i = 0; i < cPUCCTContainerArray.length; ++i) {
            if (!collection.contains(cPUCCTContainerArray[i].getThreadId())) continue;
            PrestimeCPUCCTNode prestimeCPUCCTNode = cPUCCTContainerArray[i].getRootNode();
            if (prestimeCPUCCTNode.isThreadNode()) {
                prestimeCPUCCTNodeArray[n2++] = prestimeCPUCCTNode;
                continue;
            }
            prestimeCPUCCTNodeArray[n2++] = new PrestimeCPUCCTNodeBacked(cPUCCTContainerArray[i], new PrestimeCPUCCTNode[]{prestimeCPUCCTNode});
        }
        return new AllThreadsMergedCPUCCTContainer(this, prestimeCPUCCTNodeArray, n);
    }

    private void debugValues() {
        LOGGER.log(Level.FINEST, "collectingTwoTimeStamps: {0}", this.collectingTwoTimeStamps);
        LOGGER.log(Level.FINEST, "threadCCTContainers.length: {0}", this.debugLength(this.threadCCTContainers));
        LOGGER.log(Level.FINEST, "allThreadsMergedCCTContainers.length: {0}", this.debugLength(this.allThreadsMergedCCTContainers));
        LOGGER.log(Level.FINEST, "rootNode.length: {0}", this.debugLength(this.rootNode));
        LOGGER.log(Level.FINEST, "instrMethodClassesViews.length: {0}", this.debugLength(this.instrMethodClassesViews));
        LOGGER.log(Level.FINEST, "instrMethodNames.length: {0}", this.debugLength(this.instrMethodNames));
        LOGGER.log(Level.FINEST, "instrMethodSignatures.length: {0}", this.debugLength(this.instrMethodSignatures));
        LOGGER.log(Level.FINEST, "nInstrMethods: {0}", this.nInstrMethods);
    }

    private void generateDataForView(int n) {
        if (this.threadCCTContainers[n] == null) {
            MethodIdMap methodIdMap = new MethodIdMap(this.instrMethodClassesViews[0], this.nInstrMethods, n);
            int n2 = this.threadCCTContainers[0].length;
            this.threadCCTContainers[n] = new CPUCCTContainer[n2];
            for (int i = 0; i < n2; ++i) {
                this.threadCCTContainers[n][i] = new CPUCCTClassContainer(this.threadCCTContainers[0][i], methodIdMap, n);
            }
            this.rootNode[n] = this.createRootNodeForAllThreads(n);
            this.instrMethodClassesViews[n] = methodIdMap.getInstrClassesOrPackages();
        }
    }

    public static class NoDataAvailableException
    extends Exception {
    }
}

