/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.server;

import [Lorg.netbeans.lib.profiler.server.ThreadInfo;;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.lib.profiler.server.ClassLoaderManager;
import org.netbeans.lib.profiler.server.ProfilerInterface;
import org.netbeans.lib.profiler.server.ProfilerRuntime;
import org.netbeans.lib.profiler.server.ProfilerRuntimeObjAlloc;
import org.netbeans.lib.profiler.server.ProfilerRuntimeObjLiveness;
import org.netbeans.lib.profiler.server.ProfilerServer;
import org.netbeans.lib.profiler.server.ThreadInfo;
import org.netbeans.lib.profiler.server.system.Classes;
import org.netbeans.lib.profiler.server.system.Stacks;

public class ProfilerRuntimeMemory
extends ProfilerRuntime {
    protected static final int MAX_STACK_FRAMES = 100;
    protected static final int NO_OF_PROFILER_FRAMES = 3;
    protected static int[] allocatedInstancesCount;
    protected static int allocatedInstArrayLength;
    protected static short[] allocatedInstThreshold;
    protected static char[] objectSize;
    protected static short samplingInterval;
    protected static int stackSamplingDepth;
    static final Object classIdMapLock;
    private static int currentStackDepth;
    private static int[] stackFrameIds;
    private static Map classIdMap;
    private static volatile boolean resultsAvailable;
    private static final boolean DEBUG = false;
    private static long randSeed;
    private static int bits;
    private static short samplingIntervalBase;

    public static void setAllocatedInstancesCountArray(int[] nArray) {
        allocatedInstancesCount = nArray;
        if (nArray == null) {
            allocatedInstThreshold = null;
            objectSize = null;
            stackFrameIds = null;
            Stacks.clearNativeStackFrameBuffer();
            return;
        }
        if (allocatedInstArrayLength < nArray.length) {
            short[] sArray = (short[])(allocatedInstThreshold != null ? allocatedInstThreshold : null);
            allocatedInstThreshold = new short[nArray.length];
            if (sArray != null) {
                System.arraycopy(sArray, 0, allocatedInstThreshold, 0, allocatedInstArrayLength);
            }
            char[] cArray = (char[])(objectSize != null ? objectSize : null);
            objectSize = new char[nArray.length];
            if (cArray != null) {
                System.arraycopy(cArray, 0, objectSize, 0, allocatedInstArrayLength);
            }
            allocatedInstArrayLength = nArray.length;
        }
    }

    public static void setStackSamplingDepth(int n) {
        if (n < 0) {
            n = 100;
        } else if (n > 0) {
            if ((n += 3) > 100) {
                n = 100;
            }
        } else {
            currentStackDepth = 0;
        }
        stackSamplingDepth = n;
    }

    public static void setSamplingInterval(short s) {
        samplingInterval = s;
        ProfilerRuntimeMemory.initRandomGenerator();
    }

    public static void resetProfilerCollectors(int n) {
        if (allocatedInstancesCount != null) {
            for (int i = 0; i < allocatedInstancesCount.length; ++i) {
                ProfilerRuntimeMemory.allocatedInstancesCount[i] = 0;
                ProfilerRuntimeMemory.allocatedInstThreshold[i] = 0;
            }
        }
        if (n == 6) {
            ProfilerRuntimeObjLiveness.resetProfilerCollectors();
        }
        classIdMap = new HashMap();
        resultsAvailable = false;
    }

    public static void traceVMObjectAlloc(Object object, Class clazz) {
        if (classIdMap == null || ThreadInfo.profilingSuspended() || ThreadInfo.isProfilerServerThread(Thread.currentThread())) {
            return;
        }
        ThreadInfo threadInfo = ThreadInfo.getThreadInfo();
        if (threadInfo.inProfilingRuntimeMethod > 0) {
            return;
        }
        if (!threadInfo.isInitialized()) {
            threadInfo.initialize();
            if (lockContentionMonitoringEnabled) {
                ProfilerRuntimeMemory.writeThreadCreationEvent(threadInfo);
            }
        }
        ++threadInfo.inProfilingRuntimeMethod;
        int n = ProfilerRuntimeMemory.getClassId(clazz);
        if (n == -1) {
            --threadInfo.inProfilingRuntimeMethod;
            return;
        }
        boolean bl = ProfilerInterface.getCurrentInstrType() == 6;
        --threadInfo.inProfilingRuntimeMethod;
        if (bl) {
            ProfilerRuntimeObjLiveness.traceObjAlloc(object, (char)n);
        } else {
            ProfilerRuntimeObjAlloc.traceObjAlloc(object, (char)n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int getClassId(Class clazz) {
        Integer n;
        String string = clazz.getName();
        int n2 = ClassLoaderManager.registerLoader(clazz);
        String string2 = string + '#' + n2;
        Object object = classIdMapLock;
        synchronized (object) {
            n = (Integer)classIdMap.get(string2);
        }
        if (n == null) {
            int n3 = externalActionsHandler.handleFirstTimeVMObjectAlloc(string, n2);
            n = new Integer(n3);
            Object object2 = classIdMapLock;
            synchronized (object2) {
                classIdMap.put(string2, n);
            }
            if (n3 == -1) {
                // empty if block
            }
        }
        return n;
    }

    static boolean isInternalClass(Class clazz) {
        return clazz == ThreadInfo.class || clazz == ThreadInfo;.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static synchronized void getAndSendCurrentStackTrace(int n, long l) {
        if (eventBuffer == null) {
            return;
        }
        byte[] byArray = eventBuffer;
        synchronized (eventBuffer) {
            if (stackSamplingDepth != 0) {
                currentStackDepth = Stacks.getCurrentStackFrameIds(Thread.currentThread(), stackSamplingDepth, stackFrameIds);
            }
            ProfilerRuntimeMemory.writeObjAllocStackTraceEvent(n, l);
            // ** MonitorExit[var3_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static synchronized void getAndSendCurrentStackTrace(int n, char c, int n2, long l) {
        if (eventBuffer == null) {
            return;
        }
        byte[] byArray = eventBuffer;
        synchronized (eventBuffer) {
            if (stackSamplingDepth != 0) {
                currentStackDepth = Stacks.getCurrentStackFrameIds(Thread.currentThread(), stackSamplingDepth, stackFrameIds);
            }
            ProfilerRuntimeMemory.writeObjLivenessStackTraceEvent(n, c, n2, l);
            // ** MonitorExit[var5_4] (shouldn't be in output)
            return;
        }
    }

    protected static long getCachedObjectSize(int n, Object object) {
        long l = objectSize[n];
        if (l <= 1L) {
            if (object == null) {
                System.err.println("*** JFluid critical error: received null object for classId = " + n + " in getCachedObjectSize");
                Thread.dumpStack();
                System.err.println("*** End JFluid critical error message ---------------------------");
            }
            if (l == 0L) {
                l = Classes.getObjectSize((Object)object);
                ProfilerRuntimeMemory.objectSize[n] = object.getClass().isArray() || l > 65535L ? (char)'\u0001' : (char)l;
            } else {
                l = Classes.getObjectSize((Object)object);
            }
        }
        return l;
    }

    protected static void clearDataStructures() {
        ProfilerRuntime.clearDataStructures();
        allocatedInstancesCount = null;
        stackFrameIds = null;
        Stacks.clearNativeStackFrameBuffer();
    }

    protected static void createNewDataStructures() {
        ProfilerRuntime.createNewDataStructures();
        stackFrameIds = new int[100];
        Stacks.createNativeStackFrameBuffer(100);
        classIdMap = new HashMap();
        resultsAvailable = false;
    }

    protected static void enableProfiling(boolean bl) {
    }

    protected static void initRandomGenerator() {
        short s;
        randSeed = System.currentTimeMillis();
        if (samplingInterval == 1) {
            return;
        }
        if (samplingInterval == 2 || samplingInterval == 3) {
            bits = 1;
            samplingIntervalBase = (short)(samplingInterval - 1);
            return;
        }
        bits = 1;
        short s2 = 1;
        while ((s = s2 << 1) < samplingInterval) {
            ++bits;
            s2 = s;
        }
        samplingIntervalBase = (short)(samplingInterval - (s2 >> 1));
        --bits;
    }

    protected static short nextRandomizedInterval() {
        if (samplingInterval == 1) {
            return 1;
        }
        randSeed = randSeed * 25214903917L + 11L & 0xFFFFFFFFFFFFL;
        return (short)(samplingIntervalBase + (int)(randSeed >>> 48 - bits));
    }

    protected static void writeObjAllocStackTraceEvent(int n, long l) {
        int n2;
        if (eventBuffer == null) {
            return;
        }
        if (currentStackDepth != 0) {
            currentStackDepth -= 3;
        }
        if (!resultsAvailable) {
            resultsAvailable = true;
            ProfilerServer.notifyClientOnResultsAvailability();
        }
        if ((n2 = globalEvBufPos) + 16 + currentStackDepth * 4 > globalEvBufPosThreshold) {
            externalActionsHandler.handleEventBufferDump(eventBuffer, 0, n2);
            n2 = 0;
        }
        ProfilerRuntimeMemory.eventBuffer[n2++] = 12;
        ProfilerRuntimeMemory.eventBuffer[n2++] = (byte)(n >> 8 & 0xFF);
        ProfilerRuntimeMemory.eventBuffer[n2++] = (byte)(n & 0xFF);
        ProfilerRuntimeMemory.eventBuffer[n2++] = (byte)(l >> 32 & 0xFFL);
        ProfilerRuntimeMemory.eventBuffer[n2++] = (byte)(l >> 24 & 0xFFL);
        ProfilerRuntimeMemory.eventBuffer[n2++] = (byte)(l >> 16 & 0xFFL);
        ProfilerRuntimeMemory.eventBuffer[n2++] = (byte)(l >> 8 & 0xFFL);
        ProfilerRuntimeMemory.eventBuffer[n2++] = (byte)(l & 0xFFL);
        globalEvBufPos = n2 = ProfilerRuntimeMemory.writeStack(n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void writeObjGCEvent(long l) {
        if (eventBuffer == null) {
            return;
        }
        byte[] byArray = eventBuffer;
        synchronized (eventBuffer) {
            int n = globalEvBufPos;
            if (n > globalEvBufPosThreshold) {
                externalActionsHandler.handleEventBufferDump(eventBuffer, 0, n);
                n = 0;
            }
            ProfilerRuntimeMemory.eventBuffer[n++] = 15;
            ProfilerRuntimeMemory.eventBuffer[n++] = (byte)(l >> 56 & 0xFFL);
            ProfilerRuntimeMemory.eventBuffer[n++] = (byte)(l >> 48 & 0xFFL);
            ProfilerRuntimeMemory.eventBuffer[n++] = (byte)(l >> 40 & 0xFFL);
            ProfilerRuntimeMemory.eventBuffer[n++] = (byte)(l >> 32 & 0xFFL);
            ProfilerRuntimeMemory.eventBuffer[n++] = (byte)(l >> 24 & 0xFFL);
            ProfilerRuntimeMemory.eventBuffer[n++] = (byte)(l >> 16 & 0xFFL);
            ProfilerRuntimeMemory.eventBuffer[n++] = (byte)(l >> 8 & 0xFFL);
            ProfilerRuntimeMemory.eventBuffer[n++] = (byte)(l & 0xFFL);
            globalEvBufPos = n;
            // ** MonitorExit[var2_1] (shouldn't be in output)
            return;
        }
    }

    protected static void writeObjLivenessStackTraceEvent(int n, char c, int n2, long l) {
        int n3;
        if (eventBuffer == null) {
            return;
        }
        if (currentStackDepth != 0) {
            currentStackDepth -= 3;
        }
        if (!resultsAvailable) {
            resultsAvailable = true;
            ProfilerServer.notifyClientOnResultsAvailability();
        }
        if ((n3 = globalEvBufPos) + 24 + currentStackDepth * 4 > globalEvBufPosThreshold) {
            externalActionsHandler.handleEventBufferDump(eventBuffer, 0, n3);
            n3 = 0;
        }
        ProfilerRuntimeMemory.eventBuffer[n3++] = 14;
        ProfilerRuntimeMemory.eventBuffer[n3++] = (byte)(n >> 8 & 0xFF);
        ProfilerRuntimeMemory.eventBuffer[n3++] = (byte)(n & 0xFF);
        ProfilerRuntimeMemory.eventBuffer[n3++] = (byte)(c >> 8 & 0xFF);
        ProfilerRuntimeMemory.eventBuffer[n3++] = (byte)(c & 0xFF);
        ProfilerRuntimeMemory.eventBuffer[n3++] = (byte)(n2 >> 24 & 0xFF);
        ProfilerRuntimeMemory.eventBuffer[n3++] = (byte)(n2 >> 16 & 0xFF);
        ProfilerRuntimeMemory.eventBuffer[n3++] = (byte)(n2 >> 8 & 0xFF);
        ProfilerRuntimeMemory.eventBuffer[n3++] = (byte)(n2 & 0xFF);
        ProfilerRuntimeMemory.eventBuffer[n3++] = (byte)(l >> 32 & 0xFFL);
        ProfilerRuntimeMemory.eventBuffer[n3++] = (byte)(l >> 24 & 0xFFL);
        ProfilerRuntimeMemory.eventBuffer[n3++] = (byte)(l >> 16 & 0xFFL);
        ProfilerRuntimeMemory.eventBuffer[n3++] = (byte)(l >> 8 & 0xFFL);
        ProfilerRuntimeMemory.eventBuffer[n3++] = (byte)(l & 0xFFL);
        globalEvBufPos = n3 = ProfilerRuntimeMemory.writeStack(n3);
    }

    private static int writeStack(int n) {
        ProfilerRuntimeMemory.eventBuffer[n++] = (byte)(currentStackDepth >> 16 & 0xFF);
        ProfilerRuntimeMemory.eventBuffer[n++] = (byte)(currentStackDepth >> 8 & 0xFF);
        ProfilerRuntimeMemory.eventBuffer[n++] = (byte)(currentStackDepth & 0xFF);
        int n2 = 3;
        for (int i = 0; i < currentStackDepth; ++i) {
            ProfilerRuntimeMemory.eventBuffer[n++] = (byte)(stackFrameIds[n2] >> 24 & 0xFF);
            ProfilerRuntimeMemory.eventBuffer[n++] = (byte)(stackFrameIds[n2] >> 16 & 0xFF);
            ProfilerRuntimeMemory.eventBuffer[n++] = (byte)(stackFrameIds[n2] >> 8 & 0xFF);
            ProfilerRuntimeMemory.eventBuffer[n++] = (byte)(stackFrameIds[n2] & 0xFF);
            ++n2;
        }
        return n;
    }

    static {
        classIdMapLock = new Object();
    }
}

