/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.api.caching.impl;

import com.sun.tools.visualvm.api.caching.Cache;
import com.sun.tools.visualvm.api.caching.Entry;
import com.sun.tools.visualvm.api.caching.EntryFactory;
import com.sun.tools.visualvm.api.caching.Persistor;
import com.sun.tools.visualvm.api.caching.impl.KeyFactory;
import java.lang.ref.Reference;
import java.util.HashMap;
import java.util.Map;

final class CacheImpl<K, V>
extends Cache<K, V> {
    private final Map<Reference<K>, Entry<V>> objectCache = new HashMap<Reference<K>, Entry<V>>();
    private long update_interval = 60480000L;
    private Persistor<K, V> persistor = Persistor.DEFAULT;
    private KeyFactory<K> keyFactory = KeyFactory.DEFAULT;
    private EntryFactory<K, V> resolver = EntryFactory.DEFAULT;

    CacheImpl() {
    }

    CacheImpl(EntryFactory<K, V> resolver) {
        this.resolver = resolver;
    }

    CacheImpl(Persistor<K, V> persistor) {
        this.persistor = persistor;
    }

    CacheImpl(KeyFactory<K> keyFactory) {
        this.keyFactory = keyFactory;
    }

    CacheImpl(EntryFactory<K, V> resolver, Persistor<K, V> persistor) {
        this.resolver = resolver;
        this.persistor = persistor;
    }

    CacheImpl(EntryFactory<K, V> resolver, KeyFactory<K> keyFactory) {
        this.resolver = resolver;
        this.keyFactory = keyFactory;
    }

    CacheImpl(KeyFactory<K> keyFactory, Persistor<K, V> persistor) {
        this.persistor = persistor;
        this.keyFactory = keyFactory;
    }

    CacheImpl(EntryFactory<K, V> resolver, KeyFactory<K> keyFactory, Persistor<K, V> persistor) {
        this.resolver = resolver;
        this.persistor = persistor;
        this.keyFactory = keyFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final V retrieveObject(K key) {
        Reference<K> softKey = this.keyFactory.createKey(key);
        Map<Reference<K>, Entry<V>> map = this.objectCache;
        synchronized (map) {
            Entry<V> entry = this.objectCache.get(softKey);
            if (entry == null) {
                entry = this.persistor.retrieve(key);
            }
            if (entry == null) {
                entry = this.cacheMiss(key);
                if (entry != null && entry.getContent() != null) {
                    this.persistor.store(key, entry);
                    this.objectCache.put(softKey, entry);
                }
            } else {
                Entry<V> newEntry;
                long timestamp = System.currentTimeMillis();
                if (timestamp - entry.getUpdateTimeStamp() > this.update_interval && (newEntry = this.cacheMiss(key)) != null && newEntry.getContent() != null) {
                    this.persistor.store(key, entry);
                    this.objectCache.put(softKey, newEntry);
                    entry = newEntry;
                }
            }
            return entry != null ? (V)entry.getContent() : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final V invalidateObject(K key) {
        Reference<K> softKey = this.keyFactory.createKey(key);
        Map<Reference<K>, Entry<V>> map = this.objectCache;
        synchronized (map) {
            Entry<V> entry = this.objectCache.remove(softKey);
            return entry != null ? (V)entry.getContent() : null;
        }
    }

    @Override
    public final long getTTL() {
        return this.update_interval;
    }

    @Override
    public final void setTTL(long ttl) {
        this.update_interval = ttl;
    }

    private Entry<V> cacheMiss(K key) {
        return this.resolver.createEntry(key);
    }
}

