/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.etable;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;

public class ETableTransferable
implements Transferable {
    protected String plainData;
    private static DataFlavor[] stringFlavors;
    private static DataFlavor[] plainFlavors;

    public ETableTransferable(String string) {
        this.plainData = string;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        int n = this.isPlainSupported() ? plainFlavors.length : 0;
        int n2 = this.isPlainSupported() ? stringFlavors.length : 0;
        int n3 = n + n2;
        DataFlavor[] dataFlavorArray = new DataFlavor[n3];
        int n4 = 0;
        if (n > 0) {
            System.arraycopy(plainFlavors, 0, dataFlavorArray, n4, n);
            n4 += n;
        }
        if (n2 > 0) {
            System.arraycopy(stringFlavors, 0, dataFlavorArray, n4, n2);
            n4 += n2;
        }
        return dataFlavorArray;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        DataFlavor[] dataFlavorArray = this.getTransferDataFlavors();
        for (int i = 0; i < dataFlavorArray.length; ++i) {
            if (!dataFlavorArray[i].equals(dataFlavor)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
        if (this.isPlainFlavor(dataFlavor)) {
            String string = this.getPlainData();
            String string2 = string = string == null ? "" : string;
            if (String.class.equals(dataFlavor.getRepresentationClass())) {
                return string;
            }
            if (Reader.class.equals(dataFlavor.getRepresentationClass())) {
                return new StringReader(string);
            }
            if (InputStream.class.equals(dataFlavor.getRepresentationClass())) {
                return new ByteArrayInputStream(string.getBytes());
            }
        } else if (this.isStringFlavor(dataFlavor)) {
            String string = this.getPlainData();
            string = string == null ? "" : string;
            return string;
        }
        throw new UnsupportedFlavorException(dataFlavor);
    }

    protected boolean isPlainFlavor(DataFlavor dataFlavor) {
        DataFlavor[] dataFlavorArray = plainFlavors;
        for (int i = 0; i < dataFlavorArray.length; ++i) {
            if (!dataFlavorArray[i].equals(dataFlavor)) continue;
            return true;
        }
        return false;
    }

    protected boolean isPlainSupported() {
        return this.plainData != null;
    }

    protected String getPlainData() {
        return this.plainData;
    }

    protected boolean isStringFlavor(DataFlavor dataFlavor) {
        DataFlavor[] dataFlavorArray = stringFlavors;
        for (int i = 0; i < dataFlavorArray.length; ++i) {
            if (!dataFlavorArray[i].equals(dataFlavor)) continue;
            return true;
        }
        return false;
    }

    static {
        try {
            plainFlavors = new DataFlavor[3];
            ETableTransferable.plainFlavors[0] = new DataFlavor("text/plain;class=java.lang.String");
            ETableTransferable.plainFlavors[1] = new DataFlavor("text/plain;class=java.io.Reader");
            ETableTransferable.plainFlavors[2] = new DataFlavor("text/plain;charset=unicode;class=java.io.InputStream");
            stringFlavors = new DataFlavor[2];
            ETableTransferable.stringFlavors[0] = new DataFlavor("application/x-java-jvm-local-objectref;class=java.lang.String");
            ETableTransferable.stringFlavors[1] = DataFlavor.stringFlavor;
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("error initializing SheetTasbleTransferable");
        }
    }
}

