/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.heap;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.netbeans.lib.profiler.heap.ClassDumpSegment;
import org.netbeans.lib.profiler.heap.HprofHeap;
import org.netbeans.lib.profiler.heap.LoadClassSegment;
import org.netbeans.lib.profiler.heap.StackFrameSegment;
import org.netbeans.lib.profiler.heap.StackTraceSegment;
import org.netbeans.lib.profiler.heap.StringSegment;

class TagBounds {
    final int tag;
    final long startOffset;
    long endOffset;

    TagBounds(int n, long l, long l2) {
        this.tag = n;
        this.startOffset = l;
        this.endOffset = l2;
    }

    TagBounds union(TagBounds tagBounds) {
        if (tagBounds == null) {
            return this;
        }
        long l = Math.min(this.startOffset, tagBounds.startOffset);
        long l2 = Math.max(this.endOffset, tagBounds.endOffset);
        return new TagBounds(-1, l, l2);
    }

    void writeToStream(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(this.tag);
        dataOutputStream.writeLong(this.startOffset);
        dataOutputStream.writeLong(this.endOffset);
    }

    TagBounds(DataInputStream dataInputStream) throws IOException {
        this.tag = dataInputStream.readInt();
        this.startOffset = dataInputStream.readLong();
        this.endOffset = dataInputStream.readLong();
    }

    static void writeToStream(TagBounds[] tagBoundsArray, DataOutputStream dataOutputStream) throws IOException {
        int n;
        int n2 = 0;
        for (n = 0; n < tagBoundsArray.length; ++n) {
            if (tagBoundsArray[n] == null) continue;
            ++n2;
        }
        dataOutputStream.writeInt(n2);
        for (n = 0; n < tagBoundsArray.length; ++n) {
            if (tagBoundsArray[n] == null) continue;
            tagBoundsArray[n].writeToStream(dataOutputStream);
        }
    }

    static void readFromStream(DataInputStream dataInputStream, HprofHeap hprofHeap, TagBounds[] tagBoundsArray) throws IOException {
        int n = dataInputStream.readInt();
        for (int i = 0; i < n; ++i) {
            int n2 = dataInputStream.readInt();
            long l = dataInputStream.readLong();
            long l2 = dataInputStream.readLong();
            TagBounds tagBounds = n2 == 2 ? new LoadClassSegment(hprofHeap, l, l2) : (n2 == 1 ? new StringSegment(hprofHeap, l, l2) : (n2 == 5 ? new StackTraceSegment(hprofHeap, l, l2) : (n2 == 4 ? new StackFrameSegment(hprofHeap, l, l2) : (n2 == 32 ? new ClassDumpSegment(hprofHeap, l, l2, dataInputStream) : new TagBounds(n2, l, l2)))));
            tagBoundsArray[tagBounds.tag] = tagBounds;
        }
    }
}

