/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.instrumentation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.lib.profiler.ProfilerEngineSettings;
import org.netbeans.lib.profiler.classfile.BaseClassInfo;
import org.netbeans.lib.profiler.classfile.ClassInfo;
import org.netbeans.lib.profiler.classfile.ClassRepository;
import org.netbeans.lib.profiler.classfile.DynamicClassInfo;
import org.netbeans.lib.profiler.classfile.PlaceholderClassInfo;
import org.netbeans.lib.profiler.client.RuntimeProfilingPoint;
import org.netbeans.lib.profiler.filters.InstrumentationFilter;
import org.netbeans.lib.profiler.global.ProfilingSessionStatus;
import org.netbeans.lib.profiler.instrumentation.ClassManager;
import org.netbeans.lib.profiler.instrumentation.ClassRewriter;
import org.netbeans.lib.profiler.instrumentation.DynamicConstantPoolExtension;
import org.netbeans.lib.profiler.instrumentation.HandleServletDoMethodCallInjector;
import org.netbeans.lib.profiler.instrumentation.InstrumentationFactory;
import org.netbeans.lib.profiler.instrumentation.RootMethods;
import org.netbeans.lib.profiler.wireprotocol.RootClassLoadedCommand;

public abstract class RecursiveMethodInstrumentor
extends ClassManager {
    protected Map instrClasses = new HashMap();
    protected InstrumentationFilter instrFilter;
    protected byte[] codeBytes;
    protected boolean dontInstrumentEmptyMethods;
    protected boolean dontScanGetterSetterMethods;
    protected boolean instrumentSpawnedThreads;
    protected boolean reflectInvokeInstrumented = false;
    protected int markerInjectionType;
    protected int nInstrClasses;
    protected int nInstrMethods;
    protected int normalInjectionType;
    protected int offset;
    protected int rootInjectionType;
    RootMethods rootMethods;
    private ProfilerEngineSettings engineSettings;

    RecursiveMethodInstrumentor(ProfilingSessionStatus profilingSessionStatus, ProfilerEngineSettings profilerEngineSettings) {
        super(profilingSessionStatus);
        switch (profilingSessionStatus.currentInstrType) {
            case 3: {
                this.normalInjectionType = 0;
                this.rootInjectionType = 1;
                this.markerInjectionType = 2;
                break;
            }
            case 4: {
                this.normalInjectionType = 3;
                this.rootInjectionType = 4;
                this.markerInjectionType = 5;
            }
        }
        this.reflectInvokeInstrumented = false;
        this.dontScanGetterSetterMethods = !profilerEngineSettings.getInstrumentGetterSetterMethods();
        this.dontInstrumentEmptyMethods = !profilerEngineSettings.getInstrumentEmptyMethods();
        this.instrumentSpawnedThreads = profilerEngineSettings.getInstrumentSpawnedThreads();
        this.instrFilter = profilerEngineSettings.getInstrumentationFilter();
        this.engineSettings = profilerEngineSettings;
    }

    abstract Object[] getInitialMethodsToInstrument(RootClassLoadedCommand var1, RootMethods var2);

    public abstract Object[] getMethodsToInstrumentUponClassLoad(String var1, int var2, boolean var3);

    public abstract Object[] getMethodsToInstrumentUponMethodInvocation(String var1, int var2, String var3, String var4);

    public abstract Object[] getMethodsToInstrumentUponReflectInvoke(String var1, int var2, String var3, String var4);

    protected void initInstrMethodData() {
        this.instrClasses.clear();
        this.nInstrMethods = 0;
        this.nInstrClasses = 0;
    }

    protected static boolean rootClassNameIsReal(String string) {
        return !string.equals("*NO_CLASS_NAME*");
    }

    protected void addToSubclassList(DynamicClassInfo dynamicClassInfo, DynamicClassInfo dynamicClassInfo2) {
        DynamicClassInfo[] dynamicClassInfoArray;
        DynamicClassInfo dynamicClassInfo3 = this.getSuperClass(dynamicClassInfo);
        dynamicClassInfo.setSuperClass(dynamicClassInfo3);
        if (dynamicClassInfo3 != null && !dynamicClassInfo.isInterface()) {
            if (dynamicClassInfo2 != null) {
                dynamicClassInfo3.addSubclass(dynamicClassInfo2);
                this.findAndMarkOverridingMethodsReachable(dynamicClassInfo3, dynamicClassInfo2);
            }
            if (dynamicClassInfo3.getName() != "java/lang/Object") {
                this.addToSubclassList(dynamicClassInfo3, dynamicClassInfo2);
            }
        }
        if ((dynamicClassInfoArray = this.getInterfaces(dynamicClassInfo)) != null) {
            for (int i = 0; i < dynamicClassInfoArray.length; ++i) {
                DynamicClassInfo dynamicClassInfo4 = dynamicClassInfoArray[i];
                dynamicClassInfo.setSuperInterface(dynamicClassInfo4, i);
                if (dynamicClassInfo4 == null) continue;
                if (dynamicClassInfo2 != null) {
                    dynamicClassInfo4.addSubclass(dynamicClassInfo2);
                    this.findAndMarkOverridingMethodsReachable(dynamicClassInfo4, dynamicClassInfo2);
                }
                this.addToSubclassList(dynamicClassInfo4, dynamicClassInfo2);
            }
        }
    }

    protected abstract void findAndMarkOverridingMethodsReachable(DynamicClassInfo var1, DynamicClassInfo var2);

    protected abstract void processInvoke(DynamicClassInfo var1, boolean var2, int var3);

    protected final int at(int n) {
        return this.codeBytes[this.offset + n] & 0xFF;
    }

    protected final long intAt(int n, int n2) {
        int n3 = n + (n2 << 2);
        return this.codeBytes[n3] << 24 | (this.codeBytes[n3 + 1] & 0xFF) << 16 | (this.codeBytes[n3 + 2] & 0xFF) << 8 | this.codeBytes[n3 + 3] & 0xFF;
    }

    protected void scanMethod(DynamicClassInfo dynamicClassInfo, int n) {
        byte[] byArray = dynamicClassInfo.getMethodBytecode(n);
        this.scanBytecode(dynamicClassInfo, byArray);
    }

    protected final int shortAt(int n) {
        int n2 = this.offset + n;
        return (this.codeBytes[n2] & 0xFF) << 8 | this.codeBytes[n2 + 1] & 0xFF;
    }

    protected boolean scanBytecode(DynamicClassInfo dynamicClassInfo, byte[] byArray) {
        this.codeBytes = byArray;
        this.offset = 0;
        block6: while (this.offset < this.codeBytes.length) {
            int n = this.at(0);
            if (n == 196) {
                n = this.at(1);
                if (n >= 21 && n <= 25 || n >= 54 && n <= 58 || n == 169) {
                    this.offset += 4;
                    continue;
                }
                if (n == 132) {
                    this.offset += 6;
                    continue;
                }
                ++this.offset;
                continue;
            }
            switch (n) {
                case 170: {
                    int n2 = this.offset + 1 + 3 & 0xFFFFFFFC;
                    long l = this.intAt(n2, 0);
                    long l2 = this.intAt(n2, 1);
                    long l3 = this.intAt(n2, 2);
                    this.offset = (n2 += 12) + (int)(l3 - l2 + 1L << 2);
                    continue block6;
                }
                case 171: {
                    int n2 = this.offset + 1 + 3 & 0xFFFFFFFC;
                    long l = this.intAt(n2, 0);
                    int n3 = (int)this.intAt(n2, 1);
                    int n4 = n3 * 2;
                    this.offset = (n2 += 8) + (n4 << 2);
                    continue block6;
                }
                case 182: 
                case 183: 
                case 184: {
                    if (dynamicClassInfo == null) {
                        return false;
                    }
                    int n2 = this.shortAt(1);
                    this.processInvoke(dynamicClassInfo, n == 182, n2);
                    this.offset += 3;
                    continue block6;
                }
                case 185: {
                    if (dynamicClassInfo == null) {
                        return false;
                    }
                    int n2 = this.shortAt(1);
                    this.processInvoke(dynamicClassInfo, true, n2);
                    this.offset += 5;
                    continue block6;
                }
            }
            this.offset += opc_length[n];
        }
        return true;
    }

    protected abstract boolean tryInstrumentSpawnedThreads(DynamicClassInfo var1);

    protected static boolean isEmptyMethod(byte[] byArray) {
        return byArray.length == 1;
    }

    protected static boolean isGetterSetterMethod(byte[] byArray) {
        return byArray.length == 5 ? (byArray[0] & 0xFF) == 42 && (byArray[1] & 0xFF) == 180 && (byArray[4] & 0xFF) >= 172 && (byArray[4] & 0xFF) <= 176 : byArray.length == 6 && (byArray[0] & 0xFF) == 42 && (byArray[1] & 0xFF) >= 27 && (byArray[1] & 0xFF) <= 43 && (byArray[2] & 0xFF) == 181 && (byArray[5] & 0xFF) == 177;
    }

    protected boolean isLeafMethod(byte[] byArray) {
        return this.scanBytecode(null, byArray);
    }

    protected Object[] createInstrumentedMethodPack() {
        if (this.nInstrClasses == 0) {
            return null;
        }
        return this.createInstrumentedMethodPack15();
    }

    protected void markAllMethodsMarker(DynamicClassInfo dynamicClassInfo) {
        dynamicClassInfo.setAllMethodsMarkers();
    }

    protected void markAllMethodsRoot(DynamicClassInfo dynamicClassInfo) {
        dynamicClassInfo.setAllMethodsRoots();
    }

    protected void markClassAndMethodForInstrumentation(DynamicClassInfo dynamicClassInfo, int n) {
        if (this.status.getStartingMethodId() + this.nInstrMethods < 65535) {
            this.addInsrClass(dynamicClassInfo);
            ++this.nInstrMethods;
        } else {
            dynamicClassInfo.setMethodInstrumented(n);
        }
    }

    protected void markProfilingPointForInstrumentation(String string, String string2, int n) {
        RuntimeProfilingPoint[] runtimeProfilingPointArray;
        for (RuntimeProfilingPoint runtimeProfilingPoint : runtimeProfilingPointArray = this.engineSettings.getRuntimeProfilingPoints()) {
            if (!string.equals(runtimeProfilingPoint.getClassName())) continue;
            DynamicClassInfo dynamicClassInfo = RecursiveMethodInstrumentor.javaClassForName(string2, n);
            if (dynamicClassInfo != null) {
                this.markProfilingPonitForInstrumentation(dynamicClassInfo);
            }
            return;
        }
    }

    protected void markProfilingPonitForInstrumentation(DynamicClassInfo dynamicClassInfo) {
        RuntimeProfilingPoint[] runtimeProfilingPointArray = this.engineSettings.getRuntimeProfilingPoints();
        RuntimeProfilingPoint[] runtimeProfilingPointArray2 = RecursiveMethodInstrumentor.getRuntimeProfilingPoints(runtimeProfilingPointArray, dynamicClassInfo);
        if (runtimeProfilingPointArray2.length > 0) {
            this.addInsrClass(dynamicClassInfo);
        }
    }

    protected boolean markMethod(DynamicClassInfo dynamicClassInfo, int n) {
        String string = this.rootMethods.methodNames[n];
        String string2 = this.rootMethods.methodSignatures[n];
        boolean bl = this.rootMethods.markerMethods[n];
        int n2 = dynamicClassInfo.getMethodIndex(string, string2);
        if (n2 == -1) {
            return false;
        }
        if (bl) {
            dynamicClassInfo.setMethodMarker(n2);
        } else {
            dynamicClassInfo.setMethodRoot(n2);
        }
        return true;
    }

    protected boolean markMethodMarker(DynamicClassInfo dynamicClassInfo, String string, String string2) {
        int n = dynamicClassInfo.getMethodIndex(string, string2);
        if (n == -1) {
            return false;
        }
        dynamicClassInfo.setMethodMarker(n);
        return true;
    }

    protected boolean markMethodRoot(DynamicClassInfo dynamicClassInfo, String string, String string2) {
        int n = dynamicClassInfo.getMethodIndex(string, string2);
        if (n == -1) {
            return false;
        }
        dynamicClassInfo.setMethodRoot(n);
        return true;
    }

    private Object[] createInstrumentedMethodPack15() {
        int n2;
        Object object;
        Object object2;
        Object object3 = null;
        int n3 = -1;
        if (!this.reflectInvokeInstrumented) {
            int n4 = 0;
            object2 = this.instrClasses.values().iterator();
            while (object2.hasNext()) {
                object = (DynamicClassInfo)object2.next();
                if (((BaseClassInfo)object).getName() == "java/lang/reflect/Method") {
                    n3 = n4;
                    object3 = object;
                    break;
                }
                ++n4;
            }
            if (n3 == -1 && (object3 = RecursiveMethodInstrumentor.javaClassForName("java/lang/reflect/Method", 0)) != null) {
                ++this.nInstrClasses;
            }
            if (object3 == null) {
                this.reflectInvokeInstrumented = true;
            }
        }
        String[] stringArray = new String[this.nInstrClasses];
        object2 = new int[this.nInstrClasses];
        object = new boolean[this.nInstrMethods];
        byte[][] byArrayArray = new byte[this.nInstrClasses][];
        int n5 = this.status.getStartingMethodId();
        int n6 = 0;
        int n7 = 0;
        for (Object object4 : this.instrClasses.values()) {
            n2 = ((ClassInfo)object4).getMethodNames().length;
            stringArray[n6] = ((BaseClassInfo)object4).getName().replace('/', '.').intern();
            object2[n6] = ((BaseClassInfo)object4).getLoaderId();
            boolean bl = ((DynamicClassInfo)object4).hasUninstrumentedRootMethods();
            boolean n = ((DynamicClassInfo)object4).hasUninstrumentedMarkerMethods();
            DynamicConstantPoolExtension.getCPFragment((DynamicClassInfo)object4, this.normalInjectionType);
            if (bl) {
                DynamicConstantPoolExtension.getCPFragment((DynamicClassInfo)object4, this.rootInjectionType);
            }
            if (n) {
                DynamicConstantPoolExtension.getCPFragment((DynamicClassInfo)object4, this.markerInjectionType);
            }
            int byArray = 0;
            byte[][] byArrayArray2 = new byte[n2][];
            RuntimeProfilingPoint[] runtimeProfilingPointArray = RecursiveMethodInstrumentor.getRuntimeProfilingPoints(this.engineSettings.getRuntimeProfilingPoints(), (ClassInfo)object4);
            for (int dynamicConstantPoolExtension = 0; dynamicConstantPoolExtension < n2; ++dynamicConstantPoolExtension) {
                RuntimeProfilingPoint[] n9 = RecursiveMethodInstrumentor.getRuntimeProfilingPoints(runtimeProfilingPointArray, dynamicConstantPoolExtension);
                if (!((DynamicClassInfo)object4).isMethodInstrumented(dynamicConstantPoolExtension)) {
                    if (((DynamicClassInfo)object4).isMethodReachable(dynamicConstantPoolExtension) && !((DynamicClassInfo)object4).isMethodUnscannable(dynamicConstantPoolExtension)) {
                        ((DynamicClassInfo)object4).setMethodInstrumented(dynamicConstantPoolExtension);
                        object[n7] = ((DynamicClassInfo)object4).isMethodLeaf(dynamicConstantPoolExtension);
                        byArrayArray2[dynamicConstantPoolExtension] = InstrumentationFactory.instrumentMethod((DynamicClassInfo)object4, dynamicConstantPoolExtension, this.normalInjectionType, this.rootInjectionType, this.markerInjectionType, n5++, n9);
                        ((DynamicClassInfo)object4).saveMethodInfo(dynamicConstantPoolExtension, byArrayArray2[dynamicConstantPoolExtension]);
                        this.status.updateInstrMethodsInfo(stringArray[n6], (int)object2[n6], ((ClassInfo)object4).getMethodNames()[dynamicConstantPoolExtension], ((ClassInfo)object4).getMethodSignatures()[dynamicConstantPoolExtension]);
                        ++byArray;
                        ++n7;
                        continue;
                    }
                    if (n9.length <= 0) continue;
                    byArrayArray2[dynamicConstantPoolExtension] = InstrumentationFactory.instrumentAsProiflePointHitMethod((DynamicClassInfo)object4, dynamicConstantPoolExtension, this.normalInjectionType, n9);
                    ((DynamicClassInfo)object4).saveMethodInfo(dynamicConstantPoolExtension, byArrayArray2[dynamicConstantPoolExtension]);
                    ++byArray;
                    continue;
                }
                byArrayArray2[dynamicConstantPoolExtension] = ((DynamicClassInfo)object4).getMethodInfo(dynamicConstantPoolExtension);
                ++byArray;
            }
            this.instrumentServletDoMethods((DynamicClassInfo)object4, byArrayArray2);
            if (byArray > 0) {
                if (bl) {
                    ((DynamicClassInfo)object4).setHasUninstrumentedRootMethods(false);
                }
                if (n) {
                    ((DynamicClassInfo)object4).setHasUninstrumentedMarkerMethods(false);
                }
                DynamicConstantPoolExtension dynamicConstantPoolExtension = DynamicConstantPoolExtension.getAllAddedCPFragments((DynamicClassInfo)object4);
                int n4 = dynamicConstantPoolExtension.getNEntries();
                byte[] byArray2 = dynamicConstantPoolExtension.getContents();
                byArrayArray[n6] = ClassRewriter.rewriteClassFile((DynamicClassInfo)object4, byArrayArray2, n4, byArray2);
            }
            ++n6;
        }
        if (!this.reflectInvokeInstrumented) {
            Object object4;
            int n10 = ((ClassInfo)object3).getMethodNames().length;
            object4 = new byte[n10][];
            if (n3 == -1) {
                stringArray[n6] = "java.lang.reflect.Method";
                object2[n6] = false;
            } else {
                n6 = n3;
                for (n2 = 0; n2 < n10; ++n2) {
                    object4[n2] = ((DynamicClassInfo)object3).getMethodInfo(n2);
                }
            }
            n2 = ((ClassInfo)object3).getMethodIndex("invoke", "(Ljava/lang/Object;[Ljava/lang/Object;)Ljava/lang/Object;");
            DynamicConstantPoolExtension.getCPFragment((DynamicClassInfo)object3, 6);
            object4[n2] = InstrumentationFactory.instrumentAsReflectInvokeMethod((DynamicClassInfo)object3, n2);
            DynamicConstantPoolExtension dynamicConstantPoolExtension = DynamicConstantPoolExtension.getAllAddedCPFragments((DynamicClassInfo)object3);
            int n = dynamicConstantPoolExtension.getNEntries();
            byte[] byArray = dynamicConstantPoolExtension.getContents();
            byArrayArray[n6] = ClassRewriter.rewriteClassFile((DynamicClassInfo)object3, (byte[][])object4, n, byArray);
            ((DynamicClassInfo)object3).saveMethodInfo(n2, (byte[])object4[n2]);
            this.reflectInvokeInstrumented = true;
        }
        return new Object[]{stringArray, object2, object, byArrayArray};
    }

    private void instrumentServletDoMethods(DynamicClassInfo dynamicClassInfo, byte[][] byArray) {
        if (!Boolean.getBoolean("org.netbeans.lib.profiler.servletTracking")) {
            return;
        }
        if (dynamicClassInfo.isServletDoMethodScanned()) {
            return;
        }
        dynamicClassInfo.setServletDoMethodScanned();
        if (!dynamicClassInfo.isSubclassOf(HandleServletDoMethodCallInjector.getClassName())) {
            return;
        }
        DynamicConstantPoolExtension.getCPFragment(dynamicClassInfo, 7);
        String[] stringArray = HandleServletDoMethodCallInjector.getMethodNames();
        String[] stringArray2 = HandleServletDoMethodCallInjector.getMethodSignatures();
        for (int i = 0; i < stringArray.length; ++i) {
            int n = dynamicClassInfo.getMethodIndex(stringArray[i], stringArray2[i]);
            if (n == -1) continue;
            byArray[n] = InstrumentationFactory.instrumentAsServletDoMethod(dynamicClassInfo, n);
            dynamicClassInfo.saveMethodInfo(n, byArray[n]);
        }
    }

    private void addInsrClass(DynamicClassInfo dynamicClassInfo) {
        String string = dynamicClassInfo.getNameAndLoader();
        if (!this.instrClasses.containsKey(string)) {
            this.instrClasses.put(string, dynamicClassInfo);
            ++this.nInstrClasses;
        }
    }

    private DynamicClassInfo getSuperClass(DynamicClassInfo dynamicClassInfo) {
        BaseClassInfo baseClassInfo;
        List list;
        String string = dynamicClassInfo.getSuperclassName();
        if (dynamicClassInfo.isLoaded() && (list = ClassRepository.getAllClassVersions(string)) != null && list.size() == 1 && (baseClassInfo = (BaseClassInfo)list.get(0)) instanceof DynamicClassInfo) {
            return (DynamicClassInfo)baseClassInfo;
        }
        return RecursiveMethodInstrumentor.javaClassForName(string, dynamicClassInfo.getLoaderId());
    }

    private DynamicClassInfo[] getInterfaces(DynamicClassInfo dynamicClassInfo) {
        String[] stringArray = dynamicClassInfo.getInterfaceNames();
        if (stringArray != null) {
            DynamicClassInfo[] dynamicClassInfoArray = new DynamicClassInfo[stringArray.length];
            int n = dynamicClassInfo.getLoaderId();
            boolean bl = dynamicClassInfo.isLoaded();
            for (int i = 0; i < stringArray.length; ++i) {
                BaseClassInfo baseClassInfo;
                List list;
                dynamicClassInfoArray[i] = bl && (list = ClassRepository.getAllClassVersions(stringArray[i])) != null && list.size() == 1 && (baseClassInfo = (BaseClassInfo)list.get(0)) instanceof DynamicClassInfo ? (DynamicClassInfo)list.get(0) : RecursiveMethodInstrumentor.javaClassForName(stringArray[i], n);
            }
            return dynamicClassInfoArray;
        }
        return null;
    }

    protected static class ReachableMethodPlaceholder
    extends PlaceholderClassInfo {
        protected ArrayList methodNamesAndSigs = new ArrayList();

        ReachableMethodPlaceholder(String string, int n) {
            super(string, n);
        }

        public void registerReachableMethod(String string, String string2) {
            int n = this.methodNamesAndSigs.indexOf(string);
            if (n != -1 && this.methodNamesAndSigs.get(n + 1).equals(string2)) {
                return;
            }
            this.methodNamesAndSigs.add(string);
            this.methodNamesAndSigs.add(string2);
        }
    }
}

