/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems.annotations;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.NoSuchFileException;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.openide.filesystems.annotations.LayerBuilder;
import org.openide.filesystems.annotations.LayerGenerationException;
import org.openide.util.WeakSet;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public abstract class LayerGeneratingProcessor
extends AbstractProcessor {
    private static final String GENERATED_LAYER = "META-INF/generated-layer.xml";
    private static final String PUBLIC_DTD_ID = "-//NetBeans//DTD Filesystem 1.2//EN";
    private static final String NETWORK_DTD_URL = "http://www.netbeans.org/dtds/filesystem-1_2.dtd";
    private static final String LOCAL_DTD_RESOURCE = "/org/openide/filesystems/filesystem1_2.dtd";
    private static final ErrorHandler ERROR_HANDLER = new ErrorHandler(){

        @Override
        public void warning(SAXParseException sAXParseException) throws SAXException {
            throw sAXParseException;
        }

        @Override
        public void error(SAXParseException sAXParseException) throws SAXException {
            throw sAXParseException;
        }

        @Override
        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            throw sAXParseException;
        }
    };
    private static final EntityResolver ENTITY_RESOLVER = new EntityResolver(){

        @Override
        public InputSource resolveEntity(String string, String string2) throws SAXException, IOException {
            if (LayerGeneratingProcessor.PUBLIC_DTD_ID.equals(string)) {
                return new InputSource(LayerGeneratingProcessor.class.getResource(LayerGeneratingProcessor.LOCAL_DTD_RESOURCE).toString());
            }
            return null;
        }
    };
    private static final Map<Filer, Document> generatedLayerByProcessor = new WeakHashMap<Filer, Document>();
    private static final Map<Filer, Collection<Element>> originatingElementsByProcessor = new WeakHashMap<Filer, Collection<Element>>();
    private final List<LayerBuilder> createdBuilders = new LinkedList<LayerBuilder>();

    protected LayerGeneratingProcessor() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean process(Set<? extends TypeElement> set, RoundEnvironment roundEnvironment) {
        boolean bl;
        Messager messager = this.processingEnv.getMessager();
        try {
            bl = this.handleProcess(set, roundEnvironment);
        }
        catch (LayerGenerationException layerGenerationException) {
            if (layerGenerationException.erroneousAnnotationValue != null) {
                messager.printMessage(Diagnostic.Kind.ERROR, layerGenerationException.getLocalizedMessage(), layerGenerationException.erroneousElement, layerGenerationException.erroneousAnnotation, layerGenerationException.erroneousAnnotationValue);
            } else if (layerGenerationException.erroneousAnnotation != null) {
                messager.printMessage(Diagnostic.Kind.ERROR, layerGenerationException.getLocalizedMessage(), layerGenerationException.erroneousElement, layerGenerationException.erroneousAnnotation);
            } else if (layerGenerationException.erroneousElement != null) {
                messager.printMessage(Diagnostic.Kind.ERROR, layerGenerationException.getLocalizedMessage(), layerGenerationException.erroneousElement);
            } else {
                messager.printMessage(Diagnostic.Kind.ERROR, layerGenerationException.getLocalizedMessage());
            }
            return false;
        }
        if (roundEnvironment.processingOver()) {
            Filer filer = this.processingEnv.getFiler();
            Document document = generatedLayerByProcessor.remove(filer);
            Collection<Element> collection = originatingElementsByProcessor.remove(filer);
            if (document != null && !roundEnvironment.errorRaised()) {
                Element[] elementArray = new Element[]{};
                if (collection != null) {
                    elementArray = collection.toArray(elementArray);
                }
                try {
                    ByteArrayOutputStream object = new ByteArrayOutputStream();
                    DOMImplementationLS dOMImplementationLS = (DOMImplementationLS)document.getImplementation().getFeature("LS", "3.0");
                    assert (dOMImplementationLS != null) : "No DOM 3 LS supported in " + document.getClass().getName();
                    LSOutput lSOutput = dOMImplementationLS.createLSOutput();
                    lSOutput.setEncoding("UTF-8");
                    lSOutput.setByteStream(object);
                    LSSerializer lSSerializer = dOMImplementationLS.createLSSerializer();
                    String string = "format-pretty-print";
                    if (lSSerializer.getDomConfig().canSetParameter(string, true)) {
                        lSSerializer.getDomConfig().setParameter(string, true);
                    }
                    lSSerializer.write(document, lSOutput);
                    byte[] byArray = object.toByteArray();
                    XMLUtil.parse((InputSource)new InputSource(new ByteArrayInputStream(byArray)), (boolean)true, (boolean)true, (ErrorHandler)ERROR_HANDLER, (EntityResolver)ENTITY_RESOLVER);
                    FileObject fileObject = filer.createResource(StandardLocation.CLASS_OUTPUT, "", GENERATED_LAYER, elementArray);
                    try (OutputStream outputStream = fileObject.openOutputStream();){
                        outputStream.write(byArray);
                    }
                }
                catch (IOException iOException) {
                    messager.printMessage(Diagnostic.Kind.ERROR, "Failed to write generated-layer.xml: " + iOException.toString());
                }
                catch (SAXException sAXException) {
                    messager.printMessage(Diagnostic.Kind.ERROR, "Refused to write invalid generated-layer.xml: " + sAXException.toString());
                }
            }
            for (LayerBuilder layerBuilder : this.createdBuilders) {
                layerBuilder.close();
            }
            this.createdBuilders.clear();
        }
        return bl;
    }

    protected abstract boolean handleProcess(Set<? extends TypeElement> var1, RoundEnvironment var2) throws LayerGenerationException;

    protected final LayerBuilder layer(Element ... elementArray) {
        LayerBuilder layerBuilder = new LayerBuilder(this.layerDocument(elementArray), elementArray.length == 1 ? elementArray[0] : null, this.processingEnv);
        this.createdBuilders.add(layerBuilder);
        return layerBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Document layerDocument(Element ... elementArray) {
        Filer filer = this.processingEnv.getFiler();
        WeakSet weakSet = originatingElementsByProcessor.get(filer);
        if (weakSet == null) {
            weakSet = new WeakSet();
            originatingElementsByProcessor.put(filer, (Collection<Element>)weakSet);
        }
        weakSet.addAll(Arrays.asList(elementArray));
        Document document = generatedLayerByProcessor.get(filer);
        if (document == null) {
            try {
                FileObject fileObject = filer.getResource(StandardLocation.CLASS_OUTPUT, "", GENERATED_LAYER);
                try (InputStream inputStream = fileObject.openInputStream();){
                    document = XMLUtil.parse((InputSource)new InputSource(inputStream), (boolean)true, (boolean)true, (ErrorHandler)ERROR_HANDLER, (EntityResolver)ENTITY_RESOLVER);
                }
            }
            catch (FileNotFoundException | NoSuchFileException iOException) {
            }
            catch (IOException iOException) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Failed to read generated-layer.xml: " + iOException.toString());
            }
            catch (SAXException sAXException) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Failed to parse generated-layer.xml: " + sAXException.toString());
            }
            if (document == null) {
                document = XMLUtil.createDocument((String)"filesystem", null, (String)PUBLIC_DTD_ID, (String)NETWORK_DTD_URL);
            }
            generatedLayerByProcessor.put(filer, document);
        }
        return document;
    }
}

