/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.awt.EventQueue;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.openide.loaders.DataNodeUtils;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.ChangeableDataFilter;
import org.openide.loaders.DataFilter;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.DataObjectPool;
import org.openide.loaders.FolderChildrenPair;
import org.openide.loaders.FolderList;
import org.openide.loaders.FolderOrder;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

final class FolderChildren
extends Children.Keys<FolderChildrenPair>
implements PropertyChangeListener,
ChangeListener,
FileChangeListener {
    private FolderList folder;
    private final DataFilter filter;
    private PropertyChangeListener listener;
    private FileChangeListener fcListener;
    private ChangeListener changeListener;
    private final Logger err;
    private volatile Collection<FolderChildrenPair> pairs;
    private volatile Task refTask = Task.EMPTY;
    private static final boolean DELAYED_CREATION_ENABLED = !"false".equals(System.getProperty("org.openide.loaders.FolderChildren.delayedCreation"));

    public FolderChildren(DataFolder dataFolder) {
        this(dataFolder, DataFilter.ALL);
    }

    public FolderChildren(DataFolder dataFolder, DataFilter dataFilter) {
        super(true);
        String string = dataFolder.getPrimaryFile().isRoot() ? "org.openide.loaders.FolderChildren" : "org.openide.loaders.FolderChildren." + dataFolder.getPrimaryFile().getPath().replace('/', '.');
        this.err = Logger.getLogger(string);
        this.folder = FolderList.find(dataFolder.getPrimaryFile(), true);
        this.filter = dataFilter;
        this.listener = WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.folder);
        this.fcListener = FileUtil.weakFileChangeListener((FileChangeListener)this, (Object)this.folder.getPrimaryFile());
    }

    DataFilter getFilter() {
        return this.filter;
    }

    void applyKeys(Collection<FolderChildrenPair> collection) {
        this.setKeys(collection);
        this.pairs = collection;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.err.log(Level.FINE, "Got a change {0}", propertyChangeEvent.getPropertyName());
        this.refreshChildren(RefreshMode.SHALLOW);
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        boolean bl;
        Object object = changeEvent.getSource();
        FileObject fileObject = null;
        if (object instanceof DataObject) {
            DataObject dataObject = (DataObject)object;
            fileObject = dataObject.getPrimaryFile();
        } else if (object instanceof FileObject) {
            fileObject = (FileObject)object;
        }
        if (fileObject != null) {
            FileObject fileObject2 = this.folder.getPrimaryFile();
            bl = !fileObject.isFolder() ? fileObject.getParent() == fileObject2 : fileObject == fileObject2;
        } else {
            bl = true;
        }
        if (bl) {
            this.refreshChildren(RefreshMode.DEEP);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshChildren(RefreshMode refreshMode) {
        class R
        implements Runnable {
            List<FolderChildrenPair> positioned = null;
            RefreshMode op;
            Task prevTask = null;

            R() {
            }

            @Override
            public void run() {
                block9: {
                    if (this.prevTask != null) {
                        this.prevTask.waitFinished();
                        this.prevTask = null;
                    }
                    if (this.op == RefreshMode.DEEP) {
                        this.positioned = this.getPositionedFolderChildrenPairs();
                        this.op = RefreshMode.DEEP_LATER;
                        Children.MUTEX.postWriteRequest((Runnable)this);
                        return;
                    }
                    FolderChildren.this.err.log(Level.FINE, "refreshChildren {0}", (Object)this.op);
                    try {
                        if (this.op == RefreshMode.CLEAR) {
                            FolderChildren.this.applyKeys(Collections.<FolderChildrenPair>emptyList());
                            break block9;
                        }
                        if (this.op == RefreshMode.DEEP_LATER) {
                            assert (this.positioned != null) : "positioned not prepared";
                            FolderChildren.this.applyKeys(Collections.<FolderChildrenPair>emptyList());
                            FolderChildren.this.applyKeys(this.positioned);
                            break block9;
                        }
                        if (this.op == RefreshMode.SHALLOW) {
                            FolderChildren.this.applyKeys(this.getPositionedFolderChildrenPairs());
                            break block9;
                        }
                        throw new IllegalStateException("Unknown op: " + (Object)((Object)this.op));
                    }
                    finally {
                        FolderChildren.this.err.log(Level.FINE, "refreshChildren {0}, done", (Object)this.op);
                    }
                }
            }

            private List<FolderChildrenPair> getPositionedFolderChildrenPairs() {
                FileObject[] fileObjectArray = FolderChildren.this.folder.getPrimaryFile().getChildren();
                FolderOrder folderOrder = FolderOrder.findFor(FolderChildren.this.folder.getPrimaryFile());
                Arrays.sort(fileObjectArray, folderOrder);
                ArrayList<FolderChildrenPair> arrayList = new ArrayList<FolderChildrenPair>(fileObjectArray.length);
                for (FileObject fileObject : FileUtil.getOrder(Arrays.asList(fileObjectArray), (boolean)false)) {
                    DataFilter.FileBased fileBased;
                    if (FolderChildren.this.filter instanceof DataFilter.FileBased && !(fileBased = (DataFilter.FileBased)FolderChildren.this.filter).acceptFileObject(fileObject)) continue;
                    arrayList.add(new FolderChildrenPair(fileObject));
                }
                return arrayList;
            }
        }
        R r = new R();
        if (refreshMode == RefreshMode.SHALLOW_IMMEDIATE) {
            this.refTask.waitFinished();
            r.op = RefreshMode.SHALLOW;
            r.run();
        } else {
            r.op = refreshMode;
            FolderChildren folderChildren = this;
            synchronized (folderChildren) {
                r.prevTask = this.refTask;
                this.refTask = DataNodeUtils.reqProcessor(this.folder.getPrimaryFile()).post((Runnable)r);
            }
        }
    }

    protected Node[] createNodes(FolderChildrenPair folderChildrenPair) {
        Node[] nodeArray;
        boolean bl = DELAYED_CREATION_ENABLED && EventQueue.isDispatchThread() && !folderChildrenPair.primaryFile.isFolder();
        Object object = bl ? new DelayedNode(folderChildrenPair) : this.createNode(folderChildrenPair);
        if (object == null) {
            nodeArray = null;
        } else {
            Node[] nodeArray2 = new Node[1];
            nodeArray = nodeArray2;
            nodeArray2[0] = object;
        }
        return nodeArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Node createNode(FolderChildrenPair folderChildrenPair) {
        Node node;
        long l;
        block7: {
            l = System.currentTimeMillis();
            node = null;
            try {
                FileObject fileObject = folderChildrenPair.primaryFile;
                DataObject dataObject = DataObject.find(fileObject);
                if (!dataObject.isValid() || !fileObject.equals(dataObject.getPrimaryFile()) || this.filter != null && !this.filter.acceptDataObject(dataObject)) break block7;
                node = dataObject.getClonedNodeDelegate(this.filter);
                if (dataObject.isValid()) break block7;
                node = null;
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                try {
                    Logger.getLogger(FolderChildren.class.getName()).log(Level.FINE, null, dataObjectNotFoundException);
                }
                catch (Throwable throwable) {
                    long l2 = System.currentTimeMillis() - l;
                    if (this.err.isLoggable(Level.FINE)) {
                        this.err.log(Level.FINE, "createNodes: {0} took: {1} ms", new Object[]{folderChildrenPair, l2});
                        this.err.log(Level.FINE, "  returning: {0}", node);
                    }
                    throw throwable;
                }
                long l3 = System.currentTimeMillis() - l;
                if (this.err.isLoggable(Level.FINE)) {
                    this.err.log(Level.FINE, "createNodes: {0} took: {1} ms", new Object[]{folderChildrenPair, l3});
                    this.err.log(Level.FINE, "  returning: {0}", node);
                }
            }
        }
        long l4 = System.currentTimeMillis() - l;
        if (this.err.isLoggable(Level.FINE)) {
            this.err.log(Level.FINE, "createNodes: {0} took: {1} ms", new Object[]{folderChildrenPair, l4});
            this.err.log(Level.FINE, "  returning: {0}", node);
        }
        return node;
    }

    public Node[] getNodes(boolean bl) {
        Node[] nodeArray;
        Level level = null;
        int n = 0;
        while (true) {
            if (bl) {
                this.waitOptimalResult();
            }
            nodeArray = this.getNodes();
            boolean bl2 = true;
            for (Node node : nodeArray) {
                if (!(node instanceof DelayedNode)) continue;
                DelayedNode delayedNode = (DelayedNode)node;
                if (!FolderChildren.checkChildrenMutex() || !delayedNode.waitFinished()) continue;
                this.err.log(Level.FINE, "Waiting for delayed node {0}", delayedNode);
                bl2 = false;
                if (n <= 600) continue;
                this.err.log(Level.WARNING, "Scheduling additional refresh for {0}", delayedNode);
                delayedNode.scheduleRefresh("fallback");
            }
            if (bl2) break;
            if (n == 500) {
                this.err.warning("getNodes takes ages, turning on logging");
                level = this.err.getLevel();
                this.err.setLevel(Level.FINE);
            }
            if (n == 1000) {
                this.err.warning(FolderChildren.threadDump());
                this.err.setLevel(level);
                boolean bl3 = false;
                if (!$assertionsDisabled) {
                    bl3 = true;
                    if (!true) {
                        throw new AssertionError();
                    }
                }
                if (!bl3) break;
                throw new IllegalStateException("Too many repetitions in getNodes(true). Giving up.");
            }
            ++n;
        }
        if (level != null) {
            this.err.setLevel(level);
        }
        return nodeArray;
    }

    private static void appendThread(StringBuffer stringBuffer, String string, Thread thread, Map<Thread, StackTraceElement[]> map) {
        stringBuffer.append(string).append("Thread ").append(thread.getName()).append('\n');
        StackTraceElement[] stackTraceElementArray = map.get(thread);
        if (stackTraceElementArray != null) {
            for (StackTraceElement stackTraceElement : stackTraceElementArray) {
                stringBuffer.append("\tat ").append(stackTraceElement.getClassName()).append('.').append(stackTraceElement.getMethodName()).append('(').append(stackTraceElement.getFileName()).append(':').append(stackTraceElement.getLineNumber()).append(")\n");
            }
        }
    }

    private static void appendGroup(StringBuffer stringBuffer, String string, ThreadGroup threadGroup, Map<Thread, StackTraceElement[]> map) {
        stringBuffer.append(string).append("Group ").append(threadGroup.getName()).append('\n');
        string = string.concat("  ");
        int n = threadGroup.activeGroupCount();
        ThreadGroup[] threadGroupArray = new ThreadGroup[n];
        threadGroup.enumerate(threadGroupArray, false);
        for (ThreadGroup threadGroup2 : threadGroupArray) {
            if (threadGroup2 == null) continue;
            FolderChildren.appendGroup(stringBuffer, string, threadGroup2, map);
        }
        int n2 = threadGroup.activeCount();
        Thread[] threadArray = new Thread[n2];
        threadGroup.enumerate(threadArray, false);
        for (Thread thread : threadArray) {
            if (thread == null) continue;
            FolderChildren.appendThread(stringBuffer, string, thread, map);
        }
    }

    private static String threadDump() {
        Map<Thread, StackTraceElement[]> map = Thread.getAllStackTraces();
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        while (threadGroup.getParent() != null) {
            threadGroup = threadGroup.getParent();
        }
        StringBuffer stringBuffer = new StringBuffer();
        FolderChildren.appendGroup(stringBuffer, "", threadGroup, map);
        return stringBuffer.toString();
    }

    public Node findChild(String string) {
        if (FolderChildren.checkChildrenMutex()) {
            this.waitOptimalResult();
        }
        int n = 0;
        Collection<FolderChildrenPair> collection = this.pairs;
        if (collection != null) {
            for (FolderChildrenPair folderChildrenPair : collection) {
                FileObject fileObject = folderChildrenPair.primaryFile;
                if (fileObject.getNameExt().startsWith(string)) {
                    try {
                        Node node = DataObject.find(fileObject).getNodeDelegate();
                        if (!node.getName().equals(string)) continue;
                        Node node2 = this.getNodeAt(n);
                        if (node2 != null && node2.getName().equals(string)) {
                            return node2;
                        }
                    }
                    catch (DataObjectNotFoundException dataObjectNotFoundException) {
                        this.err.log(Level.INFO, "Can't find object for " + fileObject, dataObjectNotFoundException);
                    }
                }
                ++n;
            }
        }
        return super.findChild(string);
    }

    private void waitOptimalResult() {
        if (FolderChildren.checkChildrenMutex()) {
            this.err.fine("waitOptimalResult");
            if (!this.isInitialized()) {
                this.refreshChildren(RefreshMode.SHALLOW);
            }
            this.folder.waitProcessingFinished();
            this.refTask.waitFinished();
            this.err.fine("waitOptimalResult: waitProcessingFinished");
        } else {
            Logger.getLogger(FolderChildren.class.getName()).log(Level.WARNING, null, new IllegalStateException("getNodes(true) called while holding the Children.MUTEX"));
        }
    }

    public int getNodesCount(boolean bl) {
        if (bl) {
            this.waitOptimalResult();
        }
        return this.getNodesCount();
    }

    static boolean checkChildrenMutex() {
        return !Children.MUTEX.isReadAccess() && !Children.MUTEX.isWriteAccess();
    }

    protected void addNotify() {
        this.err.fine("addNotify begin");
        this.folder.addPropertyChangeListener(this.listener);
        this.folder.getPrimaryFile().addFileChangeListener(this.fcListener);
        if (this.filter instanceof ChangeableDataFilter) {
            ChangeableDataFilter changeableDataFilter = (ChangeableDataFilter)this.filter;
            this.changeListener = WeakListeners.change((ChangeListener)this, (Object)changeableDataFilter);
            changeableDataFilter.addChangeListener(this.changeListener);
        }
        this.refreshChildren(RefreshMode.SHALLOW);
        this.err.fine("addNotify end");
    }

    protected void removeNotify() {
        this.err.fine("removeNotify begin");
        this.folder.getPrimaryFile().removeFileChangeListener(this.fcListener);
        this.folder.removePropertyChangeListener(this.listener);
        if (this.filter instanceof ChangeableDataFilter) {
            ((ChangeableDataFilter)this.filter).removeChangeListener(this.changeListener);
            this.changeListener = null;
        }
        List<FolderChildrenPair> list = Collections.emptyList();
        this.applyKeys(list);
        this.err.fine("removeNotify end");
    }

    public String toString() {
        return this.folder != null ? this.folder.getPrimaryFile().toString() : super.toString();
    }

    public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
        if ("NetBeansAttrAssignedLoader".equals(fileAttributeEvent.getName())) {
            DataObjectPool.checkAttributeChanged(fileAttributeEvent);
            this.refreshKey(new FolderChildrenPair(fileAttributeEvent.getFile()));
            this.refreshChildren(RefreshMode.SHALLOW_IMMEDIATE);
        }
    }

    public void fileChanged(FileEvent fileEvent) {
    }

    public void fileDataCreated(FileEvent fileEvent) {
        this.refreshChildren(RefreshMode.SHALLOW);
    }

    public void fileDeleted(FileEvent fileEvent) {
        this.refreshChildren(RefreshMode.SHALLOW);
    }

    public void fileFolderCreated(FileEvent fileEvent) {
        this.refreshChildren(RefreshMode.SHALLOW);
    }

    public void fileRenamed(FileRenameEvent fileRenameEvent) {
        this.refreshChildren(RefreshMode.SHALLOW);
    }

    private final class DelayedLkp
    extends AbstractLookup {
        DelayedNode node;
        final InstanceContent ic;

        public DelayedLkp(InstanceContent instanceContent) {
            super((AbstractLookup.Content)instanceContent);
            this.ic = instanceContent;
        }

        protected void beforeLookup(Lookup.Template<?> template) {
            DataObject dataObject;
            Class clazz = template.getType();
            if (DataObject.class.isAssignableFrom(clazz) && (dataObject = this.convert(this.node)) != null) {
                this.ic.add((Object)dataObject);
            }
        }

        public DataObject convert(DelayedNode delayedNode) {
            FolderChildrenPair folderChildrenPair = delayedNode.pair;
            if (EventQueue.isDispatchThread()) {
                FolderChildren.this.err.log(Level.WARNING, "Attempt to obtain DataObject for {0} from EDT", folderChildrenPair.primaryFile);
                boolean bl = false;
                if (!$assertionsDisabled) {
                    bl = true;
                    if (!true) {
                        throw new AssertionError();
                    }
                }
                if (bl) {
                    FolderChildren.this.err.log(Level.INFO, "Ineffective since #199391 was implemented", new Exception("Find for " + folderChildrenPair.primaryFile));
                }
            }
            try {
                return DataObject.find(folderChildrenPair.primaryFile);
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                FolderChildren.this.err.log(Level.INFO, "Cannot convert " + folderChildrenPair.primaryFile, dataObjectNotFoundException);
                return null;
            }
        }
    }

    private final class DelayedNode
    extends FilterNode
    implements Runnable {
        final FolderChildrenPair pair;
        private RequestProcessor.Task task;

        public DelayedNode(FolderChildrenPair folderChildrenPair) {
            this(folderChildrenPair, folderChildren.new DelayedLkp(new InstanceContent()));
        }

        private DelayedNode(FolderChildrenPair folderChildrenPair, DelayedLkp delayedLkp) {
            this(folderChildrenPair, new AbstractNode(FilterNode.Children.LEAF, (Lookup)delayedLkp));
            delayedLkp.ic.add((Object)folderChildrenPair.primaryFile);
            delayedLkp.node = this;
        }

        private DelayedNode(FolderChildrenPair folderChildrenPair, AbstractNode abstractNode) {
            super((Node)abstractNode);
            this.pair = folderChildrenPair;
            abstractNode.setName(folderChildrenPair.primaryFile.getNameExt());
            abstractNode.setIconBaseWithExtension("org/openide/loaders/unknown.gif");
            this.scheduleRefresh("constructor");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Node node = FolderChildren.this.createNode(this.pair);
            if (node != null) {
                this.changeOriginal(node, !node.isLeaf());
            } else {
                FolderChildren.this.refreshKey(this.pair);
            }
            DelayedNode delayedNode = this;
            synchronized (delayedNode) {
                this.task = null;
            }
            FolderChildren.this.err.log(Level.FINE, "delayed node refreshed {0} original: {1}", new Object[]{this, node});
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final boolean waitFinished() {
            RequestProcessor.Task task;
            DelayedNode delayedNode = this;
            synchronized (delayedNode) {
                task = this.task;
                if (task == null) {
                    return false;
                }
            }
            FolderChildren.this.err.log(Level.FINE, "original before wait: {0}", this.getOriginal());
            task.waitFinished();
            FolderChildren.this.err.log(Level.FINE, "original after wait: {0}", this.getOriginal());
            FolderChildren.this.err.log(Level.FINE, "task after waitFinished {0}", this.task);
            return true;
        }

        final synchronized void scheduleRefresh(String string) {
            this.task = DataNodeUtils.reqProcessor(this.pair.primaryFile).post((Runnable)this);
            FolderChildren.this.err.log(Level.FINE, "Task initialized by {0} to {1} for {2}", new Object[]{string, this.task, this});
        }
    }

    private static enum RefreshMode {
        SHALLOW,
        SHALLOW_IMMEDIATE,
        DEEP,
        DEEP_LATER,
        CLEAR;

    }
}

