/*
 * Decompiled with CFR 0.152.
 */
package net.sf.juife.plaf.basic;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.plaf.ComponentUI;
import net.sf.juife.NavigationHistoryModel;
import net.sf.juife.NavigationPage;
import net.sf.juife.NavigationPane;
import net.sf.juife.plaf.NavigationPaneUI;

public class BasicNavigationPaneUI
extends NavigationPaneUI {
    private static final String propertyPrefix = "NavigationPane.";
    private static Icon iconBack = null;
    private static Icon iconForward = null;
    private static Icon iconDown = null;
    private JLabel lTitle = new JLabel();
    private JPanel tiltePane;
    private JButton btnBack;
    private JButton btnForward;
    private JButton btnMenu = new JButton();
    private JPopupMenu npMenu = new JPopupMenu();
    private LayoutManager oldLayoutManager;
    private NavigationPane navigationPane = null;
    private NavigationPage currentPage = null;
    private final Handler handler = new Handler();

    private BasicNavigationPaneUI() {
    }

    protected String getPropertyPrefix() {
        return propertyPrefix;
    }

    public static ComponentUI createUI(JComponent c) {
        return new BasicNavigationPaneUI();
    }

    @Override
    public void installUI(JComponent c) {
        this.navigationPane = (NavigationPane)c;
        this.installDefaults();
        this.installListeners();
    }

    protected void installDefaults() {
        URL url;
        String s;
        if (this.getBackIcon() == null) {
            s = "net/sf/juife/icons/navigation/Back16.gif";
            url = ClassLoader.getSystemClassLoader().getResource(s);
            this.setBackIcon(new ImageIcon(url));
        }
        if (this.getForwardIcon() == null) {
            s = "net/sf/juife/icons/navigation/Forward16.gif";
            url = ClassLoader.getSystemClassLoader().getResource(s);
            this.setForwardIcon(new ImageIcon(url));
        }
        if (this.getDownIcon() == null) {
            s = "net/sf/juife/icons/navigation/Down16.gif";
            url = ClassLoader.getSystemClassLoader().getResource(s);
            this.setDownIcon(new ImageIcon(url));
        }
        this.oldLayoutManager = this.navigationPane.getLayout();
        this.navigationPane.setLayout(new BorderLayout());
        this.btnBack = new JButton(this.getBackIcon());
        this.btnForward = new JButton(this.getForwardIcon());
        this.btnMenu = new JButton(this.getDownIcon());
        this.npMenu = new JPopupMenu();
        this.initMenu();
        this.tiltePane = new JPanel();
        this.tiltePane.setLayout(new BorderLayout());
        Color bgc = new Color(0xCCCCCC);
        this.navigationPane.setTitleBackground(bgc);
        this.setTitleBackground(bgc);
        this.initTitlePane();
        this.navigationPane.add((Component)this.tiltePane, "North");
        this.lTitle.setOpaque(false);
    }

    protected void installListeners() {
        this.btnBack.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!BasicNavigationPaneUI.this.navigationPane.getModel().hasBack()) {
                    String s = "BasicNavigationPaneUI: The begining of the history list reached unexpectedly";
                    Logger.getLogger("net.sf.juife").info(s);
                    return;
                }
                if ((e.getModifiers() & 2) == 2) {
                    BasicNavigationPaneUI.this.navigationPane.getModel().goFirst();
                } else {
                    BasicNavigationPaneUI.this.navigationPane.getModel().goBack();
                }
            }
        });
        this.btnForward.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!BasicNavigationPaneUI.this.navigationPane.getModel().hasForward()) {
                    String s = "BasicNavigationPaneUI: The end of the history list reached unexpectedly";
                    Logger.getLogger("net.sf.juife").info(s);
                }
                if ((e.getModifiers() & 2) == 2) {
                    BasicNavigationPaneUI.this.navigationPane.getModel().goLast();
                } else {
                    BasicNavigationPaneUI.this.navigationPane.getModel().goForward();
                }
            }
        });
        this.navigationPane.addPropertyChangeListener(this.getHandler());
    }

    private void initTitlePane() {
        this.btnMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int x = (int)BasicNavigationPaneUI.this.btnMenu.getMinimumSize().getWidth();
                int y = (int)BasicNavigationPaneUI.this.btnMenu.getMinimumSize().getHeight() + 1;
                BasicNavigationPaneUI.this.npMenu.show(BasicNavigationPaneUI.this.btnMenu, x -= (int)BasicNavigationPaneUI.this.npMenu.getPreferredSize().getWidth(), y);
            }
        });
        this.initButton(this.btnMenu);
        this.initButton(this.btnBack);
        this.initButton(this.btnForward);
        this.btnBack.setEnabled(false);
        this.btnForward.setEnabled(false);
        JPanel p = new JPanel();
        p.setLayout(new BorderLayout());
        p.add((Component)this.btnBack, "West");
        p.add((Component)this.btnForward, "East");
        p.setOpaque(false);
        this.tiltePane.add((Component)p, "West");
        this.lTitle.setHorizontalAlignment(0);
        this.tiltePane.add((Component)this.lTitle, "Center");
        this.btnMenu.setAlignmentX(1.0f);
        this.tiltePane.add((Component)this.btnMenu, "East");
        this.tiltePane.setBorder(BorderFactory.createEmptyBorder(1, 3, 1, 3));
    }

    private void initMenu() {
        this.npMenu.removeAll();
        if (this.navigationPane.getPages() == null) {
            return;
        }
        for (NavigationPage page : this.navigationPane.getPages()) {
            this.initMenuItem(page);
        }
    }

    private void initMenuItem(final NavigationPage page) {
        JMenuItem mi = new JMenuItem(page.getTitle());
        this.npMenu.add(mi);
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BasicNavigationPaneUI.this.navigationPane.getModel().addPage(page);
            }
        });
    }

    private void initButton(final JButton button) {
        button.setBorder(BorderFactory.createEtchedBorder(1));
        button.setBorderPainted(false);
        button.setContentAreaFilled(false);
        button.setFocusPainted(false);
        button.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                if (button.isEnabled()) {
                    button.setBorderPainted(true);
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                button.setBorderPainted(false);
            }
        });
    }

    private void setTitleBackground(Color c) {
        this.tiltePane.setBackground(c);
        this.btnBack.setBackground(c);
        this.btnForward.setBackground(c);
        this.btnMenu.setBackground(c);
    }

    @Override
    public void setTitlebarVisiblie(boolean b) {
        this.tiltePane.setVisible(b);
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.uninstallListeners();
        this.uninstallDefaults();
    }

    protected void uninstallDefaults() {
        this.navigationPane.remove(this.tiltePane);
        this.navigationPane.setLayout(this.oldLayoutManager);
        this.oldLayoutManager = null;
        this.navigationPane = null;
        this.tiltePane = null;
        this.btnMenu = null;
        this.btnBack = null;
        this.btnForward = null;
        this.npMenu = null;
    }

    protected void uninstallListeners() {
        this.navigationPane.removePropertyChangeListener(this.getHandler());
        this.navigationPane.getModel().removeActionListener(this.getHandler());
    }

    private Handler getHandler() {
        return this.handler;
    }

    protected Icon getBackIcon() {
        return iconBack;
    }

    protected void setBackIcon(Icon icon) {
        iconBack = icon;
    }

    protected Icon getForwardIcon() {
        return iconForward;
    }

    protected void setForwardIcon(Icon icon) {
        iconForward = icon;
    }

    protected Icon getDownIcon() {
        return iconDown;
    }

    protected void setDownIcon(Icon icon) {
        iconDown = icon;
    }

    private class Handler
    implements ActionListener,
    PropertyChangeListener {
        private Handler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            NavigationPage p = BasicNavigationPaneUI.this.navigationPane.getCurrentPage();
            if (BasicNavigationPaneUI.this.currentPage != null) {
                BasicNavigationPaneUI.this.navigationPane.remove(BasicNavigationPaneUI.this.currentPage);
            }
            BasicNavigationPaneUI.this.currentPage = p;
            if (BasicNavigationPaneUI.this.currentPage == null) {
                return;
            }
            BasicNavigationPaneUI.this.navigationPane.add((Component)BasicNavigationPaneUI.this.currentPage, "Center");
            if (!BasicNavigationPaneUI.this.navigationPane.getModel().hasBack()) {
                BasicNavigationPaneUI.this.btnBack.setBorderPainted(false);
            }
            BasicNavigationPaneUI.this.btnBack.setEnabled(BasicNavigationPaneUI.this.navigationPane.getModel().hasBack());
            if (!BasicNavigationPaneUI.this.navigationPane.getModel().hasForward()) {
                BasicNavigationPaneUI.this.btnForward.setBorderPainted(false);
            }
            BasicNavigationPaneUI.this.btnForward.setEnabled(BasicNavigationPaneUI.this.navigationPane.getModel().hasForward());
            BasicNavigationPaneUI.this.lTitle.setText(BasicNavigationPaneUI.this.currentPage.getTitle());
            BasicNavigationPaneUI.this.navigationPane.revalidate();
            BasicNavigationPaneUI.this.navigationPane.repaint();
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String pn = e.getPropertyName();
            if (pn == "model") {
                NavigationHistoryModel oldModel = (NavigationHistoryModel)e.getOldValue();
                NavigationHistoryModel newModel = (NavigationHistoryModel)e.getNewValue();
                if (oldModel != null) {
                    oldModel.removeActionListener(BasicNavigationPaneUI.this.getHandler());
                }
                if (newModel != null) {
                    newModel.addActionListener(BasicNavigationPaneUI.this.getHandler());
                }
            } else if (pn == "pages") {
                BasicNavigationPaneUI.this.initMenu();
            } else if (pn == "titleBackground") {
                BasicNavigationPaneUI.this.setTitleBackground((Color)e.getNewValue());
            }
        }
    }
}

