/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler.view.std;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.sf.juife.OkCancelDialog;
import org.jsampler.CC;
import org.jsampler.view.DbDirectoryTreeNode;
import org.jsampler.view.InstrumentsDbTreeModel;
import org.jsampler.view.std.JSInstrumentsDbColumnPreferencesDlg;
import org.jsampler.view.std.JSInstrumentsDbTable;
import org.jsampler.view.std.JSInstrumentsDbTree;
import org.jsampler.view.std.StdI18n;
import org.linuxsampler.lscp.DbInstrumentInfo;
import org.linuxsampler.lscp.Parser;

public class JSDbInstrumentChooser
extends OkCancelDialog
implements ListSelectionListener {
    protected JSInstrumentsDbTree instrumentsDbTree = this.createInstrumentsDbTree(CC.getInstrumentsDbTreeModel());
    protected JSInstrumentsDbTable instrumentsDbTable = new JSInstrumentsDbTable(this.instrumentsDbTree, "DbInstrumentChooser.");
    protected final ToolBar toolBar = new ToolBar();

    public JSDbInstrumentChooser(Frame frame) {
        super(frame, StdI18n.i18n.getLabel("JSDbInstrumentChooser.title"));
        this.initDbInstrumentChooser();
    }

    public JSDbInstrumentChooser(Dialog dialog) {
        super(dialog, StdI18n.i18n.getLabel("JSDbInstrumentChooser.title"));
        this.initDbInstrumentChooser();
    }

    private void initDbInstrumentChooser() {
        this.btnOk.setEnabled(false);
        JScrollPane jScrollPane = new JScrollPane(this.instrumentsDbTree);
        this.instrumentsDbTable.setSelectionMode(0);
        this.instrumentsDbTable.getSelectionModel().addListSelectionListener(this);
        JScrollPane jScrollPane2 = new JScrollPane(this.instrumentsDbTable);
        JSplitPane jSplitPane = new JSplitPane(1, true, jScrollPane, jScrollPane2);
        jSplitPane.setDividerSize(3);
        jSplitPane.setDividerLocation(200);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)new ToolBar(), "North");
        jPanel.add(jSplitPane);
        this.setMainPane(jPanel);
        this.instrumentsDbTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() != 1 || mouseEvent.getClickCount() < 2) {
                    return;
                }
                DbInstrumentInfo[] dbInstrumentInfoArray = JSDbInstrumentChooser.this.instrumentsDbTable.getSelectedInstruments();
                if (dbInstrumentInfoArray.length == 0) {
                    return;
                }
                JSDbInstrumentChooser.this.onOk();
            }
        });
        this.installKeyboardListeners();
        this.setMinimumSize(this.getPreferredSize());
        this.setResizable(true);
    }

    private void installKeyboardListeners() {
        this.getRootPane().getInputMap(1).put(KeyStroke.getKeyStroke(8, 0), "goUp");
        this.getRootPane().getActionMap().put("goUp", this.instrumentsDbTree.actionGoUp);
        this.instrumentsDbTable.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "Select");
        this.instrumentsDbTable.getActionMap().put("Select", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DbDirectoryTreeNode dbDirectoryTreeNode = JSDbInstrumentChooser.this.instrumentsDbTable.getSelectedDirectoryNode();
                if (dbDirectoryTreeNode != null) {
                    JSDbInstrumentChooser.this.instrumentsDbTree.setSelectedDirectoryNode(dbDirectoryTreeNode);
                    return;
                }
                if (JSDbInstrumentChooser.this.instrumentsDbTable.getSelectedInstruments().length > 0) {
                    JSDbInstrumentChooser.this.onOk();
                }
            }
        });
    }

    protected JSInstrumentsDbTree createInstrumentsDbTree(InstrumentsDbTreeModel instrumentsDbTreeModel) {
        return new JSInstrumentsDbTree(instrumentsDbTreeModel);
    }

    public String getSelectedInstrument() {
        DbInstrumentInfo[] dbInstrumentInfoArray = this.instrumentsDbTable.getSelectedInstruments();
        if (dbInstrumentInfoArray.length == 0) {
            return null;
        }
        return dbInstrumentInfoArray[0].getInstrumentPath();
    }

    public void setSelectedInstrument(String string) {
        String string2 = Parser.getParentDirectory(string);
        if (string2 == null) {
            return;
        }
        this.instrumentsDbTree.setSelectedDirectory(string2);
        if (this.instrumentsDbTable.getParentDirectoryNode() == null) {
            return;
        }
        string = string.substring(string2.length() + 1, string.length());
        this.instrumentsDbTable.setSelectedInstrument(string);
    }

    public void setSelectedDirectory(String string) {
        this.instrumentsDbTree.setSelectedDirectory(string);
    }

    @Override
    protected void onOk() {
        if (!this.btnOk.isEnabled()) {
            return;
        }
        this.instrumentsDbTable.saveColumnsVisibleState();
        this.instrumentsDbTable.saveColumnWidths();
        this.setCancelled(false);
        this.setVisible(false);
    }

    @Override
    protected void onCancel() {
        this.setVisible(false);
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        boolean bl = this.instrumentsDbTable.getSelectedInstruments().length > 0;
        this.btnOk.setEnabled(bl);
    }

    protected JButton createToolbarButton(Action action) {
        return new JButton(action);
    }

    class PreferencesDlg
    extends JSInstrumentsDbColumnPreferencesDlg {
        PreferencesDlg() {
            super((Dialog)JSDbInstrumentChooser.this, JSDbInstrumentChooser.this.instrumentsDbTable);
        }
    }

    class ToolBar
    extends JToolBar {
        protected final JButton btnGoUp;
        protected final JButton btnGoBack;
        protected final JButton btnGoForward;
        protected final JButton btnReload;
        protected final JButton btnPreferences;

        public ToolBar() {
            super("");
            this.btnGoUp = JSDbInstrumentChooser.this.createToolbarButton(JSDbInstrumentChooser.this.instrumentsDbTree.actionGoUp);
            this.btnGoBack = JSDbInstrumentChooser.this.createToolbarButton(JSDbInstrumentChooser.this.instrumentsDbTree.actionGoBack);
            this.btnGoForward = JSDbInstrumentChooser.this.createToolbarButton(JSDbInstrumentChooser.this.instrumentsDbTree.actionGoForward);
            this.btnReload = JSDbInstrumentChooser.this.createToolbarButton(JSDbInstrumentChooser.this.instrumentsDbTable.reloadAction);
            this.btnPreferences = JSDbInstrumentChooser.this.createToolbarButton(null);
            this.setFloatable(false);
            this.add(this.btnGoBack);
            this.add(this.btnGoForward);
            this.add(this.btnGoUp);
            Icon icon = CC.getViewConfig().getBasicIconSet().getReload16Icon();
            JSDbInstrumentChooser.this.instrumentsDbTable.reloadAction.putValue("SmallIcon", icon);
            this.add(this.btnReload);
            this.addSeparator();
            icon = CC.getViewConfig().getBasicIconSet().getPreferences16Icon();
            this.btnPreferences.setIcon(icon);
            this.add(this.btnPreferences);
            this.btnPreferences.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    new PreferencesDlg().setVisible(true);
                }
            });
        }
    }
}

