/*
 * Decompiled with CFR 0.152.
 */
package org.linuxsampler.lscp;

import org.linuxsampler.lscp.AbstractParameter;
import org.linuxsampler.lscp.LscpException;
import org.linuxsampler.lscp.LscpI18n;
import org.linuxsampler.lscp.ParameterType;
import org.linuxsampler.lscp.Parser;

public class IntListParameter
extends AbstractParameter<Integer[]> {
    public IntListParameter() {
        this.setType(ParameterType.INT_LIST);
        this.setMultiplicity(true);
    }

    public IntListParameter(String string) {
        this(string, null);
    }

    public IntListParameter(String string, Integer[] integerArray) {
        this();
        this.setName(string);
        this.setValue(integerArray);
    }

    public IntListParameter(String[] stringArray) throws LscpException {
        this();
        this.parseLines(stringArray);
    }

    @Override
    public boolean parse(String string) throws LscpException {
        if (super.parse(string)) {
            return true;
        }
        if (string.startsWith("RANGE_MIN: ")) {
            string = string.substring("RANGE_MIN: ".length(), string.length());
            try {
                this.setRangeMin(Integer.parseInt(string));
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                throw new LscpException(LscpI18n.getLogMsg("notInt!", "RANGE_MIN"), numberFormatException);
            }
        }
        if (string.startsWith("RANGE_MAX: ")) {
            string = string.substring("RANGE_MAX: ".length(), string.length());
            try {
                this.setRangeMax(Integer.parseInt(string));
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                throw new LscpException(LscpI18n.getLogMsg("notInt!", "RANGE_MAX"), numberFormatException);
            }
        }
        if (string.startsWith("DEFAULT: ")) {
            string = string.substring("DEFAULT: ".length(), string.length());
            try {
                this.setDefault(Parser.parseIntList(string));
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                throw new LscpException(LscpI18n.getLogMsg("notInt!", "DEFAULT"), numberFormatException);
            }
        }
        if (string.startsWith("POSSIBILITIES: ")) {
            string = string.substring("POSSIBILITIES: ".length(), string.length());
            String[] stringArray = Parser.parseStringList(string);
            Integer[][] integerArrayArray = new Integer[stringArray.length][];
            for (int i = 0; i < stringArray.length; ++i) {
                integerArrayArray[i] = Parser.parseIntList(stringArray[i]);
            }
            this.setPossibilities((T[])integerArrayArray);
            return true;
        }
        return false;
    }

    @Override
    public void parseValue(String string) throws LscpException {
        this.setValue(Parser.parseIntList(string));
    }

    @Override
    public String getStringValue() {
        Integer[] integerArray = (Integer[])this.getValue();
        if (integerArray == null || integerArray.length == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(integerArray[0]);
        for (int i = 1; i < integerArray.length; ++i) {
            stringBuffer.append(',').append(integerArray[i]);
        }
        return stringBuffer.toString();
    }
}

