/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.manchestersyntax.renderer;

import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.formats.PrefixDocumentFormat;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.util.DefaultPrefixManager;
import org.semanticweb.owlapi.util.ShortFormProvider;

public class ManchesterOWLSyntaxPrefixNameShortFormProvider
implements ShortFormProvider {
    private final DefaultPrefixManager prefixManager;

    public ManchesterOWLSyntaxPrefixNameShortFormProvider(@Nonnull OWLOntology ont) {
        this(ont.getOWLOntologyManager().getOntologyFormat(ont));
    }

    public ManchesterOWLSyntaxPrefixNameShortFormProvider(OWLDocumentFormat format) {
        this.prefixManager = new DefaultPrefixManager();
        if (format instanceof PrefixDocumentFormat) {
            PrefixDocumentFormat ontFormat = (PrefixDocumentFormat)format;
            this.prefixManager.copyPrefixesFrom(ontFormat);
            this.prefixManager.setPrefixComparator(ontFormat.getPrefixComparator());
        }
    }

    public ManchesterOWLSyntaxPrefixNameShortFormProvider(DefaultPrefixManager prefixManager) {
        this.prefixManager = prefixManager;
    }

    public Map<String, String> getPrefixName2PrefixMap() {
        return this.prefixManager.getPrefixName2PrefixMap();
    }

    @Override
    public String getShortForm(OWLEntity entity) {
        IRI iri = entity.getIRI();
        String sf = this.prefixManager.getPrefixIRIIgnoreQName(iri);
        if (sf == null || Objects.equals(iri.toString(), sf)) {
            sf = iri.toQuotedString();
        }
        if (sf.startsWith(":")) {
            return sf.substring(1);
        }
        return sf;
    }

    public static String getShortForm(@Nonnull IRI iri) {
        return iri.toQuotedString();
    }

    @Override
    public void dispose() {
        this.prefixManager.dispose();
    }
}

