/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.hierarchy.tabbed;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.protege.editor.owl.model.entity.OWLEntityCreationException;
import org.protege.editor.owl.model.entity.OWLEntityCreationSet;
import org.protege.editor.owl.model.entity.OWLEntityFactory;
import org.protege.editor.owl.model.find.OWLEntityFinder;
import org.semanticweb.owlapi.model.EntityType;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLOntologyChange;

public class HierarchyNodeCreator<E extends OWLEntity> {
    private final E rootEntity;
    private final EntityType<E> entityType;
    private final OWLEntityFinder entityFinder;
    private final OWLEntityFactory entityFactory;
    private final Map<String, OWLEntity> entityName2EntityMap = new HashMap<String, OWLEntity>();

    public HierarchyNodeCreator(@Nonnull E rootEntity, @Nonnull EntityType<E> entityType, @Nonnull OWLEntityFinder entityFinder, @Nonnull OWLEntityFactory entityFactory) {
        this.rootEntity = (OWLEntity)Preconditions.checkNotNull(rootEntity);
        this.entityType = (EntityType)Preconditions.checkNotNull(entityType);
        this.entityFinder = (OWLEntityFinder)Preconditions.checkNotNull((Object)entityFinder);
        this.entityFactory = (OWLEntityFactory)Preconditions.checkNotNull((Object)entityFactory);
    }

    @Nonnull
    public E createEntity(@Nonnull Optional<String> entityName, @Nonnull List<OWLOntologyChange> changes) {
        return (E)entityName.map(name -> {
            Optional<E> existingEntity = this.entityFinder.getOWLEntity(this.entityType, (String)name);
            return existingEntity.orElseGet(() -> {
                OWLEntity mappedEntity = this.entityName2EntityMap.get(name);
                if (mappedEntity != null) {
                    return mappedEntity;
                }
                OWLEntityCreationSet<E> creationSet = this.createEntity((String)name);
                changes.addAll(creationSet.getOntologyChanges());
                E freshEntity = creationSet.getOWLEntity();
                this.entityName2EntityMap.put((String)name, (OWLEntity)freshEntity);
                return freshEntity;
            });
        }).orElse((OWLEntity)this.rootEntity);
    }

    private OWLEntityCreationSet<E> createEntity(@Nonnull String name) {
        try {
            return this.entityFactory.createOWLEntity(this.entityType, name, Optional.empty());
        }
        catch (OWLEntityCreationException e) {
            throw new RuntimeException((Throwable)((Object)e));
        }
    }
}

