/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.io;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.protege.editor.core.Disposable;
import org.protege.editor.core.log.LogBanner;
import org.protege.editor.owl.model.OWLModelManager;
import org.protege.editor.owl.model.io.IOListener;
import org.protege.editor.owl.model.io.IOListenerEvent;
import org.protege.editor.owl.model.io.OntologySourcesListener;
import org.semanticweb.owlapi.model.OWLOntology;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OntologySourcesManager
extends IOListener
implements Disposable {
    public static final String ID = OntologySourcesManager.class.getName();
    private static final Logger logger = LoggerFactory.getLogger(OntologySourcesManager.class);
    private final Map<URI, Long> timestamps = new HashMap<URI, Long>();
    private final OWLModelManager modelManager;
    private final List<OntologySourcesListener> listeners = new ArrayList<OntologySourcesListener>();

    public OntologySourcesManager(OWLModelManager modelManager) {
        this.modelManager = modelManager;
        modelManager.addIOListener(this);
    }

    public void markSources() {
        for (OWLOntology ontology : this.modelManager.getOntologies()) {
            this.update(ontology.getOWLOntologyManager().getOntologyDocumentIRI(ontology).toURI());
        }
    }

    public void checkSources() {
        Set<OWLOntology> changedOntologies = this.getChangedOntologies();
        if (!changedOntologies.isEmpty()) {
            OntologySourcesListener.OntologySourcesChangeEvent event = new OntologySourcesListener.OntologySourcesChangeEvent(this.getChangedOntologies());
            for (OntologySourcesListener l : this.listeners) {
                l.ontologySourcesChanged(event);
            }
        }
    }

    private Set<OWLOntology> getChangedOntologies() {
        logger.debug(LogBanner.start((String)"Ontology Sources Manager"));
        HashSet<OWLOntology> changedOntologies = new HashSet<OWLOntology>();
        for (OWLOntology ont : this.modelManager.getOntologies()) {
            URI uri = this.modelManager.getOntologyPhysicalURI(ont);
            logger.debug("Checking to see if ontology document has changed.");
            logger.debug("    Ontology: {}", (Object)ont.getOntologyID());
            logger.debug("    Document: {}", (Object)uri);
            Optional<Long> externalTimestamp = this.getTimestampOfUri(uri);
            Optional<Long> internalTimestamp = this.getInternalTimestamp(uri);
            logger.debug("    Last modified in Protege: {}", (Object)internalTimestamp.orElse(0L));
            logger.debug("    Last modified externally: {}", (Object)externalTimestamp.orElse(0L));
            if (externalTimestamp.isPresent() && internalTimestamp.isPresent() && externalTimestamp.get() > internalTimestamp.get()) {
                logger.debug("    Ontology document has changed externally");
                changedOntologies.add(ont);
                continue;
            }
            logger.debug("    Ontology document has not changed externally");
        }
        logger.debug(LogBanner.end());
        return changedOntologies;
    }

    private Optional<Long> getInternalTimestamp(URI documentURI) {
        Long cachedValue = this.timestamps.get(documentURI);
        if (cachedValue == null) {
            return Optional.empty();
        }
        return Optional.of(cachedValue);
    }

    private void update(URI documentUri) {
        Optional<Long> timestamp = this.getTimestampOfUri(documentUri);
        if (timestamp.isPresent()) {
            this.timestamps.put(documentUri, timestamp.get());
        }
    }

    private Optional<Long> getTimestampOfUri(URI uri) {
        if (!"file".equals(uri.getScheme())) {
            return Optional.empty();
        }
        File file = new File(uri);
        long value = file.lastModified();
        if (value == 0L) {
            return Optional.empty();
        }
        return Optional.of(value);
    }

    @Override
    public void beforeSave(IOListenerEvent event) {
    }

    @Override
    public void afterSave(IOListenerEvent event) {
        URI uri = event.getPhysicalURI();
        this.update(uri);
    }

    @Override
    public void beforeLoad(IOListenerEvent event) {
    }

    @Override
    public void afterLoad(IOListenerEvent event) {
        URI uri = event.getPhysicalURI();
        this.update(uri);
    }

    public void dispose() {
        this.timestamps.clear();
    }

    public void addListener(OntologySourcesListener l) {
        this.listeners.add(l);
    }

    public void removeListener(OntologySourcesListener l) {
        this.listeners.remove(l);
    }

    public void ignoreUpdates(Set<OWLOntology> onts) {
        for (OWLOntology ont : onts) {
            URI uri = this.modelManager.getOntologyPhysicalURI(ont);
            Optional<Long> timestamp = this.getTimestampOfUri(uri);
            if (!timestamp.isPresent()) continue;
            this.timestamps.put(uri, timestamp.get());
        }
    }
}

