/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.action;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import org.protege.editor.core.ProtegeManager;
import org.protege.editor.core.ui.workspace.WorkspaceFrame;
import org.protege.editor.owl.ui.action.ProtegeOWLAction;

public abstract class ComponentHierarchyAction<T>
extends ProtegeOWLAction {
    private Class<T> targetClass;

    public final void actionPerformed(ActionEvent e) {
        WorkspaceFrame frame = ProtegeManager.getInstance().getFrame(this.getWorkspace());
        for (Component c : frame.getComponents()) {
            this.processComponent(e, c, this.targetClass);
        }
    }

    protected abstract void actionPerformedOnTarget(ActionEvent var1, T var2);

    public final void initialise() throws Exception {
        this.targetClass = this.initialiseAction();
    }

    protected abstract Class<T> initialiseAction();

    public void dispose() throws Exception {
    }

    private void processComponent(ActionEvent e, Component c, Class<T> cls) {
        if (cls.isInstance(c)) {
            T target = cls.cast(c);
            this.actionPerformedOnTarget(e, target);
        }
        if (c instanceof Container) {
            for (Component childComponent : ((Container)c).getComponents()) {
                this.processComponent(e, childComponent, cls);
            }
        }
    }
}

