/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.action;

import java.awt.Component;
import java.awt.TextComponent;
import java.beans.PropertyChangeListener;
import javax.swing.FocusManager;
import javax.swing.JRootPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import org.protege.editor.owl.ui.action.ActionTarget;
import org.protege.editor.owl.ui.action.ProtegeOWLAction;

public abstract class FocusedComponentAction<C extends ActionTarget>
extends ProtegeOWLAction {
    private Class<C> targetClass;
    private C currentTarget;
    private PropertyChangeListener listener;
    private ChangeListener changeListener;

    public final void initialise() throws Exception {
        this.listener = evt -> {
            if (evt.getPropertyName().equals("focusOwner")) {
                this.update();
            }
        };
        FocusManager.getCurrentManager().addPropertyChangeListener(this.listener);
        this.changeListener = e -> this.update();
        this.targetClass = this.initialiseAction();
        this.update();
    }

    protected abstract Class<C> initialiseAction();

    protected void targetChanged() {
    }

    private void update() {
        Component c = FocusManager.getCurrentManager().getFocusOwner();
        if (c instanceof JRootPane || c == null) {
            return;
        }
        if (c instanceof TextComponent) {
            this.setEnabled(true);
            return;
        }
        if (c instanceof JTable) {
            this.setEnabled(true);
            return;
        }
        C target = this.getTarget();
        if (this.currentTarget != null) {
            this.detatchListener();
        }
        this.currentTarget = target;
        if (this.currentTarget != null) {
            this.attatchListeners();
        }
        this.setEnabled(this.currentTarget != null && this.canPerform());
        this.targetChanged();
    }

    protected abstract boolean canPerform();

    public C getCurrentTarget() {
        return this.currentTarget;
    }

    private C getTarget() {
        Component c = FocusManager.getCurrentManager().getFocusOwner();
        if (this.targetClass.isInstance(c)) {
            return (C)((ActionTarget)((Object)c));
        }
        return (C)((ActionTarget)((Object)SwingUtilities.getAncestorOfClass(this.targetClass, c)));
    }

    private void attatchListeners() {
        this.currentTarget.addChangeListener(this.changeListener);
    }

    private void detatchListener() {
        this.currentTarget.removeChangeListener(this.changeListener);
    }

    public void dispose() {
        FocusManager.getCurrentManager().removePropertyChangeListener(this.listener);
    }
}

