/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.renderer.styledstring;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.Shape;
import javax.swing.Icon;
import javax.swing.JPanel;
import org.protege.editor.owl.ui.renderer.styledstring.StyledString;

public class StyledStringPanel
extends JPanel {
    public static final int DEFAULT_ICON_PADDING = 2;
    private StyledString styledString = new StyledString();
    private Icon icon = null;

    public StyledStringPanel() {
        this.setOpaque(true);
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
    }

    public StyledStringPanel(StyledString styledString) {
        this.setOpaque(true);
        this.styledString = styledString;
    }

    public void setStyledString(StyledString styledString) {
        this.setOpaque(true);
        this.styledString = styledString;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Insets insets = this.getInsets();
        if (insets != null) {
            g.translate(insets.left, insets.top);
        }
        g2.setFont(this.getFont());
        Shape clip = g2.getClip();
        g2.setColor(this.getBackground());
        g2.fill(clip);
        if (this.icon != null) {
            this.icon.paintIcon(this, g2, 0, 0);
            g.translate(this.icon.getIconWidth() + 2, 0);
        }
        g2.setColor(this.getForeground());
        this.styledString.draw(g2, 0.0f, 0.0f);
        if (this.icon != null) {
            g.translate(-this.icon.getIconWidth() - 2, 0);
        }
        if (insets != null) {
            g.translate(-insets.left, -insets.top);
        }
    }
}

