#!/usr/bin/env perl
#
# BEGIN COPYRIGHT BLOCK
# Copyright (C) 2001 Sun Microsystems, Inc. Used by permission.
# Copyright (C) 2013 Red Hat, Inc.
# All rights reserved.
#
# License: GPL (version 3 or any later version).
# See LICENSE for details. 
# END COPYRIGHT BLOCK
#

use lib qw(/usr/lib/dirsrv/perl);
use DSUtil;

DSUtil::libpath_add("");
DSUtil::libpath_add("/usr/lib");
DSUtil::libpath_add("/usr/lib64");
$ENV{'PATH'} = ":/usr/bin";
$ENV{'SHLIB_PATH'} = "$ENV{'LD_LIBRARY_PATH'}";

$i = 0;

sub usage {
    print(STDERR "Usage: syntax-validate.pl [-Z serverID] [-D rootdn] { -w password | -w - | -j filename }\n");
    print(STDERR "                          [-P protocol] -b baseDN [-f filter] [-h]\n");
    print(STDERR "Options:\n");
    print(STDERR "        -D rootdn    - Directory Manager\n");
    print(STDERR "        -w password  - Directory Manager's password\n");
    print(STDERR "        -w -         - Prompt for Directory Manager's password\n");
    print(STDERR "        -Z serverID  - Server instance identifier\n");
    print(STDERR "        -j filename  - Read Directory Manager's password from file\n");
    print(STDERR "        -b baseDN    - Base DN that contains entries to validate\n");
    print(STDERR "        -f filter    - Filter for entries to validate\n");
    print(STDERR "                       If omitted, all entries under the specified\n");
    print(STDERR "                       base will have their attribute values validated.\n");
    print(STDERR "        -P protocol  - STARTTLS, LDAPS, LDAPI, LDAP (default: uses most secure protocol available)\n");
    print(STDERR "        -h           - Display usage\n");
}

while ($i <= $#ARGV) 
{
    if ("$ARGV[$i]" eq "-b"){
        # base DN
        $i++; $basedn_arg = $ARGV[$i];
    } elsif ("$ARGV[$i]" eq "-f"){    
        # filter 
        $i++; $filter_arg = $ARGV[$i];
    } elsif ("$ARGV[$i]" eq "-D"){    
        # Directory Manager
        $i++; $rootdn = $ARGV[$i];
    } elsif ("$ARGV[$i]" eq "-w"){    
        # Directory Manager's password
        $i++; $passwd = $ARGV[$i];
    } elsif ("$ARGV[$i]" eq "-j"){
        # Read Directory Manager's password from a file
        $i++; $passwdfile = $ARGV[$i];
    } elsif ("$ARGV[$i]" eq "-Z"){
        # Server instance identifier
        $i++; $servid = $ARGV[$i];
    } elsif ("$ARGV[$i]" eq "-P") { 
        # protocol preference
        $i++; $protocol = $ARGV[$i];
    } elsif ("$ARGV[$i]" eq "-h"){ 
        # help
        &usage;
        exit(0);
    } else {
        print "ERROR - Unknown option: $ARGV[$i]\n";
        &usage;
        exit(1);
    }
    $i++;
}

#
# Gather all our config settings
#
($servid, $confdir) = DSUtil::get_server_id($servid, "/etc/dirsrv");
%info = DSUtil::get_info($confdir, $host, $port, $rootdn);
$info{rootdnpw} = DSUtil::get_password_from_file($passwd, $passwdfile);
$info{protocol} = $protocol;
$info{args} = "-a";
if ( $basedn_arg eq "" ){ 
    &usage; 
    exit(1); 
}

#
# Construct the task entry
#
($s, $m, $h, $dy, $mn, $yr, $wdy, $ydy, $r) = localtime(time);
$mn++; $yr += 1900;
$taskname = "syntax_validate_${yr}_${mn}_${dy}_${h}_${m}_${s}";
$dn = "dn: cn=$taskname, cn=syntax validate, cn=tasks, cn=config\n";
$misc = "objectclass: top\nobjectclass: extensibleObject\n";
$cn =  "cn: $taskname\n";
$basedn = "basedn: $basedn_arg\n";
if ( $filter_arg ne "" )
{
    $filter = "filter: $filter_arg\n";
}
$entry = "${dn}${misc}${cn}${basedn}${filter}";

$rc = DSUtil::ldapmod($entry, %info);

$dn =~ s/^dn: //;
$dn =~ s/\n//;
if($rc == 0){
    print "Successfully added task entry \"$dn\"\n";
} else {
    print "Failed to add task entry \"$dn\" error ($rc)\n";
}

exit($rc);
