/*
 * Decompiled with CFR 0.152.
 */
package org.a11y.brlapi;

import java.io.InterruptedIOException;
import org.a11y.brlapi.APIError;
import org.a11y.brlapi.APIException;
import org.a11y.brlapi.Connection;
import org.a11y.brlapi.ConnectionSettings;
import org.a11y.brlapi.ExternalException;
import org.a11y.brlapi.LostConnectionException;
import org.a11y.brlapi.Parameter;
import org.a11y.brlapi.Program;
import org.a11y.brlapi.ProgramException;
import org.a11y.brlapi.SemanticException;
import org.a11y.brlapi.SyntaxException;

public abstract class Client
extends Program {
    private final ConnectionSettings connectionSettings = new ConnectionSettings();

    protected abstract void runClient(Connection var1) throws ProgramException;

    public final Client setServerHost(String string) throws SyntaxException {
        try {
            this.connectionSettings.setServerHost(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new SyntaxException(illegalArgumentException.getMessage(), new Object[0]);
        }
        return this;
    }

    public final Client setAuthenticationScheme(String string) throws SyntaxException {
        try {
            this.connectionSettings.setAuthenticationScheme(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new SyntaxException(illegalArgumentException.getMessage(), new Object[0]);
        }
        return this;
    }

    protected Client(String ... stringArray2) {
        super(stringArray2);
        this.addOption("server", stringArray -> this.setServerHost(stringArray[0]), "host specification");
        this.addOption("authentication", stringArray -> this.setAuthenticationScheme(stringArray[0]), "scheme");
    }

    @Override
    protected void extendUsageSummary(StringBuilder stringBuilder) {
        super.extendUsageSummary(stringBuilder);
        stringBuilder.append('\n').append("The default server host is ").append(":0").append(". ").append("The format of a host specification is ").append('[').append("host").append(']').append('[').append(':').append("port").append(']').append(". ").append("The host component may be either a host name or an IPV4 address").append(" - if not specified, a local socket is used. ").append("The port component must be an integer within the range ").append(0).append(" through ").append(99).append(" - if not specified, ").append(0).append(" is assumed. ");
        stringBuilder.append('\n').append("The default authentication scheme is ").append(ConnectionSettings.DEFAULT_AUTHENTICATION_SCHEME).append(". ").append("The format of a scheme specification is name").append('[').append(':').append("operand").append(']').append(". ").append("More than one scheme, separated by ").append('+').append(", may be specified. ").append("The following schemes are supported:").append("\n  ").append("keyfile").append(':').append("path").append("\n  ").append("none");
    }

    private final Client connect(ClientTask clientTask) throws ProgramException {
        try {
            Connection connection = new Connection(this.connectionSettings);
            try {
                clientTask.run(connection);
            }
            finally {
                connection.close();
                connection = null;
            }
        }
        catch (LostConnectionException lostConnectionException) {
            throw new ExternalException("connection lost", new Object[0]);
        }
        catch (APIError aPIError) {
            throw new ExternalException("API error: " + aPIError, new Object[0]);
        }
        catch (APIException aPIException) {
            throw new ExternalException("API exception: " + aPIException, new Object[0]);
        }
        return this;
    }

    public final boolean pause(Connection connection, int n) {
        try {
            connection.pause(n);
            return true;
        }
        catch (InterruptedIOException interruptedIOException) {
            return false;
        }
    }

    @Override
    protected final void runProgram() throws ProgramException {
        this.connect(connection -> this.runClient(connection));
    }

    protected final Parameter getParameter(Connection connection, String string) throws SemanticException {
        Parameter parameter = connection.getParameters().get(string);
        if (parameter != null) {
            return parameter;
        }
        throw new SemanticException("unknown parameter: %s", string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Client ttyMode(Connection connection, String string, TtyModeTask ttyModeTask, int ... nArray) throws ProgramException {
        try {
            connection.enterTtyModeWithPath(string, nArray);
            try {
                ttyModeTask.run(connection);
            }
            finally {
                if (!connection.isUnusable()) {
                    connection.leaveTtyMode();
                }
            }
        }
        catch (APIError aPIError) {
            throw new ProgramException("tty mode error: " + aPIError, new Object[0]);
        }
        return this;
    }

    protected final Client ttyMode(Connection connection, boolean bl, TtyModeTask ttyModeTask, int ... nArray) throws ProgramException {
        return this.ttyMode(connection, bl ? connection.getDriverName() : null, ttyModeTask, nArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Client rawMode(Connection connection, String string, RawModeTask rawModeTask) throws ProgramException {
        try {
            connection.enterRawMode(string);
            try {
                rawModeTask.run(connection);
            }
            finally {
                if (!connection.isUnusable()) {
                    connection.leaveRawMode();
                }
            }
        }
        catch (APIError aPIError) {
            throw new ProgramException("raw mode error: " + aPIError, new Object[0]);
        }
        return this;
    }

    protected final Client rawMode(Connection connection, RawModeTask rawModeTask) throws ProgramException {
        return this.rawMode(connection, connection.getDriverName(), rawModeTask);
    }

    protected static interface ClientTask {
        public void run(Connection var1) throws ProgramException;
    }

    protected static interface TtyModeTask {
        public void run(Connection var1) throws ProgramException;
    }

    protected static interface RawModeTask {
        public void run(Connection var1) throws ProgramException;
    }
}

