/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.cache;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.sourceforge.jnlp.DownloadOptions;
import net.sourceforge.jnlp.Version;
import net.sourceforge.jnlp.cache.CacheEntry;
import net.sourceforge.jnlp.cache.CacheUtil;
import net.sourceforge.jnlp.cache.CachedDaemonThreadPoolProvider;
import net.sourceforge.jnlp.cache.IllegalResourceDescriptorException;
import net.sourceforge.jnlp.cache.Resource;
import net.sourceforge.jnlp.cache.ResourceDownloader;
import net.sourceforge.jnlp.cache.UpdatePolicy;
import net.sourceforge.jnlp.event.DownloadEvent;
import net.sourceforge.jnlp.event.DownloadListener;
import net.sourceforge.jnlp.util.UrlUtils;
import net.sourceforge.jnlp.util.logging.OutputController;

public class ResourceTracker {
    private static final Object lock = new Object();
    private final List<Resource> resources = new ArrayList<Resource>();
    private final HashMap<String, Resource> resourcesMap = new HashMap();
    private final List<DownloadListener> listeners = new ArrayList<DownloadListener>();
    private final boolean prefetch;

    public ResourceTracker() {
        this(false);
    }

    public ResourceTracker(boolean prefetch) {
        this.prefetch = prefetch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addResource(URL location, Version version, DownloadOptions options, UpdatePolicy updatePolicy) {
        if (location == null) {
            throw new IllegalResourceDescriptorException("location==null");
        }
        try {
            location = UrlUtils.normalizeUrl(location);
        }
        catch (Exception ex) {
            OutputController.getLogger().log(OutputController.Level.ERROR_ALL, "Normalization of " + location.toString() + " have failed");
            OutputController.getLogger().log(ex);
        }
        Resource resource = Resource.getResource(location, version, updatePolicy);
        List<Resource> list = this.resources;
        synchronized (list) {
            if (this.resources.contains(resource)) {
                return;
            }
            resource.addTracker(this);
            this.resources.add(resource);
            this.resourcesMap.put(location.toString(), resource);
        }
        if (options == null) {
            options = new DownloadOptions(false, false);
        }
        resource.setDownloadOptions(options);
        boolean downloaded = this.checkCache(resource, updatePolicy);
        if (!downloaded && this.prefetch) {
            this.startResource(resource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeResource(URL location) {
        List<Resource> list = this.resources;
        synchronized (list) {
            Resource resource = this.getResource(location);
            if (resource != null) {
                this.resources.remove(resource);
                this.resourcesMap.remove(location.toString());
                resource.removeTracker(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkCache(Resource resource, UpdatePolicy updatePolicy) {
        CacheEntry entry;
        if (!CacheUtil.isCacheable(resource.getLocation(), resource.getDownloadVersion())) {
            Resource resource2 = resource;
            synchronized (resource2) {
                resource.changeStatus(EnumSet.noneOf(Resource.Status.class), EnumSet.of(Resource.Status.DOWNLOADED, Resource.Status.CONNECTED, Resource.Status.PROCESSING));
            }
            this.fireDownloadEvent(resource);
            return true;
        }
        if (updatePolicy != UpdatePolicy.ALWAYS && updatePolicy != UpdatePolicy.FORCE && (entry = new CacheEntry(resource.getLocation(), resource.getDownloadVersion())).isCached() && !updatePolicy.shouldUpdate(entry)) {
            OutputController.getLogger().log("not updating: " + resource.getLocation());
            Resource resource3 = resource;
            synchronized (resource3) {
                resource.setLocalFile(CacheUtil.getCacheFile(resource.getLocation(), resource.getDownloadVersion()));
                resource.setSize(resource.getLocalFile().length());
                resource.setTransferred(resource.getLocalFile().length());
                resource.changeStatus(EnumSet.noneOf(Resource.Status.class), EnumSet.of(Resource.Status.DOWNLOADED, Resource.Status.CONNECTED, Resource.Status.PROCESSING));
            }
            this.fireDownloadEvent(resource);
            return true;
        }
        if (updatePolicy == UpdatePolicy.FORCE) {
            resource.resetStatus();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDownloadListener(DownloadListener listener) {
        List<DownloadListener> list = this.listeners;
        synchronized (list) {
            if (!this.listeners.contains(listener)) {
                this.listeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDownloadListener(DownloadListener listener) {
        List<DownloadListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireDownloadEvent(Resource resource) {
        Set<Resource.Status> status;
        DownloadListener[] l;
        List<DownloadListener> list = this.listeners;
        synchronized (list) {
            l = this.listeners.toArray(new DownloadListener[0]);
        }
        Resource resource2 = resource;
        synchronized (resource2) {
            status = resource.getCopyOfStatus();
        }
        DownloadEvent event = new DownloadEvent(this, resource);
        for (DownloadListener dl : l) {
            if (status.contains((Object)Resource.Status.ERROR) || status.contains((Object)Resource.Status.DOWNLOADED)) {
                dl.downloadCompleted(event);
                continue;
            }
            if (status.contains((Object)Resource.Status.DOWNLOADING)) {
                dl.downloadStarted(event);
                continue;
            }
            if (!status.contains((Object)Resource.Status.CONNECTING)) continue;
            dl.updateStarted(event);
        }
    }

    public URL getCacheURL(URL location) {
        try {
            File f = this.getCacheFile(location);
            if (f != null) {
                return f.toURL();
            }
        }
        catch (MalformedURLException ex) {
            OutputController.getLogger().log(ex);
        }
        return location;
    }

    public File getCacheFile(URL location) {
        try {
            Resource resource = this.getResource(location);
            if (!resource.isSet(Resource.Status.DOWNLOADED) && !resource.isSet(Resource.Status.ERROR)) {
                this.waitForResource(location, 0L);
            }
            if (resource.isSet(Resource.Status.ERROR)) {
                return null;
            }
            if (resource.getLocalFile() != null) {
                return resource.getLocalFile();
            }
            if (location.getProtocol().equalsIgnoreCase("file")) {
                File file = UrlUtils.decodeUrlAsFile(location);
                if (file.exists()) {
                    return file;
                }
                file = new File(location.getPath());
                if (file.exists()) {
                    return file;
                }
            }
            return null;
        }
        catch (InterruptedException ex) {
            OutputController.getLogger().log(ex);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitForResources(URL[] urls, long timeout) throws InterruptedException {
        Resource[] lresources;
        Resource[] resourceArray = lresources = new Resource[urls.length];
        synchronized (lresources) {
            for (int i = 0; i < urls.length; ++i) {
                lresources[i] = this.getResource(urls[i]);
            }
            // ** MonitorExit[var5_4] (shouldn't be in output)
            if (lresources.length > 0) {
                return this.wait(lresources, timeout);
            }
            return true;
        }
    }

    public boolean waitForResource(URL location, long timeout) throws InterruptedException {
        return this.wait(new Resource[]{this.getResource(location)}, timeout);
    }

    public long getAmountRead(URL location) {
        return this.getResource(location).getTransferred();
    }

    public boolean checkResource(URL location) {
        Resource resource = this.getResource(location);
        return resource.isSet(Resource.Status.DOWNLOADED) || resource.isSet(Resource.Status.ERROR);
    }

    public boolean startResource(URL location) {
        Resource resource = this.getResource(location);
        return this.startResource(resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean startResource(Resource resource) {
        boolean enqueue;
        Resource resource2 = resource;
        synchronized (resource2) {
            if (resource.isSet(Resource.Status.ERROR)) {
                return true;
            }
            boolean bl = enqueue = !resource.isSet(Resource.Status.PROCESSING);
            if (!resource.isSet(Resource.Status.CONNECTED) && !resource.isSet(Resource.Status.CONNECTING)) {
                resource.changeStatus(EnumSet.noneOf(Resource.Status.class), EnumSet.of(Resource.Status.PRECONNECT, Resource.Status.PROCESSING));
            }
            if (!resource.isSet(Resource.Status.DOWNLOADED) && !resource.isSet(Resource.Status.DOWNLOADING)) {
                resource.changeStatus(EnumSet.noneOf(Resource.Status.class), EnumSet.of(Resource.Status.PREDOWNLOAD, Resource.Status.PROCESSING));
            }
            if (!resource.isSet(Resource.Status.PREDOWNLOAD) && !resource.isSet(Resource.Status.PRECONNECT)) {
                enqueue = false;
            }
        }
        if (enqueue) {
            this.startDownloadThread(resource);
        }
        return !enqueue;
    }

    public long getTotalSize(URL location) {
        return this.getResource(location).getSize();
    }

    protected void startDownloadThread(Resource resource) {
        CachedDaemonThreadPoolProvider.getThreadPool().execute(new ResourceDownloader(resource, lock));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Resource selectByFilter(Collection<Resource> source, Filter<Resource> filter) {
        Resource result = null;
        Iterator<Resource> iterator = source.iterator();
        while (iterator.hasNext()) {
            boolean selectable;
            Resource resource;
            Resource resource2 = resource = iterator.next();
            synchronized (resource2) {
                selectable = filter.test(resource);
            }
            if (!selectable) continue;
            result = resource;
        }
        return result;
    }

    static Resource selectByStatus(Collection<Resource> source, Resource.Status include, Resource.Status exclude) {
        return ResourceTracker.selectByStatus(source, EnumSet.of(include), EnumSet.of(exclude));
    }

    static Resource selectByStatus(Collection<Resource> source, final Collection<Resource.Status> included, final Collection<Resource.Status> excluded) {
        return ResourceTracker.selectByFilter(source, new Filter<Resource>(){

            @Override
            public boolean test(Resource t) {
                boolean hasIncluded = false;
                for (Resource.Status flag : included) {
                    if (!t.isSet(flag)) continue;
                    hasIncluded = true;
                }
                boolean hasExcluded = false;
                for (Resource.Status flag : excluded) {
                    if (!t.isSet(flag)) continue;
                    hasExcluded = true;
                }
                return hasIncluded && !hasExcluded;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Resource getResource(URL location) {
        List<Resource> list = this.resources;
        synchronized (list) {
            Resource res;
            if (null != location && null != (res = this.resourcesMap.get(location.toString())) && UrlUtils.urlEquals(res.getLocation(), location)) {
                return res;
            }
            for (Resource resource : this.resources) {
                if (!UrlUtils.urlEquals(resource.getLocation(), location)) continue;
                return resource;
            }
        }
        throw new IllegalResourceDescriptorException("Location does not specify a resource being tracked.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean wait(Resource[] resources, long timeout) throws InterruptedException {
        long startTime = System.currentTimeMillis();
        for (Resource resource : resources) {
            this.startResource(resource);
        }
        while (true) {
            boolean finished = true;
            Object object = lock;
            synchronized (object) {
                Resource[] resourceArray = resources;
                int n = resourceArray.length;
                for (int i = 0; i < n; ++i) {
                    Resource resource;
                    Resource resource2 = resource = resourceArray[i];
                    synchronized (resource2) {
                        if (!resource.isSet(Resource.Status.DOWNLOADED) && !resource.isSet(Resource.Status.ERROR)) {
                            finished = false;
                            break;
                        }
                        continue;
                    }
                }
                if (finished) {
                    return true;
                }
                long waitTime = 0L;
                if (timeout > 0L && (waitTime = timeout - (System.currentTimeMillis() - startTime)) <= 0L) {
                    return false;
                }
                lock.wait(waitTime);
            }
        }
    }

    static interface Filter<T> {
        public boolean test(T var1);
    }

    public static enum RequestMethods {
        HEAD,
        GET,
        TESTING_UNDEF;

        private static final RequestMethods[] requestMethods;

        public static RequestMethods[] getValidRequestMethods() {
            return requestMethods;
        }

        static {
            requestMethods = new RequestMethods[]{HEAD, GET};
        }
    }
}

