/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.controlpanel;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import javax.swing.JDialog;
import net.sourceforge.jnlp.util.logging.OutputController;

public class ClassFinder
extends JDialog {
    public static final String JAVA_CLASS_PATH_PROPERTY = "java.class.path";
    public static final String CUSTOM_CLASS_PATH_PROPERTY = "custom.class.path";
    public static final String BOOT_CLASS_PATH_PROPERTY = "sun.boot.class.path";

    public static <T> List<Class<? extends T>> findAllMatchingTypes(Class<T> toFind) {
        ArrayList<Class<T>> returnedClasses = new ArrayList<Class<T>>();
        Set<Class> foundClasses = ClassFinder.walkClassPath(toFind);
        for (Class clazz : foundClasses) {
            if (clazz.isInterface()) continue;
            returnedClasses.add(clazz);
        }
        return returnedClasses;
    }

    private static Set<Class> walkClassPath(Class toFind) {
        HashSet<Class> results = new HashSet<Class>();
        Set<String> classPathRoots = ClassFinder.getClassPathRoots();
        for (String classpathEntry : classPathRoots) {
            File f;
            if (!classpathEntry.toLowerCase().contains("icedtea-web") && !classpathEntry.toLowerCase().contains("javaws") && !classpathEntry.toLowerCase().contains("plugin") || !(f = new File(classpathEntry)).exists()) continue;
            if (f.isDirectory()) {
                ClassFinder.traverse(f.getAbsolutePath(), f, toFind, results);
                continue;
            }
            File jar = new File(classpathEntry);
            try {
                JarEntry entry;
                JarInputStream is = new JarInputStream(new FileInputStream(jar));
                while ((entry = is.getNextJarEntry()) != null) {
                    Class c = ClassFinder.determine(entry.getName(), toFind);
                    if (c == null) continue;
                    results.add(c);
                }
            }
            catch (IOException ex) {
                OutputController.getLogger().log(ex);
            }
        }
        return results;
    }

    private static Set<String> getClassPathRoots() {
        String classapth1 = System.getProperty(CUSTOM_CLASS_PATH_PROPERTY);
        String classapth2 = System.getProperty(JAVA_CLASS_PATH_PROPERTY);
        String classapth3 = System.getProperty(BOOT_CLASS_PATH_PROPERTY);
        String classpath = "";
        if (classapth1 != null) {
            classpath = classpath + classapth1 + File.pathSeparator;
        }
        if (classapth2 != null) {
            classpath = classpath + classapth2 + File.pathSeparator;
        }
        if (classapth3 != null) {
            classpath = classpath + classapth3 + File.pathSeparator;
        }
        String[] pathElements = classpath.split(File.pathSeparator);
        HashSet<String> s = new HashSet<String>(Arrays.asList(pathElements));
        return s;
    }

    private static Class determine(String name, Class toFind) {
        if (name.contains("$")) {
            return null;
        }
        try {
            if (name.endsWith(".class")) {
                name = name.replace(".class", "");
                name = name.replace("/", ".");
                Class<?> clazz = Class.forName(name = name.replace("\\", "."));
                if (toFind.isAssignableFrom(clazz)) {
                    return clazz;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    private static void traverse(String root, File current, Class toFind, Set<Class> result) {
        File[] fs;
        for (File f : fs = current.listFiles()) {
            if (f.isDirectory()) {
                ClassFinder.traverse(root, f, toFind, result);
                continue;
            }
            String ff = f.getAbsolutePath();
            String name = ff.substring(root.length());
            while (name.startsWith(File.separator)) {
                name = name.substring(1);
            }
            Class c = ClassFinder.determine(name, toFind);
            if (c == null) continue;
            result.add(c);
        }
    }
}

