/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.runtime.html.browser;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import net.sourceforge.jnlp.runtime.JNLPRuntime;
import net.sourceforge.jnlp.runtime.Translator;
import net.sourceforge.jnlp.runtime.html.browser.DocumentChangededListener;
import net.sourceforge.jnlp.util.UrlUtils;
import net.sourceforge.jnlp.util.logging.OutputController;

public class HtmlBrowserPanel
extends JPanel {
    List<DocumentChangededListener> documentChangededListeners = new ArrayList<DocumentChangededListener>();
    private final JPanel customUrl = new JPanel(new BorderLayout());
    private final JPanel mainButtons = new JPanel(new GridLayout(1, 0));
    private final JPanel tools = new JPanel(new BorderLayout());
    private final JTextField goTo = new JTextField();
    private final JButton gotoButton = new JButton(Translator.R("BrowserGoTo"));
    private final JButton backButton = new JButton("<<<");
    private final JButton reloadButton = new JButton(Translator.R("BUTreload"));
    private final JButton fwdButton = new JButton(">>>");
    private final JToggleButton viewSourceButton = new JToggleButton(Translator.R("BrowserSource"));
    private final JCheckBox socketCheckbox = new JCheckBox(Translator.R("BrowserSocket"));
    private final JComboBox<Charset> encodingBox = new JComboBox<Charset>(new Charset[]{null, Charset.forName("US-ASCII"), Charset.forName("UTF-8"), Charset.forName("ISO-8859-1"), Charset.forName("UTF-16"), Charset.forName("UTF-16BE"), Charset.forName("UTF-16LE")});
    private static final String TEXTPLAIN = "text/plain";
    private static final String TEXTHTML = "text/html";
    private JEditorPane currentHtml;
    private JScrollPane currentScrollHtml;
    private State current;
    private boolean source = false;
    private boolean useSocket = false;
    private final History history = new History();

    private void fireDocumentChanged(String current) {
        for (DocumentChangededListener documentChangededListener : this.documentChangededListeners) {
            documentChangededListener.documentChangeded(current);
        }
    }

    private void fireAddressChanged(String url) {
        for (DocumentChangededListener documentChangededListener : this.documentChangededListeners) {
            documentChangededListener.addressChangeded(url);
        }
    }

    private void fireAddressChanged(URL url) {
        for (DocumentChangededListener documentChangededListener : this.documentChangededListeners) {
            documentChangededListener.addressChangeded(url);
        }
    }

    public void addDocumentChangedListener(DocumentChangededListener i) {
        this.documentChangededListeners.add(i);
    }

    public URL getUrl() {
        if (this.current == null) {
            return null;
        }
        return this.current.url;
    }

    public HtmlBrowserPanel(URL url) {
        this(url, false);
    }

    public HtmlBrowserPanel(String url) {
        this(url, false);
    }

    public HtmlBrowserPanel(URL url, boolean socket) {
        super(new BorderLayout());
        this.setUseSocket(socket);
        this.crateGui();
        URL u = this.loadCatched(url);
    }

    public HtmlBrowserPanel(String url, boolean socket) {
        super(new BorderLayout());
        this.setUseSocket(socket);
        this.crateGui();
        URL u = this.loadCatched(url);
    }

    private URL loadCatched(String url) {
        try {
            URL u = new URL(url);
            this.load(u);
            return u;
        }
        catch (Exception ex) {
            OutputController.getLogger().log(ex);
            if (!JNLPRuntime.isHeadless()) {
                JOptionPane.showMessageDialog(null, ex);
            }
            return null;
        }
    }

    private URL loadCatched(URL url) {
        try {
            this.load(url);
            return url;
        }
        catch (Exception ex) {
            OutputController.getLogger().log(ex);
            if (!JNLPRuntime.isHeadless()) {
                JOptionPane.showMessageDialog(null, ex);
            }
            return null;
        }
    }

    private void load(URL url) throws IOException {
        String[] result;
        this.goTo.setText(url.toExternalForm());
        this.fireAddressChanged(url);
        this.fireAddressChanged(url.toExternalForm());
        if (this.isUseSocket()) {
            OutputController.getLogger().log("Using socket connection");
            Charset ch = (Charset)this.encodingBox.getSelectedItem();
            result = ch == null ? UrlUtils.loadUrlWithInvalidHeader(url) : UrlUtils.loadUrlWithInvalidHeader(url, ch);
        } else {
            OutputController.getLogger().log("Using URLconnection");
            Charset ch = (Charset)this.encodingBox.getSelectedItem();
            String s = ch == null ? UrlUtils.loadUrl(url) : UrlUtils.loadUrl(url, ch);
            result = new String[]{s, s, s};
        }
        OutputController.getLogger().log(result[0]);
        if (result[2].trim().isEmpty()) {
            result[2] = result[1];
        }
        this.current = new State(url, result[0], result[2]);
        if (this.source) {
            this.currentHtml = new JEditorPane(TEXTPLAIN, this.current.getSource());
            if (this.encodingBox.getSelectedItem() != null) {
                this.currentHtml.getDocument().putProperty("IgnoreCharsetDirective", Boolean.TRUE);
            }
        } else {
            this.currentHtml = new JEditorPane(TEXTHTML, this.current.getHtml());
            if (this.encodingBox.getSelectedItem() != null) {
                this.currentHtml.getDocument().putProperty("IgnoreCharsetDirective", Boolean.TRUE);
            }
            ((HTMLDocument)this.currentHtml.getDocument()).setBase(this.current.url);
        }
        this.fireDocumentChanged(this.getCurrentSource());
        this.currentHtml.setEditable(false);
        this.currentHtml.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    URL u = e.getURL();
                    HtmlBrowserPanel.this.history.visit(u);
                }
            }
        });
        if (this.currentScrollHtml != null) {
            this.remove(this.currentScrollHtml);
        }
        this.currentScrollHtml = new JScrollPane(this.currentHtml);
        this.add(this.currentScrollHtml);
        this.validate();
    }

    private void crateGui() {
        this.mainButtons.add(this.backButton);
        this.backButton.setToolTipText(Translator.R("BUTback"));
        this.mainButtons.add(this.reloadButton);
        this.mainButtons.add(this.fwdButton);
        this.fwdButton.setToolTipText(Translator.R("BUTforward"));
        this.mainButtons.add(this.viewSourceButton);
        this.mainButtons.add(this.socketCheckbox);
        this.socketCheckbox.setSelected(this.isUseSocket());
        this.socketCheckbox.setToolTipText(Translator.R("BrowserSocketHelp"));
        this.customUrl.add((Component)this.gotoButton, "West");
        this.customUrl.add(this.goTo);
        this.customUrl.add(this.encodingBox, "East");
        this.tools.add((Component)this.customUrl, "South");
        this.tools.add((Component)this.mainButtons, "North");
        this.gotoButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HtmlBrowserPanel.this.gotoUrl(HtmlBrowserPanel.this.goTo.getText());
            }
        });
        this.reloadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                URL u = HtmlBrowserPanel.this.loadCatched(HtmlBrowserPanel.this.goTo.getText());
            }
        });
        this.goTo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HtmlBrowserPanel.this.gotoUrl(HtmlBrowserPanel.this.goTo.getText());
            }
        });
        this.backButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                URL u = HtmlBrowserPanel.this.history.back();
            }
        });
        this.fwdButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                URL u = HtmlBrowserPanel.this.history.fwd();
            }
        });
        this.socketCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HtmlBrowserPanel.this.setUseSocket(HtmlBrowserPanel.this.socketCheckbox.isSelected());
            }
        });
        this.viewSourceButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HtmlBrowserPanel.this.source = !HtmlBrowserPanel.this.source;
                if (HtmlBrowserPanel.this.current == null || HtmlBrowserPanel.this.currentHtml == null) {
                    return;
                }
                HtmlBrowserPanel.this.showBySource();
            }
        });
        this.add((Component)this.tools, "North");
    }

    private void showBySource() {
        if (this.source) {
            this.currentHtml.setContentType(TEXTPLAIN);
            this.currentHtml.setText(this.current.getSource());
        } else {
            this.currentHtml.setContentType(TEXTHTML);
            this.currentHtml.setText(this.current.getHtml());
            ((HTMLDocument)this.currentHtml.getDocument()).setBase(this.current.url);
        }
    }

    private void setUseSocket(boolean b) {
        this.useSocket = b;
        if (this.socketCheckbox != null) {
            this.socketCheckbox.setSelected(b);
        }
    }

    public boolean isUseSocket() {
        return this.useSocket;
    }

    public static void warn() {
        OutputController.getLogger().log(OutputController.Level.MESSAGE_ALL, Translator.R("BrowserWarningLine1"));
        OutputController.getLogger().log(OutputController.Level.MESSAGE_ALL, Translator.R("BrowserWarningLine2"));
    }

    public static void showStandAloneWindow(String url, boolean socket) {
        HtmlBrowserPanel.warn();
        JFrame f = new JFrame();
        f.add(new HtmlBrowserPanel(url, socket));
        f.pack();
        f.setDefaultCloseOperation(3);
        f.setVisible(true);
    }

    public String getCurrentSource() {
        if (this.current == null) {
            return "";
        }
        return this.current.getSource();
    }

    public void gotoUrl(String text) {
        this.history.visit(text);
    }

    private class History {
        private final List<URL> visited = new ArrayList<URL>();
        private final List<URL> backed = new ArrayList<URL>();

        private History() {
        }

        private URL back() {
            if (this.visited.isEmpty()) {
                return null;
            }
            URL q = this.visited.get(0);
            this.visited.remove(0);
            this.put(HtmlBrowserPanel.this.current, this.backed);
            URL u = HtmlBrowserPanel.this.loadCatched(q);
            this.createTooltips();
            return q;
        }

        private URL fwd() {
            if (this.backed.isEmpty()) {
                return null;
            }
            URL q = this.backed.get(0);
            this.backed.remove(0);
            this.put(HtmlBrowserPanel.this.current, this.visited);
            URL u = HtmlBrowserPanel.this.loadCatched(q);
            this.createTooltips();
            return q;
        }

        private void put(URL url, List<URL> where) {
            if (url != null) {
                if (where.isEmpty()) {
                    where.add(0, url);
                } else if (!where.get(0).equals(url)) {
                    where.add(0, url);
                }
            }
        }

        private void put(State current, List<URL> where) {
            if (current != null) {
                this.put(current.url, where);
            }
        }

        private void visit(String text) {
            this.put(HtmlBrowserPanel.this.current, this.visited);
            URL u = HtmlBrowserPanel.this.loadCatched(text);
            this.createTooltips();
        }

        private void visit(URL url) {
            this.put(HtmlBrowserPanel.this.current, this.visited);
            URL u = HtmlBrowserPanel.this.loadCatched(url);
            this.createTooltips();
        }

        private void createTooltips() {
            this.createTooltip(this.visited, HtmlBrowserPanel.this.backButton, Translator.R("BUTback"));
            this.createTooltip(this.backed, HtmlBrowserPanel.this.fwdButton, Translator.R("BUTforward"));
        }

        private void createTooltip(List<URL> visited, JButton b, String title) {
            StringBuilder sb = new StringBuilder("<html><h3>" + title + "</h3><ol>");
            JPopupMenu p = new JPopupMenu();
            for (final URL url : visited) {
                sb.append("<li>").append(url.toExternalForm()).append("</li>");
                JMenuItem jim = new JMenuItem(url.toExternalForm());
                jim.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        History.this.visit(url);
                    }
                });
                p.add(jim);
            }
            b.removeAll();
            b.setComponentPopupMenu(p);
            sb.append("</ol></html>");
            b.setToolTipText(sb.toString());
        }
    }

    private static class State {
        final URL url;
        final String source;
        final String all;

        private static String removeMeta(String string) {
            return string.replaceAll("(?i)<\\s*meta.*?>", "");
        }

        private State(URL url, String all, String html) {
            this.url = url;
            this.all = all;
            this.source = html;
        }

        private String getSource() {
            if (this.all == null || this.all.trim().isEmpty()) {
                return this.source;
            }
            return this.all;
        }

        private String getHtml() {
            if (this.source == null || this.source.trim().isEmpty()) {
                return State.removeMeta(this.all);
            }
            return State.removeMeta(this.source);
        }
    }
}

