/*
 * Decompiled with CFR 0.152.
 */
package org.bluray.ti;

import java.util.Date;
import javax.tv.locator.Locator;
import javax.tv.service.ServiceInformationType;
import org.bluray.net.BDLocator;
import org.bluray.ti.PlayItem;
import org.bluray.ti.PlayItemImpl;
import org.bluray.ti.PlayList;
import org.bluray.ti.Title;
import org.bluray.ti.TitleInformationType;
import org.davic.net.InvalidLocatorException;
import org.videolan.Libbluray;
import org.videolan.PlaylistInfo;
import org.videolan.TIClip;

public class PlayListImpl
implements PlayList {
    private String filename;
    private PlaylistInfo playlist;
    private int id;
    private Title service;

    protected PlayListImpl(String filename, Title service) {
        this.filename = filename;
        this.id = Integer.parseInt(filename);
        this.playlist = Libbluray.getPlaylistInfo(this.id);
        this.service = service;
    }

    @Override
    public String getFileName() {
        return this.filename;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public PlayItem[] getPlayItems() {
        TIClip[] clips = this.playlist.getClips();
        PlayItem[] items = new PlayItem[clips.length];
        for (int i = 0; i < clips.length; ++i) {
            items[i] = new PlayItemImpl(this.id, i + 1, clips[i], this.service);
        }
        return items;
    }

    @Override
    public Locator getLocator() {
        int title = Libbluray.getCurrentTitle();
        try {
            return new BDLocator(null, title, this.id);
        }
        catch (InvalidLocatorException e) {
            return null;
        }
    }

    @Override
    public ServiceInformationType getServiceInformationType() {
        return TitleInformationType.BD_ROM;
    }

    @Override
    public Date getUpdateTime() {
        return null;
    }
}

