package SDL::ConfigData;
use strict;
my $arrayref = eval do {local $/; <DATA>}
  or die "Couldn't load ConfigData data: $@";
close DATA;
my ($config, $features, $auto_features) = @$arrayref;

sub config { $config->{$_[1]} }

sub set_config { $config->{$_[1]} = $_[2] }
sub set_feature { $features->{$_[1]} = 0+!!$_[2] }  # Constrain to 1 or 0

sub auto_feature_names { sort grep !exists $features->{$_}, keys %$auto_features }

sub feature_names {
  my @features = (sort keys %$features, auto_feature_names());
  @features;
}

sub config_names  { sort keys %$config }

sub write {
  my $me = __FILE__;

  # Can't use Module::Build::Dumper here because M::B is only a
  # build-time prereq of this module
  require Data::Dumper;

  my $mode_orig = (stat $me)[2] & 07777;
  chmod($mode_orig | 0222, $me); # Make it writeable
  open(my $fh, '+<', $me) or die "Can't rewrite $me: $!";
  seek($fh, 0, 0);
  while (<$fh>) {
    last if /^__DATA__$/;
  }
  die "Couldn't find __DATA__ token in $me" if eof($fh);

  seek($fh, tell($fh), 0);
  my $data = [$config, $features, $auto_features];
  print($fh 'do{ my '
	      . Data::Dumper->new([$data],['x'])->Purity(1)->Dump()
	      . '$x; }' );
  truncate($fh, tell($fh));
  close $fh;

  chmod($mode_orig, $me)
    or warn "Couldn't restore permissions on $me: $!";
}

sub feature {
  my ($package, $key) = @_;
  return $features->{$key} if exists $features->{$key};

  my $info = $auto_features->{$key} or return 0;

  require Module::Build;  # XXX should get rid of this
  foreach my $type (sort keys %$info) {
    my $prereqs = $info->{$type};
    next if $type eq 'description' || $type eq 'recommends';

    foreach my $modname (sort keys %$prereqs) {
      my $status = Module::Build->check_installed_status($modname, $prereqs->{$modname});
      if ((!$status->{ok}) xor ($type =~ /conflicts$/)) { return 0; }
      if ( ! eval "require $modname; 1" ) { return 0; }
    }
  }
  return 1;
}


=head1 NAME

SDL::ConfigData - Configuration for SDL

=head1 SYNOPSIS

  use SDL::ConfigData;
  $value = SDL::ConfigData->config('foo');
  $value = SDL::ConfigData->feature('bar');

  @names = SDL::ConfigData->config_names;
  @names = SDL::ConfigData->feature_names;

  SDL::ConfigData->set_config(foo => $new_value);
  SDL::ConfigData->set_feature(bar => $new_value);
  SDL::ConfigData->write;  # Save changes


=head1 DESCRIPTION

This module holds the configuration data for the C<SDL>
module.  It also provides a programmatic interface for getting or
setting that configuration data.  Note that in order to actually make
changes, you'll have to have write access to the C<SDL::ConfigData>
module, and you should attempt to understand the repercussions of your
actions.


=head1 METHODS

=over 4

=item config($name)

Given a string argument, returns the value of the configuration item
by that name, or C<undef> if no such item exists.

=item feature($name)

Given a string argument, returns the value of the feature by that
name, or C<undef> if no such feature exists.

=item set_config($name, $value)

Sets the configuration item with the given name to the given value.
The value may be any Perl scalar that will serialize correctly using
C<Data::Dumper>.  This includes references, objects (usually), and
complex data structures.  It probably does not include transient
things like filehandles or sockets.

=item set_feature($name, $value)

Sets the feature with the given name to the given boolean value.  The
value will be converted to 0 or 1 automatically.

=item config_names()

Returns a list of all the names of config items currently defined in
C<SDL::ConfigData>, or in scalar context the number of items.

=item feature_names()

Returns a list of all the names of features currently defined in
C<SDL::ConfigData>, or in scalar context the number of features.

=item auto_feature_names()

Returns a list of all the names of features whose availability is
dynamically determined, or in scalar context the number of such
features.  Does not include such features that have later been set to
a fixed value.

=item write()

Commits any changes from C<set_config()> and C<set_feature()> to disk.
Requires write access to the C<SDL::ConfigData> module.

=back


=head1 AUTHOR

C<SDL::ConfigData> was automatically created using C<Module::Build>.
C<Module::Build> was written by Ken Williams, but he holds no
authorship claim or copyright claim to the contents of C<SDL::ConfigData>.

=cut


__DATA__
do{ my $x = [
       {
         'SDL_cfg' => {
                        'Audio' => {
                                     'defines' => [
                                                    '-DHAVE_SDL'
                                                  ],
                                     'libs' => {
                                                 'SDL' => 1
                                               },
                                     'links' => [
                                                  '-lSDL'
                                                ]
                                   },
                        'AudioCVT' => {
                                        'defines' => [
                                                       '-DHAVE_SDL'
                                                     ],
                                        'libs' => {
                                                    'SDL' => 1
                                                  },
                                        'links' => [
                                                     '-lSDL'
                                                   ]
                                      },
                        'AudioSpec' => {
                                         'defines' => [
                                                        '-DHAVE_SDL'
                                                      ],
                                         'libs' => {
                                                     'SDL' => 1
                                                   },
                                         'links' => [
                                                      '-lSDL'
                                                    ]
                                       },
                        'BlitFunc' => {
                                        'defines' => [
                                                       '-DHAVE_SDL',
                                                       '-DHAVE_SDL_GFX_BLITFUNC'
                                                     ],
                                        'libs' => {
                                                    'SDL' => 1,
                                                    'SDL_gfx_blitfunc' => 1
                                                  },
                                        'links' => [
                                                     '-lSDL',
                                                     '-lSDL_gfx'
                                                   ]
                                      },
                        'CD' => {
                                  'defines' => [
                                                 '-DHAVE_SDL'
                                               ],
                                  'libs' => {
                                              'SDL' => 1
                                            },
                                  'links' => [
                                               '-lSDL'
                                             ]
                                },
                        'CDROM' => {
                                     'defines' => [
                                                    '-DHAVE_SDL'
                                                  ],
                                     'libs' => {
                                                 'SDL' => 1
                                               },
                                     'links' => [
                                                  '-lSDL'
                                                ]
                                   },
                        'CDTrack' => {
                                       'defines' => [
                                                      '-DHAVE_SDL'
                                                    ],
                                       'libs' => {
                                                   'SDL' => 1
                                                 },
                                       'links' => [
                                                    '-lSDL'
                                                  ]
                                     },
                        'Color' => {
                                     'defines' => [
                                                    '-DHAVE_SDL'
                                                  ],
                                     'libs' => {
                                                 'SDL' => 1
                                               },
                                     'links' => [
                                                  '-lSDL'
                                                ]
                                   },
                        'Context' => {
                                       'defines' => [
                                                      '-DHAVE_SDL',
                                                      '-DHAVE_SDL_PANGO'
                                                    ],
                                       'libs' => {
                                                   'SDL' => 1,
                                                   'SDL_Pango' => 1
                                                 },
                                       'links' => [
                                                    '-lSDL',
                                                    '-lSDL_Pango'
                                                  ]
                                     },
                        'Cursor' => {
                                      'defines' => [
                                                     '-DHAVE_SDL'
                                                   ],
                                      'libs' => {
                                                  'SDL' => 1
                                                },
                                      'links' => [
                                                   '-lSDL'
                                                 ]
                                    },
                        'Event' => {
                                     'defines' => [
                                                    '-DHAVE_SDL'
                                                  ],
                                     'libs' => {
                                                 'SDL' => 1
                                               },
                                     'links' => [
                                                  '-lSDL'
                                                ]
                                   },
                        'Events' => {
                                      'defines' => [
                                                     '-DHAVE_SDL'
                                                   ],
                                      'libs' => {
                                                  'SDL' => 1
                                                },
                                      'links' => [
                                                   '-lSDL'
                                                 ]
                                    },
                        'FPSManager' => {
                                          'defines' => [
                                                         '-DHAVE_SDL',
                                                         '-DHAVE_SDL_GFX_FRAMERATE'
                                                       ],
                                          'libs' => {
                                                      'SDL' => 1,
                                                      'SDL_gfx_framerate' => 1
                                                    },
                                          'links' => [
                                                       '-lSDL',
                                                       '-lSDL_gfx'
                                                     ]
                                        },
                        'Framerate' => {
                                         'defines' => [
                                                        '-DHAVE_SDL',
                                                        '-DHAVE_SDL_GFX_FRAMERATE'
                                                      ],
                                         'libs' => {
                                                     'SDL' => 1,
                                                     'SDL_gfx_framerate' => 1
                                                   },
                                         'links' => [
                                                      '-lSDL',
                                                      '-lSDL_gfx'
                                                    ]
                                       },
                        'GFX' => {
                                   'defines' => [
                                                  '-DHAVE_SDL',
                                                  '-DHAVE_SDL_GFX_PRIMITIVES'
                                                ],
                                   'libs' => {
                                               'SDL' => 1,
                                               'SDL_gfx_primitives' => 1
                                             },
                                   'links' => [
                                                '-lSDL',
                                                '-lSDL_gfx'
                                              ]
                                 },
                        'Image' => {
                                     'defines' => [
                                                    '-DHAVE_SDL',
                                                    '-DHAVE_SDL_IMAGE'
                                                  ],
                                     'libs' => {
                                                 'SDL' => 1,
                                                 'SDL_image' => 1
                                               },
                                     'links' => [
                                                  '-lSDL',
                                                  '-lSDL_image'
                                                ]
                                   },
                        'ImageFilter' => {
                                           'defines' => [
                                                          '-DHAVE_SDL',
                                                          '-DHAVE_SDL_GFX_IMAGEFILTER'
                                                        ],
                                           'libs' => {
                                                       'SDL' => 1,
                                                       'SDL_gfx_imagefilter' => 1
                                                     },
                                           'links' => [
                                                        '-lSDL',
                                                        '-lSDL_gfx'
                                                      ]
                                         },
                        'InterfaceX' => {
                                          'defines' => [
                                                         '-DHAVE_SDL'
                                                       ],
                                          'libs' => {
                                                      'SDL' => 1
                                                    },
                                          'links' => [
                                                       '-lSDL'
                                                     ]
                                        },
                        'Joystick' => {
                                        'defines' => [
                                                       '-DHAVE_SDL'
                                                     ],
                                        'libs' => {
                                                    'SDL' => 1
                                                  },
                                        'links' => [
                                                     '-lSDL'
                                                   ]
                                      },
                        'LayerManagerX' => {
                                             'defines' => [
                                                            '-DHAVE_SDL'
                                                          ],
                                             'libs' => {
                                                         'SDL' => 1
                                                       },
                                             'links' => [
                                                          '-lSDL'
                                                        ]
                                           },
                        'LayerX' => {
                                      'defines' => [
                                                     '-DHAVE_SDL',
                                                     '-DHAVE_SDL_IMAGE'
                                                   ],
                                      'libs' => {
                                                  'SDL' => 1,
                                                  'SDL_image' => 1
                                                },
                                      'links' => [
                                                   '-lSDL',
                                                   '-lSDL_image'
                                                 ]
                                    },
                        'MixChunk' => {
                                        'defines' => [
                                                       '-DHAVE_SDL',
                                                       '-DHAVE_SDL_MIXER'
                                                     ],
                                        'libs' => {
                                                    'SDL' => 1,
                                                    'SDL_mixer' => 1
                                                  },
                                        'links' => [
                                                     '-lSDL',
                                                     '-lSDL_mixer'
                                                   ]
                                      },
                        'MixMusic' => {
                                        'defines' => [
                                                       '-DHAVE_SDL',
                                                       '-DHAVE_SDL_MIXER'
                                                     ],
                                        'libs' => {
                                                    'SDL' => 1,
                                                    'SDL_mixer' => 1
                                                  },
                                        'links' => [
                                                     '-lSDL',
                                                     '-lSDL_mixer'
                                                   ]
                                      },
                        'Mixer' => {
                                     'defines' => [
                                                    '-DHAVE_SDL',
                                                    '-DHAVE_SDL_MIXER'
                                                  ],
                                     'libs' => {
                                                 'SDL' => 1,
                                                 'SDL_mixer' => 1
                                               },
                                     'links' => [
                                                  '-lSDL',
                                                  '-lSDL_mixer'
                                                ]
                                   },
                        'MixerChannels' => {
                                             'defines' => [
                                                            '-DHAVE_SDL',
                                                            '-DHAVE_SDL_MIXER'
                                                          ],
                                             'libs' => {
                                                         'SDL' => 1,
                                                         'SDL_mixer' => 1
                                                       },
                                             'links' => [
                                                          '-lSDL',
                                                          '-lSDL_mixer'
                                                        ]
                                           },
                        'MixerEffects' => {
                                            'defines' => [
                                                           '-DHAVE_SDL',
                                                           '-DHAVE_SDL_MIXER'
                                                         ],
                                            'libs' => {
                                                        'SDL' => 1,
                                                        'SDL_mixer' => 1
                                                      },
                                            'links' => [
                                                         '-lSDL',
                                                         '-lSDL_mixer'
                                                       ]
                                          },
                        'MixerGroups' => {
                                           'defines' => [
                                                          '-DHAVE_SDL',
                                                          '-DHAVE_SDL_MIXER'
                                                        ],
                                           'libs' => {
                                                       'SDL' => 1,
                                                       'SDL_mixer' => 1
                                                     },
                                           'links' => [
                                                        '-lSDL',
                                                        '-lSDL_mixer'
                                                      ]
                                         },
                        'MixerMusic' => {
                                          'defines' => [
                                                         '-DHAVE_SDL',
                                                         '-DHAVE_SDL_MIXER'
                                                       ],
                                          'libs' => {
                                                      'SDL' => 1,
                                                      'SDL_mixer' => 1
                                                    },
                                          'links' => [
                                                       '-lSDL',
                                                       '-lSDL_mixer'
                                                     ]
                                        },
                        'MixerSamples' => {
                                            'defines' => [
                                                           '-DHAVE_SDL',
                                                           '-DHAVE_SDL_MIXER'
                                                         ],
                                            'libs' => {
                                                        'SDL' => 1,
                                                        'SDL_mixer' => 1
                                                      },
                                            'links' => [
                                                         '-lSDL',
                                                         '-lSDL_mixer'
                                                       ]
                                          },
                        'Mouse' => {
                                     'defines' => [
                                                    '-DHAVE_SDL'
                                                  ],
                                     'libs' => {
                                                 'SDL' => 1
                                               },
                                     'links' => [
                                                  '-lSDL'
                                                ]
                                   },
                        'MultiThread' => {
                                           'defines' => [
                                                          '-DHAVE_SDL'
                                                        ],
                                           'libs' => {
                                                       'SDL' => 1
                                                     },
                                           'links' => [
                                                        '-lSDL'
                                                      ]
                                         },
                        'Overlay' => {
                                       'defines' => [
                                                      '-DHAVE_SDL'
                                                    ],
                                       'libs' => {
                                                   'SDL' => 1
                                                 },
                                       'links' => [
                                                    '-lSDL'
                                                  ]
                                     },
                        'Palette' => {
                                       'defines' => [
                                                      '-DHAVE_SDL'
                                                    ],
                                       'libs' => {
                                                   'SDL' => 1
                                                 },
                                       'links' => [
                                                    '-lSDL'
                                                  ]
                                     },
                        'Pango' => {
                                     'defines' => [
                                                    '-DHAVE_SDL',
                                                    '-DHAVE_SDL_PANGO'
                                                  ],
                                     'libs' => {
                                                 'SDL' => 1,
                                                 'SDL_Pango' => 1
                                               },
                                     'links' => [
                                                  '-lSDL',
                                                  '-lSDL_Pango'
                                                ]
                                   },
                        'PixelFormat' => {
                                           'defines' => [
                                                          '-DHAVE_SDL'
                                                        ],
                                           'libs' => {
                                                       'SDL' => 1
                                                     },
                                           'links' => [
                                                        '-lSDL'
                                                      ]
                                         },
                        'Primitives' => {
                                          'defines' => [
                                                         '-DHAVE_SDL',
                                                         '-DHAVE_SDL_GFX_PRIMITIVES'
                                                       ],
                                          'libs' => {
                                                      'SDL' => 1,
                                                      'SDL_gfx_primitives' => 1
                                                    },
                                          'links' => [
                                                       '-lSDL',
                                                       '-lSDL_gfx'
                                                     ]
                                        },
                        'RWOps' => {
                                     'defines' => [
                                                    '-DHAVE_SDL'
                                                  ],
                                     'libs' => {
                                                 'SDL' => 1
                                               },
                                     'links' => [
                                                  '-lSDL'
                                                ]
                                   },
                        'Rect' => {
                                    'defines' => [
                                                   '-DHAVE_SDL'
                                                 ],
                                    'libs' => {
                                                'SDL' => 1
                                              },
                                    'links' => [
                                                 '-lSDL'
                                               ]
                                  },
                        'Rotozoom' => {
                                        'defines' => [
                                                       '-DHAVE_SDL',
                                                       '-DHAVE_SDL_GFX_ROTOZOOM'
                                                     ],
                                        'libs' => {
                                                    'SDL' => 1,
                                                    'SDL_gfx_rotozoom' => 1
                                                  },
                                        'links' => [
                                                     '-lSDL',
                                                     '-lSDL_gfx'
                                                   ]
                                      },
                        'SDL' => {
                                   'defines' => [
                                                  '-DHAVE_SDL'
                                                ],
                                   'libs' => {
                                               'SDL' => 1
                                             },
                                   'links' => [
                                                '-lSDL'
                                              ]
                                 },
                        'SFont' => {
                                     'defines' => [
                                                    '-DHAVE_SDL',
                                                    '-DHAVE_SDL_IMAGE'
                                                  ],
                                     'libs' => {
                                                 'SDL' => 1,
                                                 'SDL_image' => 1
                                               },
                                     'links' => [
                                                  '-lSDL',
                                                  '-lSDL_image'
                                                ]
                                   },
                        'StateX' => {
                                      'defines' => [
                                                     '-DHAVE_SDL'
                                                   ],
                                      'libs' => {
                                                  'SDL' => 1
                                                },
                                      'links' => [
                                                   '-lSDL'
                                                 ]
                                    },
                        'Surface' => {
                                       'defines' => [
                                                      '-DHAVE_SDL'
                                                    ],
                                       'libs' => {
                                                   'SDL' => 1
                                                 },
                                       'links' => [
                                                    '-lSDL'
                                                  ]
                                     },
                        'SurfaceX' => {
                                        'defines' => [
                                                       '-DHAVE_SDL',
                                                       '-DHAVE_SDL_GFX_PRIMITIVES'
                                                     ],
                                        'libs' => {
                                                    'SDL' => 1,
                                                    'SDL_gfx_primitives' => 1
                                                  },
                                        'links' => [
                                                     '-lSDL',
                                                     '-lSDL_gfx'
                                                   ]
                                      },
                        'TTF' => {
                                   'defines' => [
                                                  '-DHAVE_SDL',
                                                  '-DHAVE_SDL_TTF'
                                                ],
                                   'libs' => {
                                               'SDL' => 1,
                                               'SDL_ttf' => 1
                                             },
                                   'links' => [
                                                '-lSDL',
                                                '-lSDL_ttf'
                                              ]
                                 },
                        'TTF_Font' => {
                                        'defines' => [
                                                       '-DHAVE_SDL',
                                                       '-DHAVE_SDL_TTF'
                                                     ],
                                        'libs' => {
                                                    'SDL' => 1,
                                                    'SDL_ttf' => 1
                                                  },
                                        'links' => [
                                                     '-lSDL',
                                                     '-lSDL_ttf'
                                                   ]
                                      },
                        'Time' => {
                                    'defines' => [
                                                   '-DHAVE_SDL'
                                                 ],
                                    'libs' => {
                                                'SDL' => 1
                                              },
                                    'links' => [
                                                 '-lSDL'
                                               ]
                                  },
                        'TimerX' => {
                                      'defines' => [
                                                     '-DHAVE_SDL'
                                                   ],
                                      'libs' => {
                                                  'SDL' => 1
                                                },
                                      'links' => [
                                                   '-lSDL'
                                                 ]
                                    },
                        'ValidateX' => {
                                         'defines' => [
                                                        '-DHAVE_SDL'
                                                      ],
                                         'libs' => {
                                                     'SDL' => 1
                                                   },
                                         'links' => [
                                                      '-lSDL'
                                                    ]
                                       },
                        'Version' => {
                                       'defines' => [
                                                      '-DHAVE_SDL'
                                                    ],
                                       'libs' => {
                                                   'SDL' => 1
                                                 },
                                       'links' => [
                                                    '-lSDL'
                                                  ]
                                     },
                        'Video' => {
                                     'defines' => [
                                                    '-DHAVE_SDL'
                                                  ],
                                     'libs' => {
                                                 'SDL' => 1
                                               },
                                     'links' => [
                                                  '-lSDL'
                                                ]
                                   },
                        'VideoInfo' => {
                                         'defines' => [
                                                        '-DHAVE_SDL'
                                                      ],
                                         'libs' => {
                                                     'SDL' => 1
                                                   },
                                         'links' => [
                                                      '-lSDL'
                                                    ]
                                       }
                      },
         'SDL_lib_translate' => {
                                  'SDL::Audio' => [
                                                    'SDL'
                                                  ],
                                  'SDL::AudioCVT' => [
                                                       'SDL'
                                                     ],
                                  'SDL::AudioSpec' => [
                                                        'SDL'
                                                      ],
                                  'SDL::CD' => [
                                                 'SDL'
                                               ],
                                  'SDL::CDROM' => [
                                                    'SDL'
                                                  ],
                                  'SDL::CDTrack' => [
                                                      'SDL'
                                                    ],
                                  'SDL::Color' => [
                                                    'SDL'
                                                  ],
                                  'SDL::Cursor' => [
                                                     'SDL'
                                                   ],
                                  'SDL::Event' => [
                                                    'SDL'
                                                  ],
                                  'SDL::Events' => [
                                                     'SDL'
                                                   ],
                                  'SDL::GFX' => [
                                                  'SDL',
                                                  'SDL_gfx'
                                                ],
                                  'SDL::GFX::BlitFunc' => [
                                                            'SDL',
                                                            'SDL_gfx'
                                                          ],
                                  'SDL::GFX::FPSManager' => [
                                                              'SDL',
                                                              'SDL_gfx'
                                                            ],
                                  'SDL::GFX::Framerate' => [
                                                             'SDL',
                                                             'SDL_gfx'
                                                           ],
                                  'SDL::GFX::ImageFilter' => [
                                                               'SDL',
                                                               'SDL_gfx'
                                                             ],
                                  'SDL::GFX::Primitives' => [
                                                              'SDL',
                                                              'SDL_gfx'
                                                            ],
                                  'SDL::GFX::Rotozoom' => [
                                                            'SDL',
                                                            'SDL_gfx'
                                                          ],
                                  'SDL::Image' => [
                                                    'SDL',
                                                    'SDL_image'
                                                  ],
                                  'SDL::Joystick' => [
                                                       'SDL'
                                                     ],
                                  'SDL::Mixer' => [
                                                    'SDL',
                                                    'SDL_mixer'
                                                  ],
                                  'SDL::Mixer::Channels' => [
                                                              'SDL',
                                                              'SDL_mixer'
                                                            ],
                                  'SDL::Mixer::Effects' => [
                                                             'SDL',
                                                             'SDL_mixer'
                                                           ],
                                  'SDL::Mixer::Groups' => [
                                                            'SDL',
                                                            'SDL_mixer'
                                                          ],
                                  'SDL::Mixer::MixChunk' => [
                                                              'SDL',
                                                              'SDL_mixer'
                                                            ],
                                  'SDL::Mixer::MixMusic' => [
                                                              'SDL',
                                                              'SDL_mixer'
                                                            ],
                                  'SDL::Mixer::Music' => [
                                                           'SDL',
                                                           'SDL_mixer'
                                                         ],
                                  'SDL::Mixer::Samples' => [
                                                             'SDL',
                                                             'SDL_mixer'
                                                           ],
                                  'SDL::Mouse' => [
                                                    'SDL'
                                                  ],
                                  'SDL::MultiThread' => [
                                                          'SDL'
                                                        ],
                                  'SDL::Overlay' => [
                                                      'SDL'
                                                    ],
                                  'SDL::Palette' => [
                                                      'SDL'
                                                    ],
                                  'SDL::Pango' => [
                                                    'SDL',
                                                    'SDL_Pango'
                                                  ],
                                  'SDL::Pango::Context' => [
                                                             'SDL',
                                                             'SDL_Pango'
                                                           ],
                                  'SDL::PixelFormat' => [
                                                          'SDL'
                                                        ],
                                  'SDL::RWOps' => [
                                                    'SDL'
                                                  ],
                                  'SDL::Rect' => [
                                                   'SDL'
                                                 ],
                                  'SDL::Surface' => [
                                                      'SDL'
                                                    ],
                                  'SDL::TTF' => [
                                                  'SDL',
                                                  'SDL_ttf'
                                                ],
                                  'SDL::TTF::Font' => [
                                                        'SDL',
                                                        'SDL_ttf'
                                                      ],
                                  'SDL::Time' => [
                                                   'SDL'
                                                 ],
                                  'SDL::Version' => [
                                                      'SDL'
                                                    ],
                                  'SDL::Video' => [
                                                    'SDL'
                                                  ],
                                  'SDL::VideoInfo' => [
                                                        'SDL'
                                                      ],
                                  'SDL_perl' => [
                                                  'SDL'
                                                ],
                                  'SDLx::Controller::Interface' => [
                                                                     'SDL'
                                                                   ],
                                  'SDLx::Controller::State' => [
                                                                 'SDL'
                                                               ],
                                  'SDLx::Controller::Timer' => [
                                                                 'SDL'
                                                               ],
                                  'SDLx::Layer' => [
                                                     'SDL',
                                                     'SDL_image'
                                                   ],
                                  'SDLx::LayerManager' => [
                                                            'SDL'
                                                          ],
                                  'SDLx::SFont' => [
                                                     'SDL',
                                                     'SDL_image'
                                                   ],
                                  'SDLx::Surface' => [
                                                       'SDL',
                                                       'SDL_gfx'
                                                     ],
                                  'SDLx::Validate' => [
                                                        'SDL'
                                                      ]
                                },
         'libraries' => {
                          'GL' => {
                                    'define' => 'HAVE_GL',
                                    'header' => [
                                                  'GL/gl.h',
                                                  'GL/glext.h'
                                                ],
                                    'lib' => 'GL'
                                  },
                          'GLU' => {
                                     'define' => 'HAVE_GLU',
                                     'header' => 'GL/glu.h',
                                     'lib' => 'GLU'
                                   },
                          'SDL' => {
                                     'define' => 'HAVE_SDL',
                                     'header' => 'SDL.h',
                                     'lib' => 'SDL'
                                   },
                          'SDL_Pango' => {
                                           'define' => 'HAVE_SDL_PANGO',
                                           'header' => 'SDL_Pango.h',
                                           'lib' => 'SDL_Pango'
                                         },
                          'SDL_gfx' => {
                                         'define' => 'HAVE_SDL_GFX',
                                         'header' => 'SDL_gfxPrimitives.h',
                                         'lib' => 'SDL_gfx'
                                       },
                          'SDL_gfx_blitfunc' => {
                                                  'define' => 'HAVE_SDL_GFX_BLITFUNC',
                                                  'header' => 'SDL_gfxBlitFunc.h',
                                                  'lib' => 'SDL_gfx'
                                                },
                          'SDL_gfx_framerate' => {
                                                   'define' => 'HAVE_SDL_GFX_FRAMERATE',
                                                   'header' => 'SDL_framerate.h',
                                                   'lib' => 'SDL_gfx'
                                                 },
                          'SDL_gfx_imagefilter' => {
                                                     'define' => 'HAVE_SDL_GFX_IMAGEFILTER',
                                                     'header' => 'SDL_imageFilter.h',
                                                     'lib' => 'SDL_gfx'
                                                   },
                          'SDL_gfx_primitives' => {
                                                    'define' => 'HAVE_SDL_GFX_PRIMITIVES',
                                                    'header' => 'SDL_gfxPrimitives.h',
                                                    'lib' => 'SDL_gfx'
                                                  },
                          'SDL_gfx_rotozoom' => {
                                                  'define' => 'HAVE_SDL_GFX_ROTOZOOM',
                                                  'header' => 'SDL_rotozoom.h',
                                                  'lib' => 'SDL_gfx'
                                                },
                          'SDL_image' => {
                                           'define' => 'HAVE_SDL_IMAGE',
                                           'header' => 'SDL_image.h',
                                           'lib' => 'SDL_image'
                                         },
                          'SDL_mixer' => {
                                           'define' => 'HAVE_SDL_MIXER',
                                           'header' => 'SDL_mixer.h',
                                           'lib' => 'SDL_mixer'
                                         },
                          'SDL_ttf' => {
                                         'define' => 'HAVE_SDL_TTF',
                                         'header' => 'SDL_ttf.h',
                                         'lib' => 'SDL_ttf'
                                       },
                          'jpeg' => {
                                      'define' => 'HAVE_JPEG',
                                      'header' => 'jpeglib.h',
                                      'lib' => 'jpeg'
                                    },
                          'png' => {
                                     'define' => 'HAVE_PNG',
                                     'header' => 'png.h',
                                     'lib' => 'png'
                                   },
                          'smpeg' => {
                                       'define' => 'HAVE_SMPEG',
                                       'header' => 'smpeg/smpeg.h',
                                       'lib' => 'smpeg'
                                     },
                          'tiff' => {
                                      'define' => 'HAVE_TIFF',
                                      'header' => 'tiff.h',
                                      'lib' => 'tiff'
                                    }
                        },
         'subsystems' => {
                           'Audio' => {
                                        'file' => {
                                                    'from' => 'src/Core/Audio.xs',
                                                    'to' => 'lib/SDL/Audio.xs'
                                                  },
                                        'libraries' => [
                                                         'SDL'
                                                       ]
                                      },
                           'AudioCVT' => {
                                           'file' => {
                                                       'from' => 'src/Core/objects/AudioCVT.xs',
                                                       'to' => 'lib/SDL/AudioCVT.xs'
                                                     },
                                           'libraries' => [
                                                            'SDL'
                                                          ]
                                         },
                           'AudioSpec' => {
                                            'file' => {
                                                        'from' => 'src/Core/objects/AudioSpec.xs',
                                                        'to' => 'lib/SDL/AudioSpec.xs'
                                                      },
                                            'libraries' => [
                                                             'SDL'
                                                           ]
                                          },
                           'BlitFunc' => {
                                           'file' => {
                                                       'from' => 'src/GFX/BlitFunc.xs',
                                                       'to' => 'lib/SDL/GFX/BlitFunc.xs'
                                                     },
                                           'libraries' => [
                                                            'SDL',
                                                            'SDL_gfx_blitfunc'
                                                          ]
                                         },
                           'CD' => {
                                     'file' => {
                                                 'from' => 'src/Core/objects/CD.xs',
                                                 'to' => 'lib/SDL/CD.xs'
                                               },
                                     'libraries' => [
                                                      'SDL'
                                                    ]
                                   },
                           'CDROM' => {
                                        'file' => {
                                                    'from' => 'src/Core/CDROM.xs',
                                                    'to' => 'lib/SDL/CDROM.xs'
                                                  },
                                        'libraries' => [
                                                         'SDL'
                                                       ]
                                      },
                           'CDTrack' => {
                                          'file' => {
                                                      'from' => 'src/Core/objects/CDTrack.xs',
                                                      'to' => 'lib/SDL/CDTrack.xs'
                                                    },
                                          'libraries' => [
                                                           'SDL'
                                                         ]
                                        },
                           'Color' => {
                                        'file' => {
                                                    'from' => 'src/Core/objects/Color.xs',
                                                    'to' => 'lib/SDL/Color.xs'
                                                  },
                                        'libraries' => [
                                                         'SDL'
                                                       ]
                                      },
                           'Context' => {
                                          'file' => {
                                                      'from' => 'src/Pango/objects/Context.xs',
                                                      'to' => 'lib/SDL/Pango/Context.xs'
                                                    },
                                          'libraries' => [
                                                           'SDL',
                                                           'SDL_Pango'
                                                         ]
                                        },
                           'Cursor' => {
                                         'file' => {
                                                     'from' => 'src/Core/objects/Cursor.xs',
                                                     'to' => 'lib/SDL/Cursor.xs'
                                                   },
                                         'libraries' => [
                                                          'SDL'
                                                        ]
                                       },
                           'Event' => {
                                        'file' => {
                                                    'from' => 'src/Core/objects/Event.xs',
                                                    'to' => 'lib/SDL/Event.xs'
                                                  },
                                        'libraries' => [
                                                         'SDL'
                                                       ]
                                      },
                           'Events' => {
                                         'file' => {
                                                     'from' => 'src/Core/Events.xs',
                                                     'to' => 'lib/SDL/Events.xs'
                                                   },
                                         'libraries' => [
                                                          'SDL'
                                                        ]
                                       },
                           'FPSManager' => {
                                             'file' => {
                                                         'from' => 'src/GFX/FPSManager.xs',
                                                         'to' => 'lib/SDL/GFX/FPSManager.xs'
                                                       },
                                             'libraries' => [
                                                              'SDL',
                                                              'SDL_gfx_framerate'
                                                            ]
                                           },
                           'Framerate' => {
                                            'file' => {
                                                        'from' => 'src/GFX/Framerate.xs',
                                                        'to' => 'lib/SDL/GFX/Framerate.xs'
                                                      },
                                            'libraries' => [
                                                             'SDL',
                                                             'SDL_gfx_framerate'
                                                           ]
                                          },
                           'GFX' => {
                                      'file' => {
                                                  'from' => 'src/GFX/GFX.xs',
                                                  'to' => 'lib/SDL/GFX.xs'
                                                },
                                      'libraries' => [
                                                       'SDL',
                                                       'SDL_gfx_primitives'
                                                     ]
                                    },
                           'Image' => {
                                        'file' => {
                                                    'from' => 'src/Image.xs',
                                                    'to' => 'lib/SDL/Image.xs'
                                                  },
                                        'libraries' => [
                                                         'SDL',
                                                         'SDL_image'
                                                       ]
                                      },
                           'ImageFilter' => {
                                              'file' => {
                                                          'from' => 'src/GFX/ImageFilter.xs',
                                                          'to' => 'lib/SDL/GFX/ImageFilter.xs'
                                                        },
                                              'libraries' => [
                                                               'SDL',
                                                               'SDL_gfx_imagefilter'
                                                             ]
                                            },
                           'InterfaceX' => {
                                             'file' => {
                                                         'from' => 'src/SDLx/Controller/Interface.xs',
                                                         'to' => 'lib/SDLx/Controller/Interface.xs'
                                                       },
                                             'libraries' => [
                                                              'SDL'
                                                            ]
                                           },
                           'Joystick' => {
                                           'file' => {
                                                       'from' => 'src/Core/Joystick.xs',
                                                       'to' => 'lib/SDL/Joystick.xs'
                                                     },
                                           'libraries' => [
                                                            'SDL'
                                                          ]
                                         },
                           'LayerManagerX' => {
                                                'file' => {
                                                            'from' => 'src/SDLx/LayerManager.xs',
                                                            'to' => 'lib/SDLx/LayerManager.xs'
                                                          },
                                                'libraries' => [
                                                                 'SDL'
                                                               ]
                                              },
                           'LayerX' => {
                                         'file' => {
                                                     'from' => 'src/SDLx/Layer.xs',
                                                     'to' => 'lib/SDLx/Layer.xs'
                                                   },
                                         'libraries' => [
                                                          'SDL',
                                                          'SDL_image'
                                                        ]
                                       },
                           'MixChunk' => {
                                           'file' => {
                                                       'from' => 'src/Mixer/objects/MixChunk.xs',
                                                       'to' => 'lib/SDL/Mixer/MixChunk.xs'
                                                     },
                                           'libraries' => [
                                                            'SDL',
                                                            'SDL_mixer'
                                                          ]
                                         },
                           'MixMusic' => {
                                           'file' => {
                                                       'from' => 'src/Mixer/objects/MixMusic.xs',
                                                       'to' => 'lib/SDL/Mixer/MixMusic.xs'
                                                     },
                                           'libraries' => [
                                                            'SDL',
                                                            'SDL_mixer'
                                                          ]
                                         },
                           'Mixer' => {
                                        'file' => {
                                                    'from' => 'src/Mixer/Mixer.xs',
                                                    'to' => 'lib/SDL/Mixer.xs'
                                                  },
                                        'libraries' => [
                                                         'SDL',
                                                         'SDL_mixer'
                                                       ]
                                      },
                           'MixerChannels' => {
                                                'file' => {
                                                            'from' => 'src/Mixer/Channels.xs',
                                                            'to' => 'lib/SDL/Mixer/Channels.xs'
                                                          },
                                                'libraries' => [
                                                                 'SDL',
                                                                 'SDL_mixer'
                                                               ]
                                              },
                           'MixerEffects' => {
                                               'file' => {
                                                           'from' => 'src/Mixer/Effects.xs',
                                                           'to' => 'lib/SDL/Mixer/Effects.xs'
                                                         },
                                               'libraries' => [
                                                                'SDL',
                                                                'SDL_mixer'
                                                              ]
                                             },
                           'MixerGroups' => {
                                              'file' => {
                                                          'from' => 'src/Mixer/Groups.xs',
                                                          'to' => 'lib/SDL/Mixer/Groups.xs'
                                                        },
                                              'libraries' => [
                                                               'SDL',
                                                               'SDL_mixer'
                                                             ]
                                            },
                           'MixerMusic' => {
                                             'file' => {
                                                         'from' => 'src/Mixer/Music.xs',
                                                         'to' => 'lib/SDL/Mixer/Music.xs'
                                                       },
                                             'libraries' => [
                                                              'SDL',
                                                              'SDL_mixer'
                                                            ]
                                           },
                           'MixerSamples' => {
                                               'file' => {
                                                           'from' => 'src/Mixer/Samples.xs',
                                                           'to' => 'lib/SDL/Mixer/Samples.xs'
                                                         },
                                               'libraries' => [
                                                                'SDL',
                                                                'SDL_mixer'
                                                              ]
                                             },
                           'Mouse' => {
                                        'file' => {
                                                    'from' => 'src/Core/Mouse.xs',
                                                    'to' => 'lib/SDL/Mouse.xs'
                                                  },
                                        'libraries' => [
                                                         'SDL'
                                                       ]
                                      },
                           'MultiThread' => {
                                              'file' => {
                                                          'from' => 'src/Core/MultiThread.xs',
                                                          'to' => 'lib/SDL/MultiThread.xs'
                                                        },
                                              'libraries' => [
                                                               'SDL'
                                                             ]
                                            },
                           'Overlay' => {
                                          'file' => {
                                                      'from' => 'src/Core/objects/Overlay.xs',
                                                      'to' => 'lib/SDL/Overlay.xs'
                                                    },
                                          'libraries' => [
                                                           'SDL'
                                                         ]
                                        },
                           'Palette' => {
                                          'file' => {
                                                      'from' => 'src/Core/objects/Palette.xs',
                                                      'to' => 'lib/SDL/Palette.xs'
                                                    },
                                          'libraries' => [
                                                           'SDL'
                                                         ]
                                        },
                           'Pango' => {
                                        'file' => {
                                                    'from' => 'src/Pango/Pango.xs',
                                                    'to' => 'lib/SDL/Pango.xs'
                                                  },
                                        'libraries' => [
                                                         'SDL',
                                                         'SDL_Pango'
                                                       ]
                                      },
                           'PixelFormat' => {
                                              'file' => {
                                                          'from' => 'src/Core/objects/PixelFormat.xs',
                                                          'to' => 'lib/SDL/PixelFormat.xs'
                                                        },
                                              'libraries' => [
                                                               'SDL'
                                                             ]
                                            },
                           'Primitives' => {
                                             'file' => {
                                                         'from' => 'src/GFX/Primitives.xs',
                                                         'to' => 'lib/SDL/GFX/Primitives.xs'
                                                       },
                                             'libraries' => [
                                                              'SDL',
                                                              'SDL_gfx_primitives'
                                                            ]
                                           },
                           'RWOps' => {
                                        'file' => {
                                                    'from' => 'src/Core/objects/RWOps.xs',
                                                    'to' => 'lib/SDL/RWOps.xs'
                                                  },
                                        'libraries' => [
                                                         'SDL'
                                                       ]
                                      },
                           'Rect' => {
                                       'file' => {
                                                   'from' => 'src/Core/objects/Rect.xs',
                                                   'to' => 'lib/SDL/Rect.xs'
                                                 },
                                       'libraries' => [
                                                        'SDL'
                                                      ]
                                     },
                           'Rotozoom' => {
                                           'file' => {
                                                       'from' => 'src/GFX/Rotozoom.xs',
                                                       'to' => 'lib/SDL/GFX/Rotozoom.xs'
                                                     },
                                           'libraries' => [
                                                            'SDL',
                                                            'SDL_gfx_rotozoom'
                                                          ]
                                         },
                           'SDL' => {
                                      'file' => {
                                                  'from' => 'src/SDL.xs',
                                                  'to' => 'lib/SDL_perl.xs'
                                                },
                                      'libraries' => [
                                                       'SDL'
                                                     ]
                                    },
                           'SFont' => {
                                        'file' => {
                                                    'from' => 'src/SDLx/SFont.xs',
                                                    'to' => 'lib/SDLx/SFont.xs'
                                                  },
                                        'libraries' => [
                                                         'SDL',
                                                         'SDL_image'
                                                       ]
                                      },
                           'StateX' => {
                                         'file' => {
                                                     'from' => 'src/SDLx/Controller/State.xs',
                                                     'to' => 'lib/SDLx/Controller/State.xs'
                                                   },
                                         'libraries' => [
                                                          'SDL'
                                                        ]
                                       },
                           'Surface' => {
                                          'file' => {
                                                      'from' => 'src/Core/objects/Surface.xs',
                                                      'to' => 'lib/SDL/Surface.xs'
                                                    },
                                          'libraries' => [
                                                           'SDL'
                                                         ]
                                        },
                           'SurfaceX' => {
                                           'file' => {
                                                       'from' => 'src/SDLx/Surface.xs',
                                                       'to' => 'lib/SDLx/Surface.xs'
                                                     },
                                           'libraries' => [
                                                            'SDL',
                                                            'SDL_gfx_primitives'
                                                          ]
                                         },
                           'TTF' => {
                                      'file' => {
                                                  'from' => 'src/TTF/TTF.xs',
                                                  'to' => 'lib/SDL/TTF.xs'
                                                },
                                      'libraries' => [
                                                       'SDL',
                                                       'SDL_ttf'
                                                     ]
                                    },
                           'TTF_Font' => {
                                           'file' => {
                                                       'from' => 'src/TTF/objects/Font.xs',
                                                       'to' => 'lib/SDL/TTF/Font.xs'
                                                     },
                                           'libraries' => [
                                                            'SDL',
                                                            'SDL_ttf'
                                                          ]
                                         },
                           'Time' => {
                                       'file' => {
                                                   'from' => 'src/Core/Time.xs',
                                                   'to' => 'lib/SDL/Time.xs'
                                                 },
                                       'libraries' => [
                                                        'SDL'
                                                      ]
                                     },
                           'TimerX' => {
                                         'file' => {
                                                     'from' => 'src/SDLx/Timer.xs',
                                                     'to' => 'lib/SDLx/Controller/Timer.xs'
                                                   },
                                         'libraries' => [
                                                          'SDL'
                                                        ]
                                       },
                           'ValidateX' => {
                                            'file' => {
                                                        'from' => 'src/SDLx/Validate.xs',
                                                        'to' => 'lib/SDLx/Validate.xs'
                                                      },
                                            'libraries' => [
                                                             'SDL'
                                                           ]
                                          },
                           'Version' => {
                                          'file' => {
                                                      'from' => 'src/Core/objects/Version.xs',
                                                      'to' => 'lib/SDL/Version.xs'
                                                    },
                                          'libraries' => [
                                                           'SDL'
                                                         ]
                                        },
                           'Video' => {
                                        'file' => {
                                                    'from' => 'src/Core/Video.xs',
                                                    'to' => 'lib/SDL/Video.xs'
                                                  },
                                        'libraries' => [
                                                         'SDL'
                                                       ]
                                      },
                           'VideoInfo' => {
                                            'file' => {
                                                        'from' => 'src/Core/objects/VideoInfo.xs',
                                                        'to' => 'lib/SDL/VideoInfo.xs'
                                                      },
                                            'libraries' => [
                                                             'SDL'
                                                           ]
                                          }
                         }
       },
       {},
       {}
     ];
$x; }