/*
 * Decompiled with CFR 0.152.
 */
package jakarta.websocket;

import aQute.bnd.annotation.spi.ServiceConsumer;
import jakarta.websocket.WebSocketContainer;
import java.util.Iterator;
import java.util.ServiceLoader;

@ServiceConsumer(value=ContainerProvider.class)
public abstract class ContainerProvider {
    private static final String DEFAULT_PROVIDER_CLASS_NAME = "org.apache.tomcat.websocket.WsWebSocketContainer";

    public static WebSocketContainer getWebSocketContainer() {
        WebSocketContainer webSocketContainer = null;
        ServiceLoader<ContainerProvider> serviceLoader = ServiceLoader.load(ContainerProvider.class);
        Iterator<ContainerProvider> iterator = serviceLoader.iterator();
        while (webSocketContainer == null && iterator.hasNext()) {
            webSocketContainer = iterator.next().getContainer();
        }
        if (webSocketContainer == null) {
            try {
                Class<?> clazz = Class.forName(DEFAULT_PROVIDER_CLASS_NAME);
                webSocketContainer = (WebSocketContainer)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalArgumentException | ReflectiveOperationException | SecurityException exception) {
                // empty catch block
            }
        }
        return webSocketContainer;
    }

    protected abstract WebSocketContainer getContainer();
}

