/*
 * Decompiled with CFR 0.152.
 */
package org.apache.el.parser;

import org.apache.el.parser.Token;

public class ParseException
extends Exception {
    private static final long serialVersionUID = 1L;
    public Token currentToken;
    public int[][] expectedTokenSequences;
    public String[] tokenImage;

    public ParseException(Token token, int[][] nArray, String[] stringArray) {
        super(ParseException.initialise(token, nArray, stringArray));
        this.currentToken = token;
        this.expectedTokenSequences = nArray;
        this.tokenImage = stringArray;
    }

    public ParseException() {
    }

    public ParseException(String string) {
        super(string);
    }

    private static String initialise(Token token, int[][] nArray, String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            if (n < nArray[i].length) {
                n = nArray[i].length;
            }
            for (int j = 0; j < nArray[i].length; ++j) {
                stringBuffer.append(stringArray[nArray[i][j]]).append(' ');
            }
            if (nArray[i][nArray[i].length - 1] != 0) {
                stringBuffer.append("...");
            }
            stringBuffer.append(System.lineSeparator()).append("    ");
        }
        String string = "Encountered \"";
        Token token2 = token.next;
        for (int i = 0; i < n; ++i) {
            if (i != 0) {
                string = string + " ";
            }
            if (token2.kind == 0) {
                string = string + stringArray[0];
                break;
            }
            string = string + " " + stringArray[token2.kind];
            string = string + " \"";
            string = string + ParseException.add_escapes(token2.image);
            string = string + " \"";
            token2 = token2.next;
        }
        string = string + "\" at line " + token.next.beginLine + ", column " + token.next.beginColumn;
        string = string + "." + System.lineSeparator();
        string = nArray.length == 1 ? string + "Was expecting:" + System.lineSeparator() + "    " : string + "Was expecting one of:" + System.lineSeparator() + "    ";
        string = string + stringBuffer.toString();
        return string;
    }

    static String add_escapes(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        block11: for (int i = 0; i < string.length(); ++i) {
            switch (string.charAt(i)) {
                case '\u0000': {
                    continue block11;
                }
                case '\b': {
                    stringBuffer.append("\\b");
                    continue block11;
                }
                case '\t': {
                    stringBuffer.append("\\t");
                    continue block11;
                }
                case '\n': {
                    stringBuffer.append("\\n");
                    continue block11;
                }
                case '\f': {
                    stringBuffer.append("\\f");
                    continue block11;
                }
                case '\r': {
                    stringBuffer.append("\\r");
                    continue block11;
                }
                case '\"': {
                    stringBuffer.append("\\\"");
                    continue block11;
                }
                case '\'': {
                    stringBuffer.append("\\'");
                    continue block11;
                }
                case '\\': {
                    stringBuffer.append("\\\\");
                    continue block11;
                }
                default: {
                    char c = string.charAt(i);
                    if (c < ' ' || c > '~') {
                        String string2 = "0000" + Integer.toString(c, 16);
                        stringBuffer.append("\\u" + string2.substring(string2.length() - 4, string2.length()));
                        continue block11;
                    }
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }
}

