/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.filters;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.http.FastHttpDateFormat;
import org.apache.tomcat.util.http.parser.Host;
import org.apache.tomcat.util.res.StringManager;

public class RemoteIpFilter
implements Filter {
    private static final Pattern commaSeparatedValuesPattern = Pattern.compile("\\s*,\\s*");
    protected static final String HTTP_SERVER_PORT_PARAMETER = "httpServerPort";
    protected static final String HTTPS_SERVER_PORT_PARAMETER = "httpsServerPort";
    protected static final String INTERNAL_PROXIES_PARAMETER = "internalProxies";
    private final Log log = LogFactory.getLog(RemoteIpFilter.class);
    protected static final StringManager sm = StringManager.getManager(RemoteIpFilter.class);
    protected static final String PROTOCOL_HEADER_PARAMETER = "protocolHeader";
    protected static final String PROTOCOL_HEADER_HTTPS_VALUE_PARAMETER = "protocolHeaderHttpsValue";
    protected static final String HOST_HEADER_PARAMETER = "hostHeader";
    protected static final String PORT_HEADER_PARAMETER = "portHeader";
    protected static final String CHANGE_LOCAL_NAME_PARAMETER = "changeLocalName";
    protected static final String CHANGE_LOCAL_PORT_PARAMETER = "changeLocalPort";
    protected static final String PROXIES_HEADER_PARAMETER = "proxiesHeader";
    protected static final String REMOTE_IP_HEADER_PARAMETER = "remoteIpHeader";
    protected static final String TRUSTED_PROXIES_PARAMETER = "trustedProxies";
    private int httpServerPort = 80;
    private int httpsServerPort = 443;
    private Pattern internalProxies = Pattern.compile("10\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}|192\\.168\\.\\d{1,3}\\.\\d{1,3}|169\\.254\\.\\d{1,3}\\.\\d{1,3}|127\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}|0:0:0:0:0:0:0:1|::1");
    private String protocolHeader = "X-Forwarded-Proto";
    private String protocolHeaderHttpsValue = "https";
    private String hostHeader = null;
    private boolean changeLocalName = false;
    private String portHeader = null;
    private boolean changeLocalPort = false;
    private String proxiesHeader = "X-Forwarded-By";
    private String remoteIpHeader = "X-Forwarded-For";
    private boolean requestAttributesEnabled = true;
    private Pattern trustedProxies = null;

    protected static String[] commaDelimitedListToStringArray(String string) {
        return string == null || string.length() == 0 ? new String[]{} : commaSeparatedValuesPattern.split(string);
    }

    protected static String listToCommaDelimitedString(List<String> list) {
        if (list == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<String> iterator = list.iterator();
        while (iterator.hasNext()) {
            String string = iterator.next();
            if (string == null) continue;
            stringBuilder.append((Object)string);
            if (!iterator.hasNext()) continue;
            stringBuilder.append(", ");
        }
        return stringBuilder.toString();
    }

    public void destroy() {
    }

    public void doFilter(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain filterChain) throws IOException, ServletException {
        boolean bl;
        boolean bl2 = bl = this.internalProxies != null && this.internalProxies.matcher(httpServletRequest.getRemoteAddr()).matches();
        if (bl || this.trustedProxies != null && this.trustedProxies.matcher(httpServletRequest.getRemoteAddr()).matches()) {
            String string;
            Object object;
            Object object2;
            int n;
            Object object3 = null;
            LinkedList<String> linkedList = new LinkedList<String>();
            StringBuilder stringBuilder = new StringBuilder();
            String[] stringArray = httpServletRequest.getHeaders(this.remoteIpHeader);
            while (stringArray.hasMoreElements()) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append((String)stringArray.nextElement());
            }
            stringArray = RemoteIpFilter.commaDelimitedListToStringArray(stringBuilder.toString());
            if (!bl) {
                linkedList.addFirst(httpServletRequest.getRemoteAddr());
            }
            for (n = stringArray.length - 1; n >= 0; --n) {
                object3 = object2 = stringArray[n];
                if (this.internalProxies != null && this.internalProxies.matcher((CharSequence)object2).matches()) continue;
                if (this.trustedProxies != null && this.trustedProxies.matcher((CharSequence)object2).matches()) {
                    linkedList.addFirst((String)object2);
                    continue;
                }
                --n;
                break;
            }
            object2 = new LinkedList();
            while (n >= 0) {
                object = stringArray[n];
                ((LinkedList)object2).addFirst(object);
                --n;
            }
            object = new XForwardedRequest(httpServletRequest);
            if (object3 != null) {
                ((XForwardedRequest)((Object)object)).setRemoteAddr((String)object3);
                ((XForwardedRequest)((Object)object)).setRemoteHost((String)object3);
                if (linkedList.size() == 0) {
                    ((XForwardedRequest)((Object)object)).removeHeader(this.proxiesHeader);
                } else {
                    string = RemoteIpFilter.listToCommaDelimitedString(linkedList);
                    ((XForwardedRequest)((Object)object)).setHeader(this.proxiesHeader, string);
                }
                if (((LinkedList)object2).size() == 0) {
                    ((XForwardedRequest)((Object)object)).removeHeader(this.remoteIpHeader);
                } else {
                    string = RemoteIpFilter.listToCommaDelimitedString((List<String>)object2);
                    ((XForwardedRequest)((Object)object)).setHeader(this.remoteIpHeader, string);
                }
            }
            if (this.protocolHeader != null && (string = httpServletRequest.getHeader(this.protocolHeader)) != null) {
                if (this.isForwardedProtoHeaderValueSecure(string)) {
                    ((XForwardedRequest)((Object)object)).setSecure(true);
                    ((XForwardedRequest)((Object)object)).setScheme("https");
                    this.setPorts((XForwardedRequest)((Object)object), this.httpsServerPort);
                } else {
                    ((XForwardedRequest)((Object)object)).setSecure(false);
                    ((XForwardedRequest)((Object)object)).setScheme("http");
                    this.setPorts((XForwardedRequest)((Object)object), this.httpServerPort);
                }
            }
            if (this.hostHeader != null && (string = httpServletRequest.getHeader(this.hostHeader)) != null) {
                try {
                    int n2 = Host.parse((String)string);
                    if (n2 > -1) {
                        this.log.debug((Object)sm.getString("remoteIpFilter.invalidHostWithPort", new Object[]{string, this.hostHeader}));
                        string = string.substring(0, n2);
                    }
                    ((XForwardedRequest)((Object)object)).setServerName(string);
                    if (this.isChangeLocalName()) {
                        ((XForwardedRequest)((Object)object)).setLocalName(string);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    this.log.debug((Object)sm.getString("remoteIpFilter.invalidHostHeader", new Object[]{string, this.hostHeader}));
                }
            }
            httpServletRequest.setAttribute("org.apache.tomcat.request.forwarded", (Object)Boolean.TRUE);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Incoming request " + httpServletRequest.getRequestURI() + " with originalRemoteAddr [" + httpServletRequest.getRemoteAddr() + "], originalRemoteHost=[" + httpServletRequest.getRemoteHost() + "], originalSecure=[" + httpServletRequest.isSecure() + "], originalScheme=[" + httpServletRequest.getScheme() + "], originalServerName=[" + httpServletRequest.getServerName() + "], originalServerPort=[" + httpServletRequest.getServerPort() + "] will be seen as newRemoteAddr=[" + ((XForwardedRequest)((Object)object)).getRemoteAddr() + "], newRemoteHost=[" + ((XForwardedRequest)((Object)object)).getRemoteHost() + "], newSecure=[" + ((XForwardedRequest)((Object)object)).isSecure() + "], newScheme=[" + ((XForwardedRequest)((Object)object)).getScheme() + "], newServerName=[" + ((XForwardedRequest)((Object)object)).getServerName() + "], newServerPort=[" + ((XForwardedRequest)((Object)object)).getServerPort() + "]"));
            }
            if (this.requestAttributesEnabled) {
                httpServletRequest.setAttribute("org.apache.catalina.AccessLog.RemoteAddr", (Object)((XForwardedRequest)((Object)object)).getRemoteAddr());
                httpServletRequest.setAttribute("org.apache.tomcat.remoteAddr", (Object)((XForwardedRequest)((Object)object)).getRemoteAddr());
                httpServletRequest.setAttribute("org.apache.catalina.AccessLog.RemoteHost", (Object)((XForwardedRequest)((Object)object)).getRemoteHost());
                httpServletRequest.setAttribute("org.apache.catalina.AccessLog.Protocol", (Object)object.getProtocol());
                httpServletRequest.setAttribute("org.apache.catalina.AccessLog.ServerName", (Object)((XForwardedRequest)((Object)object)).getServerName());
                httpServletRequest.setAttribute("org.apache.catalina.AccessLog.ServerPort", (Object)((XForwardedRequest)((Object)object)).getServerPort());
            }
            filterChain.doFilter((ServletRequest)object, (ServletResponse)httpServletResponse);
        } else {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Skip RemoteIpFilter for request " + httpServletRequest.getRequestURI() + " with originalRemoteAddr '" + httpServletRequest.getRemoteAddr() + "'"));
            }
            filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
        }
    }

    private boolean isForwardedProtoHeaderValueSecure(String string) {
        if (!string.contains(",")) {
            return this.protocolHeaderHttpsValue.equalsIgnoreCase(string);
        }
        String[] stringArray = RemoteIpFilter.commaDelimitedListToStringArray(string);
        if (stringArray.length == 0) {
            return false;
        }
        for (String string2 : stringArray) {
            if (this.protocolHeaderHttpsValue.equalsIgnoreCase(string2)) continue;
            return false;
        }
        return true;
    }

    private void setPorts(XForwardedRequest xForwardedRequest, int n) {
        String string;
        int n2 = n;
        if (this.getPortHeader() != null && (string = xForwardedRequest.getHeader(this.getPortHeader())) != null) {
            try {
                n2 = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                this.log.debug((Object)("Invalid port value [" + string + "] provided in header [" + this.getPortHeader() + "]"));
            }
        }
        xForwardedRequest.setServerPort(n2);
        if (this.isChangeLocalPort()) {
            xForwardedRequest.setLocalPort(n2);
        }
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (servletRequest instanceof HttpServletRequest && servletResponse instanceof HttpServletResponse) {
            this.doFilter((HttpServletRequest)servletRequest, (HttpServletResponse)servletResponse, filterChain);
        } else {
            filterChain.doFilter(servletRequest, servletResponse);
        }
    }

    public boolean isChangeLocalName() {
        return this.changeLocalName;
    }

    public boolean isChangeLocalPort() {
        return this.changeLocalPort;
    }

    public int getHttpsServerPort() {
        return this.httpsServerPort;
    }

    public Pattern getInternalProxies() {
        return this.internalProxies;
    }

    public String getProtocolHeader() {
        return this.protocolHeader;
    }

    public String getPortHeader() {
        return this.portHeader;
    }

    public String getProtocolHeaderHttpsValue() {
        return this.protocolHeaderHttpsValue;
    }

    public String getProxiesHeader() {
        return this.proxiesHeader;
    }

    public String getRemoteIpHeader() {
        return this.remoteIpHeader;
    }

    public boolean getRequestAttributesEnabled() {
        return this.requestAttributesEnabled;
    }

    public Pattern getTrustedProxies() {
        return this.trustedProxies;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        if (filterConfig.getInitParameter(INTERNAL_PROXIES_PARAMETER) != null) {
            this.setInternalProxies(filterConfig.getInitParameter(INTERNAL_PROXIES_PARAMETER));
        }
        if (filterConfig.getInitParameter(PROTOCOL_HEADER_PARAMETER) != null) {
            this.setProtocolHeader(filterConfig.getInitParameter(PROTOCOL_HEADER_PARAMETER));
        }
        if (filterConfig.getInitParameter(PROTOCOL_HEADER_HTTPS_VALUE_PARAMETER) != null) {
            this.setProtocolHeaderHttpsValue(filterConfig.getInitParameter(PROTOCOL_HEADER_HTTPS_VALUE_PARAMETER));
        }
        if (filterConfig.getInitParameter(HOST_HEADER_PARAMETER) != null) {
            this.setHostHeader(filterConfig.getInitParameter(HOST_HEADER_PARAMETER));
        }
        if (filterConfig.getInitParameter(PORT_HEADER_PARAMETER) != null) {
            this.setPortHeader(filterConfig.getInitParameter(PORT_HEADER_PARAMETER));
        }
        if (filterConfig.getInitParameter(CHANGE_LOCAL_PORT_PARAMETER) != null) {
            this.setChangeLocalPort(Boolean.parseBoolean(filterConfig.getInitParameter(CHANGE_LOCAL_PORT_PARAMETER)));
        }
        if (filterConfig.getInitParameter(CHANGE_LOCAL_NAME_PARAMETER) != null) {
            this.setChangeLocalName(Boolean.parseBoolean(filterConfig.getInitParameter(CHANGE_LOCAL_NAME_PARAMETER)));
        }
        if (filterConfig.getInitParameter(PROXIES_HEADER_PARAMETER) != null) {
            this.setProxiesHeader(filterConfig.getInitParameter(PROXIES_HEADER_PARAMETER));
        }
        if (filterConfig.getInitParameter(REMOTE_IP_HEADER_PARAMETER) != null) {
            this.setRemoteIpHeader(filterConfig.getInitParameter(REMOTE_IP_HEADER_PARAMETER));
        }
        if (filterConfig.getInitParameter(TRUSTED_PROXIES_PARAMETER) != null) {
            this.setTrustedProxies(filterConfig.getInitParameter(TRUSTED_PROXIES_PARAMETER));
        }
        if (filterConfig.getInitParameter(HTTP_SERVER_PORT_PARAMETER) != null) {
            try {
                this.setHttpServerPort(Integer.parseInt(filterConfig.getInitParameter(HTTP_SERVER_PORT_PARAMETER)));
            }
            catch (NumberFormatException numberFormatException) {
                throw new NumberFormatException(sm.getString("remoteIpFilter.invalidNumber", new Object[]{HTTP_SERVER_PORT_PARAMETER, numberFormatException.getLocalizedMessage()}));
            }
        }
        if (filterConfig.getInitParameter(HTTPS_SERVER_PORT_PARAMETER) != null) {
            try {
                this.setHttpsServerPort(Integer.parseInt(filterConfig.getInitParameter(HTTPS_SERVER_PORT_PARAMETER)));
            }
            catch (NumberFormatException numberFormatException) {
                throw new NumberFormatException(sm.getString("remoteIpFilter.invalidNumber", new Object[]{HTTPS_SERVER_PORT_PARAMETER, numberFormatException.getLocalizedMessage()}));
            }
        }
    }

    public void setChangeLocalName(boolean bl) {
        this.changeLocalName = bl;
    }

    public void setChangeLocalPort(boolean bl) {
        this.changeLocalPort = bl;
    }

    public void setHttpServerPort(int n) {
        this.httpServerPort = n;
    }

    public void setHttpsServerPort(int n) {
        this.httpsServerPort = n;
    }

    public void setInternalProxies(String string) {
        this.internalProxies = string == null || string.length() == 0 ? null : Pattern.compile(string);
    }

    public void setHostHeader(String string) {
        this.hostHeader = string;
    }

    public void setPortHeader(String string) {
        this.portHeader = string;
    }

    public void setProtocolHeader(String string) {
        this.protocolHeader = string;
    }

    public void setProtocolHeaderHttpsValue(String string) {
        this.protocolHeaderHttpsValue = string;
    }

    public void setProxiesHeader(String string) {
        this.proxiesHeader = string;
    }

    public void setRemoteIpHeader(String string) {
        this.remoteIpHeader = string;
    }

    public void setRequestAttributesEnabled(boolean bl) {
        this.requestAttributesEnabled = bl;
    }

    public void setTrustedProxies(String string) {
        this.trustedProxies = string == null || string.length() == 0 ? null : Pattern.compile(string);
    }

    public static class XForwardedRequest
    extends HttpServletRequestWrapper {
        protected Map<String, List<String>> headers;
        protected String localName;
        protected int localPort;
        protected String remoteAddr;
        protected String remoteHost;
        protected String scheme;
        protected boolean secure;
        protected String serverName;
        protected int serverPort;

        public XForwardedRequest(HttpServletRequest httpServletRequest) {
            super(httpServletRequest);
            this.localName = httpServletRequest.getLocalName();
            this.localPort = httpServletRequest.getLocalPort();
            this.remoteAddr = httpServletRequest.getRemoteAddr();
            this.remoteHost = httpServletRequest.getRemoteHost();
            this.scheme = httpServletRequest.getScheme();
            this.secure = httpServletRequest.isSecure();
            this.serverName = httpServletRequest.getServerName();
            this.serverPort = httpServletRequest.getServerPort();
            this.headers = new HashMap<String, List<String>>();
            Enumeration enumeration = httpServletRequest.getHeaderNames();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                this.headers.put(string, Collections.list(httpServletRequest.getHeaders(string)));
            }
        }

        public long getDateHeader(String string) {
            String string2 = this.getHeader(string);
            if (string2 == null) {
                return -1L;
            }
            long l = FastHttpDateFormat.parseDate((String)string2);
            if (l == -1L) {
                throw new IllegalArgumentException(string2);
            }
            return l;
        }

        public String getHeader(String string) {
            Map.Entry<String, List<String>> entry = this.getHeaderEntry(string);
            if (entry == null || entry.getValue() == null || entry.getValue().isEmpty()) {
                return null;
            }
            return entry.getValue().get(0);
        }

        protected Map.Entry<String, List<String>> getHeaderEntry(String string) {
            for (Map.Entry<String, List<String>> entry : this.headers.entrySet()) {
                if (!entry.getKey().equalsIgnoreCase(string)) continue;
                return entry;
            }
            return null;
        }

        public Enumeration<String> getHeaderNames() {
            return Collections.enumeration(this.headers.keySet());
        }

        public Enumeration<String> getHeaders(String string) {
            Map.Entry<String, List<String>> entry = this.getHeaderEntry(string);
            if (entry == null || entry.getValue() == null) {
                return Collections.enumeration(Collections.emptyList());
            }
            return Collections.enumeration((Collection)entry.getValue());
        }

        public int getIntHeader(String string) {
            String string2 = this.getHeader(string);
            if (string2 == null) {
                return -1;
            }
            return Integer.parseInt(string2);
        }

        public String getLocalName() {
            return this.localName;
        }

        public int getLocalPort() {
            return this.localPort;
        }

        public String getRemoteAddr() {
            return this.remoteAddr;
        }

        public String getRemoteHost() {
            return this.remoteHost;
        }

        public String getScheme() {
            return this.scheme;
        }

        public String getServerName() {
            return this.serverName;
        }

        public int getServerPort() {
            return this.serverPort;
        }

        public boolean isSecure() {
            return this.secure;
        }

        public void removeHeader(String string) {
            Map.Entry<String, List<String>> entry = this.getHeaderEntry(string);
            if (entry != null) {
                this.headers.remove(entry.getKey());
            }
        }

        public void setHeader(String string, String string2) {
            List<String> list = Collections.singletonList(string2);
            Map.Entry<String, List<String>> entry = this.getHeaderEntry(string);
            if (entry == null) {
                this.headers.put(string, list);
            } else {
                entry.setValue(list);
            }
        }

        public void setLocalName(String string) {
            this.localName = string;
        }

        public void setLocalPort(int n) {
            this.localPort = n;
        }

        public void setRemoteAddr(String string) {
            this.remoteAddr = string;
        }

        public void setRemoteHost(String string) {
            this.remoteHost = string;
        }

        public void setScheme(String string) {
            this.scheme = string;
        }

        public void setSecure(boolean bl) {
            this.secure = bl;
        }

        public void setServerName(String string) {
            this.serverName = string;
        }

        public void setServerPort(int n) {
            this.serverPort = n;
        }

        public StringBuffer getRequestURL() {
            StringBuffer stringBuffer = new StringBuffer();
            String string = this.getScheme();
            int n = this.getServerPort();
            if (n < 0) {
                n = 80;
            }
            stringBuffer.append(string);
            stringBuffer.append("://");
            stringBuffer.append(this.getServerName());
            if (string.equals("http") && n != 80 || string.equals("https") && n != 443) {
                stringBuffer.append(':');
                stringBuffer.append(n);
            }
            stringBuffer.append(this.getRequestURI());
            return stringBuffer;
        }
    }
}

