/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.realm;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.GSSRealm;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.Server;
import org.apache.catalina.Service;
import org.apache.catalina.Wrapper;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.deploy.SecurityCollection;
import org.apache.catalina.deploy.SecurityConstraint;
import org.apache.catalina.mbeans.MBeanUtils;
import org.apache.catalina.realm.GenericPrincipal;
import org.apache.catalina.realm.X509SubjectDnRetriever;
import org.apache.catalina.realm.X509UsernameRetriever;
import org.apache.catalina.util.LifecycleMBeanBase;
import org.apache.catalina.util.SessionConfig;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.buf.B2CConverter;
import org.apache.tomcat.util.buf.HexUtils;
import org.apache.tomcat.util.codec.binary.Base64;
import org.apache.tomcat.util.res.StringManager;
import org.apache.tomcat.util.security.MD5Encoder;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSName;

public abstract class RealmBase
extends LifecycleMBeanBase
implements GSSRealm {
    private static final Log log = LogFactory.getLog(RealmBase.class);
    protected Container container = null;
    protected Log containerLog = null;
    protected String digest = null;
    protected String digestEncoding = null;
    protected static final String info = "org.apache.catalina.realm.RealmBase/1.0";
    protected volatile MessageDigest md = null;
    @Deprecated
    protected static final MD5Encoder md5Encoder = new MD5Encoder();
    protected static volatile MessageDigest md5Helper;
    protected static final StringManager sm;
    protected PropertyChangeSupport support = new PropertyChangeSupport(this);
    protected boolean validate = true;
    protected String x509UsernameRetrieverClassName;
    protected X509UsernameRetriever x509UsernameRetriever;
    protected AllRolesMode allRolesMode = AllRolesMode.STRICT_MODE;
    protected boolean stripRealmForGss = true;
    private int transportGuaranteeRedirectStatus = 302;
    protected String realmPath = "/realm0";

    public int getTransportGuaranteeRedirectStatus() {
        return this.transportGuaranteeRedirectStatus;
    }

    public void setTransportGuaranteeRedirectStatus(int n) {
        this.transportGuaranteeRedirectStatus = n;
    }

    @Override
    public Container getContainer() {
        return this.container;
    }

    @Override
    public void setContainer(Container container) {
        Container container2 = this.container;
        this.container = container;
        this.support.firePropertyChange("container", container2, this.container);
    }

    public String getAllRolesMode() {
        return this.allRolesMode.toString();
    }

    public void setAllRolesMode(String string) {
        this.allRolesMode = AllRolesMode.toMode(string);
    }

    public String getDigest() {
        return this.digest;
    }

    public void setDigest(String string) {
        this.digest = string;
    }

    public String getDigestEncoding() {
        return this.digestEncoding;
    }

    public void setDigestEncoding(String string) {
        this.digestEncoding = string;
    }

    protected Charset getDigestCharset() throws UnsupportedEncodingException {
        if (this.digestEncoding == null) {
            return Charset.defaultCharset();
        }
        return B2CConverter.getCharset((String)this.getDigestEncoding());
    }

    @Override
    public String getInfo() {
        return info;
    }

    public boolean getValidate() {
        return this.validate;
    }

    public void setValidate(boolean bl) {
        this.validate = bl;
    }

    public String getX509UsernameRetrieverClassName() {
        return this.x509UsernameRetrieverClassName;
    }

    public void setX509UsernameRetrieverClassName(String string) {
        this.x509UsernameRetrieverClassName = string;
    }

    public boolean isStripRealmForGss() {
        return this.stripRealmForGss;
    }

    public void setStripRealmForGss(boolean bl) {
        this.stripRealmForGss = bl;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    @Override
    public Principal authenticate(String string) {
        if (string == null) {
            return null;
        }
        if (this.containerLog.isTraceEnabled()) {
            this.containerLog.trace((Object)sm.getString("realmBase.authenticateSuccess", new Object[]{string}));
        }
        return this.getPrincipal(string);
    }

    @Override
    public Principal authenticate(String string, String string2) {
        if (string == null || string2 == null) {
            if (this.containerLog.isTraceEnabled()) {
                this.containerLog.trace((Object)sm.getString("realmBase.authenticateFailure", new Object[]{string}));
            }
            return null;
        }
        String string3 = this.getPassword(string);
        if (string3 == null) {
            this.compareCredentials(string2, this.getClass().getName());
            if (this.containerLog.isTraceEnabled()) {
                this.containerLog.trace((Object)sm.getString("realmBase.authenticateFailure", new Object[]{string}));
            }
            return null;
        }
        boolean bl = this.compareCredentials(string2, string3);
        if (bl) {
            if (this.containerLog.isTraceEnabled()) {
                this.containerLog.trace((Object)sm.getString("realmBase.authenticateSuccess", new Object[]{string}));
            }
            return this.getPrincipal(string);
        }
        if (this.containerLog.isTraceEnabled()) {
            this.containerLog.trace((Object)sm.getString("realmBase.authenticateFailure", new Object[]{string}));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Principal authenticate(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8) {
        String string9 = this.getDigest(string, string7);
        if (string9 == null) {
            return null;
        }
        string9 = string9.toLowerCase(Locale.ENGLISH);
        String string10 = string6 == null ? string9 + ":" + string3 + ":" + string8 : string9 + ":" + string3 + ":" + string4 + ":" + string5 + ":" + string6 + ":" + string8;
        byte[] byArray = null;
        try {
            byArray = string10.getBytes(this.getDigestCharset());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            log.error((Object)("Illegal digestEncoding: " + this.getDigestEncoding()), (Throwable)unsupportedEncodingException);
            throw new IllegalArgumentException(unsupportedEncodingException.getMessage());
        }
        String string11 = null;
        MessageDigest messageDigest = md5Helper;
        synchronized (messageDigest) {
            string11 = MD5Encoder.encode((byte[])md5Helper.digest(byArray));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Digest : " + string2 + " Username:" + string + " ClientDigest:" + string2 + " nonce:" + string3 + " nc:" + string4 + " cnonce:" + string5 + " qop:" + string6 + " realm:" + string7 + "md5a2:" + string8 + " Server digest:" + string11));
        }
        if (string11.equals(string2)) {
            return this.getPrincipal(string);
        }
        return null;
    }

    @Override
    public Principal authenticate(X509Certificate[] x509CertificateArray) {
        if (x509CertificateArray == null || x509CertificateArray.length < 1) {
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Authenticating client certificate chain");
        }
        if (this.validate) {
            for (X509Certificate x509Certificate : x509CertificateArray) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)(" Checking validity for '" + x509Certificate.getSubjectDN().getName() + "'"));
                }
                try {
                    x509Certificate.checkValidity();
                }
                catch (Exception exception) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"  Validity exception", (Throwable)exception);
                    }
                    return null;
                }
            }
        }
        return this.getPrincipal(x509CertificateArray[0]);
    }

    @Override
    public Principal authenticate(GSSContext gSSContext, boolean bl) {
        if (gSSContext.isEstablished()) {
            GSSName gSSName = null;
            try {
                gSSName = gSSContext.getSrcName();
            }
            catch (GSSException gSSException) {
                log.warn((Object)sm.getString("realmBase.gssNameFail"), (Throwable)gSSException);
            }
            if (gSSName != null) {
                GSSCredential gSSCredential = null;
                if (bl) {
                    if (gSSContext.getCredDelegState()) {
                        try {
                            gSSCredential = gSSContext.getDelegCred();
                        }
                        catch (GSSException gSSException) {
                            log.warn((Object)sm.getString("realmBase.delegatedCredentialFail", new Object[]{gSSName}), (Throwable)gSSException);
                        }
                    } else if (log.isDebugEnabled()) {
                        log.debug((Object)sm.getString("realmBase.credentialNotDelegated", new Object[]{gSSName}));
                    }
                }
                return this.getPrincipal(gSSName, gSSCredential);
            }
        } else {
            log.error((Object)sm.getString("realmBase.gssContextNotEstablished"));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean compareCredentials(String string, String string2) {
        if (string2 == null) {
            return false;
        }
        if (this.hasMessageDigest()) {
            if (string2.startsWith("{MD5}") || string2.startsWith("{SHA}")) {
                String string3;
                String string4 = string2.substring(5);
                RealmBase realmBase = this;
                synchronized (realmBase) {
                    this.md.reset();
                    this.md.update(string.getBytes(B2CConverter.ISO_8859_1));
                    string3 = Base64.encodeBase64String((byte[])this.md.digest());
                }
                return string3.equals(string4);
            }
            if (string2.startsWith("{SSHA}")) {
                byte[] byArray;
                String string5 = string2.substring(6);
                byte[] byArray2 = Base64.decodeBase64((String)string5);
                byte[] byArray3 = new byte[20];
                System.arraycopy(byArray2, 0, byArray3, 0, 20);
                RealmBase realmBase = this;
                synchronized (realmBase) {
                    this.md.reset();
                    this.md.update(string.getBytes(B2CConverter.ISO_8859_1));
                    this.md.update(byArray2, 20, byArray2.length - 20);
                    byArray = this.md.digest();
                }
                return Arrays.equals(byArray, byArray3);
            }
            String string6 = this.digest(string);
            return string2.equalsIgnoreCase(string6);
        }
        return string2.equals(string);
    }

    @Override
    public Principal authenticate(GSSName gSSName, GSSCredential gSSCredential) {
        if (gSSName == null) {
            return null;
        }
        return this.getPrincipal(gSSName, gSSCredential);
    }

    @Override
    public void backgroundProcess() {
    }

    @Override
    public SecurityConstraint[] findSecurityConstraints(Request request, Context context) {
        int n;
        SecurityCollection[] securityCollectionArray;
        int n2;
        ArrayList<SecurityConstraint> arrayList = null;
        SecurityConstraint[] securityConstraintArray = context.findConstraints();
        if (securityConstraintArray == null || securityConstraintArray.length == 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"  No applicable constraints defined");
            }
            return null;
        }
        String string = request.getRequestPathMB().toString();
        if (string == null || string.length() == 0) {
            string = "/";
        }
        String string2 = request.getMethod();
        boolean bl = false;
        for (n2 = 0; n2 < securityConstraintArray.length; ++n2) {
            SecurityCollection[] securityCollectionArray2 = securityConstraintArray[n2].findCollections();
            if (securityCollectionArray2 == null) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("  Checking constraint '" + securityConstraintArray[n2] + "' against " + string2 + " " + string + " --> " + securityConstraintArray[n2].included(string, string2)));
            }
            for (SecurityCollection securityCollection : securityCollectionArray2) {
                String[] object2 = securityCollection.findPatterns();
                if (object2 == null) continue;
                for (String[] stringArray : object2) {
                    if (!string.equals(stringArray) && (stringArray.length() != 0 || !string.equals("/"))) continue;
                    bl = true;
                    if (!securityCollection.findMethod(string2)) continue;
                    if (arrayList == null) {
                        arrayList = new ArrayList();
                    }
                    arrayList.add(securityConstraintArray[n2]);
                }
            }
        }
        if (bl) {
            return this.resultsToArray(arrayList);
        }
        int n3 = -1;
        for (n2 = 0; n2 < securityConstraintArray.length; ++n2) {
            securityCollectionArray = securityConstraintArray[n2].findCollections();
            if (securityCollectionArray == null) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("  Checking constraint '" + securityConstraintArray[n2] + "' against " + string2 + " " + string + " --> " + securityConstraintArray[n2].included(string, string2)));
            }
            for (SecurityCollection securityCollection : securityCollectionArray) {
                String[] stringArray;
                String[] stringArray2 = securityCollection.findPatterns();
                if (stringArray2 == null) continue;
                int n4 = 0;
                n = -1;
                stringArray = stringArray2;
                int n5 = stringArray.length;
                for (int i = 0; i < n5; ++i) {
                    String string3 = stringArray[i];
                    if (!string3.startsWith("/") || !string3.endsWith("/*") || string3.length() < n3) continue;
                    if (string3.length() == 2) {
                        n4 = 1;
                        n = string3.length();
                        continue;
                    }
                    if (!string3.regionMatches(0, string, 0, string3.length() - 1) && (string3.length() - 2 != string.length() || !string3.regionMatches(0, string, 0, string3.length() - 2))) continue;
                    n4 = 1;
                    n = string3.length();
                }
                if (n4 == 0) continue;
                if (n > n3) {
                    bl = false;
                    if (arrayList != null) {
                        arrayList.clear();
                    }
                    n3 = n;
                }
                if (!securityCollection.findMethod(string2)) continue;
                bl = true;
                if (arrayList == null) {
                    arrayList = new ArrayList();
                }
                arrayList.add(securityConstraintArray[n2]);
            }
        }
        if (bl) {
            return this.resultsToArray(arrayList);
        }
        for (n2 = 0; n2 < securityConstraintArray.length; ++n2) {
            securityCollectionArray = securityConstraintArray[n2].findCollections();
            if (securityCollectionArray == null) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("  Checking constraint '" + securityConstraintArray[n2] + "' against " + string2 + " " + string + " --> " + securityConstraintArray[n2].included(string, string2)));
            }
            boolean bl2 = false;
            int n6 = -1;
            for (int i = 0; i < securityCollectionArray.length; ++i) {
                String[] stringArray = securityCollectionArray[i].findPatterns();
                if (stringArray == null) continue;
                for (int j = 0; j < stringArray.length && !bl2; ++j) {
                    String string4 = stringArray[j];
                    if (!string4.startsWith("*.")) continue;
                    n = string.lastIndexOf(47);
                    int n7 = string.lastIndexOf(46);
                    if (n < 0 || n7 <= n || n7 == string.length() - 1 || string.length() - n7 != string4.length() - 1 || !string4.regionMatches(1, string, n7, string.length() - n7)) continue;
                    bl2 = true;
                    n6 = i;
                }
            }
            if (!bl2) continue;
            bl = true;
            if (!securityCollectionArray[n6].findMethod(string2)) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<SecurityConstraint>();
            }
            arrayList.add(securityConstraintArray[n2]);
        }
        if (bl) {
            return this.resultsToArray(arrayList);
        }
        for (n2 = 0; n2 < securityConstraintArray.length; ++n2) {
            securityCollectionArray = securityConstraintArray[n2].findCollections();
            if (securityCollectionArray == null) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("  Checking constraint '" + securityConstraintArray[n2] + "' against " + string2 + " " + string + " --> " + securityConstraintArray[n2].included(string, string2)));
            }
            for (SecurityCollection securityCollection : securityCollectionArray) {
                String[] stringArray = securityCollection.findPatterns();
                if (stringArray == null) continue;
                boolean bl2 = false;
                for (String string5 : stringArray) {
                    if (!string5.equals("/")) continue;
                    bl2 = true;
                    break;
                }
                if (!bl2) continue;
                if (arrayList == null) {
                    arrayList = new ArrayList();
                }
                arrayList.add(securityConstraintArray[n2]);
            }
        }
        if (arrayList == null && log.isDebugEnabled()) {
            log.debug((Object)"  No applicable constraint located");
        }
        return this.resultsToArray(arrayList);
    }

    private SecurityConstraint[] resultsToArray(ArrayList<SecurityConstraint> arrayList) {
        if (arrayList == null || arrayList.size() == 0) {
            return null;
        }
        SecurityConstraint[] securityConstraintArray = new SecurityConstraint[arrayList.size()];
        arrayList.toArray(securityConstraintArray);
        return securityConstraintArray;
    }

    @Override
    public boolean hasResourcePermission(Request request, Response response, SecurityConstraint[] securityConstraintArray, Context context) throws IOException {
        String[] stringArray;
        if (securityConstraintArray == null || securityConstraintArray.length == 0) {
            return true;
        }
        Principal principal = request.getPrincipal();
        boolean bl = false;
        boolean bl2 = false;
        for (SecurityConstraint securityConstraint : securityConstraintArray) {
            stringArray = securityConstraint.getAllRoles() ? request.getContext().findSecurityRoles() : securityConstraint.findAuthRoles();
            if (stringArray == null) {
                stringArray = new String[]{};
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("  Checking roles " + principal));
            }
            if (stringArray.length == 0 && !securityConstraint.getAllRoles()) {
                if (securityConstraint.getAuthConstraint()) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"No roles");
                    }
                    bl = false;
                    bl2 = true;
                    break;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Passing all access");
                }
                bl = true;
                continue;
            }
            if (principal == null) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)"  No user authenticated, cannot grant access");
                continue;
            }
            for (String string : stringArray) {
                if (this.hasRole(request.getWrapper(), principal, string)) {
                    bl = true;
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("Role found:  " + string));
                    continue;
                }
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("No role found:  " + string));
            }
        }
        if (!bl2 && this.allRolesMode != AllRolesMode.STRICT_MODE && !bl && principal != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Checking for all roles mode: " + this.allRolesMode));
            }
            for (SecurityConstraint securityConstraint : securityConstraintArray) {
                if (!securityConstraint.getAllRoles()) continue;
                if (this.allRolesMode == AllRolesMode.AUTH_ONLY_MODE) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Granting access for role-name=*, auth-only");
                    }
                    bl = true;
                    break;
                }
                stringArray = request.getContext().findSecurityRoles();
                if (stringArray.length != 0 || this.allRolesMode != AllRolesMode.STRICT_AUTH_ONLY_MODE) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Granting access for role-name=*, strict auth-only");
                }
                bl = true;
                break;
            }
        }
        if (!bl) {
            response.sendError(403, sm.getString("realmBase.forbidden"));
        }
        return bl;
    }

    @Override
    public boolean hasRole(Wrapper wrapper, Principal principal, String string) {
        Object object;
        if (wrapper != null && (object = wrapper.findSecurityReference(string)) != null) {
            string = object;
        }
        if (principal == null || string == null || !(principal instanceof GenericPrincipal)) {
            return false;
        }
        object = (GenericPrincipal)principal;
        boolean bl = ((GenericPrincipal)object).hasRole(string);
        if (log.isDebugEnabled()) {
            String string2 = principal.getName();
            if (bl) {
                log.debug((Object)sm.getString("realmBase.hasRoleSuccess", new Object[]{string2, string}));
            } else {
                log.debug((Object)sm.getString("realmBase.hasRoleFailure", new Object[]{string2, string}));
            }
        }
        return bl;
    }

    @Override
    public boolean hasUserDataPermission(Request request, Response response, SecurityConstraint[] securityConstraintArray) throws IOException {
        String string;
        String string2;
        if (securityConstraintArray == null || securityConstraintArray.length == 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"  No applicable security constraint defined");
            }
            return true;
        }
        for (SecurityConstraint object2 : securityConstraintArray) {
            string2 = object2.getUserConstraint();
            if (string2 == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"  No applicable user data constraint defined");
                }
                return true;
            }
            if (!string2.equals("NONE")) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)"  User data constraint has no restrictions");
            }
            return true;
        }
        if (request.getRequest().isSecure()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"  User data constraint already satisfied");
            }
            return true;
        }
        int n = request.getConnector().getRedirectPort();
        if (n <= 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"  SSL redirect is disabled");
            }
            response.sendError(403, request.getRequestURI());
            return false;
        }
        StringBuilder stringBuilder = new StringBuilder();
        String string3 = "https";
        String string4 = request.getServerName();
        stringBuilder.append(string3).append("://").append(string4);
        if (n != 443) {
            stringBuilder.append(":").append(n);
        }
        stringBuilder.append(request.getRequestURI());
        string2 = request.getRequestedSessionId();
        if (string2 != null && request.isRequestedSessionIdFromURL()) {
            stringBuilder.append(";");
            stringBuilder.append(SessionConfig.getSessionUriParamName(request.getContext()));
            stringBuilder.append("=");
            stringBuilder.append(string2);
        }
        if ((string = request.getQueryString()) != null) {
            stringBuilder.append('?');
            stringBuilder.append(string);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("  Redirecting to " + stringBuilder.toString()));
        }
        response.sendRedirect(stringBuilder.toString(), this.transportGuaranteeRedirectStatus);
        return false;
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    @Override
    protected void initInternal() throws LifecycleException {
        super.initInternal();
        if (this.container != null) {
            this.containerLog = this.container.getLogger();
        }
        this.x509UsernameRetriever = RealmBase.createUsernameRetriever(this.x509UsernameRetrieverClassName);
    }

    @Override
    protected void startInternal() throws LifecycleException {
        if (this.digest != null) {
            try {
                this.md = MessageDigest.getInstance(this.digest);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new LifecycleException(sm.getString("realmBase.algorithm", new Object[]{this.digest}), noSuchAlgorithmException);
            }
        }
        this.setState(LifecycleState.STARTING);
    }

    @Override
    protected void stopInternal() throws LifecycleException {
        this.setState(LifecycleState.STOPPING);
        this.md = null;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("Realm[");
        stringBuilder.append(this.getName());
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String digest(String string) {
        if (!this.hasMessageDigest()) {
            return string;
        }
        RealmBase realmBase = this;
        synchronized (realmBase) {
            try {
                this.md.reset();
                byte[] byArray = null;
                try {
                    byArray = string.getBytes(this.getDigestCharset());
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    log.error((Object)("Illegal digestEncoding: " + this.getDigestEncoding()), (Throwable)unsupportedEncodingException);
                    throw new IllegalArgumentException(unsupportedEncodingException.getMessage());
                }
                this.md.update(byArray);
                return HexUtils.toHexString((byte[])this.md.digest());
            }
            catch (Exception exception) {
                log.error((Object)sm.getString("realmBase.digest"), (Throwable)exception);
                return string;
            }
        }
    }

    protected boolean hasMessageDigest() {
        return this.md != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getDigest(String string, String string2) {
        if (md5Helper == null) {
            try {
                md5Helper = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                log.error((Object)"Couldn't get MD5 digest: ", (Throwable)noSuchAlgorithmException);
                throw new IllegalStateException(noSuchAlgorithmException.getMessage());
            }
        }
        if (this.hasMessageDigest()) {
            return this.getPassword(string);
        }
        String string3 = string + ":" + string2 + ":" + this.getPassword(string);
        byte[] byArray = null;
        try {
            byArray = string3.getBytes(this.getDigestCharset());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            log.error((Object)("Illegal digestEncoding: " + this.getDigestEncoding()), (Throwable)unsupportedEncodingException);
            throw new IllegalArgumentException(unsupportedEncodingException.getMessage());
        }
        byte[] byArray2 = null;
        MessageDigest messageDigest = md5Helper;
        synchronized (messageDigest) {
            byArray2 = md5Helper.digest(byArray);
        }
        return MD5Encoder.encode((byte[])byArray2);
    }

    protected abstract String getName();

    protected abstract String getPassword(String var1);

    protected Principal getPrincipal(X509Certificate x509Certificate) {
        String string = this.x509UsernameRetriever.getUsername(x509Certificate);
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("realmBase.gotX509Username", new Object[]{string}));
        }
        return this.getPrincipal(string);
    }

    protected abstract Principal getPrincipal(String var1);

    @Deprecated
    protected Principal getPrincipal(String string, GSSCredential gSSCredential) {
        Principal principal = this.getPrincipal(string);
        if (principal instanceof GenericPrincipal) {
            ((GenericPrincipal)principal).setGssCredential(gSSCredential);
        }
        return principal;
    }

    protected Principal getPrincipal(GSSName gSSName, GSSCredential gSSCredential) {
        Principal principal;
        int n;
        String string = gSSName.toString();
        if (this.isStripRealmForGss() && (n = string.indexOf(64)) > 0) {
            string = string.substring(0, n);
        }
        if ((principal = this.getPrincipal(string)) instanceof GenericPrincipal) {
            ((GenericPrincipal)principal).setGssCredential(gSSCredential);
        }
        return principal;
    }

    protected Server getServer() {
        Service service;
        Container container = this.container;
        if (container instanceof Context) {
            container = container.getParent();
        }
        if (container instanceof Host) {
            container = container.getParent();
        }
        if (container instanceof Engine && (service = ((Engine)container).getService()) != null) {
            return service.getServer();
        }
        return null;
    }

    public static final String Digest(String string, String string2, String string3) {
        try {
            MessageDigest messageDigest = (MessageDigest)MessageDigest.getInstance(string2).clone();
            if (string3 == null) {
                messageDigest.update(string.getBytes());
            } else {
                messageDigest.update(string.getBytes(string3));
            }
            return HexUtils.toHexString((byte[])messageDigest.digest());
        }
        catch (Exception exception) {
            log.error((Object)exception);
            return string;
        }
    }

    public static void main(String[] stringArray) {
        String string = null;
        int n = 2;
        if (stringArray.length > 4 && stringArray[2].equalsIgnoreCase("-e")) {
            string = stringArray[3];
            n = 4;
        }
        if (stringArray.length > n && stringArray[0].equalsIgnoreCase("-a")) {
            for (int i = n; i < stringArray.length; ++i) {
                System.out.print(stringArray[i] + ":");
                System.out.println(RealmBase.Digest(stringArray[i], stringArray[1], string));
            }
        } else {
            System.out.println("Usage: RealmBase -a <algorithm> [-e <encoding>] <credentials>");
        }
    }

    @Override
    public String getObjectNameKeyProperties() {
        StringBuilder stringBuilder = new StringBuilder("type=Realm");
        stringBuilder.append(this.getRealmSuffix());
        stringBuilder.append(MBeanUtils.getContainerKeyProperties(this.container));
        return stringBuilder.toString();
    }

    @Override
    public String getDomainInternal() {
        return MBeanUtils.getDomain(this.container);
    }

    public String getRealmPath() {
        return this.realmPath;
    }

    public void setRealmPath(String string) {
        this.realmPath = string;
    }

    protected String getRealmSuffix() {
        return ",realmPath=" + this.getRealmPath();
    }

    private static X509UsernameRetriever createUsernameRetriever(String string) throws LifecycleException {
        if (null == string || "".equals(string.trim())) {
            return new X509SubjectDnRetriever();
        }
        try {
            Class<?> clazz = Class.forName(string);
            return (X509UsernameRetriever)clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new LifecycleException(sm.getString("realmBase.createUsernameRetriever.ClassNotFoundException", new Object[]{string}), classNotFoundException);
        }
        catch (InstantiationException instantiationException) {
            throw new LifecycleException(sm.getString("realmBase.createUsernameRetriever.InstantiationException", new Object[]{string}), instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new LifecycleException(sm.getString("realmBase.createUsernameRetriever.IllegalAccessException", new Object[]{string}), illegalAccessException);
        }
        catch (ClassCastException classCastException) {
            throw new LifecycleException(sm.getString("realmBase.createUsernameRetriever.ClassCastException", new Object[]{string}), classCastException);
        }
    }

    static {
        sm = StringManager.getManager(RealmBase.class);
    }

    protected static class AllRolesMode {
        private final String name;
        public static final AllRolesMode STRICT_MODE = new AllRolesMode("strict");
        public static final AllRolesMode AUTH_ONLY_MODE = new AllRolesMode("authOnly");
        public static final AllRolesMode STRICT_AUTH_ONLY_MODE = new AllRolesMode("strictAuthOnly");

        static AllRolesMode toMode(String string) {
            AllRolesMode allRolesMode;
            if (string.equalsIgnoreCase(AllRolesMode.STRICT_MODE.name)) {
                allRolesMode = STRICT_MODE;
            } else if (string.equalsIgnoreCase(AllRolesMode.AUTH_ONLY_MODE.name)) {
                allRolesMode = AUTH_ONLY_MODE;
            } else if (string.equalsIgnoreCase(AllRolesMode.STRICT_AUTH_ONLY_MODE.name)) {
                allRolesMode = STRICT_AUTH_ONLY_MODE;
            } else {
                throw new IllegalStateException("Unknown mode, must be one of: strict, authOnly, strictAuthOnly");
            }
            return allRolesMode;
        }

        private AllRolesMode(String string) {
            this.name = string;
        }

        public boolean equals(Object object) {
            boolean bl = false;
            if (object instanceof AllRolesMode) {
                AllRolesMode allRolesMode = (AllRolesMode)object;
                bl = this.name.equals(allRolesMode.name);
            }
            return bl;
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public String toString() {
            return this.name;
        }
    }
}

