/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.session;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Deque;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Globals;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.Manager;
import org.apache.catalina.Session;
import org.apache.catalina.SessionIdGenerator;
import org.apache.catalina.mbeans.MBeanUtils;
import org.apache.catalina.session.StandardSession;
import org.apache.catalina.session.TooManyActiveSessionsException;
import org.apache.catalina.util.LifecycleMBeanBase;
import org.apache.catalina.util.SessionIdGeneratorBase;
import org.apache.catalina.util.StandardSessionIdGenerator;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.res.StringManager;

public abstract class ManagerBase
extends LifecycleMBeanBase
implements Manager {
    private final Log log = LogFactory.getLog(ManagerBase.class);
    protected Container container;
    @Deprecated
    protected boolean distributable;
    private static final String info = "ManagerBase/1.0";
    private static final String name = "ManagerBase";
    @Deprecated
    protected int maxInactiveInterval = 1800;
    protected static final int SESSION_ID_LENGTH_UNSET = -1;
    protected int sessionIdLength = -1;
    protected String secureRandomClass = null;
    protected String secureRandomAlgorithm = "SHA1PRNG";
    protected String secureRandomProvider = null;
    protected SessionIdGenerator sessionIdGenerator = null;
    protected Class<? extends SessionIdGenerator> sessionIdGeneratorClass = null;
    protected volatile int sessionMaxAliveTime;
    private final Object sessionMaxAliveTimeUpdateLock = new Object();
    protected static final int TIMING_STATS_CACHE_SIZE = 100;
    protected final Deque<SessionTiming> sessionCreationTiming = new LinkedList<SessionTiming>();
    protected final Deque<SessionTiming> sessionExpirationTiming = new LinkedList<SessionTiming>();
    protected final AtomicLong expiredSessions = new AtomicLong(0L);
    protected Map<String, Session> sessions = new ConcurrentHashMap<String, Session>();
    protected long sessionCounter = 0L;
    protected volatile int maxActive = 0;
    private final Object maxActiveUpdateLock = new Object();
    protected int maxActiveSessions = -1;
    protected int rejectedSessions = 0;
    protected volatile int duplicates = 0;
    protected long processingTime = 0L;
    private int count = 0;
    protected int processExpiresFrequency = 6;
    protected static final StringManager sm = StringManager.getManager(ManagerBase.class);
    protected final PropertyChangeSupport support = new PropertyChangeSupport(this);
    private Pattern sessionAttributeNamePattern;
    private Pattern sessionAttributeValueClassNamePattern;
    private boolean warnOnSessionAttributeFilterFailure;
    private boolean persistAuthentication = false;

    public ManagerBase() {
        if (Globals.IS_SECURITY_ENABLED) {
            this.setSessionAttributeValueClassNameFilter("java\\.lang\\.(?:Boolean|Integer|Long|Number|String)|org\\.apache\\.catalina\\.realm\\.GenericPrincipal\\$SerializablePrincipal|\\[Ljava.lang.String;");
            this.setWarnOnSessionAttributeFilterFailure(true);
        }
    }

    public String getSessionAttributeNameFilter() {
        if (this.sessionAttributeNamePattern == null) {
            return null;
        }
        return this.sessionAttributeNamePattern.toString();
    }

    public void setSessionAttributeNameFilter(String string) {
        this.sessionAttributeNamePattern = string == null || string.length() == 0 ? null : Pattern.compile(string);
    }

    protected Pattern getSessionAttributeNamePattern() {
        return this.sessionAttributeNamePattern;
    }

    public String getSessionAttributeValueClassNameFilter() {
        if (this.sessionAttributeValueClassNamePattern == null) {
            return null;
        }
        return this.sessionAttributeValueClassNamePattern.toString();
    }

    protected Pattern getSessionAttributeValueClassNamePattern() {
        return this.sessionAttributeValueClassNamePattern;
    }

    public void setSessionAttributeValueClassNameFilter(String string) throws PatternSyntaxException {
        this.sessionAttributeValueClassNamePattern = string == null || string.length() == 0 ? null : Pattern.compile(string);
    }

    public boolean getWarnOnSessionAttributeFilterFailure() {
        return this.warnOnSessionAttributeFilterFailure;
    }

    public void setWarnOnSessionAttributeFilterFailure(boolean bl) {
        this.warnOnSessionAttributeFilterFailure = bl;
    }

    @Override
    public Container getContainer() {
        return this.container;
    }

    @Override
    public void setContainer(Container container) {
        if (this.container == container) {
            return;
        }
        if (!this.getState().equals((Object)LifecycleState.NEW)) {
            throw new IllegalStateException(sm.getString("managerBase.setContextNotNew"));
        }
        Container container2 = this.container;
        this.container = container;
        this.support.firePropertyChange("container", container2, this.container);
    }

    public String getClassName() {
        return this.getClass().getName();
    }

    @Override
    @Deprecated
    public boolean getDistributable() {
        Container container = this.getContainer();
        if (container instanceof Context) {
            return ((Context)container).getDistributable();
        }
        return false;
    }

    @Override
    @Deprecated
    public void setDistributable(boolean bl) {
    }

    @Override
    @Deprecated
    public String getInfo() {
        return info;
    }

    @Override
    public int getMaxInactiveInterval() {
        Container container = this.getContainer();
        if (container instanceof Context) {
            return ((Context)container).getSessionTimeout() * 60;
        }
        return -1;
    }

    @Override
    @Deprecated
    public void setMaxInactiveInterval(int n) {
        this.log.warn((Object)sm.getString("managerBase.setMaxInactiveIntervalUnused"));
    }

    @Override
    @Deprecated
    public int getSessionIdLength() {
        return this.sessionIdLength;
    }

    @Override
    @Deprecated
    public void setSessionIdLength(int n) {
        int n2 = this.sessionIdLength;
        this.sessionIdLength = n;
        this.support.firePropertyChange("sessionIdLength", (Object)n2, (Object)this.sessionIdLength);
    }

    public SessionIdGenerator getSessionIdGenerator() {
        if (this.sessionIdGenerator != null) {
            return this.sessionIdGenerator;
        }
        if (this.sessionIdGeneratorClass != null) {
            try {
                this.sessionIdGenerator = this.sessionIdGeneratorClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                return this.sessionIdGenerator;
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (SecurityException securityException) {
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return null;
    }

    public void setSessionIdGenerator(SessionIdGenerator sessionIdGenerator) {
        this.sessionIdGenerator = sessionIdGenerator;
        this.sessionIdGeneratorClass = sessionIdGenerator.getClass();
    }

    public String getName() {
        return name;
    }

    public String getSecureRandomClass() {
        return this.secureRandomClass;
    }

    public void setSecureRandomClass(String string) {
        String string2 = this.secureRandomClass;
        this.secureRandomClass = string;
        this.support.firePropertyChange("secureRandomClass", string2, this.secureRandomClass);
    }

    public String getSecureRandomAlgorithm() {
        return this.secureRandomAlgorithm;
    }

    public void setSecureRandomAlgorithm(String string) {
        this.secureRandomAlgorithm = string;
    }

    public String getSecureRandomProvider() {
        return this.secureRandomProvider;
    }

    public void setSecureRandomProvider(String string) {
        this.secureRandomProvider = string;
    }

    @Override
    public int getRejectedSessions() {
        return this.rejectedSessions;
    }

    @Override
    public long getExpiredSessions() {
        return this.expiredSessions.get();
    }

    @Override
    public void setExpiredSessions(long l) {
        this.expiredSessions.set(l);
    }

    public long getProcessingTime() {
        return this.processingTime;
    }

    public void setProcessingTime(long l) {
        this.processingTime = l;
    }

    public int getProcessExpiresFrequency() {
        return this.processExpiresFrequency;
    }

    public void setProcessExpiresFrequency(int n) {
        if (n <= 0) {
            return;
        }
        int n2 = this.processExpiresFrequency;
        this.processExpiresFrequency = n;
        this.support.firePropertyChange("processExpiresFrequency", (Object)n2, (Object)this.processExpiresFrequency);
    }

    public boolean getPersistAuthentication() {
        return this.persistAuthentication;
    }

    public void setPersistAuthentication(boolean bl) {
        this.persistAuthentication = bl;
    }

    @Override
    public void backgroundProcess() {
        this.count = (this.count + 1) % this.processExpiresFrequency;
        if (this.count == 0) {
            this.processExpires();
        }
    }

    public void processExpires() {
        long l = System.currentTimeMillis();
        Session[] sessionArray = this.findSessions();
        int n = 0;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Start expire sessions " + this.getName() + " at " + l + " sessioncount " + sessionArray.length));
        }
        for (Session session : sessionArray) {
            if (session == null || session.isValid()) continue;
            ++n;
        }
        long l2 = System.currentTimeMillis();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("End expire sessions " + this.getName() + " processingTime " + (l2 - l) + " expired sessions: " + n));
        }
        this.processingTime += l2 - l;
    }

    @Override
    protected void initInternal() throws LifecycleException {
        super.initInternal();
        if (!(this.container instanceof Context)) {
            throw new LifecycleException(sm.getString("managerBase.contextNull"));
        }
    }

    @Override
    protected void startInternal() throws LifecycleException {
        while (this.sessionCreationTiming.size() < 100) {
            this.sessionCreationTiming.add(null);
        }
        while (this.sessionExpirationTiming.size() < 100) {
            this.sessionExpirationTiming.add(null);
        }
        SessionIdGenerator sessionIdGenerator = this.getSessionIdGenerator();
        if (sessionIdGenerator == null) {
            sessionIdGenerator = new StandardSessionIdGenerator();
            this.setSessionIdGenerator(sessionIdGenerator);
        }
        if (this.sessionIdLength != -1) {
            sessionIdGenerator.setSessionIdLength(this.sessionIdLength);
        }
        sessionIdGenerator.setJvmRoute(this.getJvmRoute());
        if (sessionIdGenerator instanceof SessionIdGeneratorBase) {
            SessionIdGeneratorBase sessionIdGeneratorBase = (SessionIdGeneratorBase)sessionIdGenerator;
            sessionIdGeneratorBase.setSecureRandomAlgorithm(this.getSecureRandomAlgorithm());
            sessionIdGeneratorBase.setSecureRandomClass(this.getSecureRandomClass());
            sessionIdGeneratorBase.setSecureRandomProvider(this.getSecureRandomProvider());
        }
        if (sessionIdGenerator instanceof Lifecycle) {
            ((Lifecycle)((Object)sessionIdGenerator)).start();
        } else {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Force random number initialization starting");
            }
            sessionIdGenerator.generateSessionId();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Force random number initialization completed");
            }
        }
    }

    @Override
    protected void stopInternal() throws LifecycleException {
        if (this.sessionIdGenerator instanceof Lifecycle) {
            ((Lifecycle)((Object)this.sessionIdGenerator)).stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(Session session) {
        this.sessions.put(session.getIdInternal(), session);
        int n = this.getActiveSessions();
        if (n > this.maxActive) {
            Object object = this.maxActiveUpdateLock;
            synchronized (object) {
                if (n > this.maxActive) {
                    this.maxActive = n;
                }
            }
        }
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Session createSession(String string) {
        if (this.maxActiveSessions >= 0 && this.getActiveSessions() >= this.maxActiveSessions) {
            ++this.rejectedSessions;
            throw new TooManyActiveSessionsException(sm.getString("managerBase.createSession.ise"), this.maxActiveSessions);
        }
        Session session = this.createEmptySession();
        session.setNew(true);
        session.setValid(true);
        session.setCreationTime(System.currentTimeMillis());
        session.setMaxInactiveInterval(((Context)this.getContainer()).getSessionTimeout() * 60);
        String string2 = string;
        if (string2 == null) {
            string2 = this.generateSessionId();
        }
        session.setId(string2);
        ++this.sessionCounter;
        SessionTiming sessionTiming = new SessionTiming(session.getCreationTime(), 0);
        Deque<SessionTiming> deque = this.sessionCreationTiming;
        synchronized (deque) {
            this.sessionCreationTiming.add(sessionTiming);
            this.sessionCreationTiming.poll();
        }
        return session;
    }

    @Override
    public Session createEmptySession() {
        return this.getNewSession();
    }

    @Override
    public Session findSession(String string) throws IOException {
        if (string == null) {
            return null;
        }
        return this.sessions.get(string);
    }

    @Override
    public Session[] findSessions() {
        return this.sessions.values().toArray(new Session[0]);
    }

    @Override
    public void remove(Session session) {
        this.remove(session, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(Session session, boolean bl) {
        if (bl) {
            long l = System.currentTimeMillis();
            int n = (int)(l - session.getCreationTimeInternal()) / 1000;
            this.updateSessionMaxAliveTime(n);
            this.expiredSessions.incrementAndGet();
            SessionTiming sessionTiming = new SessionTiming(l, n);
            Deque<SessionTiming> deque = this.sessionExpirationTiming;
            synchronized (deque) {
                this.sessionExpirationTiming.add(sessionTiming);
                this.sessionExpirationTiming.poll();
            }
        }
        if (session.getIdInternal() != null) {
            this.sessions.remove(session.getIdInternal());
        }
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void changeSessionId(Session session) {
        this.rotateSessionId(session);
    }

    public String rotateSessionId(Session session) {
        String string = this.generateSessionId();
        this.changeSessionId(session, string);
        return string;
    }

    public void changeSessionId(Session session, String string) {
        String string2 = session.getIdInternal();
        session.setId(string, false);
        this.container.fireContainerEvent("changeSessionId", new String[]{string2, string});
    }

    @Override
    public boolean willAttributeDistribute(String string, Object object) {
        Pattern pattern = this.getSessionAttributeNamePattern();
        if (pattern != null && !pattern.matcher(string).matches()) {
            if (this.getWarnOnSessionAttributeFilterFailure() || this.log.isDebugEnabled()) {
                String string2 = sm.getString("managerBase.sessionAttributeNameFilter", new Object[]{string, pattern});
                if (this.getWarnOnSessionAttributeFilterFailure()) {
                    this.log.warn((Object)string2);
                } else {
                    this.log.debug((Object)string2);
                }
            }
            return false;
        }
        Pattern pattern2 = this.getSessionAttributeValueClassNamePattern();
        if (object != null && pattern2 != null && !pattern2.matcher(object.getClass().getName()).matches()) {
            if (this.getWarnOnSessionAttributeFilterFailure() || this.log.isDebugEnabled()) {
                String string3 = sm.getString("managerBase.sessionAttributeValueClassNameFilter", new Object[]{string, object.getClass().getName(), pattern2});
                if (this.getWarnOnSessionAttributeFilterFailure()) {
                    this.log.warn((Object)string3);
                } else {
                    this.log.debug((Object)string3);
                }
            }
            return false;
        }
        return true;
    }

    protected StandardSession getNewSession() {
        return new StandardSession(this);
    }

    protected String generateSessionId() {
        String string = null;
        do {
            if (string == null) continue;
            ++this.duplicates;
        } while (this.sessions.containsKey(string = this.sessionIdGenerator.generateSessionId()));
        return string;
    }

    public Engine getEngine() {
        Engine engine = null;
        for (Container container = this.getContainer(); engine == null && container != null; container = container.getParent()) {
            if (!(container instanceof Engine)) continue;
            engine = (Engine)container;
        }
        return engine;
    }

    public String getJvmRoute() {
        Engine engine = this.getEngine();
        return engine == null ? null : engine.getJvmRoute();
    }

    @Override
    public void setSessionCounter(long l) {
        this.sessionCounter = l;
    }

    @Override
    public long getSessionCounter() {
        return this.sessionCounter;
    }

    public int getDuplicates() {
        return this.duplicates;
    }

    public void setDuplicates(int n) {
        this.duplicates = n;
    }

    @Override
    public int getActiveSessions() {
        return this.sessions.size();
    }

    @Override
    public int getMaxActive() {
        return this.maxActive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMaxActive(int n) {
        Object object = this.maxActiveUpdateLock;
        synchronized (object) {
            this.maxActive = n;
        }
    }

    public int getMaxActiveSessions() {
        return this.maxActiveSessions;
    }

    public void setMaxActiveSessions(int n) {
        int n2 = this.maxActiveSessions;
        this.maxActiveSessions = n;
        this.support.firePropertyChange("maxActiveSessions", (Object)n2, (Object)this.maxActiveSessions);
    }

    @Override
    public int getSessionMaxAliveTime() {
        return this.sessionMaxAliveTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSessionMaxAliveTime(int n) {
        Object object = this.sessionMaxAliveTimeUpdateLock;
        synchronized (object) {
            this.sessionMaxAliveTime = n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSessionMaxAliveTime(int n) {
        if (n > this.sessionMaxAliveTime) {
            Object object = this.sessionMaxAliveTimeUpdateLock;
            synchronized (object) {
                if (n > this.sessionMaxAliveTime) {
                    this.sessionMaxAliveTime = n;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getSessionAverageAliveTime() {
        ArrayList<SessionTiming> arrayList;
        Deque<SessionTiming> deque = this.sessionExpirationTiming;
        synchronized (deque) {
            arrayList = new ArrayList<SessionTiming>(this.sessionExpirationTiming);
        }
        int n = 0;
        int n2 = 0;
        for (SessionTiming sessionTiming : arrayList) {
            if (sessionTiming == null) continue;
            int n3 = sessionTiming.getDuration();
            n2 = n2 * ((++n - 1) / n) + n3 / n;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getSessionCreateRate() {
        ArrayList<SessionTiming> arrayList;
        Deque<SessionTiming> deque = this.sessionCreationTiming;
        synchronized (deque) {
            arrayList = new ArrayList<SessionTiming>(this.sessionCreationTiming);
        }
        return ManagerBase.calculateRate(arrayList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getSessionExpireRate() {
        ArrayList<SessionTiming> arrayList;
        Deque<SessionTiming> deque = this.sessionExpirationTiming;
        synchronized (deque) {
            arrayList = new ArrayList<SessionTiming>(this.sessionExpirationTiming);
        }
        return ManagerBase.calculateRate(arrayList);
    }

    private static int calculateRate(List<SessionTiming> list) {
        long l;
        long l2 = l = System.currentTimeMillis();
        int n = 0;
        int n2 = 0;
        for (SessionTiming sessionTiming : list) {
            if (sessionTiming == null) continue;
            ++n;
            if (sessionTiming.getTimestamp() >= l2) continue;
            l2 = sessionTiming.getTimestamp();
        }
        if (n > 0) {
            n2 = l2 < l ? 60000 * n / (int)(l - l2) : Integer.MAX_VALUE;
        }
        return n2;
    }

    public String listSessionIds() {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : this.sessions.keySet()) {
            stringBuilder.append(string).append(" ");
        }
        return stringBuilder.toString();
    }

    public String getSessionAttribute(String string, String string2) {
        Session session = this.sessions.get(string);
        if (session == null) {
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)sm.getString("managerBase.sessionNotFound", new Object[]{string}));
            }
            return null;
        }
        Object object = session.getSession().getAttribute(string2);
        if (object == null) {
            return null;
        }
        return object.toString();
    }

    public HashMap<String, String> getSession(String string) {
        Session session = this.sessions.get(string);
        if (session == null) {
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)sm.getString("managerBase.sessionNotFound", new Object[]{string}));
            }
            return null;
        }
        Enumeration enumeration = session.getSession().getAttributeNames();
        if (enumeration == null || !enumeration.hasMoreElements()) {
            return null;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            hashMap.put(string2, this.getSessionAttribute(string, string2));
        }
        return hashMap;
    }

    public void expireSession(String string) {
        Session session = this.sessions.get(string);
        if (session == null) {
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)sm.getString("managerBase.sessionNotFound", new Object[]{string}));
            }
            return;
        }
        session.expire();
    }

    public long getThisAccessedTimestamp(String string) {
        Session session = this.sessions.get(string);
        if (session == null) {
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)sm.getString("managerBase.sessionNotFound", new Object[]{string}));
            }
            return -1L;
        }
        return session.getThisAccessedTime();
    }

    public String getThisAccessedTime(String string) {
        Session session = this.sessions.get(string);
        if (session == null) {
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)sm.getString("managerBase.sessionNotFound", new Object[]{string}));
            }
            return "";
        }
        return new Date(session.getThisAccessedTime()).toString();
    }

    public long getLastAccessedTimestamp(String string) {
        Session session = this.sessions.get(string);
        if (session == null) {
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)sm.getString("managerBase.sessionNotFound", new Object[]{string}));
            }
            return -1L;
        }
        return session.getLastAccessedTime();
    }

    public String getLastAccessedTime(String string) {
        Session session = this.sessions.get(string);
        if (session == null) {
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)sm.getString("managerBase.sessionNotFound", new Object[]{string}));
            }
            return "";
        }
        return new Date(session.getLastAccessedTime()).toString();
    }

    public String getCreationTime(String string) {
        Session session = this.sessions.get(string);
        if (session == null) {
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)sm.getString("managerBase.sessionNotFound", new Object[]{string}));
            }
            return "";
        }
        return new Date(session.getCreationTime()).toString();
    }

    public long getCreationTimestamp(String string) {
        Session session = this.sessions.get(string);
        if (session == null) {
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)sm.getString("managerBase.sessionNotFound", new Object[]{string}));
            }
            return -1L;
        }
        return session.getCreationTime();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.getClass().getName());
        stringBuilder.append('[');
        if (this.container == null) {
            stringBuilder.append("Container is null");
        } else {
            stringBuilder.append(this.container.getName());
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    @Override
    public String getObjectNameKeyProperties() {
        StringBuilder stringBuilder = new StringBuilder("type=Manager");
        if (this.container instanceof Context) {
            stringBuilder.append(",context=");
            String string = this.container.getName();
            if (!string.startsWith("/")) {
                stringBuilder.append('/');
            }
            stringBuilder.append(string);
            Context context = (Context)this.container;
            stringBuilder.append(",host=");
            stringBuilder.append(context.getParent().getName());
        } else {
            stringBuilder.append(",container=");
            stringBuilder.append(this.container.getName());
        }
        return stringBuilder.toString();
    }

    @Override
    public String getDomainInternal() {
        return MBeanUtils.getDomain(this.container);
    }

    protected static final class SessionTiming {
        private final long timestamp;
        private final int duration;

        public SessionTiming(long l, int n) {
            this.timestamp = l;
            this.duration = n;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public int getDuration() {
            return this.duration;
        }
    }
}

