/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.websocket;

import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;
import javax.websocket.SendHandler;
import org.apache.tomcat.websocket.AsyncChannelWrapper;
import org.apache.tomcat.websocket.SendHandlerToCompletionHandler;
import org.apache.tomcat.websocket.WsRemoteEndpointImplBase;

public class WsRemoteEndpointImplClient
extends WsRemoteEndpointImplBase {
    private final AsyncChannelWrapper channel;

    public WsRemoteEndpointImplClient(AsyncChannelWrapper asyncChannelWrapper) {
        this.channel = asyncChannelWrapper;
    }

    @Override
    protected boolean isMasked() {
        return true;
    }

    @Override
    protected void doWrite(SendHandler sendHandler, ByteBuffer ... byteBufferArray) {
        long l = this.getSendTimeout();
        if (l < 1L) {
            l = Long.MAX_VALUE;
        }
        SendHandlerToCompletionHandler sendHandlerToCompletionHandler = new SendHandlerToCompletionHandler(sendHandler);
        try {
            this.channel.write(byteBufferArray, 0, byteBufferArray.length, l, TimeUnit.MILLISECONDS, null, sendHandlerToCompletionHandler);
        }
        catch (IllegalStateException illegalStateException) {
            sendHandlerToCompletionHandler.failed((Throwable)illegalStateException, null);
        }
    }

    @Override
    protected void doClose() {
        this.channel.close();
    }
}

