/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.tribes.transport.nio;

import java.io.EOFException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Arrays;
import org.apache.catalina.tribes.RemoteProcessException;
import org.apache.catalina.tribes.io.XByteBuffer;
import org.apache.catalina.tribes.transport.AbstractSender;
import org.apache.catalina.tribes.transport.Constants;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class NioSender
extends AbstractSender {
    private static final Log log = LogFactory.getLog(NioSender.class);
    protected Selector selector;
    protected SocketChannel socketChannel = null;
    protected DatagramChannel dataChannel = null;
    protected ByteBuffer readbuf = null;
    protected ByteBuffer writebuf = null;
    protected volatile byte[] current = null;
    protected XByteBuffer ackbuf = new XByteBuffer(128, true);
    protected int remaining = 0;
    protected boolean complete;
    protected boolean connecting = false;

    /*
     * Enabled aggressive block sorting
     */
    public boolean process(SelectionKey selectionKey, boolean bl) throws IOException {
        int n = selectionKey.readyOps();
        selectionKey.interestOps(selectionKey.interestOps() & ~n);
        if (!this.isConnected() && !this.connecting) {
            throw new IOException("Sender has been disconnected, can't selection key.");
        }
        if (!selectionKey.isValid()) {
            throw new IOException("Key is not valid, it must have been cancelled.");
        }
        if (selectionKey.isConnectable()) {
            if (this.socketChannel.finishConnect()) {
                this.completeConnect();
                if (this.current == null) return false;
                selectionKey.interestOps(selectionKey.interestOps() | 4);
                return false;
            }
            selectionKey.interestOps(selectionKey.interestOps() | 8);
            return false;
        }
        if (selectionKey.isWritable()) {
            boolean bl2 = this.write(selectionKey);
            if (!bl2) {
                selectionKey.interestOps(selectionKey.interestOps() | 4);
                return false;
            }
            if (bl) {
                selectionKey.interestOps(selectionKey.interestOps() | 1);
                return false;
            }
            this.read(selectionKey);
            this.setRequestCount(this.getRequestCount() + 1);
            return true;
        }
        if (!selectionKey.isReadable()) {
            log.warn((Object)("Data is in unknown state. readyOps=" + n));
            throw new IOException("Data is in unknown state. readyOps=" + n);
        }
        boolean bl3 = this.read(selectionKey);
        if (bl3) {
            this.setRequestCount(this.getRequestCount() + 1);
            return true;
        }
        selectionKey.interestOps(selectionKey.interestOps() | 1);
        return false;
    }

    private void configureSocket() throws IOException {
        if (this.socketChannel != null) {
            this.socketChannel.configureBlocking(false);
            this.socketChannel.socket().setSendBufferSize(this.getTxBufSize());
            this.socketChannel.socket().setReceiveBufferSize(this.getRxBufSize());
            this.socketChannel.socket().setSoTimeout((int)this.getTimeout());
            this.socketChannel.socket().setSoLinger(this.getSoLingerOn(), this.getSoLingerOn() ? this.getSoLingerTime() : 0);
            this.socketChannel.socket().setTcpNoDelay(this.getTcpNoDelay());
            this.socketChannel.socket().setKeepAlive(this.getSoKeepAlive());
            this.socketChannel.socket().setReuseAddress(this.getSoReuseAddress());
            this.socketChannel.socket().setOOBInline(this.getOoBInline());
            this.socketChannel.socket().setSoLinger(this.getSoLingerOn(), this.getSoLingerTime());
            this.socketChannel.socket().setTrafficClass(this.getSoTrafficClass());
        } else if (this.dataChannel != null) {
            this.dataChannel.configureBlocking(false);
            this.dataChannel.socket().setSendBufferSize(this.getUdpTxBufSize());
            this.dataChannel.socket().setReceiveBufferSize(this.getUdpRxBufSize());
            this.dataChannel.socket().setSoTimeout((int)this.getTimeout());
            this.dataChannel.socket().setReuseAddress(this.getSoReuseAddress());
            this.dataChannel.socket().setTrafficClass(this.getSoTrafficClass());
        }
    }

    private void completeConnect() {
        this.setConnected(true);
        this.connecting = false;
        this.setRequestCount(0);
        this.setConnectTime(System.currentTimeMillis());
    }

    protected boolean read(SelectionKey selectionKey) throws IOException {
        int n;
        if (this.current == null) {
            return true;
        }
        int n2 = n = this.isUdpBased() ? this.dataChannel.read(this.readbuf) : this.socketChannel.read(this.readbuf);
        if (n == -1) {
            throw new IOException("Unable to receive an ack message. EOF on socket channel has been reached.");
        }
        if (n == 0) {
            return false;
        }
        this.readbuf.flip();
        this.ackbuf.append(this.readbuf, n);
        this.readbuf.clear();
        if (this.ackbuf.doesPackageExist()) {
            byte[] byArray = this.ackbuf.extractDataPackage(true).getBytes();
            boolean bl = Arrays.equals(byArray, Constants.ACK_DATA);
            boolean bl2 = Arrays.equals(byArray, Constants.FAIL_ACK_DATA);
            if (bl2 && this.getThrowOnFailedAck()) {
                throw new RemoteProcessException("Received a failed ack:org.apache.catalina.tribes.transport.Constants.FAIL_ACK_DATA");
            }
            return bl || bl2;
        }
        return false;
    }

    protected boolean write(SelectionKey selectionKey) throws IOException {
        if (!this.isConnected() || this.socketChannel == null && this.dataChannel == null) {
            throw new IOException("NioSender is not connected, this should not occur.");
        }
        if (this.current != null) {
            if (this.remaining > 0) {
                int n;
                int n2 = n = this.isUdpBased() ? this.dataChannel.write(this.writebuf) : this.socketChannel.write(this.writebuf);
                if (n == -1) {
                    throw new EOFException();
                }
                this.remaining -= n;
                if (this.remaining < 0) {
                    this.remaining = 0;
                }
            }
            return this.remaining == 0;
        }
        return true;
    }

    @Override
    public synchronized void connect() throws IOException {
        if (this.connecting || this.isConnected()) {
            return;
        }
        this.connecting = true;
        if (this.isConnected()) {
            throw new IOException("NioSender is already in connected state.");
        }
        if (this.readbuf == null) {
            this.readbuf = this.getReadBuffer();
        } else {
            this.readbuf.clear();
        }
        if (this.writebuf == null) {
            this.writebuf = this.getWriteBuffer();
        } else {
            this.writebuf.clear();
        }
        if (this.isUdpBased()) {
            InetSocketAddress inetSocketAddress = new InetSocketAddress(this.getAddress(), this.getUdpPort());
            if (this.dataChannel != null) {
                throw new IOException("Datagram channel has already been established. Connection might be in progress.");
            }
            this.dataChannel = DatagramChannel.open();
            this.configureSocket();
            this.dataChannel.connect(inetSocketAddress);
            this.completeConnect();
            this.dataChannel.register(this.getSelector(), 4, this);
        } else {
            InetSocketAddress inetSocketAddress = new InetSocketAddress(this.getAddress(), this.getPort());
            if (this.socketChannel != null) {
                throw new IOException("Socket channel has already been established. Connection might be in progress.");
            }
            this.socketChannel = SocketChannel.open();
            this.configureSocket();
            if (this.socketChannel.connect(inetSocketAddress)) {
                this.completeConnect();
                this.socketChannel.register(this.getSelector(), 4, this);
            } else {
                this.socketChannel.register(this.getSelector(), 8, this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnect() {
        block21: {
            try {
                this.connecting = false;
                this.setConnected(false);
                if (this.socketChannel != null) {
                    try {
                        try {
                            this.socketChannel.socket().close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            this.socketChannel.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    finally {
                        this.socketChannel = null;
                    }
                }
                if (this.dataChannel == null) break block21;
                try {
                    try {
                        this.dataChannel.socket().close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        this.dataChannel.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                finally {
                    this.dataChannel = null;
                }
            }
            catch (Exception exception) {
                log.error((Object)("Unable to disconnect NioSender. msg=" + exception.getMessage()));
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Unable to disconnect NioSender. msg=" + exception.getMessage()), (Throwable)exception);
                }
            }
        }
    }

    public void reset() {
        if (this.isConnected() && this.readbuf == null) {
            this.readbuf = this.getReadBuffer();
        }
        if (this.readbuf != null) {
            this.readbuf.clear();
        }
        if (this.writebuf != null) {
            this.writebuf.clear();
        }
        this.current = null;
        this.ackbuf.clear();
        this.remaining = 0;
        this.complete = false;
        this.setAttempt(0);
        this.setUdpBased(false);
    }

    private ByteBuffer getReadBuffer() {
        return this.getBuffer(this.getRxBufSize());
    }

    private ByteBuffer getWriteBuffer() {
        return this.getBuffer(this.getTxBufSize());
    }

    private ByteBuffer getBuffer(int n) {
        return this.getDirectBuffer() ? ByteBuffer.allocateDirect(n) : ByteBuffer.allocate(n);
    }

    public void setMessage(byte[] byArray) throws IOException {
        this.setMessage(byArray, 0, byArray.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMessage(byte[] byArray, int n, int n2) throws IOException {
        if (byArray != null) {
            NioSender nioSender = this;
            synchronized (nioSender) {
                this.current = byArray;
                this.remaining = n2;
                this.ackbuf.clear();
                if (this.writebuf != null) {
                    this.writebuf.clear();
                } else {
                    this.writebuf = this.getBuffer(n2);
                }
                if (this.writebuf.capacity() < n2) {
                    this.writebuf = this.getBuffer(n2);
                }
                this.writebuf.put(byArray, n, n2);
                this.writebuf.flip();
                if (this.isConnected()) {
                    if (this.isUdpBased()) {
                        this.dataChannel.register(this.getSelector(), 4, this);
                    } else {
                        this.socketChannel.register(this.getSelector(), 4, this);
                    }
                }
            }
        }
    }

    public byte[] getMessage() {
        return this.current;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public Selector getSelector() {
        return this.selector;
    }

    public void setSelector(Selector selector) {
        this.selector = selector;
    }

    public void setComplete(boolean bl) {
        this.complete = bl;
    }
}

