/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.realm;

import java.security.Principal;
import java.util.Arrays;
import java.util.List;
import javax.security.auth.login.LoginContext;
import org.ietf.jgss.GSSCredential;

public class GenericPrincipal
implements Principal {
    protected String name = null;
    protected String password = null;
    protected String[] roles = new String[0];
    protected Principal userPrincipal = null;
    protected LoginContext loginContext = null;
    protected GSSCredential gssCredential = null;

    @Deprecated
    public GenericPrincipal(String string, String string2) {
        this(string, string2, null);
    }

    public GenericPrincipal(String string, String string2, List<String> list) {
        this(string, string2, list, null);
    }

    public GenericPrincipal(String string, String string2, List<String> list, Principal principal) {
        this(string, string2, list, principal, null);
    }

    public GenericPrincipal(String string, String string2, List<String> list, Principal principal, LoginContext loginContext) {
        this(string, string2, list, principal, loginContext, null);
    }

    public GenericPrincipal(String string, String string2, List<String> list, Principal principal, LoginContext loginContext, GSSCredential gSSCredential) {
        this.name = string;
        this.password = string2;
        this.userPrincipal = principal;
        if (list != null) {
            this.roles = list.toArray(new String[0]);
            if (this.roles.length > 1) {
                Arrays.sort(this.roles);
            }
        }
        this.loginContext = loginContext;
        this.gssCredential = gSSCredential;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getPassword() {
        return this.password;
    }

    public String[] getRoles() {
        return this.roles;
    }

    public Principal getUserPrincipal() {
        if (this.userPrincipal != null) {
            return this.userPrincipal;
        }
        return this;
    }

    public GSSCredential getGssCredential() {
        return this.gssCredential;
    }

    protected void setGssCredential(GSSCredential gSSCredential) {
        this.gssCredential = gSSCredential;
    }

    public boolean hasRole(String string) {
        if ("*".equals(string)) {
            return true;
        }
        if (string == null) {
            return false;
        }
        return Arrays.binarySearch(this.roles, string) >= 0;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("GenericPrincipal[");
        stringBuilder.append(this.name);
        stringBuilder.append("(");
        for (String string : this.roles) {
            stringBuilder.append(string).append(",");
        }
        stringBuilder.append(")]");
        return stringBuilder.toString();
    }

    public void logout() throws Exception {
        if (this.loginContext != null) {
            this.loginContext.logout();
        }
        if (this.gssCredential != null) {
            this.gssCredential.dispose();
        }
    }
}

