/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.security;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.security.auth.Subject;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.catalina.Globals;
import org.apache.catalina.comet.CometFilter;
import org.apache.catalina.comet.CometProcessor;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.res.StringManager;

public final class SecurityUtil {
    private static final int INIT = 0;
    private static final int SERVICE = 1;
    private static final int DOFILTER = 1;
    private static final int EVENT = 2;
    private static final int DOFILTEREVENT = 2;
    private static final int DESTROY = 3;
    private static final String INIT_METHOD = "init";
    private static final String DOFILTER_METHOD = "doFilter";
    private static final String SERVICE_METHOD = "service";
    private static final String EVENT_METHOD = "event";
    private static final String DOFILTEREVENT_METHOD = "doFilterEvent";
    private static final String DESTROY_METHOD = "destroy";
    private static final Map<Object, Method[]> classCache = new ConcurrentHashMap<Object, Method[]>();
    private static final Log log = LogFactory.getLog(SecurityUtil.class);
    private static boolean packageDefinitionEnabled = System.getProperty("package.definition") != null || System.getProperty("package.access") != null;
    private static final StringManager sm = StringManager.getManager((String)"org.apache.catalina.security");

    public static void doAsPrivilege(String string, Servlet servlet) throws Exception {
        SecurityUtil.doAsPrivilege(string, servlet, null, null, null);
    }

    public static void doAsPrivilege(String string, Servlet servlet, Class<?>[] classArray, Object[] objectArray) throws Exception {
        SecurityUtil.doAsPrivilege(string, servlet, classArray, objectArray, null);
    }

    public static void doAsPrivilege(String string, Servlet servlet, Class<?>[] classArray, Object[] objectArray, Principal principal) throws Exception {
        Class clazz = servlet instanceof CometProcessor ? CometProcessor.class : Servlet.class;
        Method method = null;
        Method[] methodArray = classCache.get(Servlet.class);
        if (methodArray == null) {
            method = SecurityUtil.createMethodAndCacheIt(methodArray, clazz, string, classArray);
        } else {
            method = SecurityUtil.findMethod(methodArray, string);
            if (method == null) {
                method = SecurityUtil.createMethodAndCacheIt(methodArray, clazz, string, classArray);
            }
        }
        SecurityUtil.execute(method, servlet, objectArray, principal);
    }

    public static void doAsPrivilege(String string, Filter filter) throws Exception {
        SecurityUtil.doAsPrivilege(string, filter, null, null);
    }

    public static void doAsPrivilege(String string, Filter filter, Class<?>[] classArray, Object[] objectArray) throws Exception {
        SecurityUtil.doAsPrivilege(string, filter, classArray, objectArray, null);
    }

    public static void doAsPrivilege(String string, Filter filter, Class<?>[] classArray, Object[] objectArray, Principal principal) throws Exception {
        Class clazz = filter instanceof CometFilter ? CometFilter.class : Filter.class;
        Method method = null;
        Method[] methodArray = classCache.get(Filter.class);
        if (methodArray == null) {
            method = SecurityUtil.createMethodAndCacheIt(methodArray, clazz, string, classArray);
        } else {
            method = SecurityUtil.findMethod(methodArray, string);
            if (method == null) {
                method = SecurityUtil.createMethodAndCacheIt(methodArray, clazz, string, classArray);
            }
        }
        SecurityUtil.execute(method, filter, objectArray, principal);
    }

    private static void execute(final Method method, final Object object, final Object[] objectArray, Principal principal) throws Exception {
        try {
            Subject subject = null;
            PrivilegedExceptionAction<Void> privilegedExceptionAction = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    method.invoke(object, objectArray);
                    return null;
                }
            };
            if (objectArray != null && objectArray[0] instanceof HttpServletRequest) {
                HttpServletRequest httpServletRequest = (HttpServletRequest)objectArray[0];
                boolean bl = false;
                HttpSession httpSession = httpServletRequest.getSession(false);
                if (httpSession != null) {
                    subject = (Subject)httpSession.getAttribute("javax.security.auth.subject");
                    boolean bl2 = bl = subject != null;
                }
                if (subject == null) {
                    subject = new Subject();
                    if (principal != null) {
                        subject.getPrincipals().add(principal);
                    }
                }
                if (httpSession != null && !bl) {
                    httpSession.setAttribute("javax.security.auth.subject", (Object)subject);
                }
            }
            Subject.doAsPrivileged(subject, privilegedExceptionAction, null);
        }
        catch (PrivilegedActionException privilegedActionException) {
            Throwable throwable;
            if (privilegedActionException.getException() instanceof InvocationTargetException) {
                throwable = privilegedActionException.getException().getCause();
                ExceptionUtils.handleThrowable((Throwable)throwable);
            } else {
                throwable = privilegedActionException;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("SecurityUtil.doAsPrivilege"), throwable);
            }
            if (throwable instanceof UnavailableException) {
                throw (UnavailableException)throwable;
            }
            if (throwable instanceof ServletException) {
                throw (ServletException)throwable;
            }
            if (throwable instanceof IOException) {
                throw (IOException)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw new ServletException(throwable.getMessage(), throwable);
        }
    }

    private static Method findMethod(Method[] methodArray, String string) {
        if (string.equals(INIT_METHOD)) {
            return methodArray[0];
        }
        if (string.equals(DESTROY_METHOD)) {
            return methodArray[3];
        }
        if (string.equals(SERVICE_METHOD)) {
            return methodArray[1];
        }
        if (string.equals(DOFILTER_METHOD)) {
            return methodArray[1];
        }
        if (string.equals(EVENT_METHOD)) {
            return methodArray[2];
        }
        if (string.equals(DOFILTEREVENT_METHOD)) {
            return methodArray[2];
        }
        return null;
    }

    private static Method createMethodAndCacheIt(Method[] methodArray, Class<?> clazz, String string, Class<?>[] classArray) throws Exception {
        if (methodArray == null) {
            methodArray = new Method[4];
        }
        Method method = clazz.getMethod(string, classArray);
        if (string.equals(INIT_METHOD)) {
            methodArray[0] = method;
        } else if (string.equals(DESTROY_METHOD)) {
            methodArray[3] = method;
        } else if (string.equals(SERVICE_METHOD)) {
            methodArray[1] = method;
        } else if (string.equals(DOFILTER_METHOD)) {
            methodArray[1] = method;
        } else if (string.equals(EVENT_METHOD)) {
            methodArray[2] = method;
        } else if (string.equals(DOFILTEREVENT_METHOD)) {
            methodArray[2] = method;
        }
        classCache.put(clazz, methodArray);
        return method;
    }

    public static void remove(Object object) {
        classCache.remove(object);
    }

    public static boolean isPackageProtectionEnabled() {
        return packageDefinitionEnabled && Globals.IS_SECURITY_ENABLED;
    }
}

