/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.util;

public final class StringParser {
    private char[] chars = null;
    private int index = 0;
    private int length = 0;
    private String string = null;

    public StringParser() {
        this(null);
    }

    public StringParser(String string) {
        this.setString(string);
    }

    public int getIndex() {
        return this.index;
    }

    public int getLength() {
        return this.length;
    }

    public String getString() {
        return this.string;
    }

    public void setString(String string) {
        this.string = string;
        if (string != null) {
            this.length = string.length();
            this.chars = this.string.toCharArray();
        } else {
            this.length = 0;
            this.chars = new char[0];
        }
        this.reset();
    }

    public void advance() {
        if (this.index < this.length) {
            ++this.index;
        }
    }

    public String extract(int n) {
        if (n < 0 || n >= this.length) {
            return "";
        }
        return this.string.substring(n);
    }

    public String extract(int n, int n2) {
        if (n < 0 || n >= n2 || n2 > this.length) {
            return "";
        }
        return this.string.substring(n, n2);
    }

    public int findChar(char c) {
        while (this.index < this.length && c != this.chars[this.index]) {
            ++this.index;
        }
        return this.index;
    }

    public int findText() {
        while (this.index < this.length && this.isWhite(this.chars[this.index])) {
            ++this.index;
        }
        return this.index;
    }

    public int findWhite() {
        while (this.index < this.length && !this.isWhite(this.chars[this.index])) {
            ++this.index;
        }
        return this.index;
    }

    public void reset() {
        this.index = 0;
    }

    public int skipChar(char c) {
        while (this.index < this.length && c == this.chars[this.index]) {
            ++this.index;
        }
        return this.index;
    }

    public int skipText() {
        while (this.index < this.length && !this.isWhite(this.chars[this.index])) {
            ++this.index;
        }
        return this.index;
    }

    public int skipWhite() {
        while (this.index < this.length && this.isWhite(this.chars[this.index])) {
            ++this.index;
        }
        return this.index;
    }

    protected boolean isWhite(char c) {
        return c == ' ' || c == '\t' || c == '\r' || c == '\n';
    }
}

