/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.valves;

import java.io.IOException;
import java.io.Writer;
import java.util.Scanner;
import javax.servlet.ServletException;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.util.RequestUtil;
import org.apache.catalina.util.ServerInfo;
import org.apache.catalina.valves.ValveBase;
import org.apache.coyote.ActionCode;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.res.StringManager;

public class ErrorReportValve
extends ValveBase {
    private boolean showReport = true;
    private boolean showServerInfo = true;
    private static final String info = "org.apache.catalina.valves.ErrorReportValve/1.0";

    public ErrorReportValve() {
        super(true);
    }

    @Override
    public String getInfo() {
        return info;
    }

    @Override
    public void invoke(Request request, Response response) throws IOException, ServletException {
        this.getNext().invoke(request, response);
        if (response.isCommitted()) {
            if (response.setErrorReported()) {
                try {
                    response.flushBuffer();
                }
                catch (Throwable throwable) {
                    ExceptionUtils.handleThrowable((Throwable)throwable);
                }
                response.getCoyoteResponse().action(ActionCode.CLOSE_NOW, request.getAttribute("javax.servlet.error.exception"));
            }
            return;
        }
        Throwable throwable = (Throwable)request.getAttribute("javax.servlet.error.exception");
        if (request.isAsync() && !request.isAsyncCompleting()) {
            return;
        }
        if (throwable != null && !response.isError()) {
            response.reset();
            response.sendError(500);
        }
        response.setSuspended(false);
        try {
            this.report(request, response, throwable);
        }
        catch (Throwable throwable2) {
            ExceptionUtils.handleThrowable((Throwable)throwable2);
        }
    }

    protected void report(Request request, Response response, Throwable throwable) {
        Object object;
        String string;
        int n = response.getStatus();
        if (n < 400 || response.getContentWritten() > 0L || !response.setErrorReported()) {
            return;
        }
        String string2 = RequestUtil.filter(response.getMessage());
        if (string2 == null) {
            if (throwable != null && (string = throwable.getMessage()) != null && string.length() > 0) {
                string2 = RequestUtil.filter(new Scanner(string).nextLine());
            }
            if (string2 == null) {
                string2 = "";
            }
        }
        string = null;
        String string3 = null;
        StringManager stringManager = StringManager.getManager((String)"org.apache.catalina.valves", request.getLocales());
        response.setLocale(stringManager.getLocale());
        try {
            string = stringManager.getString("http." + n + ".reason");
            string3 = stringManager.getString("http." + n + ".desc");
        }
        catch (Throwable throwable2) {
            ExceptionUtils.handleThrowable((Throwable)throwable2);
        }
        if (string == null || string3 == null) {
            if (string2.isEmpty()) {
                return;
            }
            string = stringManager.getString("errorReportValve.unknownReason");
            string3 = stringManager.getString("errorReportValve.noDescription");
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<!doctype html><html lang=\"");
        stringBuilder.append(stringManager.getLocale().getLanguage()).append("\">");
        stringBuilder.append("<head>");
        stringBuilder.append("<title>");
        stringBuilder.append(stringManager.getString("errorReportValve.statusHeader", new Object[]{String.valueOf(n), string}));
        stringBuilder.append("</title>");
        stringBuilder.append("<style type=\"text/css\">");
        stringBuilder.append("body {font-family:Tahoma,Arial,sans-serif;} h1, h2, h3, b {color:white;background-color:#525D76;} h1 {font-size:22px;} h2 {font-size:16px;} h3 {font-size:14px;} p {font-size:12px;} a {color:black;} .line {height:1px;background-color:#525D76;border:none;}");
        stringBuilder.append("</style>");
        stringBuilder.append("</head><body>");
        stringBuilder.append("<h1>");
        stringBuilder.append(stringManager.getString("errorReportValve.statusHeader", new Object[]{String.valueOf(n), string})).append("</h1>");
        if (this.isShowReport()) {
            stringBuilder.append("<hr class=\"line\" />");
            stringBuilder.append("<p><b>");
            stringBuilder.append(stringManager.getString("errorReportValve.type"));
            stringBuilder.append("</b> ");
            if (throwable != null) {
                stringBuilder.append(stringManager.getString("errorReportValve.exceptionReport"));
            } else {
                stringBuilder.append(stringManager.getString("errorReportValve.statusReport"));
            }
            stringBuilder.append("</p>");
            if (!string2.isEmpty()) {
                stringBuilder.append("<p><b>");
                stringBuilder.append(stringManager.getString("errorReportValve.message"));
                stringBuilder.append("</b> ");
                stringBuilder.append(string2).append("</p>");
            }
            stringBuilder.append("<p><b>");
            stringBuilder.append(stringManager.getString("errorReportValve.description"));
            stringBuilder.append("</b> ");
            stringBuilder.append(string3);
            stringBuilder.append("</p>");
            if (throwable != null) {
                object = this.getPartialServletStackTrace(throwable);
                stringBuilder.append("<p><b>");
                stringBuilder.append(stringManager.getString("errorReportValve.exception"));
                stringBuilder.append("</b> <pre>");
                stringBuilder.append(RequestUtil.filter((String)object));
                stringBuilder.append("</pre></p>");
                int n2 = 0;
                for (Throwable throwable3 = throwable.getCause(); throwable3 != null && n2 < 10; throwable3 = throwable3.getCause(), ++n2) {
                    object = this.getPartialServletStackTrace(throwable3);
                    stringBuilder.append("<p><b>");
                    stringBuilder.append(stringManager.getString("errorReportValve.rootCause"));
                    stringBuilder.append("</b> <pre>");
                    stringBuilder.append(RequestUtil.filter((String)object));
                    stringBuilder.append("</pre></p>");
                }
                stringBuilder.append("<p><b>");
                stringBuilder.append(stringManager.getString("errorReportValve.note"));
                stringBuilder.append("</b> ");
                stringBuilder.append(stringManager.getString("errorReportValve.rootCauseInLogs"));
                stringBuilder.append("</p>");
            }
            stringBuilder.append("<hr class=\"line\" />");
        }
        if (this.isShowServerInfo()) {
            stringBuilder.append("<h3>").append(ServerInfo.getServerInfo()).append("</h3>");
        }
        stringBuilder.append("</body></html>");
        try {
            block21: {
                try {
                    response.setContentType("text/html");
                    response.setCharacterEncoding("utf-8");
                }
                catch (Throwable throwable4) {
                    ExceptionUtils.handleThrowable((Throwable)throwable4);
                    if (!this.container.getLogger().isDebugEnabled()) break block21;
                    this.container.getLogger().debug((Object)"status.setContentType", throwable4);
                }
            }
            object = response.getReporter();
            if (object != null) {
                ((Writer)object).write(stringBuilder.toString());
                response.finishResponse();
            }
        }
        catch (IOException iOException) {
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    protected String getPartialServletStackTrace(Throwable throwable) {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(throwable.toString()).append('\n');
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        int n2 = stackTraceElementArray.length;
        for (n = stackTraceElementArray.length - 1; n >= 0; --n) {
            if (!stackTraceElementArray[n].getClassName().startsWith("org.apache.catalina.core.ApplicationFilterChain") || !stackTraceElementArray[n].getMethodName().equals("internalDoFilter")) continue;
            n2 = n;
            break;
        }
        for (n = 0; n < n2; ++n) {
            if (stackTraceElementArray[n].getClassName().startsWith("org.apache.catalina.core.")) continue;
            stringBuilder.append('\t').append(stackTraceElementArray[n].toString()).append('\n');
        }
        return stringBuilder.toString();
    }

    public void setShowReport(boolean bl) {
        this.showReport = bl;
    }

    public boolean isShowReport() {
        return this.showReport;
    }

    public void setShowServerInfo(boolean bl) {
        this.showServerInfo = bl;
    }

    public boolean isShowServerInfo() {
        return this.showServerInfo;
    }
}

