/*
 * Decompiled with CFR 0.152.
 */
package org.apache.naming.resources;

import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.Hashtable;
import javax.naming.directory.DirContext;
import org.apache.naming.resources.DirContextURLConnection;

public class DirContextURLStreamHandler
extends URLStreamHandler {
    private static Hashtable<ClassLoader, DirContext> clBindings = new Hashtable();
    private static Hashtable<Thread, DirContext> threadBindings = new Hashtable();
    protected DirContext context = null;

    public DirContextURLStreamHandler() {
    }

    public DirContextURLStreamHandler(DirContext dirContext) {
        this.context = dirContext;
    }

    @Override
    protected URLConnection openConnection(URL uRL) throws IOException {
        DirContext dirContext = this.context;
        if (dirContext == null) {
            dirContext = DirContextURLStreamHandler.get();
        }
        return new DirContextURLConnection(dirContext, uRL);
    }

    @Override
    protected String toExternalForm(URL uRL) {
        int n = uRL.getProtocol().length() + 1;
        if (uRL.getPath() != null) {
            n += uRL.getPath().length();
        }
        if (uRL.getQuery() != null) {
            n += 1 + uRL.getQuery().length();
        }
        if (uRL.getRef() != null) {
            n += 1 + uRL.getRef().length();
        }
        StringBuilder stringBuilder = new StringBuilder(n);
        stringBuilder.append(uRL.getProtocol());
        stringBuilder.append(":");
        if (uRL.getPath() != null) {
            stringBuilder.append(uRL.getPath());
        }
        if (uRL.getQuery() != null) {
            stringBuilder.append('?');
            stringBuilder.append(uRL.getQuery());
        }
        if (uRL.getRef() != null) {
            stringBuilder.append("#");
            stringBuilder.append(uRL.getRef());
        }
        return stringBuilder.toString();
    }

    public static void setProtocolHandler() {
        String string = System.getProperty("java.protocol.handler.pkgs");
        if (string == null) {
            string = "org.apache.naming.resources";
            System.setProperty("java.protocol.handler.pkgs", string);
        } else if (string.indexOf("org.apache.naming.resources") == -1) {
            string = string + "|org.apache.naming.resources";
            System.setProperty("java.protocol.handler.pkgs", string);
        }
    }

    public static boolean isBound() {
        return clBindings.containsKey(Thread.currentThread().getContextClassLoader()) || threadBindings.containsKey(Thread.currentThread());
    }

    public static void bind(DirContext dirContext) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader != null) {
            clBindings.put(classLoader, dirContext);
        }
    }

    public static void unbind() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader != null) {
            clBindings.remove(classLoader);
        }
    }

    public static void bindThread(DirContext dirContext) {
        threadBindings.put(Thread.currentThread(), dirContext);
    }

    public static void unbindThread() {
        threadBindings.remove(Thread.currentThread());
    }

    public static DirContext get() {
        DirContext dirContext = null;
        Thread thread = Thread.currentThread();
        ClassLoader classLoader = thread.getContextClassLoader();
        dirContext = clBindings.get(classLoader);
        if (dirContext != null) {
            return dirContext;
        }
        dirContext = threadBindings.get(thread);
        for (classLoader = classLoader.getParent(); classLoader != null; classLoader = classLoader.getParent()) {
            dirContext = clBindings.get(classLoader);
            if (dirContext == null) continue;
            return dirContext;
        }
        if (dirContext == null) {
            throw new IllegalStateException("Illegal class loader binding");
        }
        return dirContext;
    }

    public static void bind(ClassLoader classLoader, DirContext dirContext) {
        clBindings.put(classLoader, dirContext);
    }

    public static void unbind(ClassLoader classLoader) {
        clBindings.remove(classLoader);
    }

    public static DirContext get(ClassLoader classLoader) {
        return clBindings.get(classLoader);
    }

    public static DirContext get(Thread thread) {
        return threadBindings.get(thread);
    }
}

