/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.http.parser;

import java.io.IOException;
import java.io.StringReader;
import org.apache.tomcat.util.collections.ConcurrentCache;
import org.apache.tomcat.util.http.parser.HttpParser;
import org.apache.tomcat.util.http.parser.MediaType;

public class MediaTypeCache {
    private final ConcurrentCache<String, String[]> cache;

    public MediaTypeCache(int n) {
        this.cache = new ConcurrentCache(n);
    }

    public String[] parse(String string) {
        String[] stringArray = this.cache.get(string);
        if (stringArray != null) {
            return stringArray;
        }
        MediaType mediaType = null;
        try {
            mediaType = HttpParser.parseMediaType(new StringReader(string));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (mediaType != null) {
            stringArray = new String[]{mediaType.toStringNoCharset(), mediaType.getCharset()};
            this.cache.put(string, stringArray);
        }
        return stringArray;
    }
}

