/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net;

import java.io.IOException;
import java.net.BindException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.security.AccessController;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.RejectedExecutionException;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.net.Constants;
import org.apache.tomcat.util.net.DefaultServerSocketFactory;
import org.apache.tomcat.util.net.SSLImplementation;
import org.apache.tomcat.util.net.ServerSocketFactory;
import org.apache.tomcat.util.net.SocketStatus;
import org.apache.tomcat.util.net.SocketWrapper;
import org.apache.tomcat.util.security.PrivilegedSetTccl;

public class JIoEndpoint
extends AbstractEndpoint<Socket> {
    private static final Log log = LogFactory.getLog(JIoEndpoint.class);
    protected ServerSocket serverSocket = null;
    protected Handler handler = null;
    protected ServerSocketFactory serverSocketFactory = null;
    protected ConcurrentLinkedQueue<SocketWrapper<Socket>> waitingRequests = new ConcurrentLinkedQueue();

    public JIoEndpoint() {
        this.setMaxConnections(0);
        this.setExecutorTerminationTimeoutMillis(0L);
    }

    public void setHandler(Handler handler) {
        this.handler = handler;
    }

    public Handler getHandler() {
        return this.handler;
    }

    public void setServerSocketFactory(ServerSocketFactory serverSocketFactory) {
        this.serverSocketFactory = serverSocketFactory;
    }

    public ServerSocketFactory getServerSocketFactory() {
        return this.serverSocketFactory;
    }

    @Override
    public int getLocalPort() {
        ServerSocket serverSocket = this.serverSocket;
        if (serverSocket == null) {
            return -1;
        }
        return serverSocket.getLocalPort();
    }

    @Override
    public boolean getUseSendfile() {
        return false;
    }

    @Override
    public boolean getUseComet() {
        return false;
    }

    @Override
    public boolean getUseCometTimeout() {
        return false;
    }

    @Override
    public boolean getDeferAccept() {
        return false;
    }

    @Override
    public boolean getUsePolling() {
        return false;
    }

    private void closeSocket(Socket socket) {
        try {
            socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void bind() throws Exception {
        if (this.acceptorThreadCount == 0) {
            this.acceptorThreadCount = 1;
        }
        if (this.getMaxConnections() == 0) {
            this.setMaxConnections(this.getMaxThreadsWithExecutor());
        }
        if (this.serverSocketFactory == null) {
            this.serverSocketFactory = this.isSSLEnabled() ? this.handler.getSslImplementation().getServerSocketFactory(this) : new DefaultServerSocketFactory(this);
        }
        if (this.serverSocket == null) {
            try {
                this.serverSocket = this.getAddress() == null ? this.serverSocketFactory.createSocket(this.getPort(), this.getBacklog()) : this.serverSocketFactory.createSocket(this.getPort(), this.getBacklog(), this.getAddress());
            }
            catch (BindException bindException) {
                String string = this.getAddress() == null ? bindException.getMessage() + " <null>:" + this.getPort() : bindException.getMessage() + " " + this.getAddress().toString() + ":" + this.getPort();
                BindException bindException2 = new BindException(string);
                bindException2.initCause(bindException);
                throw bindException2;
            }
        }
    }

    @Override
    public void startInternal() throws Exception {
        if (!this.running) {
            this.running = true;
            this.paused = false;
            if (this.getExecutor() == null) {
                this.createExecutor();
            }
            this.initializeConnectionLatch();
            this.startAcceptorThreads();
            Thread thread = new Thread((Runnable)new AsyncTimeout(), this.getName() + "-AsyncTimeout");
            thread.setPriority(this.threadPriority);
            thread.setDaemon(true);
            thread.start();
        }
    }

    @Override
    public void stopInternal() {
        this.releaseConnectionLatch();
        if (!this.paused) {
            this.pause();
        }
        if (this.running) {
            this.running = false;
            this.unlockAccept();
        }
        this.shutdownExecutor();
    }

    @Override
    public void unbind() throws Exception {
        if (this.running) {
            this.stop();
        }
        if (this.serverSocket != null) {
            try {
                if (this.serverSocket != null) {
                    this.serverSocket.close();
                }
            }
            catch (Exception exception) {
                log.error((Object)sm.getString("endpoint.err.close"), (Throwable)exception);
            }
            this.serverSocket = null;
        }
        this.handler.recycle();
    }

    @Override
    protected AbstractEndpoint.Acceptor createAcceptor() {
        return new Acceptor();
    }

    protected boolean setSocketOptions(Socket socket) {
        try {
            this.socketProperties.setProperties(socket);
        }
        catch (SocketException socketException) {
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("endpoint.err.unexpected"), (Throwable)socketException);
            }
            return false;
        }
        catch (Throwable throwable) {
            ExceptionUtils.handleThrowable(throwable);
            log.error((Object)sm.getString("endpoint.err.unexpected"), throwable);
            return false;
        }
        return true;
    }

    protected boolean processSocket(Socket socket) {
        try {
            SocketWrapper<Socket> socketWrapper = new SocketWrapper<Socket>(socket);
            socketWrapper.setKeepAliveLeft(this.getMaxKeepAliveRequests());
            socketWrapper.setSecure(this.isSSLEnabled());
            if (!this.running) {
                return false;
            }
            this.getExecutor().execute(new SocketProcessor(socketWrapper));
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            log.warn((Object)("Socket processing request was rejected for:" + socket), (Throwable)rejectedExecutionException);
            return false;
        }
        catch (Throwable throwable) {
            ExceptionUtils.handleThrowable(throwable);
            log.error((Object)sm.getString("endpoint.process.fail"), throwable);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processSocketAsync(SocketWrapper<Socket> socketWrapper, SocketStatus socketStatus) {
        try {
            SocketWrapper<Socket> socketWrapper2 = socketWrapper;
            synchronized (socketWrapper2) {
                if (this.waitingRequests.remove(socketWrapper)) {
                    PrivilegedSetTccl privilegedSetTccl;
                    SocketProcessor socketProcessor = new SocketProcessor(socketWrapper, socketStatus);
                    ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                    try {
                        if (Constants.IS_SECURITY_ENABLED) {
                            privilegedSetTccl = new PrivilegedSetTccl(this.getClass().getClassLoader());
                            AccessController.doPrivileged(privilegedSetTccl);
                        } else {
                            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                        }
                        if (!this.running) {
                            return;
                        }
                        this.getExecutor().execute(socketProcessor);
                    }
                    finally {
                        if (Constants.IS_SECURITY_ENABLED) {
                            privilegedSetTccl = new PrivilegedSetTccl(classLoader);
                            AccessController.doPrivileged(privilegedSetTccl);
                        } else {
                            Thread.currentThread().setContextClassLoader(classLoader);
                        }
                    }
                }
            }
        }
        catch (Throwable throwable) {
            ExceptionUtils.handleThrowable(throwable);
            log.error((Object)sm.getString("endpoint.process.fail"), throwable);
        }
    }

    @Override
    public void removeWaitingRequest(SocketWrapper<Socket> socketWrapper) {
        this.waitingRequests.remove(socketWrapper);
    }

    @Override
    protected Log getLog() {
        return log;
    }

    protected class SocketProcessor
    implements Runnable {
        protected SocketWrapper<Socket> socket = null;
        protected SocketStatus status = null;

        public SocketProcessor(SocketWrapper<Socket> socketWrapper) {
            if (socketWrapper == null) {
                throw new NullPointerException();
            }
            this.socket = socketWrapper;
        }

        public SocketProcessor(SocketWrapper<Socket> socketWrapper, SocketStatus socketStatus) {
            this(socketWrapper);
            this.status = socketStatus;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean bl = false;
            SocketWrapper<Socket> socketWrapper = this.socket;
            synchronized (socketWrapper) {
                try {
                    AbstractEndpoint.Handler.SocketState socketState = AbstractEndpoint.Handler.SocketState.OPEN;
                    try {
                        JIoEndpoint.this.serverSocketFactory.handshake(this.socket.getSocket());
                    }
                    catch (Throwable throwable) {
                        ExceptionUtils.handleThrowable(throwable);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)AbstractEndpoint.sm.getString("endpoint.err.handshake"), throwable);
                        }
                        socketState = AbstractEndpoint.Handler.SocketState.CLOSED;
                    }
                    if (socketState != AbstractEndpoint.Handler.SocketState.CLOSED) {
                        socketState = this.status == null ? JIoEndpoint.this.handler.process(this.socket, SocketStatus.OPEN_READ) : JIoEndpoint.this.handler.process(this.socket, this.status);
                    }
                    if (socketState == AbstractEndpoint.Handler.SocketState.CLOSED) {
                        if (log.isTraceEnabled()) {
                            log.trace((Object)("Closing socket:" + this.socket));
                        }
                        JIoEndpoint.this.countDownConnection();
                        try {
                            this.socket.getSocket().close();
                        }
                        catch (IOException iOException) {}
                    } else if (socketState == AbstractEndpoint.Handler.SocketState.OPEN || socketState == AbstractEndpoint.Handler.SocketState.UPGRADING || socketState == AbstractEndpoint.Handler.SocketState.UPGRADING_TOMCAT || socketState == AbstractEndpoint.Handler.SocketState.UPGRADED) {
                        this.socket.setKeptAlive(true);
                        this.socket.access();
                        bl = true;
                    } else if (socketState == AbstractEndpoint.Handler.SocketState.LONG) {
                        this.socket.access();
                        JIoEndpoint.this.waitingRequests.add(this.socket);
                    }
                }
                finally {
                    block31: {
                        if (bl) {
                            try {
                                JIoEndpoint.this.getExecutor().execute(new SocketProcessor(this.socket, SocketStatus.OPEN_READ));
                            }
                            catch (RejectedExecutionException rejectedExecutionException) {
                                log.warn((Object)("Socket reprocessing request was rejected for:" + this.socket), (Throwable)rejectedExecutionException);
                                try {
                                    JIoEndpoint.this.handler.process(this.socket, SocketStatus.DISCONNECT);
                                }
                                finally {
                                    JIoEndpoint.this.countDownConnection();
                                }
                            }
                            catch (NullPointerException nullPointerException) {
                                if (!JIoEndpoint.this.running) break block31;
                                log.error((Object)AbstractEndpoint.sm.getString("endpoint.launch.fail"), (Throwable)nullPointerException);
                            }
                        }
                    }
                }
            }
            this.socket = null;
        }
    }

    protected class Acceptor
    extends AbstractEndpoint.Acceptor {
        protected Acceptor() {
        }

        @Override
        public void run() {
            int n = 0;
            while (JIoEndpoint.this.running) {
                while (JIoEndpoint.this.paused && JIoEndpoint.this.running) {
                    this.state = AbstractEndpoint.Acceptor.AcceptorState.PAUSED;
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (!JIoEndpoint.this.running) break;
                this.state = AbstractEndpoint.Acceptor.AcceptorState.RUNNING;
                try {
                    JIoEndpoint.this.countUpOrAwaitConnection();
                    Socket socket = null;
                    try {
                        socket = JIoEndpoint.this.serverSocketFactory.acceptSocket(JIoEndpoint.this.serverSocket);
                    }
                    catch (IOException iOException) {
                        JIoEndpoint.this.countDownConnection();
                        n = JIoEndpoint.this.handleExceptionWithDelay(n);
                        throw iOException;
                    }
                    n = 0;
                    if (JIoEndpoint.this.running && !JIoEndpoint.this.paused && JIoEndpoint.this.setSocketOptions(socket)) {
                        if (JIoEndpoint.this.processSocket(socket)) continue;
                        JIoEndpoint.this.countDownConnection();
                        JIoEndpoint.this.closeSocket(socket);
                        continue;
                    }
                    JIoEndpoint.this.countDownConnection();
                    JIoEndpoint.this.closeSocket(socket);
                }
                catch (IOException iOException) {
                    if (!JIoEndpoint.this.running) continue;
                    log.error((Object)AbstractEndpoint.sm.getString("endpoint.accept.fail"), (Throwable)iOException);
                }
                catch (NullPointerException nullPointerException) {
                    if (!JIoEndpoint.this.running) continue;
                    log.error((Object)AbstractEndpoint.sm.getString("endpoint.accept.fail"), (Throwable)nullPointerException);
                }
                catch (Throwable throwable) {
                    ExceptionUtils.handleThrowable(throwable);
                    log.error((Object)AbstractEndpoint.sm.getString("endpoint.accept.fail"), throwable);
                }
            }
            this.state = AbstractEndpoint.Acceptor.AcceptorState.ENDED;
        }
    }

    protected class AsyncTimeout
    implements Runnable {
        protected AsyncTimeout() {
        }

        @Override
        public void run() {
            while (JIoEndpoint.this.running) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                long l = System.currentTimeMillis();
                for (SocketWrapper<Socket> socketWrapper : JIoEndpoint.this.waitingRequests) {
                    long l2 = socketWrapper.getLastAccess();
                    if ((socketWrapper.getTimeout() <= 0L || l - l2 <= socketWrapper.getTimeout()) && JIoEndpoint.this.handler.isAvailable(socketWrapper)) continue;
                    socketWrapper.setTimeout(-1L);
                    JIoEndpoint.this.processSocketAsync(socketWrapper, SocketStatus.TIMEOUT);
                }
                while (JIoEndpoint.this.paused && JIoEndpoint.this.running) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }

    public static interface Handler
    extends AbstractEndpoint.Handler {
        public AbstractEndpoint.Handler.SocketState process(SocketWrapper<Socket> var1, SocketStatus var2);

        public SSLImplementation getSslImplementation();

        public boolean isAvailable(SocketWrapper<Socket> var1);
    }
}

